/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.repgen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.neobio.BasicScoringScheme;
import net.maizegenetics.analysis.gbs.neobio.IncompatibleScoringSchemeException;
import net.maizegenetics.analysis.gbs.neobio.InvalidSequenceException;
import net.maizegenetics.analysis.gbs.neobio.PairwiseAlignment;
import net.maizegenetics.analysis.gbs.neobio.SmithWaterman;
import net.maizegenetics.analysis.gbs.repgen.AlignmentInfo;
import net.maizegenetics.analysis.gbs.repgen.RefTagData;
import net.maizegenetics.analysis.gbs.repgen.RepGenPhase2AlignerPlugin;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.GenomeSequence;
import net.maizegenetics.dna.map.GenomeSequenceBuilder;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.tag.RepGenDataWriter;
import net.maizegenetics.dna.tag.RepGenSQLite;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Tuple;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class RampSeqAlignFromBlastTags
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(RepGenPhase2AlignerPlugin.class);
    private PluginParameter<String> myDBFile = new PluginParameter.Builder<String>("db", null, String.class).guiName("Input DB").required(true).inFile().description("Input database file with tags and taxa distribution").build();
    private PluginParameter<String> refGenome = new PluginParameter.Builder<String>("ref", null, String.class).guiName("Reference Genome File").required(true).description("Referemce Genome File for aligning against ").build();
    private PluginParameter<Integer> minTagCount = new PluginParameter.Builder<Integer>("minTagCount", 1, Integer.class).guiName("Min Tag Count").description("Minimum count of reads for a tag to be aligned").build();
    private PluginParameter<Integer> match_reward = new PluginParameter.Builder<Integer>("match_reward", 2, Integer.class).guiName("Match Reward Amount").description("Parameter sent to Smith Waterman aligner for use in calculating reward when base pairs match.").build();
    private PluginParameter<Integer> mismatch_penalty = new PluginParameter.Builder<Integer>("mismatch_penalty", -1, Integer.class).guiName("Mismatch Penalty Amount").description("Parameter sent to Smith Waterman aligner for use in calculating penalty when base pairs are mis-matched.").build();
    private PluginParameter<Integer> gap_penalty = new PluginParameter.Builder<Integer>("gap_penalty", -1, Integer.class).guiName("Gap Penalty Amount").description("Parameter sent to Smith Waterman aligner for use in calculating penalty when when a gap is identified.").build();
    private PluginParameter<String> forwardp = new PluginParameter.Builder<String>("forwardp", null, String.class).guiName("Forward Primer").required(true).description("String containing the forward primer sequence.").build();
    private PluginParameter<String> reversep = new PluginParameter.Builder<String>("reversep", null, String.class).guiName("Reverse Primer").required(true).description("String containing the reverse primer sequence.").build();
    private PluginParameter<String> blastFile = new PluginParameter.Builder<String>("blastFile", null, String.class).guiName("Blast File").required(true).inFile().description("Tab delimited Blast file output with NO header line, that contains only the data from columns for chrom, start postion, end position. \nThis data should be filtered to contain only entries whose identiy value was 98% or greater.").build();
    static GenomeSequence myRefSequence = null;
    static int refAlignLen = 1000;

    public RampSeqAlignFromBlastTags() {
        super(null, false);
    }

    public RampSeqAlignFromBlastTags(Frame parentFrame) {
        super(parentFrame, false);
    }

    public RampSeqAlignFromBlastTags(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public void postProcessParameters() {
        if (this.myDBFile.isEmpty() || !Files.exists(Paths.get(this.dBFile(), new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("RepGenPhase2AlignerPlugin: postProcessParameters: Input DB not set or found");
        }
        if (this.refGenome.isEmpty()) {
            throw new IllegalArgumentException("RepGenPhase2AlignerPlugin: postProcessParameters: reference genome not set or found");
        }
        myRefSequence = GenomeSequenceBuilder.instance(this.refGenome());
    }

    @Override
    public DataSet processData(DataSet input) {
        long totalTime = System.nanoTime();
        long time = System.nanoTime();
        try {
            System.out.println("RampSeqAlignFromBlastTags:processData begin");
            RepGenSQLite repGenData = new RepGenSQLite(this.dBFile());
            time = System.nanoTime();
            HashMultimap refTagPositionMap = HashMultimap.create();
            boolean success = this.createRefTagsFromBlast(this.blastFile(), this.forwardp(), this.reversep(), (Multimap<Tag, Position>)refTagPositionMap);
            if (!success) {
                repGenData.close();
                return null;
            }
            repGenData.addMappingApproach("SmithWaterman");
            repGenData.addReferenceGenome(this.refGenome());
            repGenData.putRefTagMapping((Multimap<Tag, Position>)refTagPositionMap, this.refGenome());
            Set<Tag> tagsToAlign = repGenData.getTags();
            ArrayList<Tag> tagList = new ArrayList<Tag>(tagsToAlign);
            Multimap tagAlignInfoMap = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
            Multimap refTagAlignInfoMap = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
            System.out.println("Calling calculateTagTagAlignment for tags without refs");
            this.calculateTagTagAlignment(tagList, (Multimap<Tag, AlignmentInfo>)tagAlignInfoMap, repGenData);
            System.out.println("Calling calculateTagRefTagALignment for tags WITH ref");
            Set<RefTagData> refTags = repGenData.getRefTags();
            ArrayList<RefTagData> refTagList = new ArrayList<RefTagData>(refTags);
            tagAlignInfoMap.clear();
            this.calculateTagRefTagAlignment(tagList, refTagList, (Multimap<Tag, AlignmentInfo>)tagAlignInfoMap, this.refGenome(), repGenData);
            System.out.println("Number of tag-refTag alignments, includes aligning to ref fwd and reverse strands: " + tagAlignInfoMap.size() + ", store to db.");
            System.out.println("Calling calculateRefRefAlignment");
            this.calculateRefRefAlignment(refTagList, (Multimap<Tag, Position>)refTagPositionMap, (Multimap<RefTagData, AlignmentInfo>)refTagAlignInfoMap, repGenData);
            repGenData.close();
            myLogger.info((Object)"Finished RepGenPhase2AlignerPlugin\n");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        System.out.println("Process took " + (double)(System.nanoTime() - totalTime) / 1.0E9 + " seconds.\n");
        return null;
    }

    public boolean createRefTagsFromBlast(String chromStartEndFile, String forwardP, String reverseP, Multimap<Tag, Position> refTagPositionMap) {
        System.out.println("Begin createRefTagsFromBlast");
        BufferedReader rdChroms = Utils.getBufferedReader(chromStartEndFile);
        HashMultimap chromStartEndMap = HashMultimap.create();
        try {
            String line;
            int lineCount = 0;
            while ((line = rdChroms.readLine()) != null) {
                ++lineCount;
                String[] tokens = line.split("\t");
                String chrom = tokens[0];
                Tuple<Integer, Integer> startEnd = new Tuple<Integer, Integer>(Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]));
                chromStartEndMap.put((Object)chrom, startEnd);
            }
            System.out.println("Read " + lineCount + " lines from BLAST input file.");
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
        byte[] forwardRCBytes = NucleotideAlignmentConstants.reverseComplementAlleleByteArray(forwardP.getBytes());
        String forwardPRC = new String(forwardRCBytes);
        byte[] reverseRCBytes = NucleotideAlignmentConstants.reverseComplementAlleleByteArray(reverseP.getBytes());
        String reversePRC = new String(reverseRCBytes);
        int count = 0;
        System.out.println("Finished reading Blast file, num of entries added to chromStartEndMap: " + chromStartEndMap.size());
        for (int idx = 1; idx < 11; ++idx) {
            String chrom = Integer.toString(idx);
            System.out.println("chromStartENdMap entries for " + idx + ": " + chromStartEndMap.get((Object)chrom).size());
        }
        int perfectScore = 0;
        int oneMM = 0;
        int twoMM = 0;
        int notFound = 0;
        int fstart = 0;
        int frcstart = 0;
        int rstart = 0;
        int rrcstart = 0;
        int ostart = 0;
        int refLen150more = 0;
        int refLen150 = 0;
        int refLen150less = 0;
        for (Map.Entry entry : chromStartEndMap.entries()) {
            byte[] refTagBytes;
            String refTagString;
            int refEndIdx;
            ++count;
            String chromString = (String)entry.getKey();
            Chromosome chrom = new Chromosome(chromString);
            Tuple startEnd = (Tuple)entry.getValue();
            int chromSize = myRefSequence.chromosomeSize(chrom);
            int origSize = Math.abs((Integer)startEnd.x - (Integer)startEnd.y);
            int refStartIdx = (Integer)startEnd.x;
            if (refStartIdx > (refEndIdx = ((Integer)startEnd.y).intValue())) {
                int temp = refStartIdx;
                refStartIdx = refEndIdx;
                refEndIdx = temp;
            }
            if ((refTagString = NucleotideAlignmentConstants.nucleotideBytetoString(refTagBytes = myRefSequence.chromosomeSequence(chrom, refStartIdx, refEndIdx = refEndIdx + 200 <= chromSize ? refEndIdx + 200 : chromSize))).startsWith(this.forwardp())) {
                ++fstart;
            } else if (refTagString.startsWith(this.reversep())) {
                ++rstart;
            } else if (refTagString.startsWith(forwardPRC)) {
                ++frcstart;
            } else if (refTagString.startsWith(reversePRC)) {
                ++rrcstart;
            } else {
                ++ostart;
            }
            if (refTagString == null || refTagString.length() == 0 || refTagString.contains("N") || refTagString.contains("null")) {
                System.out.println(" storeRefTagPositions - refString is NULL");
                continue;
            }
            Tuple<Integer, Integer> forwardPrimer = null;
            Tuple<Integer, Integer> reversePrimer = null;
            Tuple<Integer, Integer> forwardRCPrimer = null;
            Tuple<Integer, Integer> reverseRCPrimer = null;
            forwardPrimer = this.computePrimerSW(forwardP, refTagString, 2, -1, -1);
            reversePrimer = this.computePrimerSW(reverseP, refTagString, 2, -1, -1);
            forwardRCPrimer = this.computePrimerSW(forwardPRC, refTagString, 2, -1, -1);
            reverseRCPrimer = this.computePrimerSW(reversePRC, refTagString, 2, -1, -1);
            int bestEndPos = origSize;
            int bestScore = 33;
            if ((Integer)forwardPrimer.y > 100 && (Integer)forwardPrimer.x > bestScore) {
                bestEndPos = (Integer)forwardPrimer.y;
                bestScore = (Integer)forwardPrimer.x;
            }
            if ((Integer)reversePrimer.y > 100 && (Integer)reversePrimer.x > bestScore) {
                if ((Integer)reversePrimer.x > bestScore) {
                    bestEndPos = (Integer)reversePrimer.y;
                    bestScore = (Integer)reversePrimer.x;
                }
                if ((Integer)reversePrimer.x == bestScore && (Integer)reversePrimer.y > bestEndPos) {
                    bestEndPos = (Integer)reversePrimer.y;
                }
            }
            if ((Integer)reverseRCPrimer.y > 100 && (Integer)reverseRCPrimer.x > bestScore) {
                if ((Integer)reverseRCPrimer.x > bestScore) {
                    bestEndPos = (Integer)reverseRCPrimer.y;
                    bestScore = (Integer)reverseRCPrimer.x;
                }
                if ((Integer)reverseRCPrimer.x == bestScore && (Integer)reverseRCPrimer.y > bestEndPos) {
                    bestEndPos = (Integer)reverseRCPrimer.y;
                }
            }
            if ((Integer)forwardRCPrimer.y > 100 && (Integer)forwardRCPrimer.x > bestScore) {
                if ((Integer)forwardRCPrimer.x > bestScore) {
                    bestEndPos = (Integer)forwardRCPrimer.y;
                    bestScore = (Integer)forwardRCPrimer.x;
                }
                if ((Integer)forwardRCPrimer.x == bestScore && (Integer)forwardRCPrimer.y > bestEndPos) {
                    bestEndPos = (Integer)forwardRCPrimer.y;
                }
            }
            if (bestScore == 40) {
                ++perfectScore;
            } else if (bestScore > 36) {
                ++oneMM;
            } else if (bestScore > 33) {
                ++twoMM;
            } else {
                ++notFound;
            }
            int endPos = forwardP.length() + bestEndPos;
            String finalRef = refTagString.substring(0, endPos);
            if (finalRef.length() > 150) {
                ++refLen150more;
            } else if (finalRef.length() == 150) {
                ++refLen150;
            } else {
                ++refLen150less;
            }
            Tag refTag = TagBuilder.instance(finalRef).reference().build();
            if (refTag != null) {
                GeneralPosition refPos = new GeneralPosition.Builder(chrom, refStartIdx).strand((byte)1).addAnno("mappingapproach", "SmithWaterman").addAnno("forward", "true").build();
                refTagPositionMap.put((Object)refTag, (Object)refPos);
                continue;
            }
            System.out.println("- null refTag created - skipping !!");
        }
        System.out.println("Number of tags processed: " + count);
        System.out.println("Finsished creating tags, refTagPositionMap size: " + refTagPositionMap.size() + ", number refTags with length greater than 150: " + refLen150more + ", equal 150: " + refLen150 + ", less than 150: " + refLen150less);
        System.out.println("Number of distinct ref tags: " + refTagPositionMap.keySet().size());
        System.out.println("Start seqences: forwardP " + fstart + ", reverseP " + rstart + ", forwardPRC " + frcstart + ", reversePRC " + rrcstart + ", other " + ostart);
        System.out.println("End primers perfectscore: " + perfectScore + ", oneMM: " + oneMM + ", twoMM: " + twoMM + ", end primer not found: " + notFound);
        return true;
    }

    private Tuple<Integer, Integer> computePrimerSW(String primerSeq, String refSeq, int match, int mismatch, int gap) {
        StringReader reader1 = new StringReader(primerSeq);
        StringReader reader2 = new StringReader(refSeq);
        SmithWaterman algorithm = new SmithWaterman();
        BasicScoringScheme scoring = new BasicScoringScheme(match, mismatch, gap);
        algorithm.setScoringScheme(scoring);
        int primerOffset = 0;
        int refAlignStartPos = 0;
        try {
            algorithm.loadSequences(reader1, reader2);
            PairwiseAlignment alignment = algorithm.getPairwiseAlignment();
            int score = algorithm.getScore();
            primerOffset = alignment.getRowStart();
            refAlignStartPos += alignment.getColStart();
            if (primerOffset > 0) {
                refAlignStartPos -= primerOffset;
            }
            return new Tuple<Integer, Integer>(score, refAlignStartPos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidSequenceException e) {
            e.printStackTrace();
        }
        catch (IncompatibleScoringSchemeException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void calculateTagTagAlignment(List<Tag> tags, Multimap<Tag, AlignmentInfo> tagAlignInfoMap, RepGenDataWriter repGenData) {
        long time = System.nanoTime();
        long totalTime = System.nanoTime();
        int totalProcessedTags = 0;
        int tagCount = 0;
        for (int tidx = 0; tidx < tags.size(); ++tidx) {
            Tag tag1 = tags.get(tidx);
            ++totalProcessedTags;
            IntStream.range(tidx + 1, tags.size()).parallel().forEach(item -> {
                Tag tag2 = (Tag)tags.get(item);
                String seq1 = tag1.sequence();
                String seq2 = tag2.sequence();
                StringReader reader1 = new StringReader(seq1);
                StringReader reader2 = new StringReader(seq2);
                SmithWaterman algorithm = new SmithWaterman();
                BasicScoringScheme scoring = new BasicScoringScheme(this.match_reward(), this.mismatch_penalty(), this.gap_penalty());
                algorithm.setScoringScheme(scoring);
                int score = 0;
                try {
                    algorithm.loadSequences(reader1, reader2);
                    score = algorithm.getScore();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (InvalidSequenceException ise) {
                    ise.printStackTrace();
                }
                catch (IncompatibleScoringSchemeException isse) {
                    isse.printStackTrace();
                }
                AlignmentInfo tagAI = new AlignmentInfo(tag2, null, -1, -1, -1, this.refGenome(), score);
                tagAlignInfoMap.put((Object)tag1, (Object)tagAI);
            });
            if (++tagCount <= 999) continue;
            System.out.println("FInished aligning " + totalProcessedTags + " tags, this set took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds, now load to db ...");
            time = System.nanoTime();
            repGenData.putTagTagAlignments(tagAlignInfoMap);
            System.out.println("Loading DB took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds.\n");
            tagCount = 0;
            tagAlignInfoMap.clear();
            time = System.nanoTime();
        }
        if (tagCount > 0) {
            System.out.println("Finished processing last alignments, load to DB");
            time = System.nanoTime();
            repGenData.putTagTagAlignments(tagAlignInfoMap);
            System.out.println("Loading DB took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds.\n");
            tagCount = 0;
            tagAlignInfoMap.clear();
        }
        System.out.println("Number of tags: " + tags.size() + ", TotalTime for calculateTagTagAlignment was " + (double)(System.nanoTime() - totalTime) / 1.0E9 + " seconds");
    }

    private void calculateTagRefTagAlignment(List<Tag> tags, List<RefTagData> refTagDataList, Multimap<Tag, AlignmentInfo> tagAlignInfoMap, String refGenome, RepGenDataWriter repGenData) {
        long totalTime = System.nanoTime();
        long time = System.nanoTime();
        int totalProcessedTags = 0;
        int tagCount = 0;
        for (int tidx = 0; tidx < tags.size(); ++tidx) {
            ++totalProcessedTags;
            Tag tag1 = tags.get(tidx);
            refTagDataList.parallelStream().forEach(rtd -> {
                Tag tag2 = rtd.tag();
                String seq1 = tag1.sequence();
                String seq2 = tag2.sequence();
                StringReader reader1 = new StringReader(seq1);
                StringReader reader2 = new StringReader(seq2);
                SmithWaterman algorithm = new SmithWaterman();
                BasicScoringScheme scoring = new BasicScoringScheme(this.match_reward(), this.mismatch_penalty(), this.gap_penalty());
                algorithm.setScoringScheme(scoring);
                int refAlignStartPos = rtd.position();
                int tagAlignOffset = 0;
                try {
                    AlignmentInfo tagAI;
                    algorithm.loadSequences(reader1, reader2);
                    PairwiseAlignment alignment = algorithm.getPairwiseAlignment();
                    int score = algorithm.getScore();
                    tagAlignOffset = alignment.getRowStart();
                    refAlignStartPos += alignment.getColStart();
                    if (tagAlignOffset > 0) {
                        refAlignStartPos -= tagAlignOffset;
                    }
                    if (refAlignStartPos >= 0) {
                        tagAI = new AlignmentInfo(tag2, rtd.chromosome(), rtd.position(), refAlignStartPos, 1, refGenome, score);
                        tagAlignInfoMap.put((Object)tag1, (Object)tagAI);
                    }
                    reader1 = new StringReader(seq1);
                    seq2 = tag2.toReverseComplement();
                    reader2 = new StringReader(seq2);
                    algorithm.unloadSequences();
                    algorithm.loadSequences(reader1, reader2);
                    score = algorithm.getScore();
                    alignment = algorithm.getPairwiseAlignment();
                    tagAlignOffset = alignment.getRowStart();
                    refAlignStartPos += alignment.getColStart();
                    if (tagAlignOffset > 0) {
                        refAlignStartPos -= tagAlignOffset;
                    }
                    if (refAlignStartPos >= 0) {
                        tagAI = new AlignmentInfo(tag2, rtd.chromosome(), rtd.position(), refAlignStartPos, 0, this.refGenome(), score);
                        tagAlignInfoMap.put((Object)tag1, (Object)tagAI);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InvalidSequenceException e) {
                    e.printStackTrace();
                }
                catch (IncompatibleScoringSchemeException e) {
                    e.printStackTrace();
                }
            });
            if (++tagCount <= 999) continue;
            System.out.println("FInished aligning " + totalProcessedTags + " tags, this set took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds, now load to db ...");
            time = System.nanoTime();
            repGenData.putTagRefTagAlignments(tagAlignInfoMap, this.refGenome());
            System.out.println("Loading DB took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds.\n");
            tagCount = 0;
            tagAlignInfoMap.clear();
            time = System.nanoTime();
        }
        if (tagCount > 0) {
            System.out.println("FInished last alignments " + totalProcessedTags + " tags, this set took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds, now load to db ...");
            time = System.nanoTime();
            repGenData.putTagRefTagAlignments(tagAlignInfoMap, this.refGenome());
            System.out.println("Loading DB took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds.\n");
            tagCount = 0;
            tagAlignInfoMap.clear();
            time = System.nanoTime();
        }
        System.out.println("Num tags: " + tags.size() + ", Num refTags: " + refTagDataList.size() + ", TotalTime for calculateTagRefTagAlignment was " + (double)(System.nanoTime() - totalTime) / 1.0E9 + " seconds");
    }

    private void calculateRefRefAlignment(List<RefTagData> refTags, Multimap<Tag, Position> refTagPosMap, Multimap<RefTagData, AlignmentInfo> refTagAlignInfoMap, RepGenDataWriter repGenData) {
        long totalTime = System.nanoTime();
        long time = System.nanoTime();
        int tagCount = 0;
        int totalProcessedTags = 0;
        for (int tidx = 0; tidx < refTags.size(); ++tidx) {
            ++totalProcessedTags;
            RefTagData tag1 = refTags.get(tidx);
            int tIdxFinal = tidx;
            IntStream.range(tidx + 1, refTags.size()).parallel().forEach(item -> {
                RefTagData tag2 = (RefTagData)refTags.get(tIdxFinal + 1);
                String seq1 = tag1.tag().sequence();
                String seq2 = tag2.tag().sequence();
                StringReader reader1 = new StringReader(seq1);
                StringReader reader2 = new StringReader(seq2);
                SmithWaterman algorithm = new SmithWaterman();
                BasicScoringScheme scoring = new BasicScoringScheme(this.match_reward(), this.mismatch_penalty(), this.gap_penalty());
                algorithm.setScoringScheme(scoring);
                int score = 0;
                try {
                    algorithm.loadSequences(reader1, reader2);
                    score = algorithm.getScore();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (InvalidSequenceException ise) {
                    ise.printStackTrace();
                }
                catch (IncompatibleScoringSchemeException isse) {
                    isse.printStackTrace();
                }
                AlignmentInfo tagAI = new AlignmentInfo(tag2.tag(), tag2.chromosome(), tag2.position(), -1, 1, this.refGenome(), score);
                refTagAlignInfoMap.put((Object)tag1, (Object)tagAI);
            });
            if (++tagCount <= 999) continue;
            System.out.println("FInished aligning " + totalProcessedTags + " tags, this set took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds, now load to db ...");
            time = System.nanoTime();
            repGenData.putRefRefAlignments(refTagAlignInfoMap, this.refGenome());
            System.out.println("Loading DB took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds.\n");
            tagCount = 0;
            refTagAlignInfoMap.clear();
            time = System.nanoTime();
        }
        if (tagCount > 0) {
            System.out.println("FInished last refRef alignments " + totalProcessedTags + " tags, this set took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds, now load to db ...");
            time = System.nanoTime();
            repGenData.putRefRefAlignments(refTagAlignInfoMap, this.refGenome());
            System.out.println("Loading DB took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds.\n");
            tagCount = 0;
            refTagAlignInfoMap.clear();
            time = System.nanoTime();
        }
        System.out.println("Number of refTags: " + refTags.size() + ", TotalTime for calculateREfRefAlignment was " + (double)(System.nanoTime() - totalTime) / 1.0E9 + " seconds");
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public String dBFile() {
        return this.myDBFile.value();
    }

    public RampSeqAlignFromBlastTags dBFile(String value) {
        this.myDBFile = new PluginParameter<String>(this.myDBFile, value);
        return this;
    }

    public String refGenome() {
        return this.refGenome.value();
    }

    public RampSeqAlignFromBlastTags refGenome(String value) {
        this.refGenome = new PluginParameter<String>(this.refGenome, value);
        return this;
    }

    public Integer minTagCount() {
        return this.minTagCount.value();
    }

    public RampSeqAlignFromBlastTags minTagCount(Integer value) {
        this.minTagCount = new PluginParameter<Integer>(this.minTagCount, value);
        return this;
    }

    public Integer match_reward() {
        return this.match_reward.value();
    }

    public RampSeqAlignFromBlastTags match_reward(Integer value) {
        this.match_reward = new PluginParameter<Integer>(this.match_reward, value);
        return this;
    }

    public Integer mismatch_penalty() {
        return this.mismatch_penalty.value();
    }

    public RampSeqAlignFromBlastTags mismatch_penalty(Integer value) {
        this.mismatch_penalty = new PluginParameter<Integer>(this.mismatch_penalty, value);
        return this;
    }

    public Integer gap_penalty() {
        return this.gap_penalty.value();
    }

    public RampSeqAlignFromBlastTags gap_penalty(Integer value) {
        this.gap_penalty = new PluginParameter<Integer>(this.gap_penalty, value);
        return this;
    }

    public String forwardp() {
        return this.forwardp.value();
    }

    public RampSeqAlignFromBlastTags forwardp(String value) {
        this.forwardp = new PluginParameter<String>(this.forwardp, value);
        return this;
    }

    public String reversep() {
        return this.reversep.value();
    }

    public RampSeqAlignFromBlastTags reversep(String value) {
        this.reversep = new PluginParameter<String>(this.reversep, value);
        return this;
    }

    public String blastFile() {
        return this.blastFile.value();
    }

    public RampSeqAlignFromBlastTags blastFile(String value) {
        this.blastFile = new PluginParameter<String>(this.blastFile, value);
        return this;
    }
}

