/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.v2;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Ordering;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.maizegenetics.analysis.gbs.Barcode;
import net.maizegenetics.analysis.gbs.v2.BarcodeTrie;
import net.maizegenetics.analysis.gbs.v2.EnzymeList;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListIOUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class GBSUtils {
    private static final Logger myLogger = Logger.getLogger(GBSUtils.class);
    public static final String inputFileGlob = "glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}";
    public static final String sampleNameField = "FullSampleName";
    public static final String flowcellField = "Flowcell";
    public static final String laneField = "Lane";
    public static final String barcodeField = "Barcode";
    public static final String tissueNameField = "Tissue";
    public static final String fileNameField = "FileName";

    private GBSUtils() {
    }

    public static String[] readFastQBlock(BufferedReader bw, int currentRead) throws IOException {
        String[] result = new String[2];
        try {
            bw.readLine();
            result[0] = bw.readLine();
            bw.readLine();
            result[1] = bw.readLine();
            if (result[0] == null) {
                return null;
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            myLogger.error((Object)("Unable to correctly parse the sequence and quality score near line: " + currentRead * 4 + " from fastq file.  Your fastq file may have been corrupted."));
            return null;
        }
    }

    public static String[] readDeMultiPlexFastQBlock(BufferedReader bw, int currentRead) throws IOException {
        String[] result = new String[3];
        try {
            String barCode = bw.readLine();
            if (barCode == null) {
                return null;
            }
            int index = barCode.lastIndexOf(":");
            result[2] = barCode.substring(index + 1);
            result[0] = bw.readLine();
            bw.readLine();
            result[1] = bw.readLine();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            myLogger.error((Object)("Unable to correctly parse the sequence and quality score near line: " + currentRead * 4 + " from fastq file.  Your fastq file may have been corrupted."));
            return null;
        }
    }

    public static int determineQualityScoreBase(Path fastqFile) throws IOException {
        try {
            BufferedReader bw = Utils.getBufferedReader(fastqFile.toString());
            int headerParts = bw.readLine().split(":").length;
            int base = headerParts < 5 ? 64 : 33;
            myLogger.info((Object)(fastqFile.toString() + ": Quality score base:" + base));
            return base;
        }
        catch (IOException e) {
            e.printStackTrace();
            myLogger.error((Object)"Unable to correctly parse the quality score base from fastq file.  Your fastq file may have been corrupted.");
            return 0;
        }
    }

    public static ArrayList<Taxon> getLaneAnnotatedTaxaList(Path keyPath, Path fastQpath) {
        ArrayList<Taxon> annoTL;
        String[] filenameField = fastQpath.getFileName().toString().split("_");
        if (filenameField.length == 3) {
            annoTL = TaxaListIOUtils.readTaxaAnnotationFileAL(keyPath.toAbsolutePath().toString(), sampleNameField, (Map<String, String>)ImmutableMap.of((Object)flowcellField, (Object)filenameField[0], (Object)laneField, (Object)filenameField[1]));
        } else if (filenameField.length == 4) {
            annoTL = TaxaListIOUtils.readTaxaAnnotationFileAL(keyPath.toAbsolutePath().toString(), sampleNameField, (Map<String, String>)ImmutableMap.of((Object)flowcellField, (Object)filenameField[0], (Object)laneField, (Object)filenameField[2]));
        } else if (filenameField.length == 5) {
            annoTL = TaxaListIOUtils.readTaxaAnnotationFileAL(keyPath.toAbsolutePath().toString(), sampleNameField, (Map<String, String>)ImmutableMap.of((Object)flowcellField, (Object)filenameField[1], (Object)laneField, (Object)filenameField[3]));
        } else {
            myLogger.error((Object)("Error in parsing file name: " + fastQpath.toString()));
            myLogger.error((Object)"   The filename does not contain either 3, 4, or 5 underscore-delimited values.");
            myLogger.error((Object)"   Expect: flowcell_lane_fastq.txt.gz OR flowcell_s_lane_fastq.txt.gz OR code_flowcell_s_lane_fastq.txt.gz");
            return null;
        }
        return annoTL;
    }

    public static BarcodeTrie initializeBarcodeTrie(ArrayList<Taxon> taxaList, TaxaList masterTaxaList, EnzymeList.Enzyme myEnzyme) {
        BarcodeTrie aTrie = new BarcodeTrie();
        for (Taxon taxon : taxaList) {
            int masterIndex = masterTaxaList.indexOf(taxon.getName());
            GeneralAnnotation annotation = taxon.getAnnotation();
            String[] myTissues = annotation.getTextAnnotation(tissueNameField);
            Barcode theBC = null;
            theBC = new Barcode(annotation.getTextAnnotation(barcodeField)[0], myEnzyme.initialCutSiteRemnant(), taxon.getName(), masterIndex, annotation.getTextAnnotation(flowcellField)[0], annotation.getTextAnnotation(laneField)[0]);
            aTrie.addBarcode(theBC);
        }
        return aTrie;
    }

    public static BarcodeTrie initializeBarcodeTrie(ArrayList<Taxon> taxaList, TaxaList masterTaxaList, ArrayList masterTissueList, EnzymeList.Enzyme myEnzyme) {
        BarcodeTrie aTrie = new BarcodeTrie();
        for (Taxon taxon : taxaList) {
            int masterIndex = masterTaxaList.indexOf(taxon.getName());
            GeneralAnnotation annotation = taxon.getAnnotation();
            String[] myTissues = annotation.getTextAnnotation(tissueNameField);
            Barcode theBC = null;
            if (myTissues.length > 0) {
                int masterTissueIndex = masterTissueList.indexOf(myTissues[0]);
                theBC = new Barcode(annotation.getTextAnnotation(barcodeField)[0], myEnzyme.initialCutSiteRemnant(), taxon.getName(), masterIndex, myTissues[0], masterTissueIndex, annotation.getTextAnnotation(flowcellField)[0], annotation.getTextAnnotation(laneField)[0]);
            } else {
                theBC = new Barcode(annotation.getTextAnnotation(barcodeField)[0], myEnzyme.initialCutSiteRemnant(), taxon.getName(), masterIndex, annotation.getTextAnnotation(flowcellField)[0], annotation.getTextAnnotation(laneField)[0]);
            }
            aTrie.addBarcode(theBC);
        }
        return aTrie;
    }

    public static List<Path> culledFiles(List<Path> directoryFiles, Path keyFile) {
        ArrayList<Path> filesToProcess = new ArrayList<Path>();
        String keyFileName = keyFile.toString();
        ListMultimap<String, String> keyFileValues = GBSUtils.parseKeyfileIntoMap(keyFileName);
        if (keyFileValues.isEmpty()) {
            return filesToProcess;
        }
        directoryFiles.stream().forEach(directoryFile -> {
            String[] filenameField = directoryFile.getFileName().toString().split("_");
            if (filenameField.length == 3) {
                if (keyFileValues.containsEntry((Object)filenameField[0], (Object)filenameField[1])) {
                    filesToProcess.add((Path)directoryFile);
                }
            } else if (filenameField.length == 4) {
                if (keyFileValues.containsEntry((Object)filenameField[0], (Object)filenameField[2])) {
                    filesToProcess.add((Path)directoryFile);
                }
            } else if (filenameField.length == 5) {
                if (keyFileValues.containsEntry((Object)filenameField[1], (Object)filenameField[3])) {
                    filesToProcess.add((Path)directoryFile);
                }
            } else {
                myLogger.error((Object)("Error in parsing file name: " + directoryFile.toString()));
                myLogger.error((Object)"   The filename does not contain either 3, 4, or 5 underscore-delimited values.");
                myLogger.error((Object)"   Expect: flowcell_lane_fastq.txt.gz OR flowcell_s_lane_fastq.txt.gz OR code_flowcell_s_lane_fastq.txt.gz");
                myLogger.error((Object)("   " + directoryFile.toString() + " will not be processed."));
            }
        });
        return filesToProcess;
    }

    public static ListMultimap<String, String> parseKeyfileIntoMap(String fileName) {
        if (fileName == null) {
            return null;
        }
        ImmutableListMultimap.Builder mMap = new ImmutableListMultimap.Builder().orderKeysBy((Comparator)Ordering.natural()).orderValuesBy((Comparator)Ordering.natural());
        try {
            BufferedReader fileIn = Utils.getBufferedReader(fileName, 1000000);
            fileIn.mark(65536);
            String line = fileIn.readLine();
            int indexOfFlowcell = 0;
            int indexOfLane = 0;
            if (line.contains(flowcellField)) {
                int idx = 0;
                for (String header : line.split("\\t")) {
                    if (header.equals(flowcellField)) {
                        indexOfFlowcell = idx;
                    }
                    if (header.equals(laneField)) {
                        indexOfLane = idx;
                    }
                    ++idx;
                }
            } else {
                fileIn.reset();
            }
            while ((line = fileIn.readLine()) != null) {
                String[] myString = line.split("\\t");
                String myFlowCell = myString[indexOfFlowcell];
                String myLane = myString[indexOfLane];
                mMap.put((Object)myFlowCell, (Object)myLane);
            }
        }
        catch (Exception e) {
            System.err.println("Error in Reading Parsing Key File:" + fileName);
            e.printStackTrace();
        }
        return mMap.build();
    }
}

