/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.v2;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagBuilder;
import net.maizegenetics.dna.tag.TagDataSQLite;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class GetTagSequenceFromDBPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(GetTagSequenceFromDBPlugin.class);
    private PluginParameter<String> myDBFile = new PluginParameter.Builder<String>("db", null, String.class).guiName("Input DB").required(true).inFile().description("Input database file with tags").build();
    private PluginParameter<String> myOutputFile = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output File").required(true).outFile().description("Output txt file that can be imported to Excel").build();
    private PluginParameter<String> myTagSequence = new PluginParameter.Builder<String>("tagSequence", null, String.class).guiName("Tag Sequence").description("Enter specific tag sequence to verify existence in database.  If no sequence is provided, all tags from the DB will be printed").build();

    public GetTagSequenceFromDBPlugin() {
        super(null, false);
    }

    public GetTagSequenceFromDBPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    public GetTagSequenceFromDBPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public void postProcessParameters() {
        if (this.myDBFile.isEmpty() || !Files.exists(Paths.get(this.inputDB(), new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("GetTagSequenceFromDBPlugin: postProcessParameters: Input DB not set or found");
        }
        try {
            String string = new File(this.outputFile()).getCanonicalFile().getParent();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Problem resolving output directory:" + ioe);
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        try {
            BufferedWriter fileWriter = Utils.getBufferedWriter(this.outputFile());
            TagDataSQLite tagData = new TagDataSQLite(this.inputDB());
            LongAdder count = new LongAdder();
            Set<Tag> dbTags = tagData.getTags();
            try {
                String columnHeader = "Tags";
                fileWriter.write(columnHeader);
            }
            catch (Exception ioe) {
                myLogger.info((Object)("Catch in writing Tag file header error=" + ioe));
                ioe.printStackTrace();
            }
            if (this.tagSequence() != null) {
                Tag requestedTag = TagBuilder.instance(this.tagSequence()).build();
                if (dbTags.contains(requestedTag)) {
                    String tagString = "\n" + this.tagSequence();
                    this.writeTagSequence(fileWriter, tagString);
                } else {
                    String tagString = "\nNOT found: " + this.tagSequence();
                    this.writeTagSequence(fileWriter, tagString);
                }
            } else {
                tagData.getTags().forEach(tag -> {
                    String tagString = "\n" + tag.sequence();
                    this.writeTagSequence(fileWriter, tagString);
                    count.increment();
                });
            }
            fileWriter.close();
            tagData.close();
            myLogger.info((Object)("Finished printing tag sequences from database.\nTotal number of tags written: " + count.longValue() + "\nOuput tab-delimited file: " + this.outputFile() + "\n\n"));
        }
        catch (Exception e) {
            myLogger.info((Object)("Catch in reading database error=" + e));
            e.printStackTrace();
        }
        return null;
    }

    private void writeTagSequence(BufferedWriter fileWriter, String tagSequence) {
        try {
            fileWriter.write(tagSequence);
        }
        catch (IOException ioe) {
            myLogger.info((Object)("Catch in writing TagSequence file error=" + ioe));
            ioe.printStackTrace();
        }
    }

    @Override
    public String getToolTipText() {
        return "Verify single tag sequence exists in DB, or get list of all tag sequences in data base";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Get Tag Sequence from DB";
    }

    public String runPlugin(DataSet input) {
        return (String)this.performFunction(input).getData(0).getData();
    }

    public String inputDB() {
        return this.myDBFile.value();
    }

    public GetTagSequenceFromDBPlugin inputDB(String value) {
        this.myDBFile = new PluginParameter<String>(this.myDBFile, value);
        return this;
    }

    public String outputFile() {
        return this.myOutputFile.value();
    }

    public GetTagSequenceFromDBPlugin outputFile(String value) {
        this.myOutputFile = new PluginParameter<String>(this.myOutputFile, value);
        return this;
    }

    public String tagSequence() {
        return this.myTagSequence.value();
    }

    public GetTagSequenceFromDBPlugin tagSequence(String value) {
        this.myTagSequence = new PluginParameter<String>(this.myTagSequence, value);
        return this;
    }
}

