/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gobii;

import java.awt.Frame;
import java.sql.Connection;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.data.GenotypeSummaryPlugin;
import net.maizegenetics.analysis.gobii.BMSConnection;
import net.maizegenetics.analysis.gobii.GOBIIPostgresConnection;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.genotypecall.GOBIIGenotypeCallTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.taxa.TaxaList;
import org.apache.log4j.Logger;

public class GOBIIPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(GOBIIPlugin.class);
    private PluginParameter<String> myDataset = new PluginParameter.Builder<String>("dataset", null, String.class).required(true).description("Dataset Name").guiName("Dataset Name").build();
    private final PluginParameter<String> myDatabaseLabel = PluginParameter.getLabelInstance("GOBII Postgres Database Properties");
    private PluginParameter<String> myDBName = new PluginParameter.Builder<String>("db", null, String.class).required(true).guiName("Database Name").description("Database Name").build();
    private PluginParameter<String> myUser = new PluginParameter.Builder<String>("user", null, String.class).required(true).description("User Name").build();
    private PluginParameter<String> myPassword = new PluginParameter.Builder<String>("password", "", String.class).description("Password").password().build();
    private final PluginParameter<String> myBMSLabel = PluginParameter.getLabelInstance("BMS Database Properties");
    private PluginParameter<String> myBMSDBName = new PluginParameter.Builder<String>("bmsdb", null, String.class).required(true).guiName("BMS Database Name").description("BMS Database Name").build();
    private PluginParameter<String> myBMSHost = new PluginParameter.Builder<String>("bmshost", "localhost", String.class).guiName("BMS Host Name").description("BMS Host Name").build();
    private PluginParameter<String> myBMSUser = new PluginParameter.Builder<String>("bmsuser", null, String.class).required(true).guiName("BMS User").description("BMS User Name").build();
    private PluginParameter<String> myBMSPassword = new PluginParameter.Builder<String>("bmspassword", "", String.class).guiName("BMS Password").description("Password").password().build();

    public GOBIIPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        if (this.dBName() == null || this.dBName().length() == 0) {
            this.dBName(TasselPrefs.getGOBIIDB());
        }
        if (this.user() == null || this.user().length() == 0) {
            this.user(TasselPrefs.getGOBIIUser());
        }
    }

    @Override
    protected void postProcessParameters() {
        TasselPrefs.putGOBIIDB(this.dBName());
        TasselPrefs.putGOBIIUser(this.user());
        TasselPrefs.putBMSHost(this.bmsHost());
        TasselPrefs.putBMSDB(this.bmsDBName());
        TasselPrefs.putBMSUser(this.bmsUser());
    }

    @Override
    public DataSet processData(DataSet input) {
        Connection postgres = GOBIIPostgresConnection.connection("localhost", this.user(), this.myPassword.value(), this.dBName());
        Connection bms = BMSConnection.connection(this.bmsHost(), this.bmsUser(), this.myBMSPassword.value(), this.bmsDBName());
        String hdf5Filename = null;
        try {
            hdf5Filename = GOBIIPostgresConnection.hdf5Filename(postgres, this.dataset());
        }
        catch (Exception e) {
            GOBIIPostgresConnection.printAvailableDatasets(postgres);
            throw e;
        }
        TaxaList taxa = GOBIIPostgresConnection.taxaList(postgres, this.dataset(), bms);
        myLogger.info((Object)("Number of Taxa: " + taxa.numberOfTaxa()));
        PositionList positions = GOBIIPostgresConnection.positionList(postgres, this.dataset());
        myLogger.info((Object)("Number of Positions: " + positions.numberOfSites()));
        GOBIIGenotypeCallTable genotypes = GOBIIGenotypeCallTable.getInstance(taxa.numberOfTaxa(), positions.numberOfSites(), false, hdf5Filename);
        GenotypeTable genotypeTable = GenotypeTableBuilder.getInstance(genotypes, positions, taxa);
        DataSet result = new DataSet(new Datum("gobii:" + this.dataset(), genotypeTable, null), (Plugin)this);
        GenotypeSummaryPlugin.printSimpleSummary(result);
        return result;
    }

    public String dataset() {
        return this.myDataset.value();
    }

    public GOBIIPlugin dataset(String value) {
        this.myDataset = new PluginParameter<String>(this.myDataset, value);
        return this;
    }

    public String dBName() {
        return this.myDBName.value();
    }

    public GOBIIPlugin dBName(String value) {
        this.myDBName = new PluginParameter<String>(this.myDBName, value);
        return this;
    }

    public String user() {
        return this.myUser.value();
    }

    public GOBIIPlugin user(String value) {
        this.myUser = new PluginParameter<String>(this.myUser, value);
        return this;
    }

    public GOBIIPlugin password(String value) {
        this.myPassword = new PluginParameter<String>(this.myPassword, value);
        return this;
    }

    public String bmsDBName() {
        return this.myBMSDBName.value();
    }

    public GOBIIPlugin bmsDBName(String value) {
        this.myBMSDBName = new PluginParameter<String>(this.myBMSDBName, value);
        return this;
    }

    public String bmsHost() {
        return this.myBMSHost.value();
    }

    public GOBIIPlugin bmsHost(String value) {
        this.myBMSHost = new PluginParameter<String>(this.myBMSHost, value);
        return this;
    }

    public String bmsUser() {
        return this.myBMSUser.value();
    }

    public GOBIIPlugin bmsUser(String value) {
        this.myBMSUser = new PluginParameter<String>(this.myBMSUser, value);
        return this;
    }

    public GOBIIPlugin bmsPassword(String value) {
        this.myBMSPassword = new PluginParameter<String>(this.myBMSPassword, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "GOBII Plugin";
    }

    @Override
    public String getToolTipText() {
        return "GOBII Plugin";
    }
}

