/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gobii;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gobii.GOBIIDbUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.GeneratePluginCode;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.Utils;

public class GWAS_IFLPlugin
extends AbstractPlugin {
    private PluginParameter<String> b4rConfigFile = new PluginParameter.Builder<String>("b4rConfigFile", null, String.class).guiName("B4R Config File").required(true).description("DB config file containing connection information to the B4r database").build();
    private PluginParameter<String> inputFile = new PluginParameter.Builder<String>("inputFile", null, String.class).guiName("Input File").required(true).description("Tab-delimited Input File containing a header line and entries, or Directory containing Tab-delimited files of gwas data.  \nIf parameter is a directory, each file must contain a header line, and the files must end with .txt or .txt.gz").build();
    private PluginParameter<String> methodIds = new PluginParameter.Builder<String>("methodIds", null, String.class).guiName("Method IDs").required(true).description("Method Id from the method table.  Must be in same order as the statNames, one for each statname.").build();
    private PluginParameter<String> expID = new PluginParameter.Builder<String>("expId", null, String.class).guiName("GWAS Experiment  ID").required(true).description("ID of the GWAS experiment to which this data belongs. This experiment must already existin the gwas_experiment table.").build();
    private PluginParameter<String> statNames = new PluginParameter.Builder<String>("statNames", null, String.class).guiName("Statistic Names").required(true).description("Comma separated list of column names from which to pull data.  \nThese names must match values in the statistics field of the gwas_method table for the specified method name.").build();
    private PluginParameter<String> outputDir = new PluginParameter.Builder<String>("outputDir", null, String.class).guiName("Path of output directory").required(true).description("Full path name of directory to which output files will be written.  If no user prefix, then end with /").build();
    private static HashMap<Integer, BufferedWriter> traitWriters = null;
    private static HashMap<Integer, String> traitHM = null;
    private static HashMap<String, String> methodHM = null;
    private static int chrCol = -1;
    private static int markerCol = -1;
    private static int posCol = -1;
    private static int traitCol = -1;

    public GWAS_IFLPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    public GWAS_IFLPlugin() {
        super(null, false);
    }

    @Override
    public DataSet processData(DataSet input) {
        long totalTime = System.nanoTime();
        File dataFile = new File(this.inputFile());
        if (!dataFile.exists()) {
            System.out.println("ERROR - input file doesn't exit: " + this.inputFile());
            return null;
        }
        List<Object> directoryFiles = new ArrayList<Path>();
        String inputFileGlob = "glob:*{txt,txt.gz,}";
        if (dataFile.isDirectory()) {
            System.out.println("LCJ - input file is a directory");
            directoryFiles = DirectoryCrawler.listPaths(inputFileGlob, Paths.get(this.inputFile.value(), new String[0]).toAbsolutePath());
            Collections.sort(directoryFiles);
        } else {
            Path inputPath = Paths.get(this.inputFile(), new String[0]).toAbsolutePath();
            directoryFiles.add(inputPath);
        }
        System.out.println("LCJ - postProcessParamers: size of DirectoryFiles is " + directoryFiles.size());
        for (int idx = 0; idx < directoryFiles.size(); ++idx) {
            System.out.println("File " + idx + ": " + directoryFiles.get(idx));
        }
        Connection dbConnection = GOBIIDbUtils.connectToDB(this.b4rConfigFile());
        if (dbConnection == null) {
            throw new IllegalStateException("GWAS_IFLPlugin: Problem connecting to database.");
        }
        BufferedReader filebr = Utils.getBufferedReader(((Path)directoryFiles.get(0)).toString(), 0x400000);
        try {
            String headerline = filebr.readLine();
            filebr.close();
            boolean success = GWAS_IFLPlugin.findColumns(headerline, this.statNames(), this.methodIds(), this.outputDir());
            if (!success) {
                System.out.println("FindColumns failed - quitting");
                return null;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        String query = "select id,name from master.variable;";
        HashMap<String, Integer> traitIDMap = new HashMap<String, Integer>();
        GWAS_IFLPlugin.getTraitIds(dbConnection, query, traitIDMap);
        System.out.println("LCJ - Number of entries from b4r trait map: " + traitIDMap.size());
        StringBuilder sb = new StringBuilder();
        try {
            String headerLine = "phenotype_id\tmarker\tchr\tposition\texperiment_id\tmethod_id\tstatistic_name\tvalue\n";
            this.writeHeaderLineToFiles(headerLine);
            sb.setLength(0);
            for (int idx = 0; idx < directoryFiles.size(); ++idx) {
                boolean totalLines = false;
                long time = System.nanoTime();
                Path infile = (Path)directoryFiles.get(idx);
                String infileString = infile.toString();
                System.out.println("GWAS_IFLPlugin: processing file " + infileString);
                filebr = Utils.getBufferedReader(infileString, 0x400000);
                String line = filebr.readLine();
                sb.setLength(0);
                boolean count = false;
                while ((line = filebr.readLine()) != null) {
                    sb.setLength(0);
                    String[] tokens = line.split("\t");
                    int phenotypeId = (Integer)traitIDMap.get(tokens[traitCol]);
                    sb.append(Integer.toString(phenotypeId));
                    sb.append("\t");
                    sb.append(tokens[markerCol]);
                    sb.append("\t");
                    sb.append(tokens[chrCol]);
                    sb.append("\t");
                    sb.append(tokens[posCol]);
                    sb.append("\t");
                    sb.append(this.expID());
                    sb.append("\t");
                    this.writeValues(tokens, sb.toString());
                }
                System.out.println("Process took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds for file " + infileString);
            }
            System.out.println("TOtalTime for all files: " + (double)(System.nanoTime() - totalTime) / 1.0E9);
            filebr.close();
            this.Shutdown();
        }
        catch (IOException ioe) {
            System.out.println("LCJ - caught exception readding or writing data file ");
            ioe.printStackTrace();
        }
        return null;
    }

    private static void getTraitIds(Connection conn, String query, Map<String, Integer> traitIDMap) {
        try {
            ResultSet rs = conn.createStatement().executeQuery(query);
            while (rs.next()) {
                int id = rs.getInt("id");
                String trait = rs.getString("name");
                traitIDMap.put(trait, id);
            }
        }
        catch (SQLException sqle) {
            System.out.println("getTraitIds barfed on query: " + query);
            sqle.printStackTrace();
            return;
        }
    }

    private static boolean findColumns(String headerLine, String statNames, String methodIds, String outputDir) {
        System.out.println("LCJ - header line: " + headerLine);
        String[] headers = headerLine.split("\t");
        int index = 0;
        for (String header : headers) {
            if (header.trim().toUpperCase().equals("CHR")) {
                chrCol = index;
            } else if (header.trim().toUpperCase().equals("POS")) {
                posCol = index;
            } else if (header.trim().toUpperCase().equals("TRAIT")) {
                traitCol = index;
            } else if (header.trim().toUpperCase().equals("MARKER")) {
                markerCol = index;
            }
            ++index;
        }
        if (chrCol == -1 || posCol == -1 || traitCol == -1 || markerCol == -1) {
            System.out.println("LCJ - didn't find chr or pos or trait column - quitting");
            return false;
        }
        int ncols = 0;
        if (statNames != null && !statNames.equalsIgnoreCase("null")) {
            traitHM = new HashMap();
            methodHM = new HashMap();
            traitWriters = new HashMap();
            int search = -1;
            String[] traitTokens = statNames.split(",");
            String[] methodTokens = methodIds.split(",");
            for (String str : traitTokens) {
                for (int col = 0; col < headers.length; ++col) {
                    if (!str.equalsIgnoreCase(headers[col])) continue;
                    search = col;
                    break;
                }
                if (search < 0) {
                    System.out.println("Cannot find column " + str);
                    return false;
                }
                String strToStore = str;
                if (str.equals("p")) {
                    strToStore = "pvalue";
                }
                traitHM.put(search, strToStore);
                int methodIdx = Arrays.asList(traitTokens).indexOf(str);
                methodHM.put(strToStore, methodTokens[methodIdx]);
                ++ncols;
                System.out.println("Found " + str + " in column " + search);
            }
        }
        if (traitHM != null) {
            for (Integer idx : traitHM.keySet()) {
                String outFile = outputDir + traitHM.get(idx) + ".gwas_data";
                BufferedWriter statWriter = Utils.getBufferedWriter(outFile);
                traitWriters.put(idx, statWriter);
            }
        }
        if (ncols < 1) {
            throw new IllegalStateException("No valid columns to read in!");
        }
        return true;
    }

    private void writeHeaderLineToFiles(String headerline) {
        try {
            if (traitHM != null) {
                for (Integer idx : traitWriters.keySet()) {
                    traitWriters.get(idx).write(headerline);
                }
            }
        }
        catch (IOException ioe) {
            System.out.println("LCJ - error writing trait files");
            ioe.printStackTrace();
        }
    }

    private void writeValues(String[] next, String initialLine) {
        try {
            if (traitHM != null) {
                for (Integer idx : traitWriters.keySet()) {
                    String methodId = methodHM.get(traitHM.get(idx)) + "\t";
                    String lineToWrite = initialLine + methodId + traitHM.get(idx) + "\t" + next[idx] + "\n";
                    traitWriters.get(idx).write(lineToWrite);
                }
            }
        }
        catch (IOException ioe) {
            System.out.println("LCJ - error writing trait files");
            ioe.printStackTrace();
        }
    }

    private void Shutdown() {
        try {
            if (traitHM != null) {
                for (Integer i : traitWriters.keySet()) {
                    traitWriters.get(i).close();
                }
            }
        }
        catch (Exception exc) {
            System.out.println("Problem with shutdown");
            exc.printStackTrace();
        }
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public static void main(String[] args) {
        GeneratePluginCode.generate(GWAS_IFLPlugin.class);
    }

    public String inputFile() {
        return this.inputFile.value();
    }

    public GWAS_IFLPlugin inputFile(String value) {
        this.inputFile = new PluginParameter<String>(this.inputFile, value);
        return this;
    }

    public String methodIds() {
        return this.methodIds.value();
    }

    public GWAS_IFLPlugin methodIds(String value) {
        this.methodIds = new PluginParameter<String>(this.methodIds, value);
        return this;
    }

    public String expID() {
        return this.expID.value();
    }

    public GWAS_IFLPlugin expID(String value) {
        this.expID = new PluginParameter<String>(this.expID, value);
        return this;
    }

    public String statNames() {
        return this.statNames.value();
    }

    public GWAS_IFLPlugin statNames(String value) {
        this.statNames = new PluginParameter<String>(this.statNames, value);
        return this;
    }

    public String outputDir() {
        return this.outputDir.value();
    }

    public GWAS_IFLPlugin outputDir(String value) {
        this.outputDir = new PluginParameter<String>(this.outputDir, value);
        return this;
    }

    public String b4rConfigFile() {
        return this.b4rConfigFile.value();
    }

    public GWAS_IFLPlugin b4rConfigFile(String value) {
        this.b4rConfigFile = new PluginParameter<String>(this.b4rConfigFile, value);
        return this;
    }
}

