/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gobii;

import java.io.BufferedWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import net.maizegenetics.analysis.gobii.GOBIIDbUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class UpdateMarkerAndDNA_idxes {
    private static final Logger myLogger = Logger.getLogger(UpdateMarkerAndDNA_idxes.class);

    public static void createIdxValues(String configFile, String outputDir, int datasetID, int platformID, int experimentID) {
        String dnarunFile = outputDir + "DS_" + datasetID + ".sh5i";
        String markerFile = outputDir + "DS_" + datasetID + ".mh5i";
        try {
            BufferedWriter writerRunID = Utils.getBufferedWriter(dnarunFile);
            BufferedWriter writerMarkerID = Utils.getBufferedWriter(markerFile);
            long time = System.nanoTime();
            Connection dbConnection = GOBIIDbUtils.connectToDB(configFile);
            if (dbConnection == null) {
                throw new IllegalStateException("UpdateMarkerAndDNA_idxes: Problem connecting to database.");
            }
            StringBuilder builder = new StringBuilder();
            builder.append("select name from dnarun,dataset_dnarun where dataset_dnarun.dnarun_id=dnarun.dnarun_id and dataset_dnarun.dataset_id='");
            builder.append(datasetID);
            builder.append("' order by dnarun.dnarun_id;");
            String query = builder.toString();
            myLogger.info((Object)("processData: query statement for dnarun: " + query));
            System.out.println("UpdateMarkerAndDNA_idxes: execute query: " + query);
            dbConnection.setAutoCommit(false);
            Statement st = dbConnection.createStatement();
            st.setFetchSize(100000);
            ResultSet rs = st.executeQuery(query);
            writerRunID.write("dnarun_name\td_name\texperiment_id\n");
            while (rs.next()) {
                String dnarun_n = rs.getString("name");
                writerRunID.write(dnarun_n);
                writerRunID.write("\t");
                writerRunID.write(dnarun_n);
                writerRunID.write("\t");
                writerRunID.write(Integer.toString(experimentID));
                writerRunID.write("\n");
            }
            System.out.printf("TotalTime for dnarun_name query %g sec%n", (double)(System.nanoTime() - time) / 1.0E9);
            builder = new StringBuilder();
            builder.append("select name from marker, dataset_marker where marker.marker_id=dataset_marker.marker_id and dataset_marker.dataset_id='");
            builder.append(datasetID);
            builder.append("' order by marker.marker_id;");
            query = builder.toString();
            myLogger.info((Object)("processData: query statement: " + query));
            System.out.println("UpdateMarkerAndDNA_idxes: execute query: " + query);
            st = dbConnection.createStatement();
            st.setFetchSize(100000);
            rs = st.executeQuery(query);
            writerMarkerID.write("marker_name\tm_name\tplatform_id\n");
            while (rs.next()) {
                String marker_n = rs.getString("name");
                writerMarkerID.write(marker_n);
                writerMarkerID.write("\t");
                writerMarkerID.write(marker_n);
                writerMarkerID.write("\t");
                writerMarkerID.write(Integer.toString(platformID));
                writerMarkerID.write("\n");
            }
            writerRunID.close();
            writerMarkerID.close();
            System.out.printf("TotalTime for marker_name query: %g sec%n", (double)(System.nanoTime() - time) / 1.0E9);
        }
        catch (Exception exc) {
            System.out.println("UpdateMarkerAndDNA_idxes:  caught exception processing writing files");
            exc.printStackTrace();
        }
        System.out.println("\nFiles written to " + dnarunFile + " and " + markerFile);
    }

    public static void main(String[] args) {
        String configFile = "/Users/lcj34/notes_files/gobiiANDBms/gobii_loading/dbConfigFile_maize2.txt";
        String outputDir = "/Users/lcj34/notes_files/gobiiANDBms/gobii_loading/update_idxes/";
        int datasetID = 5;
        int platformID = 3;
        int experimentID = 4;
        UpdateMarkerAndDNA_idxes.createIdxValues(configFile, outputDir, datasetID, platformID, experimentID);
    }
}

