/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.awt.Frame;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.TableReportBuilder;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class ImputationAccuracyPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ImputationAccuracyPlugin.class);
    private PluginParameter<Boolean> isSubset = new PluginParameter.Builder<Boolean>("subset", false, Boolean.class).guiName("Imputed is subset of original").description("The imputed data does not contain all of the sites or taxa in the original data.").build();

    public ImputationAccuracyPlugin() {
        super(null, false);
    }

    public ImputationAccuracyPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
        if (alignInList.size() != 3) {
            throw new IllegalArgumentException("ImputationAccuracyPlugin: preProcessParameters: Please select three Genotype Table.");
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        if (this.isSubset.value().booleanValue()) {
            return this.processDataForSubset(input);
        }
        GenotypeTable origGenoTable = (GenotypeTable)input.getDataOfType(GenotypeTable.class).get(0).getData();
        myLogger.info((Object)("Original Genotype: " + input.getDataOfType(GenotypeTable.class).get(0).getName()));
        GenotypeTable maskGenoTable = (GenotypeTable)input.getDataOfType(GenotypeTable.class).get(1).getData();
        myLogger.info((Object)("Masked Genotype: " + input.getDataOfType(GenotypeTable.class).get(1).getName()));
        GenotypeTable impGenoTable = (GenotypeTable)input.getDataOfType(GenotypeTable.class).get(2).getData();
        myLogger.info((Object)("Imputed Genotype: " + input.getDataOfType(GenotypeTable.class).get(2).getName()));
        int[][] cnts = new int[5][5];
        for (int site = 0; site < origGenoTable.numberOfSites(); ++site) {
            byte majorAllele = origGenoTable.majorAllele(site);
            byte minorAllele = origGenoTable.minorAllele(site);
            HashMap<Byte, Integer> genotypeToIndexMap = new HashMap<Byte, Integer>();
            genotypeToIndexMap.put(GenotypeTableUtils.getDiploidValue(majorAllele, majorAllele), 0);
            genotypeToIndexMap.put(GenotypeTableUtils.getDiploidValue(majorAllele, minorAllele), 1);
            genotypeToIndexMap.put(GenotypeTableUtils.getDiploidValue(minorAllele, majorAllele), 1);
            genotypeToIndexMap.put(GenotypeTableUtils.getDiploidValue(minorAllele, minorAllele), 2);
            genotypeToIndexMap.put((byte)-1, 3);
            for (int taxonIdx = 0; taxonIdx < origGenoTable.numberOfTaxa(); ++taxonIdx) {
                byte origGeno = origGenoTable.genotype(taxonIdx, site);
                if (origGeno == -1 || maskGenoTable.genotype(taxonIdx, site) != -1) continue;
                int originalIndex = genotypeToIndexMap.getOrDefault(origGeno, 4);
                int impIndex = genotypeToIndexMap.getOrDefault(impGenoTable.genotype(taxonIdx, site), 4);
                if (impIndex == 4) {
                    System.out.println(site + ":" + ((Taxon)impGenoTable.taxa().get(taxonIdx)).toString() + ":" + impGenoTable.genotype(taxonIdx, site) + NucleotideAlignmentConstants.getNucleotideIUPAC(impGenoTable.genotype(taxonIdx, site)));
                }
                int[] nArray = cnts[originalIndex];
                int n = impIndex;
                nArray[n] = nArray[n] + 1;
            }
        }
        DataSet dataSet = new DataSet(new Datum("AccuracyReport", this.makeTableReport(cnts), ""), (Plugin)this);
        return dataSet;
    }

    private DataSet processDataForSubset(DataSet input) {
        GenotypeTable origGenoTable = (GenotypeTable)input.getDataOfType(GenotypeTable.class).get(0).getData();
        myLogger.info((Object)("Original Genotype: " + input.getDataOfType(GenotypeTable.class).get(0).getName()));
        GenotypeTable maskGenoTable = (GenotypeTable)input.getDataOfType(GenotypeTable.class).get(1).getData();
        myLogger.info((Object)("Masked Genotype: " + input.getDataOfType(GenotypeTable.class).get(1).getName()));
        GenotypeTable impGenoTable = (GenotypeTable)input.getDataOfType(GenotypeTable.class).get(2).getData();
        myLogger.info((Object)("Imputed Genotype: " + input.getDataOfType(GenotypeTable.class).get(2).getName()));
        int[][] cnts = new int[5][5];
        for (int site = 0; site < origGenoTable.numberOfSites(); ++site) {
            int imputedSite = impGenoTable.positions().siteOfPhysicalPosition(origGenoTable.chromosomalPosition(site), origGenoTable.chromosome(site));
            if (imputedSite < 0) continue;
            byte majorAllele = origGenoTable.majorAllele(site);
            byte minorAllele = origGenoTable.minorAllele(site);
            HashMap<Byte, Integer> genotypeToIndexMap = new HashMap<Byte, Integer>();
            genotypeToIndexMap.put(GenotypeTableUtils.getDiploidValue(majorAllele, majorAllele), 0);
            genotypeToIndexMap.put(GenotypeTableUtils.getDiploidValue(majorAllele, minorAllele), 1);
            genotypeToIndexMap.put(GenotypeTableUtils.getDiploidValue(minorAllele, majorAllele), 1);
            genotypeToIndexMap.put(GenotypeTableUtils.getDiploidValue(minorAllele, minorAllele), 2);
            genotypeToIndexMap.put((byte)-1, 3);
            for (int taxonIdx = 0; taxonIdx < origGenoTable.numberOfTaxa(); ++taxonIdx) {
                byte origGeno;
                int imputedTaxonIdx = impGenoTable.taxa().indexOf((Taxon)origGenoTable.taxa().get(taxonIdx));
                if (imputedTaxonIdx < 0 || (origGeno = origGenoTable.genotype(taxonIdx, site)) == -1 || maskGenoTable.genotype(taxonIdx, site) != -1) continue;
                int originalIndex = genotypeToIndexMap.getOrDefault(origGeno, 4);
                try {
                    byte by = impGenoTable.genotype(imputedTaxonIdx, imputedSite);
                }
                catch (Exception e) {
                    System.out.printf("Error at orig site = %d, imputed site = %d%n", site, imputedSite);
                }
                int impIndex = genotypeToIndexMap.getOrDefault(impGenoTable.genotype(imputedTaxonIdx, imputedSite), 4);
                if (impIndex == 4) {
                    System.out.println(site + ":" + ((Taxon)impGenoTable.taxa().get(taxonIdx)).toString() + ":" + impGenoTable.genotype(imputedTaxonIdx, imputedSite) + NucleotideAlignmentConstants.getNucleotideIUPAC(impGenoTable.genotype(imputedTaxonIdx, imputedSite)));
                }
                int[] nArray = cnts[originalIndex];
                int n = impIndex;
                nArray[n] = nArray[n] + 1;
            }
        }
        DataSet dataSet = new DataSet(new Datum("AccuracyReport", this.makeTableReport(cnts), ""), (Plugin)this);
        return dataSet;
    }

    private TableReport makeTableReport(int[][] cnts) {
        Object[] headers = new String[]{"Original/Imputed", "AA", "Aa", "aa", "N", "Other"};
        TableReportBuilder reportBuilder = TableReportBuilder.getInstance("ImputationAccuracy", headers);
        int errors = 0;
        int correct = 0;
        for (int i = 0; i < cnts.length; ++i) {
            reportBuilder.addElements(headers[i + 1], ArrayUtils.toObject((int[])cnts[i]));
            correct += cnts[i][i];
            errors += cnts[i][0] + cnts[i][1] + cnts[i][2] - cnts[i][i];
        }
        double errorRate = (double)errors / (double)(correct + errors);
        reportBuilder.addElements("Correct", correct);
        reportBuilder.addElements("Errors", errors);
        reportBuilder.addElements("ErrorRate", errorRate);
        return reportBuilder.build();
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Evaluate Imputation Accuracy";
    }

    @Override
    public String getToolTipText() {
        return "Evaluate Imputation Accuracy";
    }

    public TableReport runPlugin(DataSet input) {
        return (TableReport)this.performFunction(input).getData(0).getData();
    }
}

