/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.LoggingUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class MergeBreakpointFilesPlugin
extends AbstractPlugin {
    private static Logger myLogger = Logger.getLogger(MergeBreakpointFilesPlugin.class);
    private static final int minSite = 0;
    private static final int maxSite = 350000000;
    private PluginParameter<Boolean> selectFiles = new PluginParameter.Builder<Boolean>("selectFiles", false, Boolean.class).description("Select the files to merge. Alternatively, merge all files in a directory. (Default = false)").guiName("Select Files to Merge").build();
    private PluginParameter<String> selectedFilesList = new PluginParameter.Builder<String>("fileList", null, String.class).description("The name and path of a file containing the names of the breakpoint files to be merged.").guiName("List of files to merge").inFile().build();
    private PluginParameter<String> outputFile = new PluginParameter.Builder<String>("outputFile", null, String.class).description("The output file. If the filename ends in gz it will be zipped. Required.").required(true).guiName("Output File").required(true).outFile().build();
    private PluginParameter<Boolean> fillToEnd = new PluginParameter.Builder<Boolean>("fillends", false, Boolean.class).description("Should the first and last break point intervals in each chromosome be exended to the ends?").guiName("Fill to Ends").build();

    public MergeBreakpointFilesPlugin() {
        this(null, false);
    }

    public MergeBreakpointFilesPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        if (!this.selectFiles.value().booleanValue() && this.selectedFilesList.value() == null) {
            throw new IllegalArgumentException("Either a list of files must be provided or individual files selected.");
        }
        if (this.selectFiles.value().booleanValue()) {
            if (!this.isInteractive()) {
                throw new IllegalArgumentException("Must supply a file list in command line mode.");
            }
            JFileChooser myInputFileChooser = new JFileChooser();
            myInputFileChooser.setName("George");
            int result = myInputFileChooser.showOpenDialog(this.getParentFrame());
            File[] mySelectedFiles = new File[]{};
            if (result == 0) {
                mySelectedFiles = myInputFileChooser.getSelectedFiles();
            }
            if (mySelectedFiles.length > 0 || this.outputFile != null) {
                this.mergeBreakpoints(mySelectedFiles);
            } else {
                if (mySelectedFiles.length == 0) {
                    throw new IllegalArgumentException("No input files were selected.");
                }
                if (this.outputFile == null) {
                    throw new IllegalArgumentException("An output file name was not supplied.");
                }
            }
        } else {
            try (BufferedReader br = new BufferedReader(new FileReader(this.selectedFilesList.value()));){
                String inputLine;
                ArrayList<File> files = new ArrayList<File>();
                while ((inputLine = br.readLine()) != null) {
                    if (inputLine.length() <= 1) continue;
                    File nextFile = new File(inputLine);
                    if (nextFile.exists()) {
                        files.add(nextFile);
                        continue;
                    }
                    String msg = nextFile.getPath() + " does not exist.";
                    myLogger.error((Object)msg);
                }
                if (files.size() > 0) {
                    File[] inputFiles = (File[])files.stream().toArray(File[]::new);
                    this.mergeBreakpoints(inputFiles);
                }
            }
            catch (IOException e) {
                String msg = "Unable to read from " + this.selectedFilesList.value() + ". Make certain that file exists.";
                throw new RuntimeException(msg, e);
            }
        }
        return null;
    }

    private void mergeBreakpoints(File[] inputFiles) {
        Pattern white_space = Pattern.compile("\\s+");
        Pattern colon = Pattern.compile(":");
        Map<String, Integer> allParentMap = this.readAndIndexParents(inputFiles);
        HashMap breakpointListMap = new HashMap();
        for (File input : inputFiles) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(input));
                Object object = null;
                try {
                    int i;
                    String string = br.readLine();
                    String[] parsedLine = white_space.split(string);
                    int nparents = Integer.parseInt(parsedLine[0]);
                    int ntaxa = Integer.parseInt(parsedLine[1]);
                    br.readLine();
                    HashMap<Integer, Integer> parentIndexer = new HashMap<Integer, Integer>();
                    for (i = 0; i < nparents; ++i) {
                        parsedLine = white_space.split(br.readLine());
                        parentIndexer.put(Integer.decode(parsedLine[0]), allParentMap.get(parsedLine[1]));
                    }
                    br.readLine();
                    br.readLine();
                    for (i = 0; i < ntaxa; ++i) {
                        try {
                            parsedLine = white_space.split(br.readLine());
                        }
                        catch (Exception e) {
                            myLogger.debug((Object)String.format("null pointer at %d in %s.", i, input.getName()));
                            System.out.println();
                        }
                        String taxon = parsedLine[0];
                        List segmentList = Arrays.stream(parsedLine).skip(1L).map(seg -> Segment.getInstance(colon.split((CharSequence)seg))).filter(opt -> opt.isPresent()).map(opt -> {
                            Segment seg = (Segment)opt.get();
                            seg.parent1 = (Integer)parentIndexer.get(seg.parent1);
                            seg.parent2 = (Integer)parentIndexer.get(seg.parent2);
                            return seg;
                        }).collect(Collectors.toList());
                        List bplist = (List)breakpointListMap.get(taxon);
                        if (bplist == null) {
                            bplist = segmentList;
                            breakpointListMap.put(taxon, bplist);
                            continue;
                        }
                        bplist.addAll(segmentList);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (br != null) {
                        if (object != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            br.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read " + input.getName(), e);
            }
        }
        ArrayList taxa = new ArrayList(breakpointListMap.keySet());
        Collections.sort(taxa);
        try (BufferedWriter bw = Utils.getBufferedWriter(this.outputFile.value());){
            int nparents = allParentMap.size();
            bw.write(String.format("%d\t%d\n", nparents, taxa.size()));
            bw.write("#Donor Haplotypes\n");
            String[] parents = new String[nparents];
            for (Map.Entry entry : allParentMap.entrySet()) {
                parents[((Integer)entry.getValue()).intValue()] = (String)entry.getKey();
            }
            for (int i = 0; i < nparents; ++i) {
                bw.write(String.format("%d\t%s\n", i, parents[i]));
            }
            bw.write("#Taxa Breakpoints\n");
            bw.write("#Block are defined chr:startPos:endPos:donor1:donor2 (-1 means no hypothesis)\n");
            for (String string : taxa) {
                List segList = (List)breakpointListMap.get(string);
                Collections.sort(segList);
                if (this.fillToEnd.value().booleanValue()) {
                    this.fillToChromosomeEnds(segList);
                }
                String outline = segList.stream().map(seg -> seg.toString()).collect(Collectors.joining("\t", string + "\t", "\n"));
                bw.write(outline);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write to " + this.outputFile.value(), e);
        }
    }

    private Map<String, Integer> readAndIndexParents(File[] inputFiles) {
        Pattern white_space = Pattern.compile("\\s+");
        TreeSet<String> parentSet = new TreeSet<String>();
        for (File input : inputFiles) {
            try (BufferedReader br = new BufferedReader(new FileReader(input));){
                br.readLine();
                br.readLine();
                String inputLine = br.readLine();
                while (!inputLine.startsWith("#")) {
                    String[] parsedLine;
                    if (inputLine.length() > 0 && (parsedLine = white_space.split(inputLine)).length == 2) {
                        parentSet.add(parsedLine[1]);
                    }
                    inputLine = br.readLine();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read " + input.getName(), e);
            }
        }
        HashMap<String, Integer> parentMap = new HashMap<String, Integer>();
        int parentCount = 0;
        for (String parent : parentSet) {
            parentMap.put(parent, parentCount++);
        }
        return parentMap;
    }

    private void fillToChromosomeEnds(List<Segment> segList) {
        int nseg = segList.size();
        Segment first = segList.get(0);
        first.start = 0;
        segList.get((int)(nseg - 1)).end = 350000000;
        String prevChr = "none";
        Segment prevSeg = first;
        for (int s = 1; s < nseg; ++s) {
            Segment currSeg = segList.get(s);
            if (!currSeg.chr.equals(prevSeg.chr)) {
                currSeg.start = 0;
                prevSeg.end = 350000000;
            }
            prevSeg = currSeg;
        }
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Merge breakpoint files";
    }

    @Override
    public String getToolTipText() {
        return "Merge selected breakpoint files.";
    }

    public Boolean selectFiles() {
        return this.selectFiles.value();
    }

    public MergeBreakpointFilesPlugin selectFiles(Boolean value) {
        this.selectFiles = new PluginParameter<Boolean>(this.selectFiles, value);
        return this;
    }

    public String selectedFilesList() {
        return this.selectedFilesList.value();
    }

    public MergeBreakpointFilesPlugin selectedFilesList(String value) {
        this.selectedFilesList = new PluginParameter<String>(this.selectedFilesList, value);
        return this;
    }

    public String outputFile() {
        return this.outputFile.value();
    }

    public MergeBreakpointFilesPlugin outputFile(String value) {
        this.outputFile = new PluginParameter<String>(this.outputFile, value);
        return this;
    }

    static {
        LoggingUtils.setupDebugLogging();
    }

    static class Segment
    implements Comparable<Segment> {
        static final Pattern colon = Pattern.compile(":");
        String chr;
        int chrnumber;
        int start;
        int end;
        int parent1;
        int parent2;

        Segment() {
        }

        Segment(String[] input) {
            this.chr = input[0];
            try {
                this.chrnumber = Integer.parseInt(this.chr);
            }
            catch (Exception e) {
                this.chrnumber = -1;
            }
            this.start = Integer.parseInt(input[1]);
            this.end = Integer.parseInt(input[2]);
            this.parent1 = Integer.parseInt(input[3]);
            this.parent2 = Integer.parseInt(input[4]);
        }

        public static Optional<Segment> getInstance(String[] input) {
            if (input.length != 5) {
                return Optional.empty();
            }
            return Optional.of(new Segment(input));
        }

        public String toString() {
            return String.format("%s:%d:%d:%d:%d", this.chr, this.start, this.end, this.parent1, this.parent2);
        }

        @Override
        public int compareTo(Segment seg) {
            if (this.chr != seg.chr) {
                if (this.chrnumber == seg.chrnumber) {
                    return this.chr.compareTo(seg.chr);
                }
                return this.chrnumber - this.chrnumber;
            }
            return this.start - seg.start;
        }
    }
}

