/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import net.maizegenetics.analysis.modelfitter.AdditiveSite;

public abstract class AbstractAdditiveSite
implements AdditiveSite {
    private static final long serialVersionUID = 3032879930663240377L;
    protected final int siteIndex;
    protected final String chrName;
    protected final int position;
    protected final String name;
    protected double criterionValue;
    protected final AdditiveSite.CRITERION selectionCriterion;
    protected final int direction;

    public AbstractAdditiveSite(int site, String chromosomeName, int pos, String id, AdditiveSite.CRITERION selectionCriterion) {
        this.siteIndex = site;
        this.selectionCriterion = selectionCriterion;
        this.direction = selectionCriterion == AdditiveSite.CRITERION.pval ? 1 : -1;
        this.chrName = chromosomeName;
        this.position = pos;
        this.name = id;
    }

    @Override
    public int siteNumber() {
        return this.siteIndex;
    }

    @Override
    public String chromosomeName() {
        return this.chrName;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public String siteName() {
        return this.name;
    }

    @Override
    public double criterionValue() {
        return this.criterionValue;
    }

    @Override
    public void criterionValue(double value) {
        this.criterionValue = value;
    }

    @Override
    public AdditiveSite.CRITERION selectionCriterion() {
        return this.selectionCriterion;
    }

    @Override
    public int compareTo(AdditiveSite other) {
        return this.direction * Double.compare(this.criterionValue, other.criterionValue());
    }
}

