/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.maizegenetics.analysis.modelfitter.AdditiveSite;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;
import org.apache.commons.math3.distribution.FDistribution;

public class CovariatePermutationTestSpliterator
implements Spliterator<double[]> {
    protected List<double[]> myPermutedData;
    protected List<AdditiveSite> mySites;
    protected List<ModelEffect> myBaseModel;
    protected int origin;
    protected final int end;

    public CovariatePermutationTestSpliterator(List<double[]> permutedData, List<AdditiveSite> siteList, List<ModelEffect> baseModel) {
        this.myPermutedData = permutedData;
        this.mySites = siteList;
        this.myBaseModel = baseModel;
        this.origin = 0;
        this.end = siteList.size();
        int numberOfEffects = baseModel.size();
        DoubleMatrix[][] components = new DoubleMatrix[1][numberOfEffects];
        for (int i = 0; i < numberOfEffects; ++i) {
            components[0][i] = this.myBaseModel.get(i).getX();
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super double[]> action) {
        if (this.origin == this.end) {
            return false;
        }
        AdditiveSite as = this.mySites.get(this.origin);
        ArrayList<ModelEffect> myModel = new ArrayList<ModelEffect>(this.myBaseModel);
        CovariateModelEffect cme = new CovariateModelEffect(as.getCovariate());
        myModel.add(cme);
        SweepFastLinearModel sflm = new SweepFastLinearModel((List<ModelEffect>)myModel, this.myPermutedData.get(0));
        double dfError = sflm.getResidualSSdf()[1];
        DoubleMatrix G = sflm.getInverseOfXtX();
        FDistribution fdist = new FDistribution(1.0, dfError);
        double[] pvals = this.myPermutedData.stream().map(d -> DoubleMatrixFactory.DEFAULT.make(((double[])d).length, 1, (double[])d)).mapToDouble(y -> {
            double[] yarray = y.to1DArray();
            int nbase = this.myBaseModel.size();
            DoubleMatrix[][] xtyMatrices = new DoubleMatrix[nbase + 1][1];
            for (int i = 0; i < nbase; ++i) {
                xtyMatrices[i][0] = this.myBaseModel.get(i).getXty(yarray);
            }
            xtyMatrices[nbase][0] = cme.getXty(yarray);
            DoubleMatrix Xty = DoubleMatrixFactory.DEFAULT.compose(xtyMatrices);
            DoubleMatrix beta = G.mult(Xty);
            double ssTotal = y.crossproduct().get(0, 0);
            double ssModel = Xty.crossproduct(beta).get(0, 0);
            double ssError = ssTotal - ssModel;
            double kb = beta.get(beta.numberOfRows() - 1, beta.numberOfColumns() - 1);
            double kgk = G.get(G.numberOfRows() - 1, G.numberOfColumns() - 1);
            double F = kb * kb / kgk / ssError * dfError;
            double p = 1.0 - fdist.cumulativeProbability(F);
            return p;
        }).toArray();
        action.accept((double[])pvals);
        ++this.origin;
        return true;
    }

    @Override
    public Spliterator<double[]> trySplit() {
        int numberRemaining = this.end - this.origin;
        if (numberRemaining < 50) {
            return null;
        }
        int mid = this.origin + numberRemaining / 2;
        List<AdditiveSite> splitSublist = this.mySites.subList(this.origin, mid);
        this.origin = mid;
        List<double[]> permutedDataCopy = this.myPermutedData.stream().map(d -> Arrays.copyOf(d, ((double[])d).length)).collect(Collectors.toList());
        return new CovariatePermutationTestSpliterator(permutedDataCopy, splitSublist, this.myBaseModel);
    }

    @Override
    public long estimateSize() {
        return this.end - this.origin;
    }

    @Override
    public int characteristics() {
        return 17728;
    }
}

