/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import net.maizegenetics.analysis.modelfitter.AbstractAdditiveSite;
import net.maizegenetics.analysis.modelfitter.AdditiveSite;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;

public class GenotypeAdditiveSite
extends AbstractAdditiveSite {
    private static final long serialVersionUID = -7891486608129027827L;
    private int[] bitStore;
    private double[] byteConversion;
    protected int ntaxa;
    protected int[] taxaIndex = null;

    public GenotypeAdditiveSite(int site, String chr, int pos, String id, AdditiveSite.CRITERION selectionCriterion, byte[] genotype, byte majorAllele, double majorAlleleFrequency) {
        super(site, chr, pos, id, selectionCriterion);
        byte unknown = -1;
        this.ntaxa = genotype.length;
        double mean = 2.0 * majorAlleleFrequency;
        this.byteConversion = new double[]{0.0, 1.0, 2.0, mean};
        int numberOfInts = this.ntaxa / 16;
        int remainder = this.ntaxa % 16;
        if (remainder > 0) {
            ++numberOfInts;
        }
        this.bitStore = new int[numberOfInts];
        int intCount = 0;
        int genoCount = 0;
        while (genoCount < this.ntaxa) {
            int intStore = 0;
            for (int i = 0; i < 32; i += 2) {
                int genoIndex;
                byte geno;
                if ((geno = genotype[genoCount++]) == unknown) {
                    genoIndex = 3;
                } else {
                    genoIndex = 0;
                    byte[] alleles = GenotypeTableUtils.getDiploidValues(geno);
                    if (alleles[0] == majorAllele) {
                        ++genoIndex;
                    }
                    if (alleles[1] == majorAllele) {
                        ++genoIndex;
                    }
                }
                intStore |= genoIndex << i;
                if (genoCount == this.ntaxa) break;
            }
            this.bitStore[intCount++] = intStore;
        }
    }

    private GenotypeAdditiveSite(int site, String chr, int pos, String id, AdditiveSite.CRITERION selectionCriterion, int[] bitStore, int ntaxa, double[] byteConversion) {
        super(site, chr, pos, id, selectionCriterion);
        this.bitStore = bitStore;
        this.ntaxa = ntaxa;
        this.byteConversion = byteConversion;
    }

    @Override
    public void reindexTaxa(int[] taxaIndex, List<Integer> uniqueTaxa) {
        this.taxaIndex = taxaIndex;
        int[] counts = new int[4];
        for (Integer Ndx : uniqueTaxa) {
            int n = this.genotypeIndex(Ndx);
            counts[n] = counts[n] + 1;
        }
        double numerator = 2 * counts[2] + counts[1];
        double denominator = numerator + (double)(counts[1] + 2 * counts[0]);
        double majorAlleleFreq = numerator / denominator;
        double mean = 2.0 * majorAlleleFreq;
        this.byteConversion = new double[]{0.0, 1.0, 2.0, mean};
    }

    private int genotypeIndex(int n) {
        int i = (n *= 2) / 32;
        int j = n % 32;
        int intStore = this.bitStore[i];
        return intStore >> j & 3;
    }

    @Override
    public double[] getCovariate() {
        if (this.taxaIndex == null) {
            return this.getCovariateNoReindex();
        }
        return this.getCovariateWithReindex();
    }

    @Override
    public double[] getCovariate(int[] subset) {
        if (this.taxaIndex == null) {
            return this.getCovariateNoReindex(subset);
        }
        return this.getCovariateWithReindex(subset);
    }

    public double[] getCovariateNoReindex() {
        double[] cov = new double[this.ntaxa];
        int intCount = 0;
        int genoCount = 0;
        block0: while (genoCount < this.ntaxa) {
            int intStore = this.bitStore[intCount++];
            for (int i = 0; i < 32; i += 2) {
                int genoIndex = intStore >> i & 3;
                cov[genoCount++] = this.byteConversion[genoIndex];
                if (genoCount == this.ntaxa) continue block0;
            }
        }
        return cov;
    }

    public double[] getCovariateNoReindex(int[] subset) {
        int nobs = subset.length;
        double[] allCov = this.getCovariate();
        double[] cov = new double[nobs];
        for (int i = 0; i < nobs; ++i) {
            cov[i] = allCov[subset[i]];
        }
        return cov;
    }

    public double[] getCovariateWithReindex() {
        int nval = this.taxaIndex.length;
        double[] cov = new double[nval];
        for (int i = 0; i < nval; ++i) {
            cov[i] = this.byteConversion[this.genotypeIndex(this.taxaIndex[i])];
        }
        return cov;
    }

    public double[] getCovariateWithReindex(int[] subset) {
        int nval = subset.length;
        double[] cov = new double[nval];
        for (int i = 0; i < nval; ++i) {
            cov[i] = this.byteConversion[this.genotypeIndex(this.taxaIndex[subset[i]])];
        }
        return cov;
    }

    public static void serializeAdditiveSites(GenotypeTable geno, String outFile) {
        long start = System.nanoTime();
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outFile));
            int nsites = geno.numberOfSites();
            int ntaxa = geno.numberOfTaxa();
            out.writeObject(new Integer(ntaxa));
            TaxaList myTaxa = geno.taxa();
            for (Taxon t : myTaxa) {
                out.writeObject(t.getName());
            }
            out.writeObject(new Integer(nsites));
            for (int s = 0; s < nsites; ++s) {
                GenotypeAdditiveSite mySite = new GenotypeAdditiveSite(s, geno.chromosomeName(s), geno.chromosomalPosition(s), geno.siteName(s), AdditiveSite.CRITERION.pval, geno.genotypeAllTaxa(s), geno.majorAllele(s), geno.majorAlleleFrequency(s));
                out.writeObject(mySite);
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(String.format("Error writing additive sites to %s.", outFile), e);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error writing additive sites to %s.", outFile), e);
        }
        System.out.printf("%d sites written to %s at %d ms.\n", geno.numberOfSites(), outFile, (System.nanoTime() - start) / 1000000L);
    }

    @Override
    public AdditiveSite copy() {
        return new GenotypeAdditiveSite(this.siteIndex, this.chrName, this.position, this.name, this.selectionCriterion, Arrays.copyOf(this.bitStore, this.bitStore.length), this.ntaxa, Arrays.copyOf(this.byteConversion, this.byteConversion.length));
    }
}

