/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.maizegenetics.analysis.modelfitter.AdditiveSite;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.NestedCovariateModelEffect;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;
import org.apache.commons.math3.distribution.FDistribution;

public class NestedCovariatePermutationTestSpliterator
implements Spliterator<double[]> {
    private List<double[]> myPermutedData;
    private List<AdditiveSite> mySites;
    private List<ModelEffect> myBaseModel;
    private FactorModelEffect myOuter;
    private int origin;
    private final int end;

    public NestedCovariatePermutationTestSpliterator(List<double[]> permutedData, List<AdditiveSite> siteList, List<ModelEffect> baseModel, ModelEffect outerEffect) {
        this.myPermutedData = permutedData;
        this.mySites = siteList;
        this.myBaseModel = baseModel;
        if (!(outerEffect instanceof FactorModelEffect)) {
            throw new IllegalArgumentException(String.format("The outer effect, %s, is not a factor and cannot be used for nesting.", outerEffect.getID().toString()));
        }
        this.myOuter = (FactorModelEffect)outerEffect;
        this.origin = 0;
        this.end = siteList.size();
        int numberOfEffects = baseModel.size();
        DoubleMatrix[][] components = new DoubleMatrix[1][numberOfEffects];
        for (int i = 0; i < numberOfEffects; ++i) {
            components[0][i] = this.myBaseModel.get(i).getX();
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super double[]> action) {
        if (this.origin == this.end) {
            return false;
        }
        AdditiveSite as = this.mySites.get(this.origin);
        ArrayList<ModelEffect> myModel = new ArrayList<ModelEffect>(this.myBaseModel);
        CovariateModelEffect cme = new CovariateModelEffect(as.getCovariate());
        NestedCovariateModelEffect ncme = new NestedCovariateModelEffect(cme, this.myOuter);
        myModel.add(ncme);
        SweepFastLinearModel sflm = new SweepFastLinearModel((List<ModelEffect>)myModel, this.myPermutedData.get(0));
        double dfError = sflm.getResidualSSdf()[1];
        double dfCovar = sflm.getIncrementalSSdf(this.myBaseModel.size())[1];
        DoubleMatrix G = sflm.getInverseOfXtX();
        int numberOfOuterLevels = this.myOuter.getNumberOfLevels();
        int ncolBase = this.myBaseModel.stream().mapToInt(me -> me.getEffectSize()).sum();
        int[] betaSelection = IntStream.range(ncolBase, ncolBase + numberOfOuterLevels).toArray();
        DoubleMatrix invKGK = G.getSelection(betaSelection, betaSelection).inverse();
        FDistribution fdist = new FDistribution(dfCovar, dfError);
        double[] pvals = this.myPermutedData.stream().map(d -> DoubleMatrixFactory.DEFAULT.make(((double[])d).length, 1, (double[])d)).mapToDouble(y -> {
            double[] yarray = y.to1DArray();
            int nbase = this.myBaseModel.size();
            DoubleMatrix[][] xtyMatrices = new DoubleMatrix[nbase + 1][1];
            for (int i = 0; i < nbase; ++i) {
                xtyMatrices[i][0] = this.myBaseModel.get(i).getXty(yarray);
            }
            xtyMatrices[nbase][0] = ncme.getXty(yarray);
            DoubleMatrix Xty = DoubleMatrixFactory.DEFAULT.compose(xtyMatrices);
            DoubleMatrix beta = G.mult(Xty);
            DoubleMatrix Kbeta = beta.getSelection(betaSelection, null);
            double Q = Kbeta.crossproduct(invKGK.mult(Kbeta)).get(0, 0);
            double totalSS = y.crossproduct().get(0, 0);
            double modelSS = Xty.crossproduct(beta).get(0, 0);
            double residualSS = totalSS - modelSS;
            double errorMS = residualSS / dfError;
            double F = Q / dfCovar / errorMS;
            double p = 1.0 - fdist.cumulativeProbability(F);
            return p;
        }).toArray();
        action.accept((double[])pvals);
        ++this.origin;
        return true;
    }

    @Override
    public Spliterator<double[]> trySplit() {
        int numberRemaining = this.end - this.origin;
        if (numberRemaining < 50) {
            return null;
        }
        int mid = this.origin + numberRemaining / 2;
        List<AdditiveSite> splitSublist = this.mySites.subList(this.origin, mid);
        this.origin = mid;
        List<double[]> permutedDataCopy = this.myPermutedData.stream().map(d -> Arrays.copyOf(d, ((double[])d).length)).collect(Collectors.toList());
        this.myBaseModel.get(0).getCopy();
        List<ModelEffect> baseModelCopy = this.myBaseModel.stream().map(me -> me.getCopy()).collect(Collectors.toList());
        return new NestedCovariatePermutationTestSpliterator(permutedDataCopy, splitSublist, baseModelCopy, this.myOuter.getCopy());
    }

    @Override
    public long estimateSize() {
        return this.end - this.origin;
    }

    @Override
    public int characteristics() {
        return 17728;
    }
}

