/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.maizegenetics.analysis.modelfitter.AddDomPermutationTestSpliterator;
import net.maizegenetics.analysis.modelfitter.AddPlusDomModelEffect;
import net.maizegenetics.analysis.modelfitter.AdditiveSite;
import net.maizegenetics.analysis.modelfitter.ForwardStepAddDomSpliterator;
import net.maizegenetics.analysis.modelfitter.GenotypeAdditiveSite;
import net.maizegenetics.analysis.modelfitter.RefProbAdditiveSite;
import net.maizegenetics.analysis.modelfitter.StepwiseAdditiveModelFitter;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.stats.linearmodels.BasicShuffler;
import net.maizegenetics.stats.linearmodels.LinearModelUtils;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.PartitionedLinearModel;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;
import net.maizegenetics.util.TableReportBuilder;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.RootLogger;

public class StepwiseAddDomModelFitter
extends StepwiseAdditiveModelFitter {
    private static Logger myLogger = RootLogger.getLogger(StepwiseAddDomModelFitter.class);

    public StepwiseAddDomModelFitter(GenotypePhenotype genopheno, String datasetName) {
        super(genopheno, datasetName);
        this.markerEffectReportBuilder = TableReportBuilder.getInstance("Marker Effects", new String[]{"Trait", "SiteID", "Chr", "Position", "Additive", "Dominance"});
        this.markerEffectCIReportBuilder = TableReportBuilder.getInstance("Marker Effects", new String[]{"Trait", "SiteID", "Chr", "Position", "Additive", "Dominance"});
    }

    @Override
    public void runAnalysis() {
        this.mySites = this.useReferenceProbability ? IntStream.range(0, this.myGenotype.numberOfSites()).mapToObj(s -> {
            int ntaxa = this.myPhenotype.numberOfObservations();
            float[] cov = this.myGenoPheno.referenceProb(s);
            return new RefProbAdditiveSite(s, this.myGenotype.chromosomeName(s), this.myGenotype.chromosomalPosition(s), this.myGenotype.siteName(s), this.modelSelectionCriterion, cov);
        }).collect(Collectors.toList()) : IntStream.range(0, this.myGenotype.numberOfSites()).mapToObj(s -> new GenotypeAdditiveSite(s, this.myGenotype.chromosomeName(s), this.myGenotype.chromosomalPosition(s), this.myGenotype.siteName(s), this.modelSelectionCriterion, this.myGenoPheno.genotypeAllTaxa(s), this.myGenotype.majorAllele(s), this.myGenotype.majorAlleleFrequency(s))).collect(Collectors.toList());
        for (PhenotypeAttribute phenoAttr : this.dataAttributeList) {
            this.currentTraitName = phenoAttr.name();
            List<ModelEffect> myBaseModel = this.baseModel(phenoAttr);
            this.myModel = new ArrayList<ModelEffect>(myBaseModel);
            this.numberOfBaseEffects = this.myModel.size();
            this.fitModel();
            if (this.createAnovaReport) {
                this.addToAnovaReport(Optional.empty());
            }
            if (this.createPreScanEffectsReport) {
                this.addToMarkerEffectReport(false);
            }
            long start = System.nanoTime();
            List<int[]> intervalList = this.scanToFindCI();
            myLogger.info((Object)String.format("Rescan in %d ms", (System.nanoTime() - start) / 1000000L));
            this.myModel = new ArrayList<ModelEffect>(myBaseModel);
            for (int[] interval : intervalList) {
                AdditiveSite as = (AdditiveSite)this.mySites.get(interval[0]);
                this.myModel.add(new AddPlusDomModelEffect(as, as));
            }
            this.mySweepFast = new SweepFastLinearModel(this.myModel, this.y);
            if (this.createAnovaReport) {
                this.addToAnovaReport(Optional.of(intervalList));
            }
            if (!this.createPostScanEffectsReport) continue;
            this.addToMarkerEffectReport(true);
        }
    }

    @Override
    protected double forwardStep(double prevCriterionValue) {
        ForwardStepAddDomSpliterator siteEvaluator = new ForwardStepAddDomSpliterator(this.mySites, this.myModel, this.y);
        LongAdder counter = new LongAdder();
        Optional<AdditiveSite> bestSite = StreamSupport.stream(siteEvaluator, true).peek(s -> counter.increment()).max((a, b) -> a.compareTo(b));
        System.out.println(counter.longValue() + " sites evaluated.");
        if (!bestSite.isPresent()) {
            return Double.NaN;
        }
        AddPlusDomModelEffect nextEffect = new AddPlusDomModelEffect(bestSite.get(), bestSite.get());
        this.myModel.add(nextEffect);
        this.mySweepFast = new SweepFastLinearModel(this.myModel, this.y);
        double[] siteSSdf = this.mySweepFast.getIncrementalSSdf(this.myModel.size() - 1);
        double[] errorSSdf = this.mySweepFast.getResidualSSdf();
        double F = siteSSdf[0] / siteSSdf[1] / errorSSdf[0] * errorSSdf[1];
        double p = LinearModelUtils.Ftest(F, siteSSdf[1], errorSSdf[1]);
        boolean addToModel = false;
        double criterionValue = Double.NaN;
        switch (this.modelSelectionCriterion) {
            case pval: {
                criterionValue = p;
                if (!(p < this.enterLimit)) break;
                addToModel = true;
                break;
            }
            case aic: {
                criterionValue = StepwiseAddDomModelFitter.aic(errorSSdf[0], this.y.length, this.mySweepFast.getFullModelSSdf()[0]);
                if (!(criterionValue < prevCriterionValue)) break;
                addToModel = true;
                break;
            }
            case bic: {
                criterionValue = StepwiseAddDomModelFitter.bic(errorSSdf[0], this.y.length, this.mySweepFast.getFullModelSSdf()[0]);
                if (!(criterionValue < prevCriterionValue)) break;
                addToModel = true;
                break;
            }
            case mbic: {
                criterionValue = StepwiseAddDomModelFitter.mbic(errorSSdf[0], this.y.length, this.mySweepFast.getFullModelSSdf()[0], this.mySites.size());
                if (!(criterionValue < prevCriterionValue)) break;
                addToModel = true;
            }
        }
        if (addToModel) {
            this.addToStepsReport(bestSite.get().siteNumber(), this.mySweepFast, "add", siteSSdf, errorSSdf, F, p);
            return criterionValue;
        }
        this.addToStepsReport(bestSite.get().siteNumber(), this.mySweepFast, "stop", siteSSdf, errorSSdf, F, p);
        this.myModel.remove(this.myModel.size() - 1);
        this.mySweepFast = new SweepFastLinearModel(this.myModel, this.y);
        return Double.NaN;
    }

    @Override
    protected List<int[]> scanToFindCI() {
        Function<ModelEffect, int[]> intervalFinder = me -> {
            AdditiveSite scanSite = (AdditiveSite)me.getID();
            myLogger.info((Object)String.format("Scanning site %d, %s, pos = %d", scanSite.siteNumber(), this.myGenotype.chromosome(scanSite.siteNumber()), this.myGenotype.chromosomalPosition(scanSite.siteNumber())));
            int[] support = this.findCI((ModelEffect)me, this.myModel);
            ArrayList<ModelEffect> baseModel = new ArrayList<ModelEffect>(this.myModel);
            baseModel.remove(me);
            AdditiveSite bestSite = this.bestTerm(baseModel, support);
            if (!bestSite.equals(scanSite)) {
                AddPlusDomModelEffect bestEffect = new AddPlusDomModelEffect(bestSite, bestSite);
                baseModel.add(bestEffect);
                support = this.findCI(bestEffect, baseModel);
            }
            return support;
        };
        return ((Stream)this.myModel.stream().skip(this.numberOfBaseEffects).parallel()).map(intervalFinder).collect(Collectors.toList());
    }

    @Override
    protected double testAddedTerm(int testedTerm, AdditiveSite addedTerm, List<ModelEffect> theModel) {
        ArrayList<ModelEffect> testingModel = new ArrayList<ModelEffect>(theModel);
        AddPlusDomModelEffect apdme = new AddPlusDomModelEffect(addedTerm, addedTerm);
        testingModel.add(apdme);
        SweepFastLinearModel sflm = new SweepFastLinearModel((List<ModelEffect>)testingModel, this.y);
        sflm.getResidualSSdf();
        double[] residualSSdf = sflm.getResidualSSdf();
        double[] marginalSSdf = sflm.getMarginalSSdf(testedTerm);
        double F = marginalSSdf[0] / marginalSSdf[1] / residualSSdf[0] * residualSSdf[1];
        double prob = 1.0;
        try {
            prob -= new FDistribution(marginalSSdf[1], residualSSdf[1]).cumulativeProbability(F);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prob;
    }

    @Override
    protected AdditiveSite bestTerm(List<ModelEffect> baseModel, int[] interval) {
        List intervalList = this.mySites.subList(interval[1], interval[2]);
        PartitionedLinearModel plm = new PartitionedLinearModel(baseModel, new SweepFastLinearModel(baseModel, this.y));
        return intervalList.stream().map(s -> {
            plm.testNewModelEffect(new AddPlusDomModelEffect((AdditiveSite)s, (AdditiveSite)s));
            s.criterionValue(plm.getp());
            return s;
        }).reduce((a, b) -> a.criterionValue() <= b.criterionValue() ? a : b).get();
    }

    @Override
    public void runPermutationTest() {
        int enterLimitIndex = (int)(this.permutationAlpha * (double)this.numberOfPermutations);
        SweepFastLinearModel sflm = new SweepFastLinearModel(this.myModel, this.y);
        double[] yhat = sflm.getPredictedValues().to1DArray();
        double[] residuals = sflm.getResiduals().to1DArray();
        BasicShuffler.shuffle(residuals);
        List<double[]> permutedData = Stream.iterate(residuals, BasicShuffler.shuffleDouble()).limit(this.numberOfPermutations).map(a -> {
            double[] permutedValues = Arrays.copyOf(a, ((double[])a).length);
            for (int i = 0; i < ((double[])a).length; ++i) {
                int n = i;
                permutedValues[n] = permutedValues[n] + yhat[i];
            }
            return permutedValues;
        }).collect(Collectors.toList());
        double[] maxP = new double[this.numberOfPermutations];
        Arrays.fill(maxP, 1.0);
        ArrayList plist = new ArrayList();
        double[] minP = StreamSupport.stream(new AddDomPermutationTestSpliterator(permutedData, this.mySites, this.myModel), true).reduce(maxP, (a, b) -> {
            int n = ((double[])a).length;
            for (int i = 0; i < n; ++i) {
                if (!(a[i] > b[i])) continue;
                a[i] = b[i];
            }
            return a;
        });
        Arrays.sort(minP);
        this.enterLimit = minP[enterLimitIndex];
        this.exitLimit = 2.0 * this.enterLimit;
        myLogger.info((Object)String.format("Additive + Dominance Permutation results for %s: enterLimit = %1.5e, exitLimit = %1.5e\n", this.currentTraitName, this.enterLimit, this.exitLimit));
        Arrays.stream(minP).forEach(d -> this.permutationReportBuilder.add(new Object[]{this.currentTraitName, new Double(d)}));
    }

    @Override
    protected void addToMarkerEffectReport(boolean CI) {
        int baseDf;
        double[] beta = this.mySweepFast.getBeta();
        int numberOfEffects = this.myModel.size();
        int numberOfMarkerEffects = numberOfEffects - this.numberOfBaseEffects;
        int betaCount = baseDf = this.myModel.stream().limit(this.numberOfBaseEffects).mapToInt(me -> me.getEffectSize()).sum();
        for (int me2 = 0; me2 < numberOfMarkerEffects; ++me2) {
            Object[] row = new Object[6];
            int col = 0;
            row[col++] = this.currentTraitName;
            AddPlusDomModelEffect adModelEffect = (AddPlusDomModelEffect)this.myModel.get(this.numberOfBaseEffects + me2);
            AdditiveSite mySite = (AdditiveSite)adModelEffect.getID();
            row[col++] = this.myGenotype.siteName(mySite.siteNumber());
            row[col++] = this.myGenotype.positions().chromosomeName(mySite.siteNumber());
            row[col++] = ((Position)this.myGenotype.positions().get(mySite.siteNumber())).getPosition();
            row[col++] = new Double(beta[betaCount++]);
            if (adModelEffect.getEffectSize() == 2) {
                row[col++] = new Double(beta[betaCount++]);
            } else {
                row[col++] = "NA";
            }
            if (CI) {
                this.markerEffectCIReportBuilder.add(row);
                continue;
            }
            this.markerEffectReportBuilder.add(row);
        }
    }
}

