/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.maizegenetics.analysis.association.AssociationUtils;
import net.maizegenetics.analysis.modelfitter.AdditiveSite;
import net.maizegenetics.analysis.modelfitter.CovariatePermutationTestSpliterator;
import net.maizegenetics.analysis.modelfitter.ForwardStepAdditiveSpliterator;
import net.maizegenetics.analysis.modelfitter.ForwardStepNestedAdditiveSpliterator;
import net.maizegenetics.analysis.modelfitter.GenotypeAdditiveSite;
import net.maizegenetics.analysis.modelfitter.NestedCovariatePermutationTestSpliterator;
import net.maizegenetics.analysis.modelfitter.RefProbAdditiveSite;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.phenotype.CategoricalAttribute;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.stats.linearmodels.BasicShuffler;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.LinearModelUtils;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffectUtils;
import net.maizegenetics.stats.linearmodels.NestedCovariateModelEffect;
import net.maizegenetics.stats.linearmodels.PartitionedLinearModel;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.TableReportBuilder;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.RootLogger;

public class StepwiseAdditiveModelFitter {
    private static Logger myLogger = RootLogger.getLogger(StepwiseAdditiveModelFitter.class);
    protected final GenotypePhenotype myGenoPheno;
    protected final GenotypeTable myGenotype;
    protected final Phenotype myPhenotype;
    protected final List<PhenotypeAttribute> dataAttributeList;
    protected final List<PhenotypeAttribute> covariateAttributeList;
    protected final List<PhenotypeAttribute> factorAttributeList;
    protected final String dataname;
    protected double[] y;
    protected String currentTraitName;
    protected List<ModelEffect> myModel;
    protected int numberOfBaseEffects;
    protected SweepFastLinearModel mySweepFast;
    protected BitSet missing;
    protected List<AdditiveSite> mySites;
    protected FactorModelEffect nestingFactor;
    protected List<String> nestingFactorLevelNames;
    protected final double rescanAlpha = 0.05;
    protected List<Phenotype> allOfTheResidualPhenotypes;
    protected int numberOfPermutations = 0;
    protected double permutationAlpha = 0.05;
    protected double enterLimit = 1.0E-5;
    protected double exitLimit = 2.0E-5;
    protected boolean useReferenceProbability = true;
    private boolean isNested = true;
    private String nestingEffectName = "family";
    protected AdditiveSite.CRITERION modelSelectionCriterion = AdditiveSite.CRITERION.pval;
    protected int maxSitesInModel = 10;
    private boolean useResiduals = false;
    protected boolean createAnovaReport = true;
    protected boolean createPostScanEffectsReport = true;
    protected boolean createPreScanEffectsReport = true;
    protected boolean createStepReport = true;
    protected boolean createResidualsByChr = false;
    private final TableReportBuilder anovaReportBuilder = TableReportBuilder.getInstance("Anova", new String[]{"Trait", "Name", "Chr", "Position", "df", "MS", "F", "probF", "MarginalRsq"});
    private final TableReportBuilder anovaCIReportBuilder = TableReportBuilder.getInstance("Anova", new String[]{"Trait", "Name", "Chr", "Position", "df", "MS", "F", "probF", "MarginalRsq", "SuppLeft", "SuppRight"});
    protected TableReportBuilder markerEffectReportBuilder = TableReportBuilder.getInstance("Marker Effects", new String[]{"Trait", "SiteID", "Chr", "Position", "Within", "Estimate"});
    protected TableReportBuilder markerEffectCIReportBuilder = TableReportBuilder.getInstance("Marker Effects", new String[]{"Trait", "SiteID", "Chr", "Position", "Within", "Estimate"});
    protected final TableReportBuilder permutationReportBuilder = TableReportBuilder.getInstance("Empirical Null", new String[]{"Trait", "p-value"});
    private final TableReportBuilder stepsReportBuilder = TableReportBuilder.getInstance("Steps", new String[]{"Trait", "SiteID", "Chr", "Position", "action", "df", "MS", "F", "probF", "AIC", "BIC", "mBIC", "ModelRsq"});

    public StepwiseAdditiveModelFitter(GenotypePhenotype genopheno, String datasetName) {
        this.myGenoPheno = genopheno;
        this.dataname = datasetName;
        this.myGenotype = this.myGenoPheno.genotypeTable();
        this.myPhenotype = this.myGenoPheno.phenotype();
        Optional<String> missingTest = this.testPhenotypeForMissingData(this.myPhenotype);
        if (missingTest.isPresent()) {
            throw new IllegalArgumentException("Missing data: " + missingTest.get());
        }
        this.dataAttributeList = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data);
        this.covariateAttributeList = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate);
        this.factorAttributeList = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor);
    }

    public Optional<String> testPhenotypeForMissingData(Phenotype pheno) {
        int nattr = pheno.numberOfAttributes();
        int nobs = pheno.numberOfObservations();
        for (int attr = 0; attr < nattr; ++attr) {
            for (int i = 0; i < nobs; ++i) {
                if (!pheno.isMissing(i, attr)) continue;
                String msg = String.format("Value missing for %s, observation %d", pheno.attribute(attr).name(), i);
                return Optional.of(msg);
            }
        }
        return Optional.empty();
    }

    public void runAnalysis() {
        this.mySites = this.useReferenceProbability ? IntStream.range(0, this.myGenotype.numberOfSites()).mapToObj(s -> {
            int ntaxa = this.myPhenotype.numberOfObservations();
            float[] cov = this.myGenoPheno.referenceProb(s);
            return new RefProbAdditiveSite(s, this.myGenotype.chromosomeName(s), this.myGenotype.chromosomalPosition(s), this.myGenotype.siteName(s), this.modelSelectionCriterion, cov);
        }).collect(Collectors.toList()) : IntStream.range(0, this.myGenotype.numberOfSites()).mapToObj(s -> new GenotypeAdditiveSite(s, this.myGenotype.chromosomeName(s), this.myGenotype.chromosomalPosition(s), this.myGenotype.siteName(s), this.modelSelectionCriterion, this.myGenoPheno.genotypeAllTaxa(s), this.myGenotype.majorAllele(s), this.myGenotype.majorAlleleFrequency(s))).collect(Collectors.toList());
        if (this.createResidualsByChr) {
            this.allOfTheResidualPhenotypes = new ArrayList<Phenotype>();
        }
        for (PhenotypeAttribute phenoAttr : this.dataAttributeList) {
            this.currentTraitName = phenoAttr.name();
            List<ModelEffect> myBaseModel = this.baseModel(phenoAttr);
            this.myModel = new ArrayList<ModelEffect>(myBaseModel);
            this.numberOfBaseEffects = this.myModel.size();
            if (this.isNested) {
                this.nestingFactor = (FactorModelEffect)this.myModel.stream().filter(me -> me.getID().equals(this.nestingEffectName)).findFirst().get();
            }
            this.fitModel();
            if (this.createAnovaReport) {
                this.addToAnovaReport(Optional.empty());
            }
            if (this.createPreScanEffectsReport) {
                this.addToMarkerEffectReport(false);
            }
            long start = System.nanoTime();
            List<int[]> intervalList = this.scanToFindCI();
            myLogger.info((Object)String.format("Rescan in %d ms", (System.nanoTime() - start) / 1000000L));
            this.myModel = new ArrayList<ModelEffect>(myBaseModel);
            for (int[] interval : intervalList) {
                AdditiveSite as;
                if (this.isNested) {
                    as = this.mySites.get(interval[0]);
                    NestedCovariateModelEffect ncme = new NestedCovariateModelEffect(as.getCovariate(), this.nestingFactor);
                    ncme.setID(as);
                    this.myModel.add(ncme);
                    continue;
                }
                as = this.mySites.get(interval[0]);
                this.myModel.add(new CovariateModelEffect(as.getCovariate(), as));
            }
            this.mySweepFast = new SweepFastLinearModel(this.myModel, this.y);
            if (this.createAnovaReport) {
                this.addToAnovaReport(Optional.of(intervalList));
            }
            if (this.createPostScanEffectsReport) {
                this.addToMarkerEffectReport(true);
            }
            if (!this.createResidualsByChr) continue;
            this.allOfTheResidualPhenotypes.addAll(this.generateChromosomeResidualsFromCurrentModel());
        }
    }

    protected void fitModel() {
        System.out.println("Running permutation test, if requested.");
        long start = System.nanoTime();
        DoubleMatrixFactory.setDefault(DoubleMatrixFactory.FactoryType.ejml);
        if (this.numberOfPermutations > 0) {
            this.runPermutationTest();
        }
        myLogger.info((Object)String.format("Permutation test run in %d ms.\n", (System.nanoTime() - start) / 1000000L));
        Optional<Object> lastTermRemoved = Optional.empty();
        SweepFastLinearModel sflm = new SweepFastLinearModel(this.myModel, this.y);
        start = System.nanoTime();
        double selectionCriterionValue = 0.0;
        switch (this.modelSelectionCriterion) {
            case pval: {
                selectionCriterionValue = 1.0;
                break;
            }
            case aic: {
                selectionCriterionValue = StepwiseAdditiveModelFitter.aic(sflm.getResidualSSdf()[0], this.y.length, sflm.getFullModelSSdf()[1]);
                break;
            }
            case bic: {
                selectionCriterionValue = StepwiseAdditiveModelFitter.bic(sflm.getResidualSSdf()[0], this.y.length, sflm.getFullModelSSdf()[1]);
                break;
            }
            case mbic: {
                selectionCriterionValue = StepwiseAdditiveModelFitter.mbic(sflm.getResidualSSdf()[0], this.y.length, sflm.getFullModelSSdf()[1], this.mySites.size());
            }
        }
        while (!Double.isNaN(selectionCriterionValue = this.forwardStep(selectionCriterionValue))) {
            if (lastTermRemoved.isPresent()) {
                AdditiveSite lastSiteRemoved = (AdditiveSite)((ModelEffect)lastTermRemoved.get()).getID();
                AdditiveSite lastSiteAdded = (AdditiveSite)this.myModel.get(this.myModel.size() - 1).getID();
                if (lastSiteRemoved.siteNumber() == lastSiteAdded.siteNumber()) break;
            }
            while ((lastTermRemoved = this.backwardStep()).isPresent()) {
            }
            int numberOfSitesInModel = this.myModel.size() - this.numberOfBaseEffects;
            if (numberOfSitesInModel < this.maxSitesInModel) continue;
            break;
        }
        myLogger.info((Object)String.format("Model fit in %d ms.\n", (System.nanoTime() - start) / 1000000L));
    }

    protected List<ModelEffect> baseModel(PhenotypeAttribute phenotypeBeingTested) {
        this.missing = new OpenBitSet(phenotypeBeingTested.missing());
        for (PhenotypeAttribute pa : this.covariateAttributeList) {
            this.missing.union(pa.missing());
        }
        for (PhenotypeAttribute pa : this.factorAttributeList) {
            this.missing.union(pa.missing());
        }
        this.y = AssociationUtils.getNonMissingDoubles((float[])phenotypeBeingTested.allValues(), this.missing);
        int numberNotMissing = this.y.length;
        ArrayList<ModelEffect> myBaseModel = new ArrayList<ModelEffect>();
        int[] mean = new int[numberNotMissing];
        ModelEffect me = new FactorModelEffect(mean, false, "mean");
        myBaseModel.add(me);
        for (PhenotypeAttribute pa : this.factorAttributeList) {
            CategoricalAttribute ca = (CategoricalAttribute)pa;
            String[] caLabels = AssociationUtils.getNonMissingValues(ca.allLabels(), this.missing);
            ArrayList<String> factorLabels = new ArrayList<String>();
            int[] levels = ModelEffectUtils.getIntegerLevels(caLabels, factorLabels);
            if (pa.name().equals(this.nestingEffectName)) {
                this.nestingFactorLevelNames = factorLabels;
            }
            me = new FactorModelEffect(levels, true, pa.name());
            myBaseModel.add(me);
        }
        for (PhenotypeAttribute pa : this.covariateAttributeList) {
            NumericAttribute numAttr = (NumericAttribute)pa;
            double[] cov = AssociationUtils.getNonMissingDoubles(numAttr.floatValues(), this.missing);
            me = new CovariateModelEffect(cov, pa.name());
            myBaseModel.add(me);
        }
        return myBaseModel;
    }

    protected double forwardStep(double prevCriterionValue) {
        ModelEffect nextEffect;
        ForwardStepAdditiveSpliterator siteEvaluator = this.isNested ? new ForwardStepNestedAdditiveSpliterator(this.mySites, this.myModel, this.y, this.nestingFactor) : new ForwardStepAdditiveSpliterator(this.mySites, this.myModel, this.y);
        Optional<AdditiveSite> bestSite = StreamSupport.stream(siteEvaluator, true).max((a, b) -> a.compareTo(b));
        if (!bestSite.isPresent()) {
            return Double.NaN;
        }
        if (this.isNested) {
            nextEffect = new NestedCovariateModelEffect(bestSite.get().getCovariate(), this.nestingFactor);
            nextEffect.setID(bestSite.get());
        } else {
            nextEffect = new CovariateModelEffect(bestSite.get().getCovariate(), bestSite.get());
        }
        this.myModel.add(nextEffect);
        this.mySweepFast = new SweepFastLinearModel(this.myModel, this.y);
        double[] siteSSdf = this.mySweepFast.getIncrementalSSdf(this.myModel.size() - 1);
        double[] errorSSdf = this.mySweepFast.getResidualSSdf();
        double F = siteSSdf[0] / siteSSdf[1] / errorSSdf[0] * errorSSdf[1];
        double p = LinearModelUtils.Ftest(F, siteSSdf[1], errorSSdf[1]);
        boolean addToModel = false;
        double criterionValue = Double.NaN;
        switch (this.modelSelectionCriterion) {
            case pval: {
                criterionValue = p;
                if (!(p < this.enterLimit)) break;
                addToModel = true;
                break;
            }
            case aic: {
                criterionValue = StepwiseAdditiveModelFitter.aic(errorSSdf[0], this.y.length, this.mySweepFast.getFullModelSSdf()[0]);
                if (!(criterionValue < prevCriterionValue)) break;
                addToModel = true;
                break;
            }
            case bic: {
                criterionValue = StepwiseAdditiveModelFitter.bic(errorSSdf[0], this.y.length, this.mySweepFast.getFullModelSSdf()[0]);
                if (!(criterionValue < prevCriterionValue)) break;
                addToModel = true;
                break;
            }
            case mbic: {
                criterionValue = StepwiseAdditiveModelFitter.mbic(errorSSdf[0], this.y.length, this.mySweepFast.getFullModelSSdf()[0], this.mySites.size());
                if (!(criterionValue < prevCriterionValue)) break;
                addToModel = true;
            }
        }
        if (addToModel) {
            this.addToStepsReport(bestSite.get().siteNumber(), this.mySweepFast, "add", siteSSdf, errorSSdf, F, p);
            return criterionValue;
        }
        this.addToStepsReport(bestSite.get().siteNumber(), this.mySweepFast, "stop", siteSSdf, errorSSdf, F, p);
        this.myModel.remove(this.myModel.size() - 1);
        this.mySweepFast = new SweepFastLinearModel(this.myModel, this.y);
        return Double.NaN;
    }

    protected void addToStepsReport(int siteNumber, SweepFastLinearModel theModel, String action, double[] siteSSdf, double[] errorSSdf, double F, double p) {
        Object[] row = new Object[13];
        int col = 0;
        double[] modelSSdf = theModel.getFullModelSSdf();
        double[] modelcfmSSdf = theModel.getModelcfmSSdf();
        int nsites = this.mySites.size();
        int N = this.y.length;
        row[col++] = this.currentTraitName;
        row[col++] = this.myGenotype.positions().siteName(siteNumber);
        row[col++] = this.myGenotype.positions().chromosome(siteNumber).getName();
        row[col++] = new Integer(((Position)this.myGenotype.positions().get(siteNumber)).getPosition());
        row[col++] = action;
        row[col++] = new Integer((int)siteSSdf[1]);
        row[col++] = new Double(siteSSdf[0] / siteSSdf[1]);
        row[col++] = new Double(F);
        row[col++] = new Double(p);
        row[col++] = new Double(StepwiseAdditiveModelFitter.aic(errorSSdf[0], N, modelSSdf[1]));
        row[col++] = new Double(StepwiseAdditiveModelFitter.bic(errorSSdf[0], N, modelSSdf[1]));
        row[col++] = new Double(StepwiseAdditiveModelFitter.mbic(errorSSdf[0], N, modelSSdf[1], nsites));
        row[col++] = new Double(modelcfmSSdf[0] / (modelcfmSSdf[0] + errorSSdf[0]));
        this.stepsReportBuilder.add(row);
        myLogger.info((Object)String.format("site %s, action = %s, p = %1.5e\n", this.myGenotype.positions().siteName(siteNumber), action, p));
    }

    private Optional<ModelEffect> backwardStep() {
        if (this.modelSelectionCriterion == AdditiveSite.CRITERION.pval) {
            return this.backwardStepPval();
        }
        return this.backwardStepXic();
    }

    private Optional<ModelEffect> backwardStepPval() {
        double F;
        int numberOfEffects = this.myModel.size();
        double[] lowestSSdf = new double[]{Double.MAX_VALUE, 0.0};
        int effectWithLowestSS = -1;
        for (int effect = this.numberOfBaseEffects; effect < numberOfEffects; ++effect) {
            double[] ssdf = this.mySweepFast.getMarginalSSdf(effect);
            if (!(ssdf[0] < lowestSSdf[0])) continue;
            lowestSSdf = ssdf;
            effectWithLowestSS = effect;
        }
        double[] errorSSdf = this.mySweepFast.getResidualSSdf();
        double p = 1.0 - new FDistribution(lowestSSdf[1], errorSSdf[1]).cumulativeProbability(F = lowestSSdf[0] / lowestSSdf[1] / errorSSdf[0] * errorSSdf[1]);
        if (p > this.exitLimit) {
            int siteNumber = ((AdditiveSite)this.myModel.get(effectWithLowestSS).getID()).siteNumber();
            this.addToStepsReport(siteNumber, this.mySweepFast, "remove", lowestSSdf, errorSSdf, F, p);
            ModelEffect removedEffect = this.myModel.remove(effectWithLowestSS);
            this.mySweepFast = new SweepFastLinearModel(this.myModel, this.y);
            return Optional.of(removedEffect);
        }
        return Optional.empty();
    }

    private Optional<ModelEffect> backwardStepXic() {
        int numberOfParameters = this.myModel.size();
        double lowestVal = Double.MAX_VALUE;
        int effectWithLowestVal = -1;
        double[] errorSSdf = this.mySweepFast.getResidualSSdf();
        double[] modelSSdf = this.mySweepFast.getFullModelSSdf();
        for (int effect = this.numberOfBaseEffects; effect < numberOfParameters; ++effect) {
            double[] margSSdf = this.mySweepFast.getMarginalSSdf(effect);
            double RSS = errorSSdf[0] + margSSdf[0];
            double df = modelSSdf[1] - margSSdf[1];
            double valReducedModel = Double.MAX_VALUE;
            switch (this.modelSelectionCriterion) {
                case aic: {
                    valReducedModel = StepwiseAdditiveModelFitter.aic(RSS, this.y.length, df);
                    break;
                }
                case bic: {
                    valReducedModel = StepwiseAdditiveModelFitter.bic(RSS, this.y.length, df);
                    break;
                }
                case mbic: {
                    valReducedModel = StepwiseAdditiveModelFitter.mbic(RSS, this.y.length, df, this.mySites.size());
                }
            }
            if (!(valReducedModel < lowestVal)) continue;
            lowestVal = valReducedModel;
            effectWithLowestVal = effect;
        }
        double valFullModel = Double.MAX_VALUE;
        switch (this.modelSelectionCriterion) {
            case aic: {
                valFullModel = StepwiseAdditiveModelFitter.aic(errorSSdf[0], this.y.length, modelSSdf[1]);
                break;
            }
            case bic: {
                valFullModel = StepwiseAdditiveModelFitter.bic(errorSSdf[0], this.y.length, modelSSdf[1]);
                break;
            }
            case mbic: {
                valFullModel = StepwiseAdditiveModelFitter.mbic(errorSSdf[0], this.y.length, modelSSdf[1], this.mySites.size());
            }
        }
        if (lowestVal < valFullModel) {
            ModelEffect removedEffect = this.myModel.remove(effectWithLowestVal);
            int siteNumber = ((AdditiveSite)this.myModel.get(effectWithLowestVal).getID()).siteNumber();
            double[] siteSSdf = this.mySweepFast.getMarginalSSdf(effectWithLowestVal);
            double F = siteSSdf[0] / siteSSdf[1] / errorSSdf[0] * errorSSdf[1];
            double p = 1.0 - new FDistribution(siteSSdf[1], errorSSdf[1]).cumulativeProbability(F);
            this.addToStepsReport(siteNumber, this.mySweepFast, "remove", siteSSdf, errorSSdf, F, p);
            this.mySweepFast = new SweepFastLinearModel(this.myModel, this.y);
            return Optional.of(removedEffect);
        }
        return Optional.empty();
    }

    protected List<int[]> scanToFindCI() {
        Function<ModelEffect, int[]> intervalFinder = me -> {
            AdditiveSite scanSite = (AdditiveSite)me.getID();
            myLogger.info((Object)String.format("Scanning site %d, %s, pos = %d", scanSite.siteNumber(), this.myGenotype.chromosome(scanSite.siteNumber()), this.myGenotype.chromosomalPosition(scanSite.siteNumber())));
            int[] support = this.findCI((ModelEffect)me, this.myModel);
            ArrayList<ModelEffect> baseModel = new ArrayList<ModelEffect>(this.myModel);
            baseModel.remove(me);
            AdditiveSite bestSite = this.bestTerm(baseModel, support);
            if (!bestSite.equals(scanSite)) {
                ModelEffect bestEffect;
                if (this.isNested) {
                    bestEffect = new NestedCovariateModelEffect(new CovariateModelEffect(bestSite.getCovariate(), bestSite), this.nestingFactor);
                    bestEffect.setID(bestSite);
                } else {
                    bestEffect = new CovariateModelEffect(bestSite.getCovariate(), bestSite);
                }
                baseModel.add(bestEffect);
                support = this.findCI(bestEffect, baseModel);
            }
            return support;
        };
        return ((Stream)this.myModel.stream().skip(this.numberOfBaseEffects).parallel()).map(intervalFinder).collect(Collectors.toList());
    }

    protected int[] findCI(ModelEffect me, List<ModelEffect> theModel) {
        int rightndx;
        AdditiveSite site = (AdditiveSite)me.getID();
        int testedSiteNumber = site.siteNumber();
        int effectNumber = theModel.indexOf(me);
        Chromosome thisChr = this.myGenotype.positions().chromosome(testedSiteNumber);
        int leftndx = rightndx = testedSiteNumber;
        ArrayList<AdditiveSite> siteArrayList = this.mySites instanceof ArrayList ? (ArrayList<AdditiveSite>)this.mySites : new ArrayList<AdditiveSite>(this.mySites);
        do {
            if (--leftndx != -1 && this.myGenotype.positions().chromosome(leftndx).equals(thisChr)) continue;
            ++leftndx;
            break;
        } while (this.testAddedTerm(effectNumber, siteArrayList.get(leftndx), theModel) > 0.05);
        while (++rightndx != this.myGenotype.numberOfSites() && this.myGenotype.positions().chromosome(rightndx).equals(thisChr) && this.testAddedTerm(effectNumber, siteArrayList.get(rightndx), theModel) > 0.05) {
        }
        return new int[]{testedSiteNumber, leftndx, --rightndx};
    }

    protected double testAddedTerm(int testedTerm, AdditiveSite addedTerm, List<ModelEffect> theModel) {
        ArrayList<ModelEffect> testingModel = new ArrayList<ModelEffect>(theModel);
        if (this.isNested) {
            NestedCovariateModelEffect ncme = new NestedCovariateModelEffect(addedTerm.getCovariate(), this.nestingFactor);
            testingModel.add(ncme);
        } else {
            CovariateModelEffect cme = new CovariateModelEffect(addedTerm.getCovariate());
            testingModel.add(cme);
        }
        SweepFastLinearModel sflm = new SweepFastLinearModel((List<ModelEffect>)testingModel, this.y);
        sflm.getResidualSSdf();
        double[] residualSSdf = sflm.getResidualSSdf();
        double[] marginalSSdf = sflm.getMarginalSSdf(testedTerm);
        double F = marginalSSdf[0] / marginalSSdf[1] / residualSSdf[0] * residualSSdf[1];
        double prob = 1.0;
        try {
            prob -= new FDistribution(marginalSSdf[1], residualSSdf[1]).cumulativeProbability(F);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prob;
    }

    protected AdditiveSite bestTerm(List<ModelEffect> baseModel, int[] interval) {
        List<AdditiveSite> intervalList = this.mySites.subList(interval[1], interval[2]);
        PartitionedLinearModel plm = new PartitionedLinearModel(baseModel, new SweepFastLinearModel(baseModel, this.y));
        if (this.isNested) {
            return intervalList.stream().map(s -> {
                plm.testNewModelEffect(new NestedCovariateModelEffect(s.getCovariate(), this.nestingFactor));
                s.criterionValue(plm.getModelSS());
                return s;
            }).reduce((a, b) -> a.criterionValue() >= b.criterionValue() ? a : b).get();
        }
        return intervalList.stream().map(s -> {
            s.criterionValue(plm.testNewModelEffect(s.getCovariate()));
            return s;
        }).reduce((a, b) -> a.criterionValue() >= b.criterionValue() ? a : b).get();
    }

    public void runPermutationTest() {
        double[] minP;
        int enterLimitIndex = (int)(this.permutationAlpha * (double)this.numberOfPermutations);
        SweepFastLinearModel sflm = new SweepFastLinearModel(this.myModel, this.y);
        double[] yhat = sflm.getPredictedValues().to1DArray();
        double[] residuals = sflm.getResiduals().to1DArray();
        BasicShuffler.shuffle(residuals);
        List<double[]> permutedData = Stream.iterate(residuals, BasicShuffler.shuffleDouble()).limit(this.numberOfPermutations).map(a -> {
            double[] permutedValues = Arrays.copyOf(a, ((double[])a).length);
            for (int i = 0; i < ((double[])a).length; ++i) {
                int n = i;
                permutedValues[n] = permutedValues[n] + yhat[i];
            }
            return permutedValues;
        }).collect(Collectors.toList());
        double[] maxP = new double[this.numberOfPermutations];
        Arrays.fill(maxP, 1.0);
        ArrayList plist = new ArrayList();
        if (this.isNested) {
            ModelEffect nestWithin = this.myModel.stream().filter(me -> this.nestingEffectName.equals(me.getID())).findFirst().get();
            minP = StreamSupport.stream(new NestedCovariatePermutationTestSpliterator(permutedData, this.mySites, this.myModel, nestWithin), true).peek(mp -> plist.add(mp)).reduce(maxP, (a, b) -> {
                int n = ((double[])a).length;
                for (int i = 0; i < n; ++i) {
                    if (!(a[i] > b[i])) continue;
                    a[i] = b[i];
                }
                return a;
            });
        } else {
            minP = StreamSupport.stream(new CovariatePermutationTestSpliterator(permutedData, this.mySites, this.myModel), true).reduce(maxP, (a, b) -> {
                int n = ((double[])a).length;
                for (int i = 0; i < n; ++i) {
                    if (!(a[i] > b[i])) continue;
                    a[i] = b[i];
                }
                return a;
            });
        }
        Arrays.sort(minP);
        this.enterLimit = minP[enterLimitIndex];
        this.exitLimit = 2.0 * this.enterLimit;
        myLogger.info((Object)String.format("Permutation results for %s: enterLimit = %1.5e, exitLimit = %1.5e\n", this.currentTraitName, this.enterLimit, this.exitLimit));
        Arrays.stream(minP).forEach(d -> this.permutationReportBuilder.add(new Object[]{this.currentTraitName, new Double(d)}));
    }

    private List<Phenotype> generateChromosomeResidualsFromCurrentModel() {
        Chromosome[] myChromosomes;
        ArrayList<Phenotype> chrResidualPhenotypeList = new ArrayList<Phenotype>();
        ArrayList<PhenotypeAttribute> attributes = new ArrayList<PhenotypeAttribute>();
        ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        Taxon[] allTaxa = this.myPhenotype.taxaAttribute().allTaxa();
        Taxon[] nonmissingTaxa = AssociationUtils.getNonMissingValues(allTaxa, this.missing);
        attributes.add(new TaxaAttribute(Arrays.asList(nonmissingTaxa)));
        types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        for (PhenotypeAttribute factor : this.factorAttributeList) {
            String[] values = ((CategoricalAttribute)factor).allLabels();
            attributes.add(new CategoricalAttribute(factor.name(), AssociationUtils.getNonMissingValues(values, this.missing)));
            types.add(Phenotype.ATTRIBUTE_TYPE.factor);
        }
        for (Chromosome chr : myChromosomes = this.myGenotype.chromosomes()) {
            myLogger.info((Object)String.format("Calculating residuals for %s, %s", chr.getName(), this.currentTraitName));
            ArrayList<PhenotypeAttribute> chrAttributes = new ArrayList<PhenotypeAttribute>(attributes);
            ArrayList<Phenotype.ATTRIBUTE_TYPE> chrTypes = new ArrayList<Phenotype.ATTRIBUTE_TYPE>(types);
            String traitname = String.format("%s_chr_%s", this.currentTraitName, chr.getName());
            Predicate<ModelEffect> notInChr = me -> {
                if (me.getID() instanceof AdditiveSite) {
                    int siteNumber = ((AdditiveSite)me.getID()).siteNumber();
                    return !chr.equals(this.myGenotype.positions().chromosome(siteNumber));
                }
                return true;
            };
            List<ModelEffect> chrModel = this.myModel.stream().filter(notInChr).collect(Collectors.toList());
            SweepFastLinearModel sflm = new SweepFastLinearModel(chrModel, this.y);
            DoubleMatrix resid = sflm.getResiduals();
            float[] data = AssociationUtils.convertDoubleArrayToFloat(resid.to1DArray());
            chrAttributes.add(new NumericAttribute(traitname, data, new OpenBitSet(data.length)));
            chrTypes.add(Phenotype.ATTRIBUTE_TYPE.data);
            chrResidualPhenotypeList.add(new PhenotypeBuilder().fromAttributeList(chrAttributes, chrTypes).build().get(0));
        }
        return chrResidualPhenotypeList;
    }

    protected void addToAnovaReport(Optional<List<int[]>> intervalList) {
        double[] errorSSdf = this.mySweepFast.getResidualSSdf();
        double errorMS = errorSSdf[0] / errorSSdf[1];
        double[] modelcfmSSdf = this.mySweepFast.getModelcfmSSdf();
        double totalSScfm = modelcfmSSdf[0] + errorSSdf[0];
        for (int i = 0; i < this.myModel.size(); ++i) {
            double p;
            ModelEffect me = this.myModel.get(i);
            Object[] row = intervalList.isPresent() ? new Object[11] : new Object[9];
            int col = 0;
            row[col++] = this.currentTraitName;
            Object id = me.getID();
            if (id instanceof AdditiveSite) {
                AdditiveSite as = (AdditiveSite)id;
                row[col++] = this.myGenotype.positions().siteName(as.siteNumber());
                row[col++] = this.myGenotype.positions().chromosome(as.siteNumber());
                row[col++] = new Integer(((Position)this.myGenotype.positions().get(as.siteNumber())).getPosition());
            } else {
                row[col++] = id.toString();
                row[col++] = "--";
                row[col++] = "--";
            }
            double[] ssdf = this.mySweepFast.getMarginalSSdf(i);
            double F = ssdf[0] / ssdf[1] / errorMS;
            try {
                p = LinearModelUtils.Ftest(F, ssdf[1], errorSSdf[1]);
            }
            catch (Exception e) {
                p = Double.NaN;
            }
            row[col++] = new Integer((int)ssdf[1]);
            row[col++] = new Double(ssdf[0] / ssdf[1]);
            row[col++] = new Double(F);
            row[col++] = new Double(p);
            row[col++] = new Double(ssdf[0] / totalSScfm);
            if (intervalList.isPresent()) {
                if (i >= this.numberOfBaseEffects) {
                    int markerNumber = i - this.numberOfBaseEffects;
                    int[] interval = intervalList.get().get(markerNumber);
                    row[col++] = new Integer(((Position)this.myGenotype.positions().get(interval[1])).getPosition());
                    row[col++] = new Integer(((Position)this.myGenotype.positions().get(interval[2])).getPosition());
                } else {
                    row[col++] = "--";
                    row[col++] = "--";
                }
                this.anovaCIReportBuilder.add(row);
                continue;
            }
            this.anovaReportBuilder.add(row);
        }
        Object[] row = intervalList.isPresent() ? new Object[11] : new Object[9];
        int col = 0;
        row[col++] = this.currentTraitName;
        row[col++] = "Error";
        row[col++] = "--";
        row[col++] = "--";
        row[col++] = new Integer((int)errorSSdf[1]);
        row[col++] = new Double(errorMS);
        row[col++] = "--";
        row[col++] = "--";
        row[col++] = "--";
        if (intervalList.isPresent()) {
            row[col++] = "--";
            row[col++] = "--";
            this.anovaCIReportBuilder.add(row);
        } else {
            this.anovaReportBuilder.add(row);
        }
    }

    protected void addToMarkerEffectReport(boolean CI) {
        double[] beta = this.mySweepFast.getBeta();
        int numberOfEffects = this.myModel.size();
        if (this.isNested) {
            int numberOfMarkers = numberOfEffects - this.numberOfBaseEffects;
            int numberOfFactorLevels = this.nestingFactor.getNumberOfLevels();
            int numberOfMarkerEstimates = numberOfMarkers * numberOfFactorLevels;
            int estCounter = beta.length - numberOfMarkerEstimates;
            for (int m2 = 0; m2 < numberOfMarkers; ++m2) {
                int site = ((AdditiveSite)this.myModel.get(this.numberOfBaseEffects + m2).getID()).siteNumber();
                String siteID = this.myGenotype.siteName(site);
                String chr = this.myGenotype.positions().chromosomeName(site);
                Integer pos = ((Position)this.myGenotype.positions().get(site)).getPosition();
                for (int f = 0; f < numberOfFactorLevels; ++f) {
                    Object[] row = new Object[6];
                    int col = 0;
                    row[col++] = this.currentTraitName;
                    row[col++] = siteID;
                    row[col++] = chr;
                    row[col++] = pos;
                    row[col++] = this.nestingFactorLevelNames.get(f);
                    row[col++] = new Double(beta[estCounter++]);
                    if (CI) {
                        this.markerEffectCIReportBuilder.add(row);
                        continue;
                    }
                    this.markerEffectReportBuilder.add(row);
                }
            }
        } else {
            int numberOfMarkers = numberOfEffects - this.numberOfBaseEffects;
            int firstMarker = beta.length - numberOfMarkers;
            IntStream.range(0, numberOfMarkers).forEach(m -> {
                Object[] row = new Object[6];
                int col = 0;
                row[col++] = this.currentTraitName;
                int site = ((AdditiveSite)this.myModel.get(this.numberOfBaseEffects + m).getID()).siteNumber();
                row[col++] = this.myGenotype.siteName(site);
                row[col++] = this.myGenotype.positions().chromosomeName(site);
                row[col++] = ((Position)this.myGenotype.positions().get(site)).getPosition();
                row[col++] = "--";
                row[col++] = new Double(beta[firstMarker + m]);
                if (CI) {
                    this.markerEffectCIReportBuilder.add(row);
                } else {
                    this.markerEffectReportBuilder.add(row);
                }
            });
        }
    }

    public void numberOfPermutations(int nperm) {
        this.numberOfPermutations = nperm;
    }

    public void permutationAlpha(double alpha) {
        this.permutationAlpha = alpha;
    }

    public void enterLimit(double limit) {
        this.enterLimit = limit;
    }

    public void exitLimit(double limit) {
        this.exitLimit = limit;
    }

    public void useReferenceProbability(boolean useRefProb) {
        this.useReferenceProbability = useRefProb;
    }

    public void isNested(boolean nested) {
        this.isNested = nested;
    }

    public void nestingEffectName(String factorName) {
        this.nestingEffectName = factorName;
    }

    public void modelSelectionCriterion(AdditiveSite.CRITERION criterion) {
        this.modelSelectionCriterion = criterion;
    }

    public void maxSitesInModel(int maxSites) {
        this.maxSitesInModel = maxSites;
    }

    public void useResiduals(boolean useResid) {
        this.useResiduals = useResid;
    }

    public void createAnovaReport(boolean createIt) {
        this.createAnovaReport = createIt;
    }

    public void createPostScanEffectsReport(boolean createIt) {
        this.createPostScanEffectsReport = createIt;
    }

    public void createPreScanEffectsReport(boolean createIt) {
        this.createPreScanEffectsReport = createIt;
    }

    public void createResidualsByChr(boolean createIt) {
        this.createResidualsByChr = createIt;
    }

    public void createStepReport(boolean createIt) {
        this.createStepReport = createIt;
    }

    public TableReport getAnovaReport() {
        return this.anovaReportBuilder.build();
    }

    public TableReport getAnovaReportWithCI() {
        return this.anovaCIReportBuilder.build();
    }

    public TableReport getMarkerEffectReport() {
        return this.markerEffectReportBuilder.build();
    }

    public TableReport getMarkerEffectReportWithCI() {
        return this.markerEffectCIReportBuilder.build();
    }

    public List<Phenotype> getResidualPhenotypesByChromosome() {
        return this.allOfTheResidualPhenotypes;
    }

    public TableReport getPermutationReport() {
        return this.permutationReportBuilder.build();
    }

    public TableReport getSteps() {
        return this.stepsReportBuilder.build();
    }

    public static double aic(double RSS, int N, double modelDf) {
        return (double)N * Math.log(RSS / (double)N) + 2.0 * modelDf;
    }

    public static double bic(double RSS, int N, double modelDf) {
        return (double)N * Math.log(RSS / (double)N) + Math.log(N) * modelDf;
    }

    public static double mbic(double RSS, int N, double modelDf, int numberOfSites) {
        return (double)N * Math.log(RSS) + Math.log(N) * modelDf + 2.0 * modelDf * Math.log((double)numberOfSites / 2.2 - 1.0);
    }
}

