/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.monetdb;

import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.monetdb.ColumnsToBinaryUtils;
import net.maizegenetics.analysis.monetdb.LittleEndianDataOutputStream;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GenomeSequence;
import net.maizegenetics.dna.map.GenomeSequenceBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.GeneratePluginCode;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.Utils;

public class ColumnsToBinaryFullGenomeTablePlugin
extends AbstractPlugin {
    private PluginParameter<String> inputFile = new PluginParameter.Builder<String>("inputFile", null, String.class).guiName("Input File").required(true).description("Input File containing a header line and entries sorted by chromosome and position, or Directory containing Tab-delimited files split by chromosome and sorted by position.  \nIf parameter is a directory, each file must contain a header line, and the files must end with .txt and be named in a maaner that sorts lexicographically by chromosome").build();
    private PluginParameter<String> refFile = new PluginParameter.Builder<String>("refFile", null, String.class).guiName("refFile").required(true).description("A link to the species reference file. This must be the same reference file used by other columns in the monetdb table for your species.").build();
    private PluginParameter<String> outBase = new PluginParameter.Builder<String>("outBase", null, String.class).guiName("outBase").required(true).description("Output directory and base filename to hold the binary files. Will make directory if neccesary").build();
    private PluginParameter<String> colsFloat = new PluginParameter.Builder<String>("colNamesFloat", null, String.class).guiName("Columns keep as Real (Float)").required(false).description("Comma separated list of column names to generate real binaries for").build();
    private PluginParameter<String> colsInt = new PluginParameter.Builder<String>("colNamesInt", null, String.class).guiName("Columns keep as Int").required(false).description("Comma separated list of column names to generate int  binaries for").build();
    private PluginParameter<String> colsShort = new PluginParameter.Builder<String>("colNamesShort", null, String.class).guiName("Columns keep as Short").required(false).description("Comma separated list of column names to generate short binaries for").build();
    private PluginParameter<String> colsLong = new PluginParameter.Builder<String>("colNamesLong", null, String.class).guiName("Columns keep as Long").required(false).description("Comma separated list of column names to generate long binaries for").build();
    private PluginParameter<String> colsChar = new PluginParameter.Builder<String>("colNamesChar", null, String.class).guiName("Columns keep as Char String").required(false).description("Comma separated list of column names to generate character/text binaries for").build();
    private PluginParameter<String> colsByte = new PluginParameter.Builder<String>("colNamesByte", null, String.class).guiName("Columns keep as Byte").required(false).description("Comma separated list of column names to generate byte binaries for").build();
    private PluginParameter<String> colsAllele = new PluginParameter.Builder<String>("colNamesAllele", null, String.class).guiName("Columns translate Alleles").required(false).description("Comma separated list of column names to generate for single char alleles to be translated to 0-5 for A/C/G/T/+/-").build();
    private PluginParameter<String> colsLog10 = new PluginParameter.Builder<String>("colNamesLog10", null, String.class).guiName("Columns to Keep and transform -log10").required(false).description("Comma separated list of column names to first transform using -log10 then generate binaries for").build();
    private PluginParameter<Boolean> range = new PluginParameter.Builder<Boolean>("range", false, Boolean.class).guiName("Range information?").required(false).description("Columns for range data. If true, will look for 'start' and 'end' (inclusive exclusive) or 'first' 'last' (inclusive inclusive) instead of 'Pos' ").build();
    private PluginParameter<Boolean> negToZero = new PluginParameter.Builder<Boolean>("negToZero", false, Boolean.class).guiName("Negative floats to zero?").required(false).description("Will set negative column values to zero (otherwise they the negative value is stored").build();
    private PluginParameter<Boolean> missToZero = new PluginParameter.Builder<Boolean>("missToZero", false, Boolean.class).guiName("Missing float values to zero?").required(false).description("Will set missing  column values to zero (otherwise they are set to null").build();
    private PluginParameter<Boolean> oneBased = new PluginParameter.Builder<Boolean>("oneBased", true, Boolean.class).guiName("positions are 1 based?").required(false).description("Will assume all positions and ranges are 1-based unless this value is set to false").build();
    private HashMap<Integer, String> log10HM = null;
    private HashMap<Integer, LittleEndianDataOutputStream> log10Writers = null;
    private HashMap<Integer, String> realHM = null;
    private HashMap<Integer, LittleEndianDataOutputStream> realWriters = null;
    private HashMap<Integer, String> shortHM = null;
    private HashMap<Integer, LittleEndianDataOutputStream> shortWriters = null;
    private HashMap<Integer, String> longHM = null;
    private HashMap<Integer, LittleEndianDataOutputStream> longWriters = null;
    private HashMap<Integer, String> charHM = null;
    private HashMap<Integer, LittleEndianDataOutputStream> charWriters = null;
    private HashMap<Integer, String> intHM = null;
    private HashMap<Integer, LittleEndianDataOutputStream> intWriters = null;
    private HashMap<Integer, String> byteHM = null;
    private HashMap<Integer, LittleEndianDataOutputStream> byteWriters = null;
    private HashMap<Integer, String> alleleHM = null;
    private HashMap<Integer, LittleEndianDataOutputStream> alleleWriters = null;
    private int chrCol = -1;
    private String chrName = "CHR";
    private int posCol = -1;
    private int totalLines;
    private int totalZeroLines;
    private int totalNonZeroLines;
    private int linesForChr;
    private FileInputStream fis = null;
    private Scanner scanner = null;
    private boolean inclusive = false;
    private int startCol = -1;
    private int endCol = -1;
    private GenomeSequence myRefSequence = null;
    List<Path> infiles;

    public ColumnsToBinaryFullGenomeTablePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    public ColumnsToBinaryFullGenomeTablePlugin() {
        super(null, false);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
    }

    @Override
    protected void postProcessParameters() {
        File dirList;
        File out = new File(this.outBase.value());
        if (!out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
        }
        if (!(dirList = new File(this.inputFile())).exists()) {
            throw new IllegalStateException("Input file or directory not found !!");
        }
        if (dirList.isDirectory()) {
            String inputFileGlob = "glob:*{.txt}";
            this.infiles = DirectoryCrawler.listPaths(inputFileGlob, Paths.get(this.inputFile.value(), new String[0]).toAbsolutePath());
            if (this.infiles.size() < 1) {
                throw new IllegalStateException("no .txt files found in input directory !!");
            }
        } else {
            this.infiles = new ArrayList<Path>();
            Path filePath = Paths.get(this.inputFile(), new String[0]).toAbsolutePath();
            this.infiles.add(filePath);
        }
        Collections.sort(this.infiles);
        this.FindColumns(this.infiles.get(0).toString());
    }

    @Override
    public DataSet processData(DataSet input) {
        long time = System.nanoTime();
        this.Initialize();
        this.myRefSequence = GenomeSequenceBuilder.instance(this.refFile());
        try {
            String currChr = null;
            Chromosome currChrom = null;
            System.out.println("processData: number of infiles: " + this.infiles.size());
            for (Path filepath : this.infiles) {
                String inputFile = filepath.toString();
                int refChromPosSize = 0;
                int lastStart = -1;
                int lastEnd = -1;
                int lastLinePos = 1;
                boolean first = true;
                this.fis = new FileInputStream(inputFile);
                System.out.println("Processing file: " + inputFile);
                this.scanner = new Scanner(this.fis);
                while (this.scanner.hasNextLine()) {
                    int position;
                    String[] next;
                    String line;
                    block15: {
                        line = this.scanner.nextLine();
                        if ((line.isEmpty() || line.startsWith("#")) && first) continue;
                        if (line.isEmpty() && !first) break;
                        next = line.split("\t");
                        if (next[this.chrCol].toUpperCase().equals(this.chrName)) continue;
                        if (first) {
                            currChr = next[this.chrCol];
                            System.out.println("...working on chr " + currChr);
                            currChrom = new Chromosome(currChr);
                            refChromPosSize = this.myRefSequence.chromosomeSize(currChrom);
                            first = false;
                        }
                        if (!currChr.equals(next[this.chrCol])) {
                            this.writeNull(lastLinePos, refChromPosSize);
                            System.out.println("Chrom within file changed, " + this.linesForChr + " lines output for chr " + currChr);
                            this.linesForChr = 0;
                            lastLinePos = 1;
                            if (Integer.parseInt(currChr) != Integer.parseInt(next[this.chrCol]) - 1) {
                                this.Shutdown();
                                String message = "Chromosomes files must be named so they sort by chromosomes in ascending order !!\nYour chromosome " + currChr + " came before chromosome " + next[this.chrCol];
                                throw new IllegalStateException(message);
                            }
                            currChr = next[this.chrCol];
                            lastStart = -1;
                            lastEnd = -1;
                            currChrom = new Chromosome(currChr);
                            refChromPosSize = this.myRefSequence.chromosomeSize(currChrom);
                            System.out.println("...working on chr " + currChr);
                        }
                        position = -1;
                        try {
                            int n = position = this.posCol > -1 ? Integer.parseInt(next[this.posCol]) : Integer.parseInt(next[this.startCol]);
                            if (!this.oneBased().booleanValue()) {
                                // empty if block
                            }
                        }
                        catch (Exception e) {
                            System.out.println(line);
                            position = Double.valueOf(next[this.posCol]).intValue();
                            if (this.oneBased().booleanValue()) break block15;
                            ++position;
                        }
                    }
                    int currPosOnChr = ++position;
                    if (lastStart == currPosOnChr) {
                        System.out.println("WARNING: Already recorded value for this position. Excluded\n" + line);
                        continue;
                    }
                    if (this.range.value().booleanValue() && this.inclusive && lastEnd == currPosOnChr) {
                        throw new IllegalStateException("Ranges are overlapping and supposed to be inclusive!!!!!. If not inclusive, denote ranges by start, end");
                    }
                    this.writeNull(lastLinePos, currPosOnChr - 1);
                    if (this.posCol > -1) {
                        this.WriteValues(next);
                        lastLinePos = currPosOnChr + 1;
                        lastStart = currPosOnChr;
                        ++this.totalLines;
                        ++this.linesForChr;
                        ++this.totalNonZeroLines;
                        continue;
                    }
                    int end = Integer.parseInt(next[this.endCol]);
                    if (!this.oneBased().booleanValue()) {
                        ++end;
                    }
                    end = this.inclusive ? end + 1 : end;
                    for (int i = currPosOnChr; i < end; ++i) {
                        this.WriteValues(next);
                        ++this.totalLines;
                        ++this.linesForChr;
                        ++this.totalNonZeroLines;
                    }
                    lastLinePos = end;
                    lastStart = currPosOnChr;
                    lastEnd = end - 1;
                }
                this.writeNull(lastLinePos, refChromPosSize);
                System.out.println("File changed, " + this.linesForChr + "  lines output for chr " + currChr + " lastLinePos " + lastLinePos + " refChromPosSize:" + refChromPosSize);
                this.linesForChr = 0;
            }
            this.Shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Shutdown();
            return null;
        }
        System.out.println("Process took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds.");
        System.out.println("Wrote the files with totalReads: " + this.totalLines + " totalZeroLines written: " + this.totalZeroLines + " totalNonZeroLines written: " + this.totalNonZeroLines);
        return null;
    }

    private void writeNull(int start, int end) {
        try {
            for (int posIdx = start; posIdx <= end; ++posIdx) {
                if (this.realHM != null) {
                    for (Integer i : this.realWriters.keySet()) {
                        this.realWriters.get(i).writeFloat(this.missToZero.value() != false ? 0.0f : -3.4028235E38f);
                    }
                }
                if (this.log10HM != null) {
                    for (Integer i : this.log10Writers.keySet()) {
                        this.log10Writers.get(i).writeFloat(this.missToZero() != false ? 0.0f : -3.4028235E38f);
                    }
                }
                if (this.shortHM != null) {
                    for (Integer i : this.shortWriters.keySet()) {
                        this.shortWriters.get(i).writeShort(this.missToZero() != false ? (short)0 : Short.MIN_VALUE);
                    }
                }
                if (this.longHM != null) {
                    for (Integer i : this.longWriters.keySet()) {
                        this.longWriters.get(i).writeLong(this.missToZero() != false ? 0L : Long.MIN_VALUE);
                    }
                }
                if (this.charHM != null) {
                    for (Integer i : this.charWriters.keySet()) {
                        String nullString = "NULL\n";
                        this.charWriters.get(i).writeChars(nullString.getBytes());
                    }
                }
                if (this.intHM != null) {
                    for (Integer i : this.intWriters.keySet()) {
                        this.intWriters.get(i).writeInt(this.missToZero() != false ? 0 : Integer.MIN_VALUE);
                    }
                }
                if (this.byteHM != null) {
                    for (Integer i : this.byteWriters.keySet()) {
                        this.byteWriters.get(i).writeByte(this.missToZero() != false ? (byte)0 : -128);
                    }
                }
                if (this.alleleHM != null) {
                    for (Integer i : this.alleleWriters.keySet()) {
                        this.alleleWriters.get(i).writeByte((byte)-128);
                    }
                }
                ++this.totalLines;
                ++this.linesForChr;
                ++this.totalZeroLines;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Problem writing nulls between " + start + " and " + end);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void WriteValues(String[] next) {
        try {
            byte storedVal;
            double val;
            if (this.realHM != null) {
                for (Integer i : this.realWriters.keySet()) {
                    val = Double.MIN_VALUE;
                    try {
                        val = Double.parseDouble(next[i]);
                    }
                    catch (NumberFormatException nfe) {
                        val = Double.MIN_VALUE;
                    }
                    float storedVal2 = val == Double.MIN_VALUE ? (this.missToZero.value() != false ? 0.0f : -3.4028235E38f) : (this.negToZero.value() != false && val <= 0.0 ? 0.0f : (float)val);
                    this.realWriters.get(i).writeFloat(storedVal2);
                }
            }
            if (this.log10HM != null) {
                for (Integer i : this.log10Writers.keySet()) {
                    val = Double.MIN_VALUE;
                    try {
                        val = Double.parseDouble(next[i]);
                    }
                    catch (NumberFormatException nfe) {
                        val = Double.MIN_VALUE;
                    }
                    double storedVal3 = val == Double.MIN_VALUE ? (this.missToZero.value() != false ? 0.0 : -3.4028234663852886E38) : (this.negToZero.value() != false && val <= 0.0 ? 0.0 : (val == Double.MIN_VALUE ? -3.4028234663852886E38 : (double)((float)(-Math.log10(val)))));
                    this.log10Writers.get(i).writeFloat((float)storedVal3);
                }
            }
            if (this.shortHM != null) {
                for (Integer i : this.shortWriters.keySet()) {
                    byte val2 = Short.MIN_VALUE;
                    try {
                        val2 = (byte)Short.parseShort(next[i]);
                    }
                    catch (NumberFormatException nfe) {
                        val2 = Short.MIN_VALUE;
                    }
                    storedVal = val2 == Short.MIN_VALUE ? (this.missToZero.value() != false ? (byte)0 : Short.MIN_VALUE) : (this.negToZero.value() != false && val2 <= 0 ? (byte)0 : val2);
                    this.shortWriters.get(i).writeShort(storedVal);
                }
            }
            if (this.longHM != null) {
                for (Integer i : this.longWriters.keySet()) {
                    long val3 = Long.MIN_VALUE;
                    try {
                        val3 = Long.parseLong(next[i]);
                    }
                    catch (NumberFormatException nfe) {
                        val3 = Long.MIN_VALUE;
                    }
                    long storedVal4 = val3 == Long.MIN_VALUE ? (this.missToZero.value() != false ? 0L : Long.MIN_VALUE) : (this.negToZero.value() != false && val3 <= 0L ? 0L : val3);
                    this.longWriters.get(i).writeLong(storedVal4);
                }
            }
            if (this.charHM != null) {
                for (Integer i : this.charWriters.keySet()) {
                    String charData = next[i] + "\n";
                    this.charWriters.get(i).writeChars(charData.getBytes());
                }
            }
            if (this.intHM != null) {
                for (Integer i : this.intWriters.keySet()) {
                    byte val4 = Integer.MIN_VALUE;
                    try {
                        val4 = Integer.parseInt(next[i]);
                    }
                    catch (NumberFormatException nfe) {
                        val4 = Integer.MIN_VALUE;
                    }
                    storedVal = val4 == Integer.MIN_VALUE ? (this.missToZero.value() != false ? (byte)0 : Integer.MIN_VALUE) : (this.negToZero.value() != false && val4 <= 0 ? (byte)0 : val4);
                    this.intWriters.get(i).writeInt(storedVal);
                }
            }
            if (this.byteHM != null) {
                for (Integer i : this.byteWriters.keySet()) {
                    byte val5 = -128;
                    try {
                        val5 = (byte)Integer.parseInt(next[i]);
                    }
                    catch (NumberFormatException nfe) {
                        val5 = -128;
                    }
                    storedVal = val5 == -128 ? (this.missToZero.value() != false ? (byte)0 : -128) : (this.negToZero.value() != false && val5 <= 0 ? (byte)0 : val5);
                    this.byteWriters.get(i).writeByte(val5);
                }
            }
            if (this.alleleHM == null) return;
            for (Integer idx : this.alleleWriters.keySet()) {
                byte val6 = -128;
                try {
                    String allele = next[idx];
                    int alleleInt = ColumnsToBinaryUtils.getIntFromSeq(allele);
                    if (alleleInt < 0 && alleleInt > 5) {
                        throw new IllegalStateException("Illegal allele char, must be A/C/G/T/+/- but found " + allele);
                    }
                    val6 = (byte)alleleInt;
                    this.alleleWriters.get(idx).writeByte(val6);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    throw new IllegalStateException("Error parsing  allele column " + this.alleleWriters.get(idx));
                    return;
                }
            }
        }
        catch (Exception e) {
            for (String i : next) {
                System.out.println(i);
            }
            e.printStackTrace();
        }
    }

    private void FindColumns(String filename) {
        int col;
        String s2;
        int n;
        int col2;
        String[] next = null;
        try {
            FileInputStream fis = new FileInputStream(filename);
            Scanner scanner = new Scanner(fis);
            boolean first = true;
            while (scanner.hasNextLine() && first) {
                String line = scanner.nextLine();
                if (line.isEmpty() || line.startsWith("#")) continue;
                next = line.split("\t");
                if (!first) continue;
                first = false;
            }
            scanner.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int search = -1;
        for (col2 = 0; col2 < next.length; ++col2) {
            if (!next[col2].toLowerCase().startsWith("chr")) continue;
            search = col2;
            break;
        }
        if (search < 0) {
            throw new IllegalStateException("Couldn't find chromosome in first non-empty line of input file");
        }
        this.chrCol = search;
        System.out.println("Chr found in column " + search);
        search = -1;
        if (this.range.value().booleanValue()) {
            for (col2 = 0; col2 < next.length; ++col2) {
                if (!next[col2].equalsIgnoreCase("start")) continue;
                search = col2;
                break;
            }
            if (search < 0) {
                this.inclusive = true;
                for (col2 = 0; col2 < next.length; ++col2) {
                    if (!next[col2].equalsIgnoreCase("first")) continue;
                    search = col2;
                    break;
                }
                if (search < 0) {
                    throw new IllegalStateException("Couldn't find first or start in first line of input file to indicate range");
                }
                this.startCol = search;
            } else {
                this.startCol = search;
            }
            search = -1;
            for (col2 = 0; col2 < next.length; ++col2) {
                if (!next[col2].equalsIgnoreCase(this.inclusive ? "last" : "end")) continue;
                search = col2;
                break;
            }
            if (search < 0) {
                if (search < 0) {
                    throw new IllegalStateException("Couldn't find " + (this.inclusive ? "last" : "end") + " in first line of input file to indicate range");
                }
            } else {
                this.endCol = search;
            }
            System.out.println("Using columns " + this.startCol + " and " + this.endCol + " to indicate ends of ranges, " + (this.inclusive ? "inclusive" : "exclusive"));
        } else {
            for (col2 = 0; col2 < next.length; ++col2) {
                if (!next[col2].toLowerCase().startsWith("pos")) continue;
                search = col2;
                break;
            }
            if (search < 0) {
                System.out.println("Cannot find column for pos");
            } else {
                this.posCol = search;
                System.out.println("Pos found in column " + search);
            }
            if (this.chrCol < 0 || this.posCol < 0) {
                throw new IllegalStateException("Couldn't find chromosome or position in first line of input file");
            }
        }
        int ncols = 0;
        if (this.colsLog10.value() != null && !this.colsLog10.value().equalsIgnoreCase("null") && !this.colsLog10.value().isEmpty()) {
            this.log10HM = new HashMap();
            search = -1;
            String[] stringArray = this.colsLog10.value().split(",");
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                s2 = stringArray[n];
                search = -1;
                for (col = 0; col < next.length; ++col) {
                    if (!s2.equalsIgnoreCase(next[col])) continue;
                    search = col;
                    break;
                }
                if (search < 0) {
                    System.out.println("Cannot find column " + s2);
                    continue;
                }
                this.log10HM.put(search, s2);
                this.log10Writers = new HashMap();
                ++ncols;
                System.out.println("Found " + s2 + " in column " + search + " as -log10 transformed float");
            }
        }
        if (this.colsFloat.value() != null && !this.colsFloat.value().equalsIgnoreCase("null") && !this.colsFloat.value().isEmpty()) {
            this.realHM = new HashMap();
            this.realWriters = new HashMap();
            search = -1;
            String[] stringArray = this.colsFloat.value().split(",");
            int n3 = stringArray.length;
            for (n = 0; n < n3; ++n) {
                s2 = stringArray[n];
                for (col = 0; col < next.length; ++col) {
                    if (!s2.equalsIgnoreCase(next[col])) continue;
                    search = col;
                    break;
                }
                if (search < 0) {
                    System.out.println("Cannot find column " + s2);
                    continue;
                }
                this.realHM.put(search, s2);
                ++ncols;
                System.out.println("Found " + s2 + " in column " + search + " as real (float)");
            }
        }
        if (this.colsInt.value() != null && !this.colsInt.value().equalsIgnoreCase("null") && !this.colsInt.value().isEmpty()) {
            this.intHM = new HashMap();
            this.intWriters = new HashMap();
            search = -1;
            String[] stringArray = this.colsInt.value().split(",");
            int n4 = stringArray.length;
            for (n = 0; n < n4; ++n) {
                s2 = stringArray[n];
                for (col = 0; col < next.length; ++col) {
                    if (!s2.equalsIgnoreCase(next[col])) continue;
                    search = col;
                    break;
                }
                if (search < 0) {
                    System.out.println("Cannot find column " + s2);
                    continue;
                }
                this.intHM.put(search, s2);
                ++ncols;
                System.out.println("Found " + s2 + " in column " + search + " as int");
            }
        }
        if (this.colsShort.value() != null && !this.colsShort.value().equalsIgnoreCase("null") && !this.colsShort.value().isEmpty()) {
            this.shortHM = new HashMap();
            this.shortWriters = new HashMap();
            search = -1;
            String[] stringArray = this.colsShort.value().split(",");
            int n5 = stringArray.length;
            for (n = 0; n < n5; ++n) {
                s2 = stringArray[n];
                for (col = 0; col < next.length; ++col) {
                    if (!s2.equalsIgnoreCase(next[col])) continue;
                    search = col;
                    break;
                }
                if (search < 0) {
                    System.out.println("Cannot find column " + s2);
                    continue;
                }
                this.shortHM.put(search, s2);
                ++ncols;
                System.out.println("Found " + s2 + " in column " + search + " as short");
            }
        }
        if (this.colsLong.value() != null && !this.colsLong.value().equalsIgnoreCase("null") && !this.colsLong.value().isEmpty()) {
            this.longHM = new HashMap();
            this.longWriters = new HashMap();
            search = -1;
            String[] stringArray = this.colsLong.value().split(",");
            int n6 = stringArray.length;
            for (n = 0; n < n6; ++n) {
                s2 = stringArray[n];
                for (col = 0; col < next.length; ++col) {
                    if (!s2.equalsIgnoreCase(next[col])) continue;
                    search = col;
                    break;
                }
                if (search < 0) {
                    System.out.println("Cannot find column " + s2);
                    continue;
                }
                this.longHM.put(search, s2);
                ++ncols;
                System.out.println("Found " + s2 + " in column " + search + " as long");
            }
        }
        if (this.colsChar.value() != null && !this.colsChar.value().equalsIgnoreCase("null") && !this.colsChar.value().isEmpty()) {
            this.charHM = new HashMap();
            this.charWriters = new HashMap();
            search = -1;
            String[] stringArray = this.colsChar.value().split(",");
            int n7 = stringArray.length;
            for (n = 0; n < n7; ++n) {
                s2 = stringArray[n];
                for (col = 0; col < next.length; ++col) {
                    if (!s2.equalsIgnoreCase(next[col])) continue;
                    search = col;
                    break;
                }
                if (search < 0) {
                    System.out.println("Cannot find column " + s2);
                    continue;
                }
                this.charHM.put(search, s2);
                ++ncols;
                System.out.println("Found " + s2 + " in column " + search + " as char");
            }
        }
        if (this.colsByte.value() != null && !this.colsByte.value().equalsIgnoreCase("null") && !this.colsByte.value().isEmpty()) {
            this.byteHM = new HashMap();
            this.byteWriters = new HashMap();
            search = -1;
            String[] stringArray = this.colsByte.value().split(",");
            int n8 = stringArray.length;
            for (n = 0; n < n8; ++n) {
                s2 = stringArray[n];
                for (col = 0; col < next.length; ++col) {
                    if (!s2.equalsIgnoreCase(next[col])) continue;
                    search = col;
                    break;
                }
                if (search < 0) {
                    System.out.println("Cannot find column " + s2);
                    continue;
                }
                this.byteHM.put(search, s2);
                ++ncols;
                System.out.println("Found " + s2 + " in column " + search + " as byte");
            }
        }
        if (this.colsAllele.value() != null && !this.colsAllele.value().equalsIgnoreCase("null") && !this.colsAllele.value().isEmpty()) {
            this.alleleHM = new HashMap();
            this.alleleWriters = new HashMap();
            search = -1;
            for (String s2 : this.colsAllele.value().split(",")) {
                for (col = 0; col < next.length; ++col) {
                    if (!s2.equalsIgnoreCase(next[col])) continue;
                    search = col;
                    break;
                }
                if (search < 0) {
                    System.out.println("Cannot find column " + s2);
                    continue;
                }
                this.alleleHM.put(search, s2);
                ++ncols;
                System.out.println("Found " + s2 + " in column " + search + " as allele");
            }
        }
        if (ncols < 1) {
            throw new IllegalStateException("No valid columns to read in!");
        }
    }

    private void Initialize() {
        this.totalLines = 0;
        this.totalZeroLines = 0;
        this.totalNonZeroLines = 0;
        this.linesForChr = 0;
        try {
            String outFile;
            String createFile;
            String copyFile;
            System.out.println("\nColumnsToBInaryFullGenomeTable: outBase is : " + this.outBase() + "\n\n");
            DataOutputStream outCopy = Utils.getDataOutputStream(this.outBase.value() + "copy.sql", 1040);
            DataOutputStream outCreate = Utils.getDataOutputStream(this.outBase.value() + "create.sql", 1040);
            outCopy.writeBytes("COPY binary into ... from ('snpChrFile.bin','snpPosFile.bin',");
            boolean first = true;
            outCreate.writeBytes("CREATE TABLE ... (chr int,pos int,");
            String lastChar = this.outBase().substring(this.outBase().length() - 1, this.outBase().length());
            String out = null;
            if (!lastChar.equals("/")) {
                out = new File(this.outBase.value()).getName();
            }
            if (this.realHM != null) {
                for (Integer i : this.realHM.keySet()) {
                    if (out != null) {
                        copyFile = out + this.realHM.get(i) + "_real.bin";
                        createFile = out + this.realHM.get(i) + " real";
                    } else {
                        copyFile = this.realHM.get(i) + "_real.bin";
                        createFile = this.realHM.get(i) + " real";
                    }
                    outFile = this.outBase() + this.realHM.get(i) + "_real.bin";
                    if (!first) {
                        outCopy.writeBytes(",");
                        outCreate.writeBytes(",");
                    }
                    first = false;
                    outCopy.writeBytes("'" + copyFile + "'");
                    first = false;
                    outCreate.writeBytes(createFile);
                    this.realWriters.put(i, new LittleEndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile))));
                }
            }
            if (this.intHM != null) {
                for (Integer i : this.intHM.keySet()) {
                    if (out != null) {
                        copyFile = out + this.intHM.get(i) + "_int.bin";
                        createFile = out + this.intHM.get(i) + " int";
                    } else {
                        copyFile = this.intHM.get(i) + "_int.bin";
                        createFile = this.intHM.get(i) + " int";
                    }
                    outFile = this.outBase() + this.intHM.get(i) + "_int.bin";
                    if (!first) {
                        outCopy.writeBytes(",");
                        outCreate.writeBytes(",");
                    }
                    first = false;
                    outCopy.writeBytes("'" + copyFile + "'");
                    outCreate.writeBytes(createFile);
                    this.intWriters.put(i, new LittleEndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile))));
                }
            }
            if (this.byteHM != null) {
                for (Integer i : this.byteHM.keySet()) {
                    if (out != null) {
                        copyFile = out + this.byteHM.get(i) + "_byte.bin";
                        createFile = out + this.byteHM.get(i) + " byte";
                    } else {
                        copyFile = this.byteHM.get(i) + "_byte.bin";
                        createFile = this.byteHM.get(i) + " byte";
                    }
                    outFile = this.outBase() + this.byteHM.get(i) + "_byte.bin";
                    if (!first) {
                        outCopy.writeBytes(",");
                        outCreate.writeBytes(",");
                    }
                    first = false;
                    outCopy.writeBytes("'" + copyFile + "'");
                    outCreate.writeBytes(createFile);
                    this.byteWriters.put(i, new LittleEndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile))));
                }
            }
            if (this.alleleHM != null) {
                for (Integer i : this.alleleHM.keySet()) {
                    if (out != null) {
                        copyFile = out + this.alleleHM.get(i) + "_allelebyte.bin";
                        createFile = out + this.alleleHM.get(i) + " tinyint";
                    } else {
                        copyFile = this.alleleHM.get(i) + "_allelebyte.bin";
                        createFile = this.alleleHM.get(i) + " tinyint";
                    }
                    outFile = this.outBase() + this.alleleHM.get(i) + "_allelebyte.bin";
                    if (!first) {
                        outCopy.writeBytes(",");
                        outCreate.writeBytes(",");
                    }
                    first = false;
                    outCopy.writeBytes("'" + copyFile + "'");
                    outCreate.writeBytes(createFile);
                    this.alleleWriters.put(i, new LittleEndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile))));
                }
            }
            if (this.log10HM != null) {
                for (Integer i : this.log10HM.keySet()) {
                    if (out != null) {
                        copyFile = out + this.log10HM.get(i) + "_neglog10_real.bin";
                        createFile = out + this.log10HM.get(i) + "_neglog10 real";
                    } else {
                        copyFile = this.log10HM.get(i) + "_neglog10_real.bin";
                        createFile = this.log10HM.get(i) + "_neglog10 real";
                    }
                    outFile = this.outBase() + this.log10HM.get(i) + "_neglog10_real.bin";
                    if (!first) {
                        outCopy.writeBytes(",");
                        outCreate.writeBytes(",");
                    }
                    first = false;
                    outCopy.writeBytes("'" + copyFile + "'");
                    outCreate.writeBytes(createFile);
                    this.log10Writers.put(i, new LittleEndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile))));
                }
            }
            if (this.shortHM != null) {
                for (Integer i : this.shortHM.keySet()) {
                    if (out != null) {
                        copyFile = out + this.shortHM.get(i) + "_short.bin";
                        createFile = out + this.shortHM.get(i) + " short";
                    } else {
                        copyFile = this.shortHM.get(i) + "_short.bin";
                        createFile = this.shortHM.get(i) + " short";
                    }
                    outFile = this.outBase() + this.shortHM.get(i) + "_short.bin";
                    if (!first) {
                        outCopy.writeBytes(",");
                        outCreate.writeBytes(",");
                    }
                    first = false;
                    outCopy.writeBytes("'" + copyFile + "'");
                    outCreate.writeBytes(createFile);
                    this.shortWriters.put(i, new LittleEndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile))));
                }
            }
            if (this.longHM != null) {
                for (Integer i : this.longHM.keySet()) {
                    if (out != null) {
                        copyFile = out + "_" + this.longHM.get(i) + "_long.bin";
                        createFile = out + "_" + this.longHM.get(i) + " long";
                    } else {
                        copyFile = this.longHM.get(i) + "_long.bin";
                        createFile = this.longHM.get(i) + " long";
                    }
                    outFile = this.outBase() + this.longHM.get(i) + "_long.bin";
                    if (!first) {
                        outCopy.writeBytes(",");
                        outCreate.writeBytes(",");
                    }
                    first = false;
                    outCopy.writeBytes("'" + copyFile + "'");
                    outCreate.writeBytes(createFile);
                    this.longWriters.put(i, new LittleEndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile))));
                }
            }
            if (this.charHM != null) {
                for (Integer i : this.charHM.keySet()) {
                    if (out != null) {
                        copyFile = out + this.charHM.get(i) + "_char.bin";
                        createFile = out + this.charHM.get(i) + " char";
                    } else {
                        copyFile = this.charHM.get(i) + "_char.bin";
                        createFile = this.charHM.get(i) + " char";
                    }
                    outFile = this.outBase() + this.charHM.get(i) + "_char.bin";
                    if (!first) {
                        outCopy.writeBytes(",");
                        outCreate.writeBytes(",");
                    }
                    first = false;
                    outCopy.writeBytes("'" + copyFile + "'");
                    outCreate.writeBytes(createFile);
                    this.charWriters.put(i, new LittleEndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile))));
                }
            }
            outCopy.writeBytes(");");
            outCopy.close();
            outCreate.writeBytes(");");
            outCreate.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void Shutdown() {
        try {
            this.scanner.close();
            this.fis.close();
            if (this.realHM != null) {
                for (Integer i : this.realWriters.keySet()) {
                    this.realWriters.get(i).close();
                }
            }
            if (this.intHM != null) {
                for (Integer i : this.intWriters.keySet()) {
                    this.intWriters.get(i).close();
                }
            }
            if (this.shortHM != null) {
                for (Integer i : this.shortWriters.keySet()) {
                    this.shortWriters.get(i).close();
                }
            }
            if (this.longHM != null) {
                for (Integer i : this.longWriters.keySet()) {
                    this.longWriters.get(i).close();
                }
            }
            if (this.charHM != null) {
                for (Integer i : this.charWriters.keySet()) {
                    this.charWriters.get(i).close();
                }
            }
            if (this.log10HM != null) {
                for (Integer i : this.log10Writers.keySet()) {
                    this.log10Writers.get(i).close();
                }
            }
            if (this.byteHM != null) {
                for (Integer i : this.byteWriters.keySet()) {
                    this.byteWriters.get(i).close();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Problem with shutdown");
            e.printStackTrace();
        }
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public static void main(String[] args) {
        GeneratePluginCode.generate(ColumnsToBinaryFullGenomeTablePlugin.class);
    }

    public String inputFile() {
        return this.inputFile.value();
    }

    public ColumnsToBinaryFullGenomeTablePlugin inputFile(String value) {
        this.inputFile = new PluginParameter<String>(this.inputFile, value);
        return this;
    }

    public String refFile() {
        return this.refFile.value();
    }

    public ColumnsToBinaryFullGenomeTablePlugin refFile(String value) {
        this.refFile = new PluginParameter<String>(this.refFile, value);
        return this;
    }

    public String outBase() {
        return this.outBase.value();
    }

    public ColumnsToBinaryFullGenomeTablePlugin outBase(String value) {
        this.outBase = new PluginParameter<String>(this.outBase, value);
        return this;
    }

    public String colsFloat() {
        return this.colsFloat.value();
    }

    public ColumnsToBinaryFullGenomeTablePlugin colsFloat(String value) {
        this.colsFloat = new PluginParameter<String>(this.colsFloat, value);
        return this;
    }

    public String colsInt() {
        return this.colsInt.value();
    }

    public ColumnsToBinaryFullGenomeTablePlugin colsInt(String value) {
        this.colsInt = new PluginParameter<String>(this.colsInt, value);
        return this;
    }

    public String colsShort() {
        return this.colsShort.value();
    }

    public ColumnsToBinaryFullGenomeTablePlugin colsShort(String value) {
        this.colsShort = new PluginParameter<String>(this.colsShort, value);
        return this;
    }

    public String colsLong() {
        return this.colsLong.value();
    }

    public ColumnsToBinaryFullGenomeTablePlugin colsLong(String value) {
        this.colsLong = new PluginParameter<String>(this.colsLong, value);
        return this;
    }

    public String colsByte() {
        return this.colsByte.value();
    }

    public ColumnsToBinaryFullGenomeTablePlugin colByte(String value) {
        this.colsByte = new PluginParameter<String>(this.colsByte, value);
        return this;
    }

    public String colsAllele() {
        return this.colsAllele.value();
    }

    public ColumnsToBinaryFullGenomeTablePlugin colsAllele(String value) {
        this.colsAllele = new PluginParameter<String>(this.colsAllele, value);
        return this;
    }

    public String colsChar() {
        return this.colsChar.value();
    }

    public ColumnsToBinaryFullGenomeTablePlugin colsChar(String value) {
        this.colsChar = new PluginParameter<String>(this.colsChar, value);
        return this;
    }

    public String colsLog10() {
        return this.colsLog10.value();
    }

    public ColumnsToBinaryFullGenomeTablePlugin colsLog10(String value) {
        this.colsLog10 = new PluginParameter<String>(this.colsLog10, value);
        return this;
    }

    public Boolean range() {
        return this.range.value();
    }

    public ColumnsToBinaryFullGenomeTablePlugin range(Boolean value) {
        this.range = new PluginParameter<Boolean>(this.range, value);
        return this;
    }

    public Boolean negToZero() {
        return this.negToZero.value();
    }

    public ColumnsToBinaryFullGenomeTablePlugin negToZero(Boolean value) {
        this.negToZero = new PluginParameter<Boolean>(this.negToZero, value);
        return this;
    }

    public Boolean missToZero() {
        return this.missToZero.value();
    }

    public ColumnsToBinaryFullGenomeTablePlugin missToZero(Boolean value) {
        this.missToZero = new PluginParameter<Boolean>(this.missToZero, value);
        return this;
    }

    public Boolean oneBased() {
        return this.oneBased.value();
    }

    public ColumnsToBinaryFullGenomeTablePlugin oneBased(Boolean value) {
        this.oneBased = new PluginParameter<Boolean>(this.oneBased, value);
        return this;
    }
}

