/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

public class ImputationByMean {
    private ImputationByMean() {
    }

    public static double[][] impute(double[][] data) {
        int rows = data.length;
        int cols = data[0].length;
        double[][] result = new double[rows][cols];
        for (int j = 0; j < cols; ++j) {
            double colmean = ImputationByMean.mean(j, data);
            for (int i = 0; i < rows; ++i) {
                result[i][j] = !Double.isNaN(data[i][j]) ? data[i][j] : colmean;
            }
        }
        return result;
    }

    public static double mean(int col, double[][] data) {
        int rows = data.length;
        double sum = 0.0;
        double count = 0.0;
        for (int i = 0; i < rows; ++i) {
            if (Double.isNaN(data[i][col])) continue;
            sum += data[i][col];
            count += 1.0;
        }
        double average = sum / count;
        return average;
    }
}

