/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.awt.Frame;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.numericaltransform.SubtractPhenotype;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;

public class SubtractPhenotypeByTaxaPlugin
extends AbstractPlugin {
    private PluginParameter<Boolean> useAbsoluteDifference = new PluginParameter.Builder<Boolean>("useAbsDiff", false, Boolean.class).description("Boolean to allow the user to use Absolute Difference when doing the subtraction.").build();

    public SubtractPhenotypeByTaxaPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        List<Datum> datumList = input.getDataOfType(Phenotype.class);
        if (datumList.size() != 2) {
            throw new IllegalArgumentException("SubtractPhenotypeByTaxaPlugin: select exactly two phenotype dataset to subtract.");
        }
        SubtractPhenotype subPheno = new SubtractPhenotype();
        Phenotype myPhenotype1 = (Phenotype)datumList.get(0).getData();
        Phenotype myPhenotype2 = (Phenotype)datumList.get(1).getData();
        try {
            Phenotype subtractedPhenotype = subPheno.subtractPhenotype(myPhenotype1, myPhenotype2, this.useAbsoluteDifference.value());
            if (myPhenotype1 != null) {
                String name = subtractedPhenotype.name();
                Datum td = new Datum(name, subtractedPhenotype, null);
                DataSet tds = new DataSet(td, (Plugin)this);
                return tds;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Subtract Phenotypes By Taxa";
    }

    @Override
    public String getToolTipText() {
        return "Subtract Phenotypes for Matching Taxa.";
    }

    @Override
    public String getCitation() {
        return "Bradbury PJ, Zhang Z, Kroon DE, Casstevens TM, Ramdoss Y, Buckler ES. (2007) TASSEL: Software for association mapping of complex traits in diverse samples. Bioinformatics 23:2633\u00ad2635.";
    }

    @Override
    public String pluginUserManualURL() {
        return "https://bitbucket.org/tasseladmin/tassel\u00ad5\u00adsource/wiki/UserManual/Kinship/Kinship";
    }

    public Phenotype runPlugin(DataSet input) {
        return (Phenotype)this.performFunction(input).getData(0).getData();
    }

    public Boolean useAbsoluteDifference() {
        return this.useAbsoluteDifference.value();
    }

    public SubtractPhenotypeByTaxaPlugin useAbsoluteDifference(Boolean value) {
        this.useAbsoluteDifference = new PluginParameter<Boolean>(this.useAbsoluteDifference, value);
        return this;
    }
}

