/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import com.google.common.collect.HashMultimap;
import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.numericaltransform.TransformDataDialog;
import net.maizegenetics.phenotype.CategoricalAttribute;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.util.OpenBitSet;
import org.apache.log4j.Logger;

public class TransformDataPlugin
extends AbstractPlugin {
    private static Logger myLogger = Logger.getLogger(TransformDataPlugin.class);
    private List<NumericAttribute> traitsToTransform;
    private List<CategoricalAttribute> byFactor;
    private boolean logTransform = false;
    private boolean powerTransform = false;
    private boolean standardize = false;
    private BASE myBase = BASE.natural;
    private double power = 1.0;
    private static final double log2 = Math.log(2.0);
    private boolean allTraits = true;
    private String traitnames = "";
    private String factornames = "";

    public TransformDataPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        List<Datum> myData = input.getDataOfType(Phenotype.class);
        if (myData.size() == 1) {
            Phenotype myPhenotype = (Phenotype)myData.get(0).getData();
            if (this.isInteractive()) {
                this.allTraits = false;
                List<NumericAttribute> numericAttributes = Stream.concat(myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data).stream(), myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate).stream()).map(pa -> (NumericAttribute)pa).collect(Collectors.toList());
                List<CategoricalAttribute> catAttributes = myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor).stream().map(pa -> (CategoricalAttribute)pa).collect(Collectors.toList());
                TransformDataDialog tdd = new TransformDataDialog(this.getParentFrame(), numericAttributes, catAttributes);
                tdd.setVisible(true);
                this.traitsToTransform = tdd.traitsToTransform();
                this.byFactor = tdd.factorsForStandardizing();
                this.logTransform = tdd.logTransformation();
                this.powerTransform = tdd.powerTransformation();
                this.standardize = tdd.standardize();
                this.myBase = tdd.base();
                this.power = tdd.exponent();
            } else {
                String[] attributeNames;
                if (this.traitnames.length() == 0) {
                    this.traitsToTransform = myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data).stream().map(a -> (NumericAttribute)a).collect(Collectors.toList());
                } else {
                    attributeNames = this.traitnames.split(",");
                    this.traitsToTransform = myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data).stream().filter(a -> this.contains(a.name(), attributeNames)).map(a -> (NumericAttribute)a).collect(Collectors.toList());
                }
                if (this.factornames.length() == 0) {
                    this.byFactor = new ArrayList<CategoricalAttribute>();
                } else {
                    attributeNames = this.factornames.split(",");
                    this.byFactor = myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor).stream().filter(a -> this.contains(a.name(), attributeNames)).map(a -> (CategoricalAttribute)a).collect(Collectors.toList());
                }
            }
            if (this.logTransform || this.powerTransform || this.standardize) {
                return this.transformTraits(myPhenotype, myData.get(0));
            }
            return null;
        }
        throw new IllegalArgumentException("TransformDataPlugin: Please select one Phenotype data set.");
    }

    private boolean contains(String name, String[] array) {
        return Arrays.stream(array).anyMatch(str -> str.equals(name));
    }

    public DataSet transformTraits(Phenotype myPhenotype, Datum myData) {
        List<PhenotypeAttribute> myNewAttributes = myPhenotype.attributeListCopy().stream().map(a -> this.transformAttribute((PhenotypeAttribute)a)).collect(Collectors.toList());
        Phenotype transformedPhenotype = new PhenotypeBuilder().fromAttributeList(myNewAttributes, myPhenotype.typeListCopy()).build().get(0);
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append("transformed_").append(myData.getName());
        StringBuilder commentBuilder = new StringBuilder();
        commentBuilder.append("Phenotypes transformed from ");
        commentBuilder.append(myData.getName()).append("\n");
        commentBuilder.append("The following traits were transformed by ");
        if (this.powerTransform) {
            commentBuilder.append("using a power ").append(this.power).append(" transformation:\n");
        } else if (this.logTransform) {
            commentBuilder.append("using a ").append(this.myBase.name()).append(" log transformation:\n");
        }
        if (this.standardize) {
            commentBuilder.append("standardizing.\n");
        }
        for (NumericAttribute na : this.traitsToTransform) {
            commentBuilder.append(na.name()).append("\n");
        }
        return new DataSet(new Datum(nameBuilder.toString(), transformedPhenotype, commentBuilder.toString()), (Plugin)this);
    }

    public PhenotypeAttribute transformAttribute(PhenotypeAttribute myAttribute) {
        if (!(myAttribute instanceof NumericAttribute)) {
            return myAttribute;
        }
        NumericAttribute myNumericAttribute = (NumericAttribute)myAttribute;
        if (!this.traitsToTransform.contains(myNumericAttribute)) {
            return myAttribute;
        }
        if (this.powerTransform) {
            myNumericAttribute = this.powerTransform(myNumericAttribute);
        } else if (this.logTransform) {
            myNumericAttribute = this.logTransform(myNumericAttribute);
        }
        if (this.standardize) {
            if (this.byFactor.size() > 0) {
                return this.standardize(myNumericAttribute, this.byFactor);
            }
            return this.standardize(myNumericAttribute);
        }
        return myNumericAttribute;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = TransformDataPlugin.class.getResource("/net/maizegenetics/analysis/images/Transform.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Transform Phenotype";
    }

    @Override
    public String getToolTipText() {
        return "Transform or standardize phenotypes";
    }

    public NumericAttribute powerTransform(NumericAttribute original) {
        float[] originalValues = original.floatValues();
        int n = originalValues.length;
        float[] transValues = new float[n];
        for (int i = 0; i < n; ++i) {
            transValues[i] = (float)Math.pow(originalValues[i], this.power);
        }
        return new NumericAttribute(original.name(), transValues, original.missing());
    }

    public NumericAttribute logTransform(NumericAttribute original) {
        double divisor;
        float[] originalValues = original.floatValues();
        int n = originalValues.length;
        float[] transValues = new float[n];
        switch (this.myBase) {
            case base_10: {
                divisor = Math.log(10.0);
                break;
            }
            case base_2: {
                divisor = Math.log(2.0);
                break;
            }
            default: {
                divisor = 1.0;
            }
        }
        block8: for (int i = 0; i < n; ++i) {
            switch (this.myBase) {
                case natural: {
                    transValues[i] = (float)Math.log(originalValues[i]);
                    continue block8;
                }
                case base_10: 
                case base_2: {
                    transValues[i] = (float)(Math.log(originalValues[i]) / divisor);
                }
            }
        }
        return new NumericAttribute(original.name(), transValues, original.missing());
    }

    public NumericAttribute standardize(NumericAttribute original) {
        float[] originalValues = original.floatValues();
        int n = originalValues.length;
        float[] meanSD = this.meanStdDev(originalValues);
        float[] transValues = new float[n];
        for (int i = 0; i < n; ++i) {
            transValues[i] = (originalValues[i] - meanSD[0]) / meanSD[1];
        }
        return new NumericAttribute(original.name(), transValues, original.missing());
    }

    public float[] meanStdDev(float[] data) {
        int n = data.length;
        double sum = 0.0;
        double sumsq = 0.0;
        int notMissingCount = 0;
        for (int i = 0; i < n; ++i) {
            double val = data[i];
            if (Double.isNaN(val)) continue;
            sum += val;
            sumsq += val * val;
            ++notMissingCount;
        }
        float mean = (float)sum / (float)notMissingCount;
        float sdev = (float)Math.sqrt((sumsq - sum / (double)notMissingCount * sum) / (double)(notMissingCount - 1));
        return new float[]{mean, sdev};
    }

    public NumericAttribute standardize(NumericAttribute original, List<CategoricalAttribute> byFactors) {
        List<int[]> subsetList = this.subsets(byFactors);
        float[] stdData = Arrays.copyOf(original.floatValues(), original.size());
        for (int[] subset : subsetList) {
            int n = subset.length;
            float[] subsetData = new float[n];
            for (int i = 0; i < n; ++i) {
                subsetData[i] = stdData[subset[i]];
            }
            float[] meanSD = this.meanStdDev(subsetData);
            for (int i = 0; i < n; ++i) {
                stdData[subset[i]] = (stdData[subset[i]] - meanSD[0]) / meanSD[1];
            }
        }
        return new NumericAttribute(original.name(), stdData, original.missing());
    }

    public List<int[]> subsets(List<CategoricalAttribute> byFactors) {
        class Subset {
            int[] levels;

            Subset(int[] levels) {
                this.levels = levels;
            }

            public boolean equals(Object other) {
                if (other instanceof Subset) {
                    return Arrays.equals(this.levels, ((Subset)other).levels);
                }
                return false;
            }

            public int hashCode() {
                int hc = 0;
                int mult = 1;
                for (int i : this.levels) {
                    hc += mult * Integer.hashCode(i);
                    mult *= 10;
                }
                return hc;
            }
        }
        int nobs = byFactors.get(0).size();
        OpenBitSet missing = new OpenBitSet(nobs);
        for (PhenotypeAttribute phenotypeAttribute : byFactors) {
            missing.or(phenotypeAttribute.missing());
        }
        int nfactors = byFactors.size();
        HashMultimap hashMultimap = HashMultimap.create();
        for (int obs = 0; obs < nobs; ++obs) {
            if (missing.fastGet(obs)) continue;
            int[] levels = new int[nfactors];
            int count = 0;
            for (CategoricalAttribute ca : byFactors) {
                levels[count++] = ca.intValue(obs);
            }
            hashMultimap.put((Object)new Subset(levels), (Object)obs);
        }
        ArrayList<int[]> subsetList = new ArrayList<int[]>();
        for (Subset sub : hashMultimap.keySet()) {
            subsetList.add(hashMultimap.get((Object)sub).stream().mapToInt(Integer::intValue).toArray());
        }
        return subsetList;
    }

    @Override
    public void setParameters(String[] args) {
        this.traitsToTransform = new ArrayList<NumericAttribute>();
        this.byFactor = new ArrayList<CategoricalAttribute>();
        int argPtr = 0;
        while (argPtr < args.length) {
            if (args[argPtr].toLowerCase().startsWith("-trait")) {
                this.setTraits(args[++argPtr]);
                ++argPtr;
                continue;
            }
            if (args[argPtr].toLowerCase().startsWith("-factor")) {
                this.setFactors(args[++argPtr]);
                ++argPtr;
                continue;
            }
            if (args[argPtr].equals("-log")) {
                String baseName;
                this.logTransform = true;
                this.powerTransform = false;
                if ((baseName = args[++argPtr]).equals("natural")) {
                    this.myBase = BASE.natural;
                } else if (baseName.equals("base_2")) {
                    this.myBase = BASE.base_2;
                } else if (baseName.equals("base_10")) {
                    this.myBase = BASE.base_10;
                } else {
                    throw new IllegalArgumentException("-log parameter value must be one of natural, base_2, base_10.");
                }
                ++argPtr;
                continue;
            }
            if (args[argPtr].equals("-power")) {
                this.powerTransform = true;
                this.logTransform = false;
                try {
                    this.power = Double.parseDouble(args[++argPtr]);
                }
                catch (NumberFormatException nfe) {
                    myLogger.error((Object)"-power parameter value must be a floating point number.", (Throwable)nfe);
                }
                ++argPtr;
                continue;
            }
            if (args[argPtr].equals("-standardize")) {
                String paramVal;
                this.standardize = (paramVal = args[++argPtr]).toLowerCase().startsWith("t");
                ++argPtr;
                continue;
            }
            String msg = String.format("unrecognized command line parameter for TransformDataPlugin: %s", args[argPtr]);
            myLogger.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public String getUsage() {
        StringBuilder usageString = new StringBuilder();
        usageString.append("The TransformDataPlugin can take the following parameters. Cannot use both log and power parameters.:\n");
        usageString.append("-traits: A comma delimited list of trait names with no embedded space. If this parameter is not specified then all traits will be transformed.");
        usageString.append("-factor: The factor name or a comma-delimited list of factor names with no embedded spaces within which values are to be standardized. ");
        usageString.append("The default is to ignore factors and use the mean and standard deviation of all observations.\n");
        usageString.append("-log: perform a log transformation. Can take one of natural, base_2, or base_10. Default = no transformation.");
        usageString.append("-power: perform a power transformation. The parameter value is the exponent to which each value should be raised. Default = no transformation.");
        usageString.append("-standardize: standardize values by subtracting the mean and dividing by the standard deviation. true or false. Default = false.");
        return usageString.toString();
    }

    public void setTraits(String namelist) {
        this.traitnames = namelist;
    }

    public void setFactors(String namelist) {
        this.factornames = namelist;
    }

    public void setTraitsToTransform(List<NumericAttribute> traitsToTransform) {
        this.traitsToTransform = traitsToTransform;
    }

    public void setByFactor(List<CategoricalAttribute> byFactor) {
        this.byFactor = byFactor;
    }

    public void setLogTransform(boolean logTransform) {
        this.logTransform = logTransform;
    }

    public void setPowerTransform(boolean powerTransform) {
        this.powerTransform = powerTransform;
    }

    public void setStandardize(boolean standardize) {
        this.standardize = standardize;
    }

    public void setMyBase(BASE myBase) {
        this.myBase = myBase;
    }

    public void setPower(double power) {
        this.power = power;
    }

    public static enum BASE {
        natural,
        base_2,
        base_10;

    }
}

