/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.popgen;

import cern.colt.map.OpenLongObjectHashMap;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Arrays;
import net.maizegenetics.analysis.popgen.LDResult;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.stats.statistics.FisherExact;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.ProgressListener;
import net.maizegenetics.util.TableReport;
import org.apache.log4j.Logger;

public class LinkageDisequilibrium
extends Thread
implements Serializable,
TableReport {
    private static final long serialVersionUID = -123423421342L;
    private static final Logger myLogger = Logger.getLogger(LinkageDisequilibrium.class);
    private GenotypeTable myAlignment;
    private int myMinTaxaForEstimate = 20;
    private int myWindowSize = 50;
    private int myTestSite = -1;
    private long myTotalTests = 0L;
    private testDesign myCurrDesign = testDesign.SlidingWindow;
    private OpenLongObjectHashMap myMapResults;
    private ProgressListener myListener = null;
    private FisherExact myFisherExact;
    private boolean myIsAccumulativeReport = false;
    private int myNumAccumulativeBins = 100;
    private float myAccumulativeInterval;
    private int[] myAccumulativeRValueBins;
    private int[] mySiteList;
    private static String NotImplemented = "NotImplemented";
    private static String NA = "N/A";
    private static Integer IntegerTwo = 2;
    private HetTreatment myHetTreatment = HetTreatment.Homozygous;

    public LinkageDisequilibrium(GenotypeTable alignment, int windowSize, testDesign LDType, int testSite, ProgressListener listener, boolean isAccumulativeReport, int numAccumulateIntervals, int[] sitesList, HetTreatment hetTreatment) {
        this.myAlignment = alignment;
        this.myFisherExact = FisherExact.getInstance(2 * this.myAlignment.numberOfTaxa() + 10);
        this.myWindowSize = windowSize;
        this.myCurrDesign = LDType;
        this.myTestSite = testSite;
        this.myListener = listener;
        this.myIsAccumulativeReport = isAccumulativeReport;
        if (this.myIsAccumulativeReport) {
            this.myNumAccumulativeBins = numAccumulateIntervals;
        }
        this.mySiteList = sitesList;
        if (this.mySiteList != null) {
            Arrays.sort(this.mySiteList);
        }
        this.myHetTreatment = hetTreatment;
    }

    @Override
    public void run() {
        this.initMatrices();
        switch (this.myHetTreatment) {
            case Haplotype: {
                this.calculateBitLDForHaplotype(false);
                break;
            }
            case Homozygous: {
                this.calculateBitLDForHaplotype(true);
                break;
            }
            case Genotype: {
                this.calculateBitLDWithHets();
                break;
            }
            default: {
                myLogger.error((Object)"Unknown LD analysis type selected for heterozygotes; skipping");
            }
        }
    }

    private void initMatrices() {
        long numSites = this.myAlignment.numberOfSites();
        if (this.myCurrDesign == testDesign.All) {
            this.myTotalTests = numSites * (numSites - 1L) / 2L;
        } else if (this.myCurrDesign == testDesign.SlidingWindow) {
            long n = Math.min(numSites - 1L, (long)this.myWindowSize);
            this.myTotalTests = n * (n + 1L) / 2L + (numSites - n - 1L) * n;
        } else if (this.myCurrDesign == testDesign.SiteByAll) {
            this.myTotalTests = numSites - 1L;
        } else if (this.myCurrDesign == testDesign.SiteList) {
            long n = this.mySiteList.length;
            this.myTotalTests = n * (n + 1L) / 2L + (numSites - n - 1L) * n;
        }
        if (this.myIsAccumulativeReport) {
            this.myAccumulativeInterval = 1.0f / (float)this.myNumAccumulativeBins;
            this.myAccumulativeRValueBins = new int[this.myNumAccumulativeBins + 1];
        } else {
            this.myMapResults = new OpenLongObjectHashMap((int)numSites);
        }
    }

    private long getMapKey(int r, int c) {
        return c < r ? (long)c * (long)this.myAlignment.numberOfSites() + (long)r : (long)r * (long)this.myAlignment.numberOfSites() + (long)c;
    }

    public static LDResult calculateBitLDForHaplotype(boolean ignoreHets, int minTaxaForEstimate, GenotypeTable alignment, int site1, int site2) {
        FisherExact fisherExact = FisherExact.getInstance(2 * alignment.numberOfTaxa() + 10);
        BitSet rMj = alignment.allelePresenceForAllTaxa(site1, WHICH_ALLELE.Major);
        BitSet rMn = alignment.allelePresenceForAllTaxa(site1, WHICH_ALLELE.Minor);
        BitSet cMj = alignment.allelePresenceForAllTaxa(site2, WHICH_ALLELE.Major);
        BitSet cMn = alignment.allelePresenceForAllTaxa(site2, WHICH_ALLELE.Minor);
        return LinkageDisequilibrium.getLDForSitePair(rMj, rMn, cMj, cMn, 2, minTaxaForEstimate, -1.0f, fisherExact, site1, site2);
    }

    public static LDResult calculateBitLDForHaplotype(int minTaxaForEstimate, int minorCnt, GenotypeTable alignment, int site1, int site2) {
        FisherExact fisherExact = FisherExact.getInstance(2 * alignment.numberOfTaxa() + 10);
        BitSet rMj = alignment.allelePresenceForAllTaxa(site1, WHICH_ALLELE.Major);
        BitSet rMn = alignment.allelePresenceForAllTaxa(site1, WHICH_ALLELE.Minor);
        BitSet cMj = alignment.allelePresenceForAllTaxa(site2, WHICH_ALLELE.Major);
        BitSet cMn = alignment.allelePresenceForAllTaxa(site2, WHICH_ALLELE.Minor);
        return LinkageDisequilibrium.getLDForSitePair(rMj, rMn, cMj, cMn, minorCnt, minTaxaForEstimate, -1.0f, fisherExact, site1, site2);
    }

    private void calculateBitLDForHaplotype(boolean ignoreHets) {
        GenotypeTable workingAlignment = ignoreHets ? GenotypeTableBuilder.getHomozygousInstance(this.myAlignment) : this.myAlignment;
        for (long currTest = 0L; currTest < this.myTotalTests; ++currTest) {
            int r = this.getRowFromIndex(currTest);
            int c = this.getColFromIndex(currTest);
            int currentProgress = (int)(100.0 * ((double)currTest / (double)this.myTotalTests));
            this.fireProgress(currentProgress);
            BitSet rMj = workingAlignment.allelePresenceForAllTaxa(r, WHICH_ALLELE.Major);
            BitSet rMn = workingAlignment.allelePresenceForAllTaxa(r, WHICH_ALLELE.Minor);
            BitSet cMj = workingAlignment.allelePresenceForAllTaxa(c, WHICH_ALLELE.Major);
            BitSet cMn = workingAlignment.allelePresenceForAllTaxa(c, WHICH_ALLELE.Minor);
            LDResult ldr = LinkageDisequilibrium.getLDForSitePair(rMj, rMn, cMj, cMn, 2, this.myMinTaxaForEstimate, -1.0f, this.myFisherExact, r, c);
            if (this.myIsAccumulativeReport) {
                int index;
                if (Float.isNaN(ldr.r2())) {
                    int n = this.myNumAccumulativeBins;
                    this.myAccumulativeRValueBins[n] = this.myAccumulativeRValueBins[n] + 1;
                    continue;
                }
                if (ldr.r2() == 1.0f) {
                    int n = this.myNumAccumulativeBins - 1;
                    this.myAccumulativeRValueBins[n] = this.myAccumulativeRValueBins[n] + 1;
                    continue;
                }
                int n = index = (int)Math.floor(ldr.r2() / this.myAccumulativeInterval);
                this.myAccumulativeRValueBins[n] = this.myAccumulativeRValueBins[n] + 1;
                continue;
            }
            long key = this.getMapKey(r, c);
            this.myMapResults.put(key, (Object)ldr);
        }
        if (this.myMapResults != null) {
            this.myMapResults.trimToSize();
        }
    }

    private void calculateBitLDWithHets() {
        myLogger.error((Object)"Calculating LD with hets as a third state is not implemented yet; skipping");
        throw new IllegalStateException("LinkageDisequilibrium: calculateBitLDWithHets: Treating hets as a third state is not yet implemented");
    }

    public static double calculateDPrime(int countAB, int countAb, int countaB, int countab, int minTaxaForEstimate) {
        double nonmissingSampleSize = countAB + countAb + countaB + countab;
        if (nonmissingSampleSize < (double)minTaxaForEstimate) {
            return Double.NaN;
        }
        double countR = countab + countAb;
        double countC = countab + countaB;
        double freqR = (nonmissingSampleSize - countR) / nonmissingSampleSize;
        double freqC = (nonmissingSampleSize - countC) / nonmissingSampleSize;
        if (freqR == 0.0 || freqC == 0.0 || freqR == 1.0 || freqC == 1.0) {
            return Double.NaN;
        }
        double freq = (double)countAB / nonmissingSampleSize - freqR * freqC;
        if (freq < 0.0) {
            return freq / Math.max(-freqR * freqC, -(1.0 - freqR) * (1.0 - freqC));
        }
        return freq / Math.min((1.0 - freqR) * freqC, (1.0 - freqC) * freqR);
    }

    public static double calculateRSqr(int countAB, int countAb, int countaB, int countab, int minTaxaForEstimate) {
        double nonmissingSampleSize = countAB + countAb + countaB + countab;
        if (nonmissingSampleSize < (double)minTaxaForEstimate) {
            return Double.NaN;
        }
        double freqA = (double)(countAB + countAb) / nonmissingSampleSize;
        double freqB = (double)(countAB + countaB) / nonmissingSampleSize;
        if (freqA == 0.0 || freqB == 0.0 || freqA == 1.0 || freqB == 1.0) {
            return Double.NaN;
        }
        double rsqr = (double)countAB / nonmissingSampleSize * ((double)countab / nonmissingSampleSize);
        rsqr -= (double)countaB / nonmissingSampleSize * ((double)countAb / nonmissingSampleSize);
        rsqr *= rsqr;
        return rsqr /= freqA * (1.0 - freqA) * freqB * (1.0 - freqB);
    }

    public static LDResult getLDForSitePair(BitSet rMj, BitSet rMn, BitSet cMj, BitSet cMn, int minMinorCnt, int minCnt, float minR2, FisherExact myFisherExact, int site1Index, int site2Index) {
        if (myFisherExact == null) {
            myFisherExact = FisherExact.getInstance(2 * (int)rMj.size() + 10);
        }
        LDResult.Builder results = new LDResult.Builder(site1Index, site2Index);
        int n = 0;
        int[][] contig = new int[2][2];
        int n2 = (int)OpenBitSet.intersectionCount(rMn, cMn);
        contig[1][1] = n2;
        n += n2;
        int n3 = (int)OpenBitSet.intersectionCount(rMn, cMj);
        contig[1][0] = n3;
        n += n3;
        if (contig[1][0] + contig[1][1] < minMinorCnt) {
            return results.build();
        }
        int n4 = (int)OpenBitSet.intersectionCount(rMj, cMn);
        contig[0][1] = n4;
        n += n4;
        if (contig[0][1] + contig[1][1] < minMinorCnt) {
            return results.build();
        }
        int n5 = (int)OpenBitSet.intersectionCount(rMj, cMj);
        contig[0][0] = n5;
        results.n(n += n5);
        if (n < minCnt) {
            return results.build();
        }
        double rValue = LinkageDisequilibrium.calculateRSqr(contig[0][0], contig[1][0], contig[0][1], contig[1][1], minCnt);
        results.r2((float)rValue);
        if (Double.isNaN(rValue)) {
            return results.build();
        }
        results.dprime((float)LinkageDisequilibrium.calculateDPrime(contig[0][0], contig[1][0], contig[0][1], contig[1][1], minCnt));
        if (rValue < (double)minR2) {
            return results.build();
        }
        double pValue = myFisherExact.getTwoTailedP(contig[0][0], contig[1][0], contig[0][1], contig[1][1]);
        results.p((float)pValue);
        return results.build();
    }

    private int getRowFromIndex(long index) {
        int k;
        int m;
        int row = 0;
        int n = this.myAlignment.numberOfSites();
        int w = this.myWindowSize;
        row = this.myCurrDesign == testDesign.SlidingWindow && n > w + 1 && (double)index >= (double)(w * (w + 1)) / 2.0 ? (int)Math.ceil(((double)index + 1.0 - (double)(w * (w + 1) / 2) + (double)(w * w)) / (double)w) : (this.myCurrDesign == testDesign.SiteByAll ? (index < (long)this.myTestSite ? this.myTestSite : (int)index + 1) : (this.myCurrDesign == testDesign.SiteList ? ((long)(m = n * ((k = (int)Math.ceil((double)n - 1.5 - Math.sqrt(((double)n - 1.5) * ((double)n - 1.5) + (double)(2L * ((long)n - index - 2L))))) + 1) - (k + 1) * (k + 2) / 2 - 1) - index > (long)(n - this.mySiteList[k] - 1) ? this.mySiteList[k] : n - 1 - m + (int)index) : (int)Math.ceil((Math.sqrt(8L * (index + 1L) + 1L) - 1.0) / 2.0)));
        return row;
    }

    private int getColFromIndex(long index) {
        int row = this.getRowFromIndex(index);
        int col = 0;
        int n = this.myAlignment.numberOfSites();
        int w = this.myWindowSize;
        if (this.myCurrDesign == testDesign.SlidingWindow && n > w + 1 && (double)index >= (double)(w * (w + 1)) / 2.0) {
            col = (int)((double)(row - 1) - (double)w * (double)(w + 1) / 2.0 - (double)(w * (row - w)) + 1.0 + (double)index);
        } else if (this.myCurrDesign == testDesign.SiteByAll) {
            col = index < (long)this.myTestSite ? (int)index : this.myTestSite;
        } else if (this.myCurrDesign == testDesign.SiteList) {
            int k = (int)Math.ceil((double)n - 1.5 - Math.sqrt(((double)n - 1.5) * ((double)n - 1.5) + (double)(2L * ((long)n - index - 2L))));
            int m = n * (k + 1) - (k + 1) * (k + 2) / 2 - 1;
            if (row != this.mySiteList[k]) {
                col = this.mySiteList[k];
            } else {
                col = n - m + (int)index - 2;
                int yy = Arrays.binarySearch(this.mySiteList, row);
                int y = Arrays.binarySearch(this.mySiteList, col);
                while (yy + (y + 1) != 0) {
                    if (y < 0) {
                        y = -(y + 1);
                    }
                    yy = y;
                    y = Arrays.binarySearch(this.mySiteList, col -= yy - y);
                }
            }
        } else {
            col = row - (row * (row + 1) / 2 - (int)index);
        }
        return col;
    }

    public double getPVal(int r, int c) {
        long key = this.getMapKey(r, c);
        LDResult result = (LDResult)this.myMapResults.get(key);
        if (result == null) {
            return Double.NaN;
        }
        return result.p();
    }

    public int getSampleSize(int r, int c) {
        long key = this.getMapKey(r, c);
        LDResult result = (LDResult)this.myMapResults.get(key);
        if (result == null) {
            return 0;
        }
        return result.n();
    }

    public float getDPrime(int r, int c) {
        long key = this.getMapKey(r, c);
        LDResult result = (LDResult)this.myMapResults.get(key);
        if (result == null) {
            return Float.NaN;
        }
        return result.dPrime();
    }

    public float getRSqr(int r, int c) {
        long key = this.getMapKey(r, c);
        LDResult result = (LDResult)this.myMapResults.get(key);
        if (result == null) {
            return Float.NaN;
        }
        return result.r2();
    }

    public int getX(int row) {
        return this.getColFromIndex(row);
    }

    public int getY(int row) {
        return this.getRowFromIndex(row);
    }

    public int getSiteCount() {
        return this.myAlignment.numberOfSites();
    }

    public GenotypeTable getAlignment() {
        return this.myAlignment;
    }

    @Override
    public String toString() {
        String delimit = "\t";
        StringWriter sw = new StringWriter();
        Object[] colNames = this.getTableColumnNames();
        for (int j = 0; j < colNames.length; ++j) {
            sw.write(colNames[j].toString());
            sw.write(delimit);
        }
        sw.write("\n");
        for (long r = 0L; r < this.myTotalTests; ++r) {
            Object[] theRow = this.getRow(r);
            for (int i = 0; i < theRow.length; ++i) {
                sw.write(theRow[i].toString());
                sw.write(delimit);
            }
        }
        return sw.toString();
    }

    @Override
    public Object[] getTableColumnNames() {
        Object[] annotatedLabels = null;
        annotatedLabels = this.myIsAccumulativeReport ? new String[]{"R2BinMin", "R2BinMax", "Count"} : new String[]{"Locus1", "Position1", "Site1", "NumberOfStates1", "States1", "Frequency1", "Locus2", "Position2", "Site2", "NumberOfStates2", "States2", "Frequency2", "Dist_bp", "R^2", "DPrime", "pDiseq", "N"};
        return annotatedLabels;
    }

    @Override
    public Object[] getRow(long row) {
        if (this.myIsAccumulativeReport) {
            Object[] data = new Object[3];
            if (row == (long)this.myNumAccumulativeBins) {
                data[0] = Double.NaN;
                data[1] = Double.NaN;
                data[2] = this.myAccumulativeRValueBins[(int)row];
            } else {
                double start = (double)this.myAccumulativeInterval * (double)row;
                data[0] = start;
                data[1] = start + (double)this.myAccumulativeInterval;
                data[2] = this.myAccumulativeRValueBins[(int)row];
            }
            return data;
        }
        int labelOffset = 0;
        Object[] data = new Object[17];
        int r = this.getRowFromIndex(row);
        int c = this.getColFromIndex(row);
        String rState = this.myAlignment.majorAlleleAsString(r) + ":" + this.myAlignment.minorAlleleAsString(r);
        Integer rStr = r;
        String cState = this.myAlignment.majorAlleleAsString(c) + ":" + this.myAlignment.minorAlleleAsString(c);
        Integer cStr = c;
        data[labelOffset++] = this.myAlignment.chromosomeName(r);
        data[labelOffset++] = this.myAlignment.chromosomalPosition(r);
        data[labelOffset++] = rStr;
        data[labelOffset++] = IntegerTwo;
        data[labelOffset++] = rState;
        data[labelOffset++] = NotImplemented;
        data[labelOffset++] = this.myAlignment.chromosomeName(c);
        data[labelOffset++] = this.myAlignment.chromosomalPosition(c);
        data[labelOffset++] = cStr;
        data[labelOffset++] = IntegerTwo;
        data[labelOffset++] = cState;
        data[labelOffset++] = NotImplemented;
        data[labelOffset++] = this.myAlignment.chromosomeName(r).equals(this.myAlignment.chromosomeName(c)) ? Integer.valueOf(Math.abs(this.myAlignment.chromosomalPosition(r) - this.myAlignment.chromosomalPosition(c))) : NA;
        data[labelOffset++] = Float.valueOf(this.getRSqr(r, c));
        data[labelOffset++] = Float.valueOf(this.getDPrime(r, c));
        data[labelOffset++] = this.getPVal(r, c);
        data[labelOffset++] = this.getSampleSize(r, c);
        return data;
    }

    @Override
    public String getTableTitle() {
        return "Linkage Disequilibrium";
    }

    @Override
    public int getColumnCount() {
        return this.getTableColumnNames().length;
    }

    @Override
    public long getRowCount() {
        if (this.myIsAccumulativeReport) {
            return this.myNumAccumulativeBins + 1;
        }
        return this.myTotalTests;
    }

    @Override
    public long getElementCount() {
        return this.getRowCount() * (long)this.getColumnCount();
    }

    @Override
    public Object getValueAt(long row, int col) {
        return this.getRow(row)[col];
    }

    protected void fireProgress(int percent) {
        if (percent < 0) {
            percent = -percent;
        }
        if (this.myListener != null) {
            this.myListener.progress(percent, null);
        }
    }

    public static enum HetTreatment {
        Haplotype,
        Homozygous,
        Genotype;

    }

    public static enum testDesign {
        All,
        SlidingWindow,
        SiteByAll,
        SiteList;

    }
}

