/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.rna;

import java.awt.Frame;
import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagBuilder;
import net.maizegenetics.dna.tag.TagDataSQLite;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class LoadRNAContigsToGBSDBPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(LoadRNAContigsToGBSDBPlugin.class);
    private PluginParameter<String> myContigFile = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input Fasta Contig File").required(true).inFile().description("Input file containing contigs in fasta format.\n").build();
    private PluginParameter<String> myOutputDB = new PluginParameter.Builder<String>("db", null, String.class).guiName("Output Database File").required(true).outFile().description("Output Database File").build();
    private PluginParameter<Boolean> myDeleteOldData = new PluginParameter.Builder<Boolean>("deleteOldData", false, Boolean.class).guiName("Delete Old Data").description("Delete existing SNP quality data from db tables").build();

    public LoadRNAContigsToGBSDBPlugin() {
        super(null, false);
    }

    public LoadRNAContigsToGBSDBPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        super.preProcessParameters(input);
        if (Files.exists(Paths.get(this.outputDB(), new String[0]), new LinkOption[0]) && this.deleteOldData().booleanValue()) {
            try {
                Files.delete(Paths.get(this.myOutputDB.value(), new String[0]));
            }
            catch (Exception exc) {
                System.out.println("Error when trying to delete database file: " + this.myOutputDB.value());
                System.out.println("File delete error: " + exc.getMessage());
            }
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        long lineNumber = 0L;
        try {
            Tag newTag;
            String line;
            TagDataSQLite tdw = new TagDataSQLite(this.myOutputDB.value());
            BufferedReader br = Utils.getBufferedReader(this.contigFile(), 0x400000);
            String header = null;
            StringBuilder seq = new StringBuilder();
            HashMap<Tag, String> contigNameMap = new HashMap<Tag, String>(100000);
            while ((line = br.readLine()) != null) {
                line = line.trim();
                ++lineNumber;
                if (line.startsWith(">")) {
                    if (header != null && (newTag = TagBuilder.instance(seq.toString()).build()) != null) {
                        contigNameMap.put(newTag, header);
                    }
                    header = line;
                    seq = new StringBuilder();
                    continue;
                }
                seq.append(line);
            }
            if (header != null && (newTag = TagBuilder.instance(seq.toString()).build()) != null) {
                contigNameMap.put(newTag, header);
            }
            tdw.putAllNamesTag(contigNameMap);
            tdw.close();
        }
        catch (Exception ioe) {
            System.err.println("Error in line number " + lineNumber);
            ioe.printStackTrace();
        }
        return new DataSet(new Datum("OutputDatabase", this.outputDB(), ""), (Plugin)this);
    }

    public String runPlugin(DataSet input) {
        return (String)this.performFunction(input).getData(0).getData();
    }

    public String contigFile() {
        return this.myContigFile.value();
    }

    public LoadRNAContigsToGBSDBPlugin contigFile(String value) {
        this.myContigFile = new PluginParameter<String>(this.myContigFile, value);
        return this;
    }

    public String outputDB() {
        return this.myOutputDB.value();
    }

    public LoadRNAContigsToGBSDBPlugin outputDB(String value) {
        this.myOutputDB = new PluginParameter<String>(this.myOutputDB, value);
        return this;
    }

    public Boolean deleteOldData() {
        return this.myDeleteOldData.value();
    }

    public LoadRNAContigsToGBSDBPlugin deleteOldData(Boolean value) {
        this.myDeleteOldData = new PluginParameter<Boolean>(this.myDeleteOldData, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return null;
    }
}

