/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.tree;

import java.awt.Frame;
import java.util.List;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.tree.NewickUtils;
import net.maizegenetics.taxa.tree.Tree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\tJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\tJ\b\u0010\f\u001a\u00020\tH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/maizegenetics/analysis/tree/ConvertTreeNamesPlugin;", "Lnet/maizegenetics/plugindef/AbstractPlugin;", "parentFrame", "Ljava/awt/Frame;", "isInteractive", "", "(Ljava/awt/Frame;Z)V", "filename", "Lnet/maizegenetics/plugindef/PluginParameter;", "", "kotlin.jvm.PlatformType", "value", "getButtonName", "getIcon", "Ljavax/swing/ImageIcon;", "getToolTipText", "preProcessParameters", "", "input", "Lnet/maizegenetics/plugindef/DataSet;", "processData", "tassel"})
public final class ConvertTreeNamesPlugin
extends AbstractPlugin {
    private PluginParameter<String> filename;

    public ConvertTreeNamesPlugin(@Nullable Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
        this.filename = new PluginParameter.Builder<String>("nameList", null, String.class).description("Conversion filename. Each line of the file should have two names separated with a tab. The first name should be converted to the second.").inFile().required(true).build();
    }

    public /* synthetic */ ConvertTreeNamesPlugin(Frame frame, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            frame = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(frame, bl);
    }

    @Override
    protected void preProcessParameters(@Nullable DataSet input) {
        int n;
        int numTrees;
        List<Datum> temp;
        DataSet dataSet = input;
        List<Datum> list = temp = dataSet == null ? null : dataSet.getDataOfType(Tree.class);
        int n2 = numTrees = list == null ? 0 : (n = list.size());
        if (numTrees != 1) {
            throw new IllegalArgumentException("ConvertTreeNamesPlugin: processData: must input 1 tree");
        }
    }

    @Override
    @Nullable
    public DataSet processData(@Nullable DataSet input) {
        DataSet dataSet = input;
        Intrinsics.checkNotNull((Object)dataSet);
        Object object = dataSet.getDataOfType(Tree.class).get(0).getData();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.maizegenetics.taxa.tree.Tree");
        }
        Tree tree = (Tree)object;
        return new DataSet(new Datum("Convert Tree Names", NewickUtils.convertNames(tree, this.filename()), null), (Plugin)this);
    }

    @NotNull
    public final String filename() {
        String string = this.filename.value();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filename.value()");
        return string;
    }

    @NotNull
    public final ConvertTreeNamesPlugin filename(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.filename = new PluginParameter<String>(this.filename, value);
        return this;
    }

    @Override
    @NotNull
    public String getToolTipText() {
        return "Convert Tree Names";
    }

    @Override
    @NotNull
    public String getButtonName() {
        return "Convert Tree Names";
    }

    @Override
    @Nullable
    public ImageIcon getIcon() {
        return null;
    }

    public ConvertTreeNamesPlugin() {
        this(null, false, 3, null);
    }
}

