/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.util.Tuple;

public interface GenomeSequence {
    public Set<Chromosome> chromosomes();

    public byte[] chromosomeSequence(Chromosome var1);

    public byte[] chromosomeSequence(Chromosome var1, int var2, int var3);

    public byte[] genomeSequence(long var1, long var3);

    default public String genomeSequenceAsString(long startSite, long lastSite) {
        return NucleotideAlignmentConstants.nucleotideBytetoString(this.genomeSequence(startSite, lastSite));
    }

    public Map<Long, Tuple<Chromosome, Integer>> fullRefCoordinateToChromCoordinate(ArrayList<Long> var1);

    public int chromosomeSize(Chromosome var1);

    public long genomeSize();

    public int numberOfChromosomes();

    public byte genotype(Chromosome var1, int var2);

    public byte genotype(Chromosome var1, Position var2);

    public String genotypeAsString(Chromosome var1, int var2);

    public String genotypeAsString(Chromosome var1, Position var2);

    public String genotypeAsString(Chromosome var1, int var2, int var3);
}

