/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GenomeSequence;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.util.Tuple;

class HalfByteGenomeSequence
implements GenomeSequence {
    private Map<Chromosome, byte[]> chromPositionMap;
    private Map<Chromosome, Integer> chromLengthLookup = new HashMap<Chromosome, Integer>();
    private RangeMap<Long, Chromosome> wholeGenomeIndexMap = TreeRangeMap.create();
    private final long genomeSize;

    protected HalfByteGenomeSequence(Map<Chromosome, byte[]> chromPositionMap) {
        this.chromPositionMap = chromPositionMap;
        chromPositionMap.entrySet().stream().forEach(e -> this.chromLengthLookup.put((Chromosome)e.getKey(), ((Chromosome)e.getKey()).getLength()));
        LongAdder genomeIndex = new LongAdder();
        this.chromosomes().stream().sorted().forEach(chrom -> {
            int length = this.chromLengthLookup.get(chrom);
            this.wholeGenomeIndexMap.put(Range.closed((Comparable)Long.valueOf(genomeIndex.longValue()), (Comparable)Long.valueOf(genomeIndex.longValue() + (long)length - 1L)), chrom);
            genomeIndex.add(length);
        });
        this.genomeSize = genomeIndex.longValue();
    }

    @Override
    public Set<Chromosome> chromosomes() {
        return this.chromPositionMap.keySet();
    }

    @Override
    public byte[] chromosomeSequence(Chromosome chrom) {
        return this.chromosomeSequence(chrom, 1, this.chromLengthLookup.get(chrom));
    }

    @Override
    public byte[] chromosomeSequence(Chromosome chrom, int startSite, int lastSite) {
        --lastSite;
        if (--startSite < 0) {
            throw new IllegalArgumentException("GenomeSequenceBuilder.chromosomeSequence: starting parameter is less than 1 for 1-based method");
        }
        byte[] packedBytes = this.chromPositionMap.get(chrom);
        if (packedBytes == null) {
            throw new IllegalArgumentException("GenomeSequenceBuilder.chromosomeSequence: chromosome not found");
        }
        if (startSite > packedBytes.length * 2 || lastSite > packedBytes.length * 2) {
            System.out.println("GenomeSequenceBuilder, chrom: " + chrom.getName() + ", startSite: " + startSite + ", lastSite: " + lastSite + ", chromSize: " + this.chromosomeSize(chrom));
            throw new IllegalArgumentException("GenomeSequenceBuilder.chromosomeSequence: requested sequence is out of range");
        }
        byte[] fullBytes = new byte[lastSite - startSite + 1];
        for (int i = startSite; i <= lastSite; ++i) {
            fullBytes[i - startSite] = (byte)(i % 2 == 0 ? (packedBytes[i / 2] & 0xF0) >> 4 : packedBytes[i / 2] & 0xF);
        }
        return fullBytes;
    }

    @Override
    public byte genotype(Chromosome chrom, int position) {
        --position;
        byte[] packedBytes = this.chromPositionMap.get(chrom);
        if (packedBytes == null) {
            throw new IllegalArgumentException("GenomeSequenceBuilder.chromosomeSequence: chromosome not found");
        }
        if (position > packedBytes.length * 2) {
            System.out.println("GenomeSequenceBuilder, chrom: " + chrom.getName() + ", position: " + position + ", chromSize: " + this.chromosomeSize(chrom));
            throw new IllegalArgumentException("GenomeSequenceBuilder.chromosomeSequence: requested position is out of range");
        }
        byte alleleAtPosition = (byte)(position % 2 == 0 ? (packedBytes[position / 2] & 0xF0) >> 4 : packedBytes[position / 2] & 0xF);
        return alleleAtPosition;
    }

    @Override
    public byte genotype(Chromosome chrom, Position positionObject) {
        int position = positionObject.getPosition();
        --position;
        byte[] packedBytes = this.chromPositionMap.get(chrom);
        if (packedBytes == null) {
            throw new IllegalArgumentException("GenomeSequenceBuilder.chromosomeSequence: chromosome not found");
        }
        if (position > packedBytes.length * 2) {
            System.out.println("GenomeSequenceBuilder, chrom: " + chrom.getName() + ", position: " + position + ", chromSize: " + this.chromosomeSize(chrom));
            throw new IllegalArgumentException("GenomeSequenceBuilder.chromosomeSequence: requested position is out of range");
        }
        byte valueAtPosition = (byte)(position % 2 == 0 ? (packedBytes[position / 2] & 0xF0) >> 4 : packedBytes[position / 2] & 0xF);
        return valueAtPosition;
    }

    @Override
    public String genotypeAsString(Chromosome chrom, int position) {
        byte valueAtPosition = this.genotype(chrom, position);
        return NucleotideAlignmentConstants.getHaplotypeNucleotide(valueAtPosition);
    }

    @Override
    public String genotypeAsString(Chromosome chrom, Position positionObject) {
        int position = positionObject.getPosition();
        byte valueAtPosition = this.genotype(chrom, position);
        return NucleotideAlignmentConstants.getHaplotypeNucleotide(valueAtPosition);
    }

    @Override
    public String genotypeAsString(Chromosome chrom, int startSite, int endSite) {
        byte[] chromBytes = this.chromosomeSequence(chrom, startSite, endSite);
        StringBuilder builder = new StringBuilder();
        for (int idx = 0; idx < chromBytes.length; ++idx) {
            builder.append(NucleotideAlignmentConstants.getHaplotypeNucleotide(chromBytes[idx]));
        }
        return builder.toString();
    }

    @Override
    public byte[] genomeSequence(long startSite, long lastSite) {
        byte[] chromoSeq;
        if (lastSite - startSite > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Less than 2147483647 sites must be requested at a time");
        }
        byte[] fullBytes = new byte[(int)(lastSite - startSite + 1L)];
        for (long currentSiteToGet = startSite; currentSiteToGet < lastSite; currentSiteToGet += (long)chromoSeq.length) {
            Map.Entry rangeChromEntry = this.wholeGenomeIndexMap.getEntry((Comparable)Long.valueOf(currentSiteToGet));
            int chrStart = (int)(currentSiteToGet - (Long)((Range)rangeChromEntry.getKey()).lowerEndpoint());
            int chrLast = (int)Math.min((Long)((Range)rangeChromEntry.getKey()).upperEndpoint() - (Long)((Range)rangeChromEntry.getKey()).lowerEndpoint(), lastSite - (Long)((Range)rangeChromEntry.getKey()).lowerEndpoint());
            chromoSeq = this.chromosomeSequence((Chromosome)rangeChromEntry.getValue(), chrStart + 1, chrLast + 1);
            System.arraycopy(chromoSeq, 0, fullBytes, (int)(currentSiteToGet - startSite), chromoSeq.length);
        }
        return fullBytes;
    }

    @Override
    public int chromosomeSize(Chromosome chromosome) {
        return this.chromLengthLookup.get(chromosome);
    }

    @Override
    public long genomeSize() {
        return this.genomeSize;
    }

    @Override
    public int numberOfChromosomes() {
        return this.chromPositionMap.size();
    }

    @Override
    public Map<Long, Tuple<Chromosome, Integer>> fullRefCoordinateToChromCoordinate(ArrayList<Long> coordinates) {
        ConcurrentHashMap<Long, Tuple<Chromosome, Integer>> mappedCoordinates = new ConcurrentHashMap<Long, Tuple<Chromosome, Integer>>();
        ((Stream)coordinates.stream().parallel()).forEach(coordinate -> {
            Map.Entry rangeChromEntry = this.wholeGenomeIndexMap.getEntry((Comparable)coordinate);
            Chromosome curChrom = (Chromosome)rangeChromEntry.getValue();
            long chromCoordinate = coordinate - (Long)((Range)rangeChromEntry.getKey()).lowerEndpoint();
            Tuple<Chromosome, Integer> chromWithCoordinate = new Tuple<Chromosome, Integer>(curChrom, (int)chromCoordinate);
            mappedCoordinates.put((Long)coordinate, chromWithCoordinate);
        });
        return mappedCoordinates;
    }
}

