/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.SAMUtils;
import net.maizegenetics.dna.tag.Tags;
import net.maizegenetics.util.MultiMemberGZIPInputStream;

public class PETagsOnPhysicalMapV3
implements Tags {
    protected int tagLengthInLong = 2;
    long[][] tags;
    byte[] variableTagLengthInLong;
    short[] tagLength;
    boolean[] ifContig;
    int[] pairIndex;
    byte[] mappingNum;
    byte[][] chr;
    byte[][] strand;
    int[][] startPos;
    short[][] score;
    byte[][] divergence;

    public PETagsOnPhysicalMapV3(String PETOPMFileS) {
        this.readBinaryFile(PETOPMFileS);
    }

    public PETagsOnPhysicalMapV3(String fFastaFileS, String bFastaFileS, String fSamFileS, String bSamFileS) {
        int tagNum = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader(fFastaFileS), 65536);
            String temp = null;
            while ((temp = br.readLine()) != null) {
                ++tagNum;
            }
            System.out.println(String.valueOf(tagNum) + " PE tags (one end) in total");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.iniMatrix(tagNum);
        this.importSamFile(fFastaFileS, fSamFileS, 0);
        this.importSamFile(bFastaFileS, bSamFileS, tagNum / 2);
        this.trancateTag();
        this.sort();
    }

    public void trancateTag() {
        String nullS = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
        for (int i = 0; i < this.tags.length; ++i) {
            int j;
            long[] t = new long[this.tagLengthInLong];
            if (this.variableTagLengthInLong[i] < this.tagLengthInLong) {
                for (j = 0; j < this.variableTagLengthInLong[i]; ++j) {
                    t[j] = this.tags[i][j];
                }
                for (j = this.variableTagLengthInLong[i]; j < this.tagLengthInLong; ++j) {
                    t[j] = BaseEncoder.getLongFromSeq(nullS);
                }
            } else {
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    t[j] = this.tags[i][j];
                }
            }
            this.tags[i] = t;
        }
        System.out.println("PE tags were truncated to " + String.valueOf(this.tagLengthInLong * 32) + " bp");
    }

    public void writeBinaryFile(String outfileS) {
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outfileS), 65536));
            dos.writeInt(this.tagLengthInLong);
            dos.writeInt(this.tags.length);
            for (int i = 0; i < this.getTagCount(); ++i) {
                int j;
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    dos.writeLong(this.tags[i][j]);
                }
                dos.writeByte(this.variableTagLengthInLong[i]);
                dos.writeShort(this.tagLength[i]);
                dos.writeBoolean(this.ifContig[i]);
                dos.writeInt(this.pairIndex[i]);
                dos.writeByte(this.mappingNum[i]);
                for (j = 0; j < this.mappingNum[i]; ++j) {
                    dos.writeByte(this.chr[i][j]);
                    dos.writeByte(this.strand[i][j]);
                    dos.writeInt(this.startPos[i][j]);
                    dos.writeShort(this.score[i][j]);
                    dos.writeByte(this.divergence[i][j]);
                }
            }
            dos.flush();
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("File written to " + outfileS);
    }

    public void readBinaryFile(String infileS) {
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(infileS), 65536));
            this.tagLengthInLong = dis.readInt();
            int tagNum = dis.readInt();
            this.iniMatrix(tagNum);
            for (int i = 0; i < tagNum; ++i) {
                int j;
                this.tags[i] = new long[this.tagLengthInLong];
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    this.tags[i][j] = dis.readLong();
                }
                this.variableTagLengthInLong[i] = dis.readByte();
                this.tagLength[i] = dis.readShort();
                this.ifContig[i] = dis.readBoolean();
                this.pairIndex[i] = dis.readInt();
                this.mappingNum[i] = dis.readByte();
                if (this.mappingNum[i] == 0) continue;
                this.chr[i] = new byte[this.mappingNum[i]];
                this.strand[i] = new byte[this.mappingNum[i]];
                this.startPos[i] = new int[this.mappingNum[i]];
                this.score[i] = new short[this.mappingNum[i]];
                this.divergence[i] = new byte[this.mappingNum[i]];
                for (j = 0; j < this.mappingNum[i]; ++j) {
                    this.chr[i][j] = dis.readByte();
                    this.strand[i][j] = dis.readByte();
                    this.startPos[i][j] = dis.readInt();
                    this.score[i][j] = dis.readShort();
                    this.divergence[i][j] = dis.readByte();
                }
            }
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("File read from " + infileS);
    }

    private void importSamFile(String fastaFileS, String samFileS, int startIndex) {
        BufferedReader br;
        try {
            br = new BufferedReader(new FileReader(fastaFileS), 65536);
            for (int i = startIndex; i < startIndex + this.tags.length / 2; ++i) {
                if (br.readLine().split("_")[2].startsWith("c")) {
                    this.ifContig[i] = true;
                }
                String seq = br.readLine();
                this.tagLength[i] = (short)seq.length();
                int left = this.tagLength[i] % 32;
                if (left == 0) {
                    this.variableTagLengthInLong[i] = (byte)(this.tagLength[i] / 32);
                } else {
                    this.variableTagLengthInLong[i] = (byte)(this.tagLength[i] / 32 + 1);
                    StringBuilder sb = new StringBuilder();
                    for (int j = 0; j < 32 - left; ++j) {
                        sb.append("A");
                    }
                    seq = seq + sb.toString();
                }
                this.tags[i] = BaseEncoder.getLongArrayFromSeq(seq);
                this.pairIndex[i] = startIndex == 0 ? i + this.tags.length / 2 : i - this.tags.length / 2;
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String temp;
            br = samFileS.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(new File(samFileS))))) : new BufferedReader(new FileReader(new File(samFileS)), 65536);
            ArrayList<String> recordList = new ArrayList<String>();
            while (!(temp = br.readLine()).startsWith("@PG")) {
            }
            temp = br.readLine();
            String[] tem = temp.substring(0, 30).split("\t");
            String currendId = tem[0];
            recordList.add(temp);
            while ((temp = br.readLine()) != null) {
                tem = temp.substring(0, 30).split("\t");
                if (tem[0].equals(currendId)) {
                    recordList.add(temp);
                    continue;
                }
                this.importSAMRecord(recordList.toArray(new String[recordList.size()]), startIndex);
                recordList = new ArrayList();
                recordList.add(temp);
                currendId = tem[0];
            }
            this.importSAMRecord(recordList.toArray(new String[recordList.size()]), startIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("SAM file was imported from " + samFileS);
    }

    private void importSAMRecord(String[] record, int startIndex) {
        int index = Integer.parseInt(record[0].split("_")[0]) + startIndex;
        this.mappingNum[index] = (byte)record.length;
        this.chr[index] = new byte[record.length];
        this.strand[index] = new byte[record.length];
        this.startPos[index] = new int[record.length];
        this.score[index] = new short[record.length];
        this.divergence[index] = new byte[record.length];
        for (int i = 0; i < record.length; ++i) {
            int[] alignSpan;
            String[] temp = record[i].split("\\s");
            int orientiation = Integer.parseInt(temp[1]);
            int chromosome = Integer.MIN_VALUE;
            int stran = -128;
            int sPos = Integer.MIN_VALUE;
            int ePos = Integer.MIN_VALUE;
            int mappingScore = Short.MIN_VALUE;
            int diver = -128;
            if (orientiation == 4) {
                this.mappingNum[index] = 0;
                this.chr[index] = null;
                this.strand[index] = null;
                this.startPos[index] = null;
                this.score[index] = null;
                this.divergence[index] = null;
                continue;
            }
            if (orientiation == 16 || orientiation == 272) {
                chromosome = Integer.parseInt(temp[2]);
                stran = -1;
                alignSpan = SAMUtils.adjustCoordinates(temp[5], Integer.parseInt(temp[3]));
                sPos = alignSpan[1];
                ePos = alignSpan[0];
                mappingScore = Short.parseShort(temp[11].split(":")[2]);
                diver = temp[17].startsWith("NM") ? (int)Byte.parseByte(temp[17].split(":")[2]) : (int)Byte.parseByte(temp[16].split(":")[2]);
            } else {
                chromosome = Integer.parseInt(temp[2]);
                stran = 1;
                alignSpan = SAMUtils.adjustCoordinates(temp[5], Integer.parseInt(temp[3]));
                sPos = alignSpan[0];
                ePos = alignSpan[1];
                mappingScore = Short.parseShort(temp[11].split(":")[2]);
                diver = temp[17].startsWith("NM") ? (int)Byte.parseByte(temp[17].split(":")[2]) : (int)Byte.parseByte(temp[16].split(":")[2]);
            }
            this.chr[index][i] = (byte)chromosome;
            this.strand[index][i] = stran;
            this.startPos[index][i] = sPos;
            this.score[index][i] = mappingScore;
            this.divergence[index][i] = diver;
        }
    }

    private void iniMatrix(int tagNum) {
        this.tags = new long[tagNum][];
        this.variableTagLengthInLong = new byte[tagNum];
        this.tagLength = new short[tagNum];
        this.ifContig = new boolean[tagNum];
        this.pairIndex = new int[tagNum];
        this.mappingNum = new byte[tagNum];
        this.chr = new byte[tagNum][];
        this.strand = new byte[tagNum][];
        this.startPos = new int[tagNum][];
        this.score = new short[tagNum][];
        this.divergence = new byte[tagNum][];
    }

    @Override
    public int getTagSizeInLong() {
        return this.tagLengthInLong;
    }

    public int getVariableTagSizeInLong(int index) {
        return this.variableTagLengthInLong[index];
    }

    @Override
    public String getNullTag() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getTagLength(int index) {
        return this.tagLength[index];
    }

    @Override
    public long[] getTag(int index) {
        return this.tags[index];
    }

    public int getPairIndex(int index) {
        return this.pairIndex[index];
    }

    public int getMappingNum(int index) {
        return this.mappingNum[index];
    }

    public byte getChr(int tagIndex, int mappingIndex) {
        return this.chr[tagIndex][mappingIndex];
    }

    public byte getStrand(int tagIndex, int mappingIndex) {
        return this.strand[tagIndex][mappingIndex];
    }

    public int getStartPos(int tagIndex, int mappingIndex) {
        return this.startPos[tagIndex][mappingIndex];
    }

    public short getScore(int tagIndex, int mappingIndex) {
        return this.score[tagIndex][mappingIndex];
    }

    public byte getDivergence(int tagIndex, int mappingIndex) {
        return this.divergence[tagIndex][mappingIndex];
    }

    @Override
    public int getTagIndex(long[] read2) {
        int first = 0;
        int len = this.tags.length - first;
        int comp = 0;
        while (len > 0) {
            int half = len / 2;
            int middle = first + half;
            comp = this.compareTags(middle, read2);
            if (comp < 0) {
                first = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        if (first < this.tags.length && this.compareTags(first, read2) == 0) {
            return first;
        }
        return -(first + 1);
    }

    private int compareTags(int index, long[] t2) {
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            if (this.tags[index][i] < t2[i]) {
                return -1;
            }
            if (this.tags[index][i] <= t2[i]) continue;
            return 1;
        }
        return 0;
    }

    public int getTagIndexWithLongestSeq(long[] read2) {
        int[] range = this.getTagIndexSet(read2);
        if (range == null) {
            return -1;
        }
        int index = -1;
        int length = -1;
        for (int i = range[0]; i < range[1]; ++i) {
            if (this.getTagLength(i) <= length) continue;
            index = i;
            length = this.getTagLength(i);
        }
        return index;
    }

    @Override
    public int[] getTagIndexSet(long[] read2) {
        int index = this.getTagIndex(read2);
        if (index < 0) {
            return null;
        }
        while (index > 0 && this.compareTags(index - 1, read2) == 0) {
            --index;
        }
        int[] range = new int[2];
        range[0] = index;
        while (index < this.tags.length - 1 && this.compareTags(index + 1, read2) == 0) {
            ++index;
        }
        range[1] = index + 1;
        return range;
    }

    @Override
    public boolean areTagsUnique() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getTagCount() {
        return this.tags.length;
    }

    public void swap(int index1, int index2) {
        long[] tmLong = this.tags[index1];
        this.tags[index1] = this.tags[index2];
        this.tags[index2] = tmLong;
        byte tmByte = this.variableTagLengthInLong[index1];
        this.variableTagLengthInLong[index1] = this.variableTagLengthInLong[index2];
        this.variableTagLengthInLong[index2] = tmByte;
        short tmShort = this.tagLength[index1];
        this.tagLength[index1] = this.tagLength[index2];
        this.tagLength[index2] = tmShort;
        boolean tmBoo = this.ifContig[index1];
        this.ifContig[index1] = this.ifContig[index2];
        this.ifContig[index2] = tmBoo;
        int tmInt1 = this.pairIndex[index1];
        int tmInt2 = this.pairIndex[index2];
        this.pairIndex[this.pairIndex[index1]] = index2;
        this.pairIndex[this.pairIndex[index2]] = index1;
        this.pairIndex[index1] = tmInt2;
        this.pairIndex[index2] = tmInt1;
        tmByte = this.mappingNum[index1];
        this.mappingNum[index1] = this.mappingNum[index2];
        this.mappingNum[index2] = tmByte;
        byte[] tmBytes = this.chr[index1];
        this.chr[index1] = this.chr[index2];
        this.chr[index2] = tmBytes;
        tmBytes = this.strand[index1];
        this.strand[index1] = this.strand[index2];
        this.strand[index2] = tmBytes;
        int[] tmInts = this.startPos[index1];
        this.startPos[index1] = this.startPos[index2];
        this.startPos[index2] = tmInts;
        short[] tmShorts = this.score[index1];
        this.score[index1] = this.score[index2];
        this.score[index2] = tmShorts;
        tmBytes = this.divergence[index1];
        this.divergence[index1] = this.divergence[index2];
        this.divergence[index2] = tmBytes;
    }

    public int compare(int index1, int index2) {
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            if (this.tags[index1][i] < this.tags[index2][i]) {
                return -1;
            }
            if (this.tags[index1][i] <= this.tags[index2][i]) continue;
            return 1;
        }
        return 0;
    }

    public void sort() {
        System.out.println("Position index sort begin.");
        GenericSorting.quickSort((int)0, (int)this.getTagCount(), (IntComparator)this, (Swapper)this);
        System.out.println("Position index sort end.");
    }
}

