/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import ch.systemsx.cisd.hdf5.IHDF5Reader;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Array;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.util.HDF5Utils;

final class PositionHDF5List
implements PositionList {
    private final IHDF5Reader reader;
    private final int numPositions;
    private final Map<Chromosome, ChrOffPos> myChrOffPosTree;
    private final Map<String, Chromosome> myChrNameHash;
    private final int[] chrOffsets;
    private final Chromosome[] chrIndex;
    private final byte[][] alleles;
    private final String genomeVersion;
    public static final int BLOCKSIZE = 65536;
    public static final int blockMask = 65535;
    public static final int siteMask = -65536;
    private LoadingCache<Integer, Position> mySiteList;
    private CacheLoader<Integer, Position> annoPosLoader = new CacheLoader<Integer, Position>(){

        public Position load(Integer key) {
            ArrayList<Integer> toFill = new ArrayList<Integer>();
            toFill.add(key);
            try {
                PositionHDF5List.this.mySiteList.putAll(this.loadAll(toFill));
                return PositionHDF5List.this.get(key);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<Integer, Position> loadAll(Iterable<? extends Integer> keys) throws Exception {
            String[] snpIDs;
            float[] paf;
            float[] maf;
            byte[] anc;
            byte[] ref;
            int key = keys.iterator().next();
            HashMap<Integer, Position> result = new HashMap<Integer, Position>(65536);
            Object afOrder = new byte[2][];
            int startSite = key & 0xFFFF0000;
            int length = PositionHDF5List.this.numPositions - startSite < 65536 ? PositionHDF5List.this.numPositions - startSite : 65536;
            IHDF5Reader iHDF5Reader = PositionHDF5List.this.reader;
            synchronized (iHDF5Reader) {
                afOrder = PositionHDF5List.this.reader.int8().readMatrixBlockWithOffset("Genotypes/_Descriptors/AlleleFreqOrder", 2, length, 0L, (long)startSite);
                ref = HDF5Utils.getHDF5ReferenceAlleles(PositionHDF5List.this.reader, startSite, length);
                anc = HDF5Utils.getHDF5AncestralAlleles(PositionHDF5List.this.reader, startSite, length);
                maf = PositionHDF5List.this.reader.float32().readArrayBlockWithOffset("Genotypes/_Descriptors/MAF", length, (long)startSite);
                paf = PositionHDF5List.this.reader.float32().readArrayBlockWithOffset("Genotypes/_Descriptors/SiteCoverage", length, (long)startSite);
                snpIDs = PositionHDF5List.this.reader.string().readArrayBlockWithOffset("Positions/SnpIds", length, (long)startSite);
            }
            for (int i = 0; i < length; ++i) {
                int site = i + startSite;
                Chromosome chr = PositionHDF5List.this.chromosome(site);
                ChrOffPos cop = (ChrOffPos)PositionHDF5List.this.myChrOffPosTree.get(chr);
                int pos = cop.position[site - cop.startSiteOff];
                GeneralPosition p = new GeneralPosition.Builder(chr, pos).snpName(snpIDs[i]).allele(WHICH_ALLELE.GlobalMajor, afOrder[0][i]).allele(WHICH_ALLELE.GlobalMinor, afOrder[1][i]).allele(WHICH_ALLELE.Reference, ref[i]).allele(WHICH_ALLELE.Ancestral, anc[i]).maf(maf[i]).siteCoverage(paf[i]).build();
                result.put(site, p);
            }
            return result;
        }
    };

    PositionHDF5List(IHDF5Reader reader) {
        this.reader = reader;
        this.genomeVersion = reader.hasAttribute("Positions/", "genomeVersion") ? reader.string().getAttr("Positions/", "genomeVersion") : null;
        int[] variableSites = reader.readIntArray("Positions/Positions");
        this.numPositions = variableSites.length;
        this.alleles = new byte[WHICH_ALLELE.COUNT][];
        String[] lociStrings = reader.readStringArray("Positions/Chromosomes");
        ArrayList<Chromosome> chrs = new ArrayList<Chromosome>();
        for (String ls : lociStrings) {
            chrs.add(new Chromosome(ls));
        }
        int[] locusIndices = reader.readIntArray("Positions/ChromosomeIndices");
        this.myChrOffPosTree = new TreeMap<Chromosome, ChrOffPos>();
        this.myChrNameHash = new HashMap<String, Chromosome>();
        int currStart = 0;
        int currLocusIndex = locusIndices[0];
        this.chrOffsets = new int[chrs.size()];
        this.chrIndex = new Chromosome[chrs.size()];
        int cI = 0;
        for (int i = 0; i < locusIndices.length; ++i) {
            if (i != locusIndices.length - 1 && currLocusIndex == locusIndices[i]) continue;
            int end = i == locusIndices.length - 1 && currLocusIndex == locusIndices[i] ? i : i - 1;
            int endRange = i == locusIndices.length - 1 ? i + 1 : i;
            int[] cPos = Arrays.copyOfRange(variableSites, currStart, endRange);
            Chromosome currChr = (Chromosome)chrs.get(currLocusIndex);
            this.myChrOffPosTree.put(currChr, new ChrOffPos(currStart, end, cPos));
            this.myChrNameHash.put(currChr.getName(), currChr);
            this.chrOffsets[cI] = currStart;
            this.chrIndex[cI] = currChr;
            ++cI;
            if (i == locusIndices.length - 1 && currLocusIndex != locusIndices[i]) {
                currLocusIndex = locusIndices[i];
                currStart = i;
                end = i;
                int[] cPosLast = Arrays.copyOfRange(variableSites, currStart, end);
                Chromosome lastChr = (Chromosome)chrs.get(currLocusIndex);
                this.myChrOffPosTree.put(lastChr, new ChrOffPos(currStart, end, cPosLast));
                this.myChrNameHash.put(lastChr.getName(), lastChr);
                this.chrOffsets[cI] = currStart;
                this.chrIndex[cI] = currChr;
            }
            currStart = i;
            currLocusIndex = locusIndices[i];
        }
        this.mySiteList = CacheBuilder.newBuilder().maximumSize(1000000L).build(this.annoPosLoader);
    }

    private void loadAllele(WHICH_ALLELE alleleType) {
        if (this.alleles[alleleType.index()] == null) {
            switch (alleleType) {
                case Reference: {
                    this.alleles[alleleType.index()] = HDF5Utils.getHDF5ReferenceAlleles(this.reader);
                    break;
                }
                case GlobalMajor: {
                    this.alleles[alleleType.index()] = HDF5Utils.getHDF5Alleles(this.reader, WHICH_ALLELE.Major);
                    break;
                }
                case GlobalMinor: {
                    this.alleles[alleleType.index()] = HDF5Utils.getHDF5Alleles(this.reader, WHICH_ALLELE.Minor);
                    break;
                }
                case Ancestral: {
                    this.alleles[alleleType.index()] = HDF5Utils.getHDF5AncestralAlleles(this.reader);
                    break;
                }
            }
        }
    }

    @Override
    public byte allele(WHICH_ALLELE alleleType, int site) {
        try {
            return ((Position)this.mySiteList.get((Object)site)).getAllele(alleleType);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return 15;
        }
    }

    @Override
    public byte[] alleles(WHICH_ALLELE alleleType, int startSite, int endSite) {
        byte[] result = new byte[endSite - startSite];
        System.arraycopy(this.alleleForAllSites(alleleType), startSite, result, 0, result.length);
        return result;
    }

    @Override
    public byte[] alleleForAllSites(WHICH_ALLELE alleleType) {
        if (this.alleles[alleleType.index()] == null) {
            this.loadAllele(alleleType);
        }
        return this.alleles[alleleType.index()];
    }

    @Override
    public boolean hasReference() {
        return this.genomeVersion != null;
    }

    @Override
    public String siteName(int site) {
        try {
            return ((Position)this.mySiteList.get((Object)site)).getSNPID();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int numberOfSites() {
        return this.numPositions;
    }

    @Override
    public int chromosomeSiteCount(Chromosome chromosome) {
        return this.myChrOffPosTree.get((Object)chromosome).position.length;
    }

    @Override
    public int[] startAndEndOfChromosome(Chromosome chromosome) {
        ChrOffPos cop = this.myChrOffPosTree.get(chromosome);
        if (cop == null) {
            return null;
        }
        return new int[]{cop.startSiteOff, cop.endSiteOff};
    }

    @Override
    public int chromosomalPosition(int site) {
        int i = Arrays.binarySearch(this.chrOffsets, site);
        if (i < 0) {
            i = -(i + 1) - 1;
        }
        Chromosome chr = this.chrIndex[i];
        ChrOffPos cop = this.myChrOffPosTree.get(chr);
        return cop.position[site - cop.startSiteOff];
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome chromosome) {
        int i;
        ChrOffPos cop = this.myChrOffPosTree.get(chromosome);
        if (cop == null) {
            return Integer.MIN_VALUE;
        }
        for (i = Arrays.binarySearch(cop.position, physicalPosition); i > 0 && physicalPosition == cop.position[i - 1]; --i) {
        }
        return i += i < 0 ? -cop.startSiteOff : cop.startSiteOff;
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome chromosome, String snpName) {
        int result = this.siteOfPhysicalPosition(physicalPosition, chromosome);
        if (result < 0) {
            return result;
        }
        if (snpName.equals(this.siteName(result))) {
            return result;
        }
        int index = result;
        while (index < this.numPositions && this.chromosomalPosition(index) == physicalPosition) {
            if (snpName.equals(this.siteName(index))) {
                return index;
            }
            ++result;
        }
        return -result - 1;
    }

    @Override
    public int[] physicalPositions() {
        int[] result = new int[this.numPositions];
        IntBuffer ib = IntBuffer.wrap(result);
        for (ChrOffPos cop : this.myChrOffPosTree.values()) {
            ib.put(cop.position);
        }
        return result;
    }

    @Override
    public String chromosomeName(int site) {
        return this.chromosome(site).getName();
    }

    @Override
    public Chromosome chromosome(int site) {
        int i = Arrays.binarySearch(this.chrOffsets, site);
        if (i < 0) {
            i = -(i + 1) - 1;
        }
        Chromosome chr = this.chrIndex[i];
        return chr;
    }

    @Override
    public Chromosome chromosome(String name) {
        return this.myChrNameHash.get(name);
    }

    @Override
    public Chromosome[] chromosomes() {
        return this.myChrOffPosTree.keySet().toArray(new Chromosome[0]);
    }

    @Override
    public int numChromosomes() {
        return this.myChrOffPosTree.size();
    }

    @Override
    public int[] chromosomesOffsets() {
        int[] result = new int[this.myChrOffPosTree.size()];
        int index = 0;
        for (ChrOffPos cop : this.myChrOffPosTree.values()) {
            result[index++] = cop.startSiteOff;
        }
        return result;
    }

    @Override
    public int indelSize(int site) {
        try {
            return ((Position)this.mySiteList.get((Object)site)).getKnownVariants()[1].length();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public boolean isIndel(int site) {
        try {
            return ((Position)this.mySiteList.get((Object)site)).isIndel();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String genomeVersion() {
        return this.genomeVersion;
    }

    @Override
    public boolean isPositiveStrand(int site) {
        return true;
    }

    @Override
    public int size() {
        return this.numPositions;
    }

    @Override
    public boolean isEmpty() {
        return this.numPositions == 0;
    }

    @Override
    public boolean contains(Object o) {
        Position p;
        int site;
        return o instanceof Position && (site = this.siteOfPhysicalPosition((p = (Position)o).getPosition(), p.getChromosome())) >= 0;
    }

    @Override
    public Iterator<Position> iterator() {
        Iterator<Position> it = new Iterator<Position>(){
            private int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentIndex < PositionHDF5List.this.numPositions;
            }

            @Override
            public Position next() {
                return PositionHDF5List.this.get(this.currentIndex++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This Class is Immutable.");
            }
        };
        return it;
    }

    @Override
    public Object[] toArray() {
        Object[] aps = new Position[this.numPositions];
        for (int i = 0; i < this.numPositions; ++i) {
            aps[i] = this.get(i);
        }
        return aps;
    }

    @Override
    public <Position> Position[] toArray(Position[] a) {
        if (a.length < this.numPositions) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.numPositions);
        } else if (a.length > this.numPositions) {
            a[this.numPositions] = null;
        }
        for (int i = 0; i < this.numPositions; ++i) {
            a[i] = this.get(i);
        }
        return a;
    }

    @Override
    @Deprecated
    public boolean add(Position e) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends Position> c) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    @Deprecated
    public boolean addAll(int index, Collection<? extends Position> c) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public Position get(int index) {
        try {
            return (Position)this.mySiteList.get((Object)index);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Override
    @Deprecated
    public Position set(int index, Position element) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    @Deprecated
    public void add(int index, Position element) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    @Deprecated
    public Position remove(int index) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public int indexOf(Object o) {
        Position p;
        int site;
        if (o instanceof Position && (site = this.siteOfPhysicalPosition((p = (Position)o).getPosition(), p.getChromosome())) >= 0) {
            return site;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public ListIterator<Position> listIterator() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public ListIterator<Position> listIterator(int index) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public List<Position> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private class ChrOffPos {
        final int startSiteOff;
        final int endSiteOff;
        final int[] position;

        private ChrOffPos(int startSiteOff, int endSiteOff, int[] position) {
            this.startSiteOff = startSiteOff;
            this.endSiteOff = endSiteOff;
            this.position = position;
        }
    }
}

