/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import com.google.common.base.Joiner;
import com.google.common.collect.SetMultimap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.genotypecall.AlleleFreqCache;
import net.maizegenetics.dna.snp.io.VCFUtil;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.ExceptionUtils;
import net.maizegenetics.util.FormattedOutput;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.ProgressListener;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ExportUtils {
    private static final Logger myLogger = Logger.getLogger(ExportUtils.class);
    private static FormattedOutput format = FormattedOutput.getInstance();

    private ExportUtils() {
    }

    public static String writeGenotypeHDF5(GenotypeTable a, String newHDF5file) {
        return ExportUtils.writeGenotypeHDF5(a, newHDF5file, null, true);
    }

    public static String writeGenotypeHDF5(GenotypeTable a, String newHDF5file, boolean keepDepth) {
        return ExportUtils.writeGenotypeHDF5(a, newHDF5file, null, keepDepth);
    }

    public static String writeGenotypeHDF5(GenotypeTable a, String newHDF5file, TaxaList exportTaxa, boolean keepDepth) {
        GenotypeTableBuilder aB = GenotypeTableBuilder.getTaxaIncremental(a.positions(), newHDF5file);
        if (exportTaxa != null && exportTaxa.numberOfTaxa() == 0) {
            aB.build();
            return newHDF5file;
        }
        for (int t = 0; t < a.numberOfTaxa(); ++t) {
            if (exportTaxa != null && !exportTaxa.contains(a.taxa().get(t))) continue;
            byte[] bases = a.genotypeAllSites(t);
            if (!a.hasDepth() || !keepDepth) {
                aB.addTaxon((Taxon)a.taxa().get(t), bases, (byte[][])null);
                continue;
            }
            aB.addTaxon((Taxon)a.taxa().get(t), bases, a.depth().valuesForTaxonByte(t));
        }
        aB.build();
        return newHDF5file;
    }

    public static String writeToHapmap(GenotypeTable alignment, String filename) {
        return ExportUtils.writeToHapmap(alignment, false, filename, '\t', null);
    }

    public static String writeToHapmap(GenotypeTable alignment, boolean diploid, String filename, char delimChar, ProgressListener listener) {
        return ExportUtils.writeToHapmap(alignment, diploid, filename, delimChar, true, listener);
    }

    public static String writeToHapmap(GenotypeTable alignment, boolean diploid, String filename, char delimChar, boolean includeTaxaAnnotations, ProgressListener listener) {
        if (delimChar != ' ' && delimChar != '\t') {
            throw new IllegalArgumentException("Delimiter charater must be either a blank space or a tab.");
        }
        BufferedWriter bw = null;
        try {
            String fullFileName = Utils.addSuffixIfNeeded(filename, ".hmp.txt", new String[]{".hmp.txt", ".hmp.txt.gz"});
            bw = Utils.getBufferedWriter(fullFileName);
            if (includeTaxaAnnotations) {
                for (Taxon taxon : alignment.taxa()) {
                    GeneralAnnotation annotation = taxon.getAnnotation();
                    if (annotation == null || annotation.numAnnotations() == 0) continue;
                    bw.write("##SAMPLE=" + taxon.toStringWithVCFAnnotation() + "\n");
                }
            }
            bw.write(Joiner.on((char)delimChar).join((Object)"rs#", (Object)"alleles", new Object[]{"chrom", "pos", "strand", "assembly#", "center", "protLSID", "assayLSID", "panelLSID", "QCcode"}));
            bw.write(delimChar);
            int numTaxa = alignment.numberOfTaxa();
            for (int taxa = 0; taxa < numTaxa; ++taxa) {
                String sequenceID = alignment.taxaName(taxa).trim();
                bw.write(sequenceID);
                if (taxa == numTaxa - 1) continue;
                bw.write(delimChar);
            }
            bw.write("\n");
            int numSites = alignment.numberOfSites();
            for (int site = 0; site < numSites; ++site) {
                bw.write(alignment.siteName(site));
                bw.write(delimChar);
                byte[] genotypes = alignment.genotypeAllTaxa(site);
                int[][] sortedAlleles = AlleleFreqCache.allelesSortedByFrequencyNucleotide(genotypes);
                int numAlleles = sortedAlleles[0].length;
                if (numAlleles == 0) {
                    bw.write("NA");
                } else if (numAlleles == 1) {
                    bw.write(alignment.genotypeAsString(site, (byte)sortedAlleles[0][0]));
                } else {
                    bw.write(alignment.genotypeAsString(site, (byte)sortedAlleles[0][0]));
                    for (int allele = 1; allele < sortedAlleles[0].length; ++allele) {
                        if (sortedAlleles[0][allele] == 15) continue;
                        bw.write(47);
                        bw.write(alignment.genotypeAsString(site, (byte)sortedAlleles[0][allele]));
                    }
                }
                bw.write(delimChar);
                bw.write(Joiner.on((char)delimChar).join((Object)alignment.chromosomeName(site), (Object)String.valueOf(alignment.chromosomalPosition(site)), new Object[]{"+", "NA", "NA", "NA", "NA", "NA", "NA"}));
                bw.write(delimChar);
                for (int taxa = 0; taxa < numTaxa; ++taxa) {
                    if (!diploid) {
                        String baseIUPAC = null;
                        try {
                            baseIUPAC = alignment.diploidAsString(site, genotypes[taxa]);
                        }
                        catch (Exception e) {
                            String[] b = alignment.genotypeAsStringArray(taxa, site);
                            bw.close();
                            myLogger.debug((Object)e.getMessage(), (Throwable)e);
                            throw new IllegalArgumentException("There is no String representation for diploid values: " + b[0] + ":" + b[1] + " getBase(): 0x" + Integer.toHexString(alignment.genotype(taxa, site)) + "\nTry Exporting as Diploid Values.");
                        }
                        if (baseIUPAC == null || baseIUPAC.equals("?")) {
                            String[] b = alignment.genotypeAsStringArray(taxa, site);
                            bw.close();
                            throw new IllegalArgumentException("There is no String representation for diploid values: " + b[0] + ":" + b[1] + " getBase(): 0x" + Integer.toHexString(alignment.genotype(taxa, site)) + "\nTry Exporting as Diploid Values.");
                        }
                        bw.write(baseIUPAC);
                    } else {
                        byte[] temp = GenotypeTableUtils.getDiploidValues(genotypes[taxa]);
                        bw.write(alignment.genotypeAsString(site, temp[0]));
                        bw.write(alignment.genotypeAsString(site, temp[1]));
                    }
                    if (taxa == numTaxa - 1) continue;
                    bw.write(delimChar);
                }
                bw.write("\n");
                if (listener == null) continue;
                listener.progress((int)((double)(site + 1) / (double)numSites * 100.0), null);
            }
            String string = fullFileName;
            return string;
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("Error writing Hapmap file: " + filename + ": " + ExceptionUtils.getExceptionCauses(e));
        }
        finally {
            try {
                bw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String writeToVCF(GenotypeTable gt, String filename, boolean keepDepth) {
        return ExportUtils.writeToVCF(gt, filename, keepDepth, null);
    }

    public static String writeToVCF(GenotypeTable gt, String filename, boolean keepDepth, ProgressListener listener) {
        int delimChar = 9;
        boolean hasDepth = gt.hasDepth() && keepDepth;
        try {
            filename = Utils.addSuffixIfNeeded(filename, ".vcf", new String[]{".vcf", ".vcf.gz"});
            BufferedWriter bw = Utils.getBufferedWriter(filename);
            bw.write("##fileformat=VCFv4.0");
            bw.newLine();
            if (!gt.hasReference()) {
                bw.write("##Tassel=<ID=GenotypeTable,Version=5,Description=\"Reference allele is not known. The major allele was used as reference allele\">");
                bw.newLine();
            }
            bw.write("##FORMAT=<ID=GT,Number=1,Type=String,Description=\"Genotype\">");
            bw.newLine();
            bw.write("##FORMAT=<ID=AD,Number=.,Type=Integer,Description=\"Allelic depths for the reference and alternate alleles in the order listed\">");
            bw.newLine();
            bw.write("##FORMAT=<ID=DP,Number=1,Type=Integer,Description=\"Read Depth (only filtered reads used for calling)\">");
            bw.newLine();
            bw.write("##FORMAT=<ID=GQ,Number=1,Type=Float,Description=\"Genotype Quality\">");
            bw.newLine();
            bw.write("##FORMAT=<ID=PL,Number=.,Type=Float,Description=\"Normalized, Phred-scaled likelihoods for AA,AB,BB genotypes where A=ref and B=alt; not applicable if site is not biallelic\">");
            bw.newLine();
            bw.write("##INFO=<ID=NS,Number=1,Type=Integer,Description=\"Number of Samples With Data\">");
            bw.newLine();
            bw.write("##INFO=<ID=DP,Number=1,Type=Integer,Description=\"Total Depth\">");
            bw.newLine();
            bw.write("##INFO=<ID=AF,Number=.,Type=Float,Description=\"Allele Frequency\">");
            bw.newLine();
            ExportUtils.writeVCFSampleAnnotationToWriter(gt, bw);
            bw.write("#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT");
            for (int taxa = 0; taxa < gt.numberOfTaxa(); ++taxa) {
                String taxonName = gt.taxaName(taxa).trim();
                bw.write('\t' + taxonName);
            }
            bw.newLine();
            int noAlleles = 0;
            for (int site = 0; site < gt.numberOfSites(); ++site) {
                int numSites = gt.numberOfSites();
                Position p = (Position)gt.positions().get(site);
                String[] knownVariants = p.getKnownVariants();
                byte refAllele = p.getAllele(WHICH_ALLELE.Reference);
                int[] sortedAlleles = gt.allelesSortedByFrequency(site)[0];
                int[] sortedAllelesTemp = VCFUtil.resolveRefSorted(sortedAlleles, refAllele);
                sortedAlleles = sortedAllelesTemp;
                if (knownVariants.length > 0) {
                    int i;
                    ArrayList<Integer> tempSortedAlleles = new ArrayList<Integer>();
                    boolean knownVariantIndel = VCFUtil.indelInKnownVariant(knownVariants);
                    if (knownVariantIndel) {
                        for (int i2 = 0; i2 < knownVariants.length; ++i2) {
                            if (knownVariants[i2].length() > 1) {
                                String parsedVariant = knownVariants[i2].substring(1);
                                tempSortedAlleles.add(Integer.valueOf(NucleotideAlignmentConstants.getNucleotideAlleleByte(parsedVariant.charAt(0))));
                                continue;
                            }
                            tempSortedAlleles.add(Integer.valueOf(NucleotideAlignmentConstants.getNucleotideAlleleByte('-')));
                        }
                    } else {
                        if (sortedAlleles.length < knownVariants.length) {
                            tempSortedAlleles = new ArrayList();
                        }
                        int nIndex = -1;
                        for (int i3 = 0; i3 < knownVariants.length; ++i3) {
                            if (knownVariants[i3].charAt(0) != 'N') {
                                tempSortedAlleles.add(Integer.valueOf(NucleotideAlignmentConstants.getNucleotideAlleleByte(knownVariants[i3].charAt(0))));
                                continue;
                            }
                            nIndex = i3;
                        }
                        if (nIndex != -1) {
                            String[] knownVariantsSmall = new String[knownVariants.length - 1];
                            for (int i4 = 0; i4 < knownVariants.length; ++i4) {
                                if (i4 < nIndex) {
                                    knownVariantsSmall[i4] = knownVariants[i4];
                                    continue;
                                }
                                if (i4 <= nIndex) continue;
                                knownVariantsSmall[i4 - 1] = knownVariants[i4];
                            }
                            knownVariants = knownVariantsSmall;
                        }
                    }
                    ArrayList<String> knownVariantsList = new ArrayList<String>();
                    boolean indelsExist = false;
                    boolean indelsInKnownVariants = VCFUtil.indelInKnownVariant(knownVariants);
                    if (indelsInKnownVariants) {
                        indelsExist = true;
                    }
                    for (int i5 = 0; i5 < sortedAlleles.length; ++i5) {
                        if (!NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[i5]).equals("-")) continue;
                        indelsExist = true;
                    }
                    for (String variant : knownVariants) {
                        if (indelsExist && !indelsInKnownVariants) {
                            knownVariantsList.add("N" + variant);
                            continue;
                        }
                        knownVariantsList.add(variant);
                    }
                    ArrayList<Integer> sortedAllelesList = new ArrayList<Integer>();
                    HashMap<Integer, String> sortedAlleleKnownVariantMap = new HashMap<Integer, String>();
                    for (i = 0; i < sortedAlleles.length; ++i) {
                        sortedAllelesList.add(sortedAlleles[i]);
                        if (!tempSortedAlleles.contains(sortedAlleles[i])) {
                            if (indelsExist) {
                                if (NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[i]).equals("-")) {
                                    sortedAlleleKnownVariantMap.put(sortedAlleles[i], "N");
                                    continue;
                                }
                                sortedAlleleKnownVariantMap.put(sortedAlleles[i], NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[i]));
                                continue;
                            }
                            sortedAlleleKnownVariantMap.put(sortedAlleles[i], NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[i]));
                            continue;
                        }
                        int variantIndex = tempSortedAlleles.indexOf(sortedAlleles[i]);
                        sortedAlleleKnownVariantMap.put(sortedAlleles[i], knownVariants[variantIndex]);
                    }
                    for (i = 0; i < tempSortedAlleles.size(); ++i) {
                        if (sortedAllelesList.contains(tempSortedAlleles.get(i))) continue;
                        sortedAllelesList.add((Integer)tempSortedAlleles.get(i));
                        sortedAlleleKnownVariantMap.put((Integer)tempSortedAlleles.get(i), (String)knownVariantsList.get(i));
                    }
                    int[] sortedAllelesExtended = new int[sortedAllelesList.size()];
                    for (int i6 = 0; i6 < sortedAllelesExtended.length; ++i6) {
                        sortedAllelesExtended[i6] = (Integer)sortedAllelesList.get(i6);
                    }
                    sortedAlleles = sortedAllelesExtended;
                    String[] knownVariantsExtended = new String[sortedAllelesList.size()];
                    for (int i7 = 0; i7 < knownVariantsExtended.length; ++i7) {
                        knownVariantsExtended[i7] = (String)sortedAlleleKnownVariantMap.get(sortedAllelesList.get(i7));
                    }
                    knownVariants = knownVariantsExtended;
                } else {
                    int i;
                    int indelIndex = -1;
                    for (i = 0; i < sortedAlleles.length; ++i) {
                        if (sortedAlleles[i] != NucleotideAlignmentConstants.getNucleotideAlleleByte('-')) continue;
                        indelIndex = i;
                        break;
                    }
                    knownVariants = new String[sortedAlleles.length];
                    for (i = 0; i < knownVariants.length; ++i) {
                        knownVariants[i] = indelIndex == -1 ? "" + NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[i]) : (indelIndex == i ? "N" : "N" + NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[i]));
                    }
                }
                int nAlleles = sortedAlleles.length;
                HashMap<String, Integer> alleleRedirectMap = new HashMap<String, Integer>();
                Object[] alleleRedirect = new String[16];
                Arrays.fill(alleleRedirect, ".");
                for (int i = 0; i < sortedAlleles.length; ++i) {
                    alleleRedirect[sortedAlleles[i]] = "" + i;
                    alleleRedirectMap.put(NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[i]), i);
                }
                bw.write(gt.chromosomeName(site));
                bw.write(9);
                bw.write(gt.chromosomalPosition(site) + "");
                bw.write(9);
                bw.write(gt.siteName(site));
                bw.write(9);
                if (nAlleles == 0) {
                    ++noAlleles;
                    bw.write(".\t.\t.\tPASS\t.\tGT");
                    for (int taxa = 0; taxa < gt.numberOfTaxa(); ++taxa) {
                        bw.write("\t./.");
                    }
                    bw.newLine();
                    continue;
                }
                if (knownVariants.length == 0) {
                    bw.write(NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[0]));
                } else {
                    bw.write(knownVariants[0]);
                }
                bw.write(9);
                StringBuilder altAllelesBuilder = new StringBuilder("");
                String altString = "";
                int indelIndex = -1;
                if (knownVariants.length == 0 || knownVariants.length < sortedAlleles.length) {
                    ArrayList<String> altAlleles = new ArrayList<String>();
                    for (int aa = 1; aa < sortedAlleles.length; ++aa) {
                        if (NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[aa]) != "-") {
                            altAlleles.add(NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[aa]));
                            continue;
                        }
                        indelIndex = aa;
                    }
                    altString = altAlleles.stream().collect(Collectors.joining(","));
                } else {
                    altString = Arrays.stream(knownVariants, 1, knownVariants.length).collect(Collectors.joining(","));
                }
                if (altString.length() == 0) {
                    altString = ".";
                }
                bw.write(altString);
                bw.write(9);
                bw.write(".");
                bw.write(9);
                bw.write("PASS");
                bw.write(9);
                GeneralAnnotation ga = p.getAnnotation();
                String annotationHolder = ga.getAnnotationKeys().stream().sorted().filter(k -> !k.equals("VARIANT")).filter(k -> !k.equals("DP") || !hasDepth).map(key -> {
                    String[] annos = ga.getTextAnnotation((String)key);
                    if (annos[0].equals("TRUE")) {
                        return key;
                    }
                    return key + Arrays.stream(annos).collect(Collectors.joining(",", "=", ""));
                }).collect(Collectors.joining(";"));
                if (hasDepth) {
                    annotationHolder = annotationHolder.equals("") ? annotationHolder + "DP=" + gt.depth().depthForSite(site) : (annotationHolder.equals(".") ? "DP=" + gt.depth().depthForSite(site) : annotationHolder + ";DP=" + gt.depth().depthForSite(site));
                }
                if (!annotationHolder.equals("")) {
                    bw.write(annotationHolder);
                } else {
                    bw.write(".");
                }
                bw.write(9);
                if (hasDepth) {
                    bw.write("GT:AD:DP:GQ:PL");
                } else {
                    bw.write("GT");
                }
                for (int taxa = 0; taxa < gt.numberOfTaxa(); ++taxa) {
                    bw.write(9);
                    byte[] values = gt.genotypeArray(taxa, site);
                    if (knownVariants.length > 0) {
                        bw.write((String)alleleRedirect[values[0]] + "/" + (String)alleleRedirect[values[1]]);
                    } else {
                        if (NucleotideAlignmentConstants.getHaplotypeNucleotide(values[0]).equals("-")) {
                            bw.write(".");
                        } else if (((String)alleleRedirect[values[0]]).equals(".")) {
                            bw.write((String)alleleRedirect[values[0]]);
                        } else if (indelIndex != -1 && Integer.parseInt((String)alleleRedirect[values[0]]) > indelIndex) {
                            bw.write("" + (Integer.parseInt((String)alleleRedirect[values[0]]) - 1));
                        } else {
                            bw.write((String)alleleRedirect[values[0]]);
                        }
                        bw.write("/");
                        if (NucleotideAlignmentConstants.getHaplotypeNucleotide(values[1]).equals("-")) {
                            bw.write(".");
                        } else if (((String)alleleRedirect[values[1]]).equals(".")) {
                            bw.write((String)alleleRedirect[values[1]]);
                        } else if (indelIndex != -1 && Integer.parseInt((String)alleleRedirect[values[1]]) > indelIndex) {
                            bw.write("" + (Integer.parseInt((String)alleleRedirect[values[1]]) - 1));
                        } else {
                            bw.write((String)alleleRedirect[values[1]]);
                        }
                    }
                    if (!hasDepth) continue;
                    bw.write(":");
                    int[] siteAlleleDepths = gt.depthForAlleles(taxa, site);
                    int siteTotalDepth = 0;
                    ArrayList<Integer> depthsList = new ArrayList<Integer>();
                    for (int ss = 0; ss < sortedAlleles.length; ++ss) {
                        if (ss == indelIndex || sortedAlleles[ss] >= siteAlleleDepths.length) continue;
                        try {
                            depthsList.add(siteAlleleDepths[sortedAlleles[ss]]);
                            siteTotalDepth += siteAlleleDepths[sortedAlleles[ss]];
                            continue;
                        }
                        catch (Exception e) {
                            System.out.println(Arrays.toString(alleleRedirect));
                            System.out.println(altString);
                            System.out.println(Arrays.toString(siteAlleleDepths));
                            System.out.println(Arrays.toString(sortedAlleles));
                            System.out.println(ss);
                            throw e;
                        }
                    }
                    bw.write(depthsList.stream().map(depth -> "" + depth).collect(Collectors.joining(",")));
                    bw.write(":");
                    bw.write(siteTotalDepth + "");
                    int[] scores = new int[]{-1, -1, -1, -1};
                    if (values[0] == 15) continue;
                    int altDepth = sortedAlleles.length < 2 || sortedAlleles[1] >= siteAlleleDepths.length ? 0 : siteAlleleDepths[sortedAlleles[1]];
                    int n = altDepth = altDepth < 0 ? 0 : altDepth;
                    if (siteAlleleDepths[sortedAlleles[0]] < 0 || altDepth < 0) continue;
                    scores = VCFUtil.getScore(siteAlleleDepths[sortedAlleles[0]], altDepth);
                    bw.write(":");
                    bw.write(scores[3] + "");
                    bw.write(":");
                    int k2 = sortedAlleles.length - 1;
                    int[] fullPL = new int[k2 * (k2 + 1) / 2 + k2 + 1];
                    Arrays.fill(fullPL, 255);
                    if (fullPL.length == 1) {
                        fullPL[0] = scores[0];
                    } else {
                        fullPL[0] = scores[0];
                        fullPL[1] = scores[1];
                        fullPL[2] = scores[2];
                    }
                    for (int i = 0; i < fullPL.length - 1; ++i) {
                        bw.write(fullPL[i] + ",");
                    }
                    bw.write("" + fullPL[fullPL.length - 1]);
                }
                bw.newLine();
                if (listener == null) continue;
                listener.progress((int)((double)(site + 1) / (double)numSites * 100.0), null);
            }
            if (noAlleles > 0) {
                myLogger.warn((Object)("Warning: " + noAlleles + " sites have no alleles."));
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error writing VCF file: " + filename + ": " + ExceptionUtils.getExceptionCauses(e));
        }
        return filename;
    }

    private static void writeVCFSampleAnnotationToWriter(GenotypeTable gt, BufferedWriter bw) throws IOException {
        for (Taxon taxon : gt.taxa()) {
            GeneralAnnotation annotation = taxon.getAnnotation();
            if (annotation == null || annotation.numAnnotations() == 0) continue;
            SetMultimap<String, String> annoMap = taxon.getAnnotation().getAnnotationAsMap();
            String annoString = Joiner.on((char)',').withKeyValueSeparator("=").join((Iterable)annoMap.entries());
            bw.write("##SAMPLE=<ID=" + taxon.getName() + "," + annoString + ">");
            bw.newLine();
        }
    }

    public static String writeToPlink(GenotypeTable alignment, String filename, char delimChar) {
        if (delimChar != ' ' && delimChar != '\t') {
            throw new IllegalArgumentException("Delimiter charater must be either a blank space or a tab.");
        }
        BufferedWriter MAPbw = null;
        BufferedWriter PEDbw = null;
        String mapFileName = Utils.addSuffixIfNeeded(filename, ".plk.map");
        String pedFileName = Utils.addSuffixIfNeeded(filename, ".plk.ped");
        try {
            MAPbw = new BufferedWriter(new FileWriter(mapFileName), 1000000);
            int numSites = alignment.numberOfSites();
            for (int site = 0; site < numSites; ++site) {
                MAPbw.write(alignment.chromosomeName(site));
                MAPbw.write(delimChar);
                MAPbw.write(alignment.siteName(site));
                MAPbw.write(delimChar);
                MAPbw.write("-9");
                MAPbw.write(delimChar);
                MAPbw.write(Integer.toString(alignment.chromosomalPosition(site)));
                MAPbw.write("\n");
            }
            MAPbw.close();
            PEDbw = new BufferedWriter(new FileWriter(pedFileName), 1000000);
            Pattern splitter = Pattern.compile(":");
            int numTaxa = alignment.numberOfTaxa();
            for (int taxa = 0; taxa < numTaxa; ++taxa) {
                String[] name = splitter.split(alignment.taxaName(taxa).trim());
                if (name.length != 1) {
                    PEDbw.write(name[1]);
                } else {
                    PEDbw.write("-9");
                }
                PEDbw.write(delimChar);
                PEDbw.write(alignment.taxaName(taxa).trim());
                PEDbw.write(delimChar);
                PEDbw.write("-9");
                PEDbw.write(delimChar);
                PEDbw.write("-9");
                PEDbw.write(delimChar);
                PEDbw.write("-9");
                PEDbw.write(delimChar);
                PEDbw.write("-9");
                PEDbw.write(delimChar);
                for (int site = 0; site < numSites; ++site) {
                    String[] b = ExportUtils.getSNPValueForPlink(alignment.genotypeAsStringArray(taxa, site));
                    PEDbw.write(b[0]);
                    PEDbw.write(delimChar);
                    PEDbw.write(b[b.length - 1]);
                    if (site == numSites - 1) continue;
                    PEDbw.write(delimChar);
                }
                PEDbw.write("\n");
            }
            PEDbw.close();
            String string = mapFileName + " and " + pedFileName;
            return string;
        }
        catch (Exception e) {
            myLogger.error((Object)("Error writing Plink files: " + mapFileName + " and " + pedFileName + ": " + ExceptionUtils.getExceptionCauses(e)));
            throw new IllegalArgumentException("Error writing Plink files: " + mapFileName + " and " + pedFileName + ": " + ExceptionUtils.getExceptionCauses(e));
        }
        finally {
            try {
                PEDbw.close();
            }
            catch (Exception exception) {}
            try {
                MAPbw.close();
            }
            catch (Exception exception) {}
        }
    }

    private static String[] getSNPValueForPlink(String[] base) {
        for (int i = 0; i < base.length; ++i) {
            if (base[i].equals("N")) {
                base[i] = "0";
                continue;
            }
            if (!base[i].equals("0")) continue;
            base[i] = "D";
        }
        return base;
    }

    public static String saveDelimitedAlignment(GenotypeTable theAlignment, String delimit, String saveFile) {
        if (saveFile == null || saveFile.length() == 0) {
            return null;
        }
        saveFile = Utils.addSuffixIfNeeded(saveFile, ".txt");
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(new File(saveFile));
            bw = new BufferedWriter(fw);
            bw.write("Taxa");
            int numSites = theAlignment.numberOfSites();
            for (int j = 0; j < numSites; ++j) {
                bw.write(delimit);
                bw.write(String.valueOf(theAlignment.chromosomalPosition(j)));
            }
            bw.write("\n");
            int n = theAlignment.numberOfTaxa();
            for (int r = 0; r < n; ++r) {
                bw.write(theAlignment.taxaName(r));
                for (int i = 0; i < numSites; ++i) {
                    bw.write(delimit);
                    bw.write(theAlignment.genotypeAsString(r, i));
                }
                bw.write("\n");
            }
            String string = saveFile;
            return string;
        }
        catch (Exception e) {
            myLogger.error((Object)("Error writing Delimited Alignment: " + saveFile + ": " + ExceptionUtils.getExceptionCauses(e)));
            throw new IllegalArgumentException("Error writing Delimited Alignment: " + saveFile + ": " + ExceptionUtils.getExceptionCauses(e));
        }
        finally {
            try {
                bw.close();
                fw.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void printSequential(GenotypeTable a, Writer out) throws IOException {
        out.write("  " + a.numberOfTaxa() + " " + a.numberOfSites() + "  S\n");
        for (int s = 0; s < a.numberOfTaxa(); ++s) {
            for (int n = 0; n < a.numberOfSites(); n += 50) {
                if (n == 0) {
                    format.displayLabel(out, a.taxaName(s), 10);
                    out.write("     ");
                } else {
                    out.write("               ");
                }
                ExportUtils.printNextSites(a, out, false, s, n, 50);
                out.write("\n");
            }
        }
    }

    public static void printInterleaved(GenotypeTable a, Writer out) throws IOException {
        out.write("  " + a.numberOfTaxa() + " " + a.numberOfSites() + "\n");
        for (int n = 0; n < a.numberOfSites(); n += 50) {
            for (int s = 0; s < a.numberOfTaxa(); ++s) {
                if (n == 0) {
                    format.displayLabel(out, a.taxaName(s), 10);
                    out.write("     ");
                } else {
                    out.write("               ");
                }
                ExportUtils.printNextSites(a, out, true, s, n, 50);
                out.write("\n");
            }
            out.write("\n");
        }
    }

    public static void printCLUSTALW(GenotypeTable a, Writer out) throws IOException {
        out.write("CLUSTAL W multiple sequence alignment\n\n");
        for (int n = 0; n < a.numberOfSites(); n += 50) {
            out.write("\n");
            for (int s = 0; s < a.numberOfTaxa(); ++s) {
                format.displayLabel(out, a.taxaName(s), 10);
                out.write("     ");
                ExportUtils.printNextSites(a, out, false, s, n, 50);
                out.write("\n");
            }
            out.write("               \n");
        }
    }

    private static void printNextSites(GenotypeTable a, Writer out, boolean chunked, int seq, int start, int num) throws IOException {
        for (int i = 0; i < num && start + i < a.numberOfSites(); ++i) {
            if (i % 10 == 0 && i != 0 && chunked) {
                out.write(32);
            }
            out.write(a.genotypeAsString(seq, start + i));
        }
    }

    public static String writeAlignmentToSerialGZ(GenotypeTable sba, String outFile) {
        long time = System.currentTimeMillis();
        File theFile = null;
        FileOutputStream fos = null;
        DeflaterOutputStream gz = null;
        ObjectOutputStream oos = null;
        try {
            theFile = new File(Utils.addSuffixIfNeeded(outFile, ".serial.gz"));
            fos = new FileOutputStream(theFile);
            gz = new GZIPOutputStream(fos);
            oos = new ObjectOutputStream(gz);
            oos.writeObject(sba);
            String string = theFile.getName();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            myLogger.error((Object)("Error writing Serial GZ: " + theFile.getName() + ": " + ExceptionUtils.getExceptionCauses(e)));
            throw new IllegalArgumentException("Error writing Serial GZ: " + theFile.getName() + ": " + ExceptionUtils.getExceptionCauses(e));
        }
        finally {
            try {
                oos.flush();
                oos.close();
                gz.close();
                fos.close();
            }
            catch (Exception exception) {}
            myLogger.info((Object)("writeAlignmentToSerialGZ: " + theFile.toString() + "  Time: " + (System.currentTimeMillis() - time)));
        }
    }

    public static void writeFasta(GenotypeTable gt, Writer out) {
        try {
            TaxaList tl = gt.taxa();
            for (int i = 0; i < tl.size(); ++i) {
                out.write(">");
                out.write(((Taxon)tl.get(i)).getName());
                out.write("\n");
                for (int j = 0; j < gt.positions().size(); ++j) {
                    byte call = gt.genotype(i, j);
                    out.write(NucleotideAlignmentConstants.getNucleotideIUPAC(call));
                }
                out.write("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            myLogger.error((Object)("Error writing FASTA file: " + ExceptionUtils.getExceptionCauses(e)));
            throw new IllegalArgumentException("Error writing FastaAlignment: " + ExceptionUtils.getExceptionCauses(e));
        }
    }

    public static void writeFastaNoGaps(GenotypeTable gt, Writer out) {
        try {
            TaxaList tl = gt.taxa();
            for (int i = 0; i < tl.size(); ++i) {
                out.write(">");
                out.write(((Taxon)tl.get(i)).getName());
                out.write("\n");
                for (int j = 0; j < gt.positions().size(); ++j) {
                    byte call = gt.genotype(i, j);
                    if (NucleotideAlignmentConstants.getNucleotideIUPAC(call).equals("-")) continue;
                    out.write(NucleotideAlignmentConstants.getNucleotideIUPAC(call));
                }
                out.write("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            myLogger.error((Object)("Error writing FASTA file: " + ExceptionUtils.getExceptionCauses(e)));
            throw new IllegalArgumentException("Error writing FastaAlignment: " + ExceptionUtils.getExceptionCauses(e));
        }
    }
}

