/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.Filter;

public final class FilterSite
implements Filter {
    private final Map<FILTER_SITES_ATTRIBUTES, Object> myAttributes = new LinkedHashMap<FILTER_SITES_ATTRIBUTES, Object>();

    public FilterSite(Map<String, Object> values) {
        for (Map.Entry<String, Object> current : values.entrySet()) {
            if (current.getValue() == null || current.getValue() instanceof String && ((String)current.getValue()).isEmpty()) continue;
            FILTER_SITES_ATTRIBUTES attribute = FILTER_SITES_ATTRIBUTES.valueOf(current.getKey());
            this.myAttributes.put(attribute, current.getValue());
        }
        if (this.filterName() == null || this.filterName().length() == 0) {
            this.myAttributes.put(FILTER_SITES_ATTRIBUTES.filterName, "Filter");
        }
        if (this.siteFilterType() == SITE_RANGE_FILTER_TYPES.SITES) {
            System.out.println("startSite: " + this.startSite() + "  endSite: " + this.endSite());
            if (this.startSite() == -1 || this.endSite() == -1) {
                throw new IllegalArgumentException("Filter: init: both start site and end site must be specified.");
            }
            if (this.startSite() > this.endSite()) {
                throw new IllegalArgumentException("Filter: init: start site can't be larger than end site.");
            }
        }
        if (this.siteFilterType() == SITE_RANGE_FILTER_TYPES.POSITIONS && (this.startChr() == null || this.endChr() == null)) {
            throw new IllegalArgumentException("Filter: init: start chr and end chr must be specified.");
        }
        if (this.siteMinCount() < 0) {
            throw new IllegalArgumentException("Filter: init: site min count can't be less than zero.");
        }
        if (this.siteMinAlleleFreq() < 0.0 || this.siteMinAlleleFreq() > 1.0) {
            throw new IllegalArgumentException("Filter: init: site min allele freq must be between 0.0 and 1.0");
        }
        if (this.siteMaxAlleleFreq() < 0.0 || this.siteMaxAlleleFreq() > 1.0) {
            throw new IllegalArgumentException("Filter: init: site max allele freq must be between 0.0 and 1.0");
        }
    }

    public Map<FILTER_SITES_ATTRIBUTES, Object> attributes() {
        return Collections.unmodifiableMap(this.myAttributes);
    }

    @Override
    public int numAttributes() {
        return this.myAttributes.size();
    }

    public String filterName() {
        return (String)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.filterName);
    }

    public int siteMinCount() {
        Integer value = (Integer)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.siteMinCount);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public double siteMinAlleleFreq() {
        Double value = (Double)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.siteMinAlleleFreq);
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public double siteMaxAlleleFreq() {
        Double value = (Double)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.siteMaxAlleleFreq);
        if (value == null) {
            return 1.0;
        }
        return value;
    }

    public double minHeterozygous() {
        Double value = (Double)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.minHeterozygous);
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public double maxHeterozygous() {
        Double value = (Double)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.maxHeterozygous);
        if (value == null) {
            return 1.0;
        }
        return value;
    }

    public boolean removeMinorSNPStates() {
        Boolean value = (Boolean)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.removeMinorSNPStates);
        if (value == null) {
            return false;
        }
        return value;
    }

    public boolean removeSitesWithIndels() {
        Boolean value = (Boolean)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.removeSitesWithIndels);
        if (value == null) {
            return false;
        }
        return value;
    }

    public SITE_RANGE_FILTER_TYPES siteFilterType() {
        SITE_RANGE_FILTER_TYPES value = (SITE_RANGE_FILTER_TYPES)((Object)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.siteRangeFilterType));
        if (value == null) {
            return SITE_RANGE_FILTER_TYPES.NONE;
        }
        return value;
    }

    public int startSite() {
        Integer value = (Integer)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.startSite);
        if (value == null) {
            System.out.println("start site is null");
            return -1;
        }
        return value;
    }

    public int endSite() {
        Integer value = (Integer)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.endSite);
        if (value == null) {
            return -1;
        }
        return value;
    }

    public Chromosome startChr() {
        Chromosome value = (Chromosome)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.startChr);
        if (value == null) {
            return null;
        }
        return value;
    }

    public int startPos() {
        Integer value = (Integer)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.startPos);
        if (value == null) {
            return -1;
        }
        return value;
    }

    public Chromosome endChr() {
        Chromosome value = (Chromosome)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.endChr);
        if (value == null) {
            return null;
        }
        return value;
    }

    public int endPos() {
        Integer value = (Integer)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.endPos);
        if (value == null) {
            return -1;
        }
        return value;
    }

    public boolean includeSites() {
        Boolean value = (Boolean)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.includeSites);
        if (value == null) {
            return true;
        }
        return value;
    }

    public List<String> siteNames() {
        List value = (List)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.siteNames);
        if (value == null) {
            return null;
        }
        return Collections.unmodifiableList(value);
    }

    public String chrPosFile() {
        return (String)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.chrPosFile);
    }

    public PositionList positionList() {
        return (PositionList)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.positionList);
    }

    public String bedFile() {
        return (String)this.myAttributes.get((Object)FILTER_SITES_ATTRIBUTES.bedFile);
    }

    public static enum SITE_RANGE_FILTER_TYPES {
        NONE,
        SITES,
        POSITIONS;

    }

    public static enum FILTER_SITES_ATTRIBUTES {
        filterName,
        siteMinCount,
        siteMinAlleleFreq,
        siteMaxAlleleFreq,
        siteRangeFilterType,
        startSite,
        endSite,
        startChr,
        startPos,
        endChr,
        endPos,
        includeSites,
        siteNames,
        chrPosFile,
        positionList,
        removeMinorSNPStates,
        removeSitesWithIndels,
        bedFile,
        minHeterozygous,
        maxHeterozygous;

    }
}

