/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.io.BufferedReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.genotypecall.AlleleFreqCache;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class GenotypeTableUtils {
    private static final Logger myLogger = Logger.getLogger(GenotypeTableUtils.class);
    private static final Integer ONE = 1;
    private static final byte HIGHMASK = 15;

    private GenotypeTableUtils() {
    }

    public static int[][] getAllelesSortedByFrequency(byte[] data) {
        int[] stateCnt = new int[16];
        for (int i = 0; i < data.length; ++i) {
            byte first = (byte)(data[i] >>> 4 & 0xF);
            byte second = (byte)(data[i] & 0xF);
            if (first < 14) {
                byte by = first;
                stateCnt[by] = stateCnt[by] + 1;
            }
            if (second >= 14) continue;
            byte by = second;
            stateCnt[by] = stateCnt[by] + 1;
        }
        int count = 0;
        for (int j = 0; j < 16; ++j) {
            if (stateCnt[j] == 0) continue;
            ++count;
        }
        int[][] result = new int[2][count];
        int index = 0;
        for (int k = 0; k < 16; ++k) {
            if (stateCnt[k] == 0) continue;
            result[0][index] = k;
            result[1][index] = stateCnt[k];
            ++index;
        }
        boolean change = true;
        while (change) {
            change = false;
            for (int k = 0; k < count - 1; ++k) {
                if (result[1][k] >= result[1][k + 1]) continue;
                int temp = result[0][k];
                result[0][k] = result[0][k + 1];
                result[0][k + 1] = temp;
                int tempCount = result[1][k];
                result[1][k] = result[1][k + 1];
                result[1][k + 1] = tempCount;
                change = true;
            }
        }
        return result;
    }

    public static int[][] getAllelesSortedByFrequency(byte[][] data, int site) {
        int[] stateCnt = new int[16];
        for (int i = 0; i < data.length; ++i) {
            byte first = (byte)(data[i][site] >>> 4 & 0xF);
            byte second = (byte)(data[i][site] & 0xF);
            if (first < 14) {
                byte by = first;
                stateCnt[by] = stateCnt[by] + 1;
            }
            if (second >= 14) continue;
            byte by = second;
            stateCnt[by] = stateCnt[by] + 1;
        }
        int count = 0;
        for (int j = 0; j < 16; ++j) {
            if (stateCnt[j] == 0) continue;
            ++count;
        }
        int[][] result = new int[2][count];
        int index = 0;
        for (int k = 0; k < 16; ++k) {
            if (stateCnt[k] == 0) continue;
            result[0][index] = k;
            result[1][index] = stateCnt[k];
            ++index;
        }
        boolean change = true;
        while (change) {
            change = false;
            for (int k = 0; k < count - 1; ++k) {
                if (result[1][k] >= result[1][k + 1]) continue;
                int temp = result[0][k];
                result[0][k] = result[0][k + 1];
                result[0][k + 1] = temp;
                int tempCount = result[1][k];
                result[1][k] = result[1][k + 1];
                result[1][k + 1] = tempCount;
                change = true;
            }
        }
        return result;
    }

    public static byte[] getAlleles(byte[][] data, int site) {
        int[][] alleles = GenotypeTableUtils.getAllelesSortedByFrequency(data, site);
        int resultSize = alleles[0].length;
        byte[] result = new byte[resultSize];
        for (int i = 0; i < resultSize; ++i) {
            result[i] = (byte)alleles[0][i];
        }
        return result;
    }

    public static Object[][] getAllelesSortedByFrequency(String[][] data, int site) {
        HashMap<String, Integer> stateCnt = new HashMap<String, Integer>();
        for (int i = 0; i < data.length; ++i) {
            Integer count;
            String first;
            String second;
            String[] temp = data[i][site].split(":");
            if (temp == null || temp.length == 0) {
                second = "N";
                first = "N";
            } else if (temp.length == 1) {
                first = second = temp[0].trim();
            } else {
                first = temp[0].trim();
                second = temp[1].trim();
            }
            if (!first.equalsIgnoreCase("N")) {
                count = (Integer)stateCnt.get(first);
                if (count == null) {
                    stateCnt.put(first, ONE);
                } else {
                    stateCnt.put(first, count + 1);
                }
            }
            if (second.equalsIgnoreCase("N")) continue;
            count = (Integer)stateCnt.get(second);
            if (count == null) {
                stateCnt.put(second, ONE);
                continue;
            }
            stateCnt.put(second, count + 1);
        }
        int count = stateCnt.size();
        Object[][] result = new Object[2][count];
        Iterator itr = stateCnt.keySet().iterator();
        int index = 0;
        while (itr.hasNext()) {
            String key = (String)itr.next();
            result[0][index] = key;
            result[1][index] = (Integer)stateCnt.get(key);
            ++index;
        }
        boolean change = true;
        while (change) {
            change = false;
            for (int k = 0; k < count - 1; ++k) {
                if ((Integer)result[1][k] >= (Integer)result[1][k + 1]) continue;
                Object temp = result[0][k];
                result[0][k] = result[0][k + 1];
                result[0][k + 1] = temp;
                Object tempCount = result[1][k];
                result[1][k] = result[1][k + 1];
                result[1][k + 1] = tempCount;
                change = true;
            }
        }
        return result;
    }

    public static List<String> convertNucleotideGenotypesToStringList(byte[] data) {
        ArrayList<String> result = new ArrayList<String>();
        for (byte b : data) {
            result.add(NucleotideAlignmentConstants.getHaplotypeNucleotide(b));
        }
        return result;
    }

    public static List<String> getAlleles(String[][] data, int site) {
        Object[][] alleles = GenotypeTableUtils.getAllelesSortedByFrequency(data, site);
        if (alleles == null || alleles.length == 0) {
            return null;
        }
        int resultSize = alleles[0].length;
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < resultSize; ++i) {
            result.add((String)alleles[0][i]);
        }
        return result;
    }

    public static int[][] getAllelesSortedByFrequency(GenotypeTable alignment, int site) {
        int[] stateCnt = new int[16];
        for (int i = 0; i < alignment.numberOfTaxa(); ++i) {
            byte[] dipB = alignment.genotypeArray(i, site);
            if (dipB[0] != 15) {
                byte by = dipB[0];
                stateCnt[by] = stateCnt[by] + 1;
            }
            if (dipB[1] == 15) continue;
            byte by = dipB[1];
            stateCnt[by] = stateCnt[by] + 1;
        }
        int count = 0;
        for (int j = 0; j < 16; ++j) {
            if (stateCnt[j] == 0) continue;
            ++count;
        }
        int[][] result = new int[2][count];
        int index = 0;
        for (int k = 0; k < 16; ++k) {
            if (stateCnt[k] == 0) continue;
            result[0][index] = k;
            result[1][index] = stateCnt[k];
            ++index;
        }
        boolean change = true;
        while (change) {
            change = false;
            for (int k = 0; k < count - 1; ++k) {
                if (result[1][k] >= result[1][k + 1]) continue;
                int temp = result[0][k];
                result[0][k] = result[0][k + 1];
                result[0][k + 1] = temp;
                int tempCount = result[1][k];
                result[1][k] = result[1][k + 1];
                result[1][k + 1] = tempCount;
                change = true;
            }
        }
        return result;
    }

    public static Object[][] getDiploidsSortedByFrequency(GenotypeTable alignment, int site) {
        Integer ONE_INTEGER = 1;
        int numTaxa = alignment.numberOfTaxa();
        HashMap<String, Integer> diploidValueCounts = new HashMap<String, Integer>();
        for (int r = 0; r < numTaxa; ++r) {
            String current = alignment.genotypeAsString(r, site);
            Integer num = (Integer)diploidValueCounts.get(current);
            if (num == null) {
                diploidValueCounts.put(current, ONE_INTEGER);
                continue;
            }
            num = num + 1;
            diploidValueCounts.put(current, num);
        }
        Object[][] result = new Object[2][diploidValueCounts.size()];
        int i = 0;
        for (String key : diploidValueCounts.keySet()) {
            Integer count = (Integer)diploidValueCounts.get(key);
            result[0][i] = key;
            result[1][i++] = count;
        }
        boolean change = true;
        while (change) {
            change = false;
            int n = diploidValueCounts.size() - 1;
            for (int k = 0; k < n; ++k) {
                if ((Integer)result[1][k] >= (Integer)result[1][k + 1]) continue;
                Object temp = result[0][k];
                result[0][k] = result[0][k + 1];
                result[0][k + 1] = temp;
                Object tempCount = result[1][k];
                result[1][k] = result[1][k + 1];
                result[1][k + 1] = tempCount;
                change = true;
            }
        }
        return result;
    }

    public static String[][] getAlleleStates(String[][] data, int maxNumAlleles) {
        int numSites = data[0].length;
        String[][] alleleStates = new String[numSites][16];
        for (int i = 0; i < numSites; ++i) {
            for (int j = 0; j < 16; ++j) {
                alleleStates[i][j] = j == 14 ? "Z" : "N";
            }
        }
        for (int site = 0; site < numSites; ++site) {
            List<String> alleles = GenotypeTableUtils.getAlleles(data, site);
            if (alleles == null) continue;
            int numAlleles = Math.min(alleles.size(), maxNumAlleles);
            for (int k = 0; k < numAlleles; ++k) {
                alleleStates[site][k] = alleles.get(k);
            }
        }
        return alleleStates;
    }

    public static GenotypeTable removeSitesBasedOnFreqIgnoreMissing(GenotypeTable aa, double minimumProportion, double maximumProportion, int minimumCount) {
        if (!aa.hasGenotype()) {
            return aa;
        }
        int[] includeSites = GenotypeTableUtils.getIncludedSitesBasedOnFreqIgnoreMissing(aa, minimumProportion, maximumProportion, minimumCount);
        return FilterGenotypeTable.getInstance(aa, includeSites);
    }

    public static GenotypeTable filterSitesByBedFile(GenotypeTable input, String bedFile, boolean includeSites) {
        int numSites = input.numberOfSites();
        OpenBitSet sitesToInclude = new OpenBitSet(numSites);
        String line = null;
        try (BufferedReader reader = Utils.getBufferedReader(bedFile);){
            int lineNum = 1;
            line = reader.readLine();
            while (line != null) {
                int endSite;
                String[] tokens = line.trim().split("\t");
                if (tokens.length < 3) {
                    throw new IllegalStateException("filterSitesByBedFile: Expecting at least 3 columns on line: " + lineNum);
                }
                int startSite = input.siteOfPhysicalPosition(Integer.parseInt(tokens[1]) + 1, new Chromosome(tokens[0]));
                if (startSite < 0) {
                    startSite = -startSite - 1;
                }
                endSite = (endSite = input.siteOfPhysicalPosition(Integer.parseInt(tokens[2]) + 1, new Chromosome(tokens[0]))) < 0 ? -endSite - 2 : --endSite;
                for (int i = startSite; i <= endSite; ++i) {
                    sitesToInclude.fastSet(i);
                }
                line = reader.readLine();
                ++lineNum;
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("filterSitesByBedFile: problem reading: " + bedFile + " line: " + line);
        }
        if (!includeSites) {
            sitesToInclude.flip(0L, numSites);
        }
        int numNewSites = (int)sitesToInclude.cardinality();
        int[] result = new int[numNewSites];
        int count = 0;
        for (int s = 0; s < numSites; ++s) {
            if (!sitesToInclude.fastGet(s)) continue;
            result[count++] = s;
        }
        return FilterGenotypeTable.getInstance(input, result);
    }

    public static GenotypeTable filterSitesByChrPos(GenotypeTable input, PositionList positionList, boolean includeSites) {
        Chromosome[] chromosomes;
        TreeSet<Integer> temp = new TreeSet<Integer>();
        PositionList origPositionList = input.positions();
        for (Chromosome chromosome : chromosomes = positionList.chromosomes()) {
            if (origPositionList.chromosomeSiteCount(chromosome) == 0) continue;
            int[] startEndSubSet = positionList.startAndEndOfChromosome(chromosome);
            int[] startEnd = origPositionList.startAndEndOfChromosome(chromosome);
            int posIndex = startEndSubSet[0];
            block1: for (int site = startEnd[0]; site <= startEnd[1]; ++site) {
                Position current = (Position)origPositionList.get(site);
                int pos = current.getPosition();
                while (posIndex <= startEndSubSet[1]) {
                    int currentPos = ((Position)positionList.get(posIndex)).getPosition();
                    if (currentPos == pos) {
                        temp.add(site);
                    } else if (currentPos > pos) continue block1;
                    ++posIndex;
                }
            }
        }
        if (temp.size() == origPositionList.size()) {
            return input;
        }
        if (includeSites) {
            return FilterGenotypeTable.getInstance(input, GenotypeTableUtils.toPrimitive(temp));
        }
        int numSites = input.numberOfSites();
        int[] result = new int[numSites - temp.size()];
        int count = 0;
        for (int i = 0; i < numSites; ++i) {
            if (temp.contains(i)) continue;
            result[count++] = i;
        }
        return FilterGenotypeTable.getInstance(input, result);
    }

    public static GenotypeTable filterSitesByChrPos(GenotypeTable input, String filename, boolean includeSites) {
        HashMap<String, List<Integer>> positionsByChr = new HashMap<String, List<Integer>>();
        int lineNum = 1;
        String[] tokens = null;
        try (BufferedReader reader = Utils.getBufferedReader(filename);){
            String line = reader.readLine();
            if (line != null && line.toLowerCase().startsWith("chr")) {
                line = reader.readLine();
                ++lineNum;
            }
            while (line != null) {
                tokens = line.split("\t");
                if (tokens.length != 2) {
                    throw new IllegalStateException("GenotypeTableUtils: filterSitesByChrPos: Each line in file must have 2 columns (chr, position). line: " + lineNum + " has: " + tokens.length);
                }
                ArrayList<Integer> positions = (ArrayList<Integer>)positionsByChr.get(tokens[0]);
                if (positions == null) {
                    positions = new ArrayList<Integer>();
                    positionsByChr.put(tokens[0], positions);
                }
                positions.add(Integer.valueOf(tokens[1]));
                line = reader.readLine();
                ++lineNum;
            }
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("GenotypeTableUtils: filterSitesByChrPos: value: " + (String)tokens[1] + " is not a number on line: " + lineNum);
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("GenotypeTableUtils: filterSitesByChrPos: Problem reading file: " + filename + "\n" + e.getMessage());
        }
        return GenotypeTableUtils.filterSitesByChrPos(input, positionsByChr, includeSites);
    }

    private static GenotypeTable filterSitesByChrPos(GenotypeTable input, Map<String, List<Integer>> positionsByChr, boolean includeSites) {
        if (positionsByChr.isEmpty()) {
            return null;
        }
        if (positionsByChr.size() == 1) {
            Iterator<Map.Entry<String, List<Integer>>> iterator = positionsByChr.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, List<Integer>> entry = iterator.next();
                if (includeSites) {
                    return FilterGenotypeTable.getInstance(input, GenotypeTableUtils.toPrimitive(GenotypeTableUtils.getSitesToKeepChrPos(input, entry.getKey(), entry.getValue())));
                }
                throw new UnsupportedOperationException();
            }
            return null;
        }
        ArrayList<Integer> allSites = new ArrayList<Integer>();
        for (Map.Entry<String, List<Integer>> entry : positionsByChr.entrySet()) {
            allSites.addAll(GenotypeTableUtils.getSitesToKeepChrPos(input, entry.getKey(), entry.getValue()));
        }
        if (includeSites) {
            return FilterGenotypeTable.getInstance(input, GenotypeTableUtils.toPrimitive(allSites));
        }
        throw new UnsupportedOperationException();
    }

    public static GenotypeTable keepSitesChrPos(GenotypeTable input, String chromosome, List<Integer> position) {
        return FilterGenotypeTable.getInstance(input, GenotypeTableUtils.toPrimitive(GenotypeTableUtils.getSitesToKeepChrPos(input, chromosome, position)));
    }

    private static List<Integer> getSitesToKeepChrPos(GenotypeTable input, String chromosome, List<Integer> position) {
        Position current;
        Position current2;
        if (chromosome == null || position == null) {
            throw new IllegalArgumentException("GenotypeTableUtils: keepSitesChrPos: must specify chromosome and positions.");
        }
        Collections.sort(position);
        PositionList origPositions = input.positions();
        int site = 0;
        Iterator iterator = origPositions.iterator();
        while (iterator.hasNext() && !(current2 = (Position)iterator.next()).getChromosome().getName().equals(chromosome)) {
            ++site;
        }
        int numSites = origPositions.numberOfSites();
        if (site == numSites) {
            return null;
        }
        ArrayList<Integer> temp = new ArrayList<Integer>();
        int posIndex = 0;
        while (site < numSites && (current = (Position)origPositions.get(site)).getChromosome().getName().equals(chromosome)) {
            int pos = current.getPosition();
            while (position.get(posIndex) < pos) {
                if (++posIndex != position.size()) continue;
                return temp;
            }
            if (position.get(posIndex) == pos) {
                temp.add(site);
            }
            ++site;
        }
        return temp;
    }

    private static int[] toPrimitive(Collection<Integer> list) {
        int[] result = new int[list.size()];
        int index = 0;
        for (int current : list) {
            result[index++] = current;
        }
        return result;
    }

    public static int[] getIncludedSitesBasedOnFreqIgnoreMissing(GenotypeTable aa, double minimumProportion, double maximumProportion, int minimumCount) {
        int[][] alleles;
        int i;
        ArrayList<Integer> includeAL = new ArrayList<Integer>();
        int numSites = aa.numberOfSites();
        if (minimumCount > 0) {
            for (i = 0; i < numSites; ++i) {
                double obsMinProp;
                alleles = aa.allelesSortedByFrequency(i);
                int totalNonMissing = AlleleFreqCache.totalGametesNonMissingForSite(alleles);
                if (totalNonMissing < minimumCount * 2 || !((obsMinProp = AlleleFreqCache.minorAlleleFrequency(alleles)) >= minimumProportion) || !(obsMinProp <= maximumProportion)) continue;
                includeAL.add(i);
            }
        } else {
            for (i = 0; i < numSites; ++i) {
                alleles = aa.allelesSortedByFrequency(i);
                double obsMinProp = AlleleFreqCache.minorAlleleFrequency(alleles);
                if (!(obsMinProp >= minimumProportion) || !(obsMinProp <= maximumProportion)) continue;
                includeAL.add(i);
            }
        }
        int[] includeSites = new int[includeAL.size()];
        for (int i2 = 0; i2 < includeAL.size(); ++i2) {
            includeSites[i2] = (Integer)includeAL.get(i2);
        }
        return includeSites;
    }

    public static boolean isHeterozygous(byte diploidAllele) {
        return (diploidAllele >>> 4 & 0xF) != (diploidAllele & 0xF);
    }

    public static boolean isHomozygous(byte diploidAllele) {
        if (diploidAllele == -1) {
            return false;
        }
        return (diploidAllele >>> 4 & 0xF) == (diploidAllele & 0xF);
    }

    public static boolean isEqual(byte[] alleles1, byte[] alleles2) {
        return alleles1[0] == alleles2[0] && alleles1[1] == alleles2[1] || alleles1[0] == alleles2[1] && alleles1[1] == alleles2[0];
    }

    public static boolean isEqual(byte diploidAllele1, byte diploidAllele2) {
        byte reversed;
        return diploidAllele1 == diploidAllele2 || (reversed = (byte)(diploidAllele1 << 4 | diploidAllele1 >>> 4)) == diploidAllele2;
    }

    public static boolean isEqualOrUnknown(byte[] alleles1, byte[] alleles2) {
        if (alleles1[0] == 15 && alleles1[1] == 15 || alleles2[0] == 15 && alleles2[1] == 15) {
            return true;
        }
        return alleles1[0] == alleles2[0] && alleles1[1] == alleles2[1] || alleles1[0] == alleles2[1] && alleles1[1] == alleles2[0];
    }

    public static boolean isEqualOrUnknown(byte diploidAllele1, byte diploidAllele2) {
        byte reversed;
        if (diploidAllele1 == -1 || diploidAllele2 == -1) {
            return true;
        }
        return diploidAllele1 == diploidAllele2 || (reversed = (byte)(diploidAllele1 << 4 | diploidAllele1 >>> 4)) == diploidAllele2;
    }

    public static boolean isPartiallyEqual(byte genotype1, byte genotype2) {
        int low1 = 0xF & genotype1;
        int low2 = 0xF & genotype2;
        if (low1 == low2) {
            return true;
        }
        int high1 = genotype1 >>> 4;
        if (high1 == low2) {
            return true;
        }
        int high2 = genotype2 >>> 4;
        if (low1 == high2) {
            return true;
        }
        return high1 == high2;
    }

    public static boolean areEncodingsEqual(String[][][] encodings) {
        int numEncodings = encodings.length;
        for (int i = 1; i < numEncodings; ++i) {
            int numSites = encodings[0].length;
            if (numSites != encodings[i].length) {
                return false;
            }
            for (int s = 0; s < numSites; ++s) {
                int numCodes = encodings[0][s].length;
                if (numCodes != encodings[i][s].length) {
                    return false;
                }
                for (int c = 0; c < numCodes; ++c) {
                    if (encodings[0][s][c].equals(encodings[i][s][c])) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static byte getDiploidValuePhased(byte a, byte b) {
        return (byte)(a << 4 | 0xF & b);
    }

    public static byte getDiploidValue(byte a, byte b) {
        return GenotypeTableUtils.getDiploidValuePhased(a, b);
    }

    public static byte getUnphasedDiploidValue(byte a, byte b) {
        if ((a = (byte)(0xF & a)) < (b = (byte)(0xF & b))) {
            return (byte)(a << 4 | b);
        }
        return (byte)(b << 4 | a);
    }

    public static byte getUnphasedSortedDiploidValue(byte genotype) {
        byte a = (byte)(genotype >>> 4 & 0xF);
        byte b = (byte)(genotype & 0xF);
        if (a < b) {
            return (byte)(a << 4 | b);
        }
        return (byte)(b << 4 | a);
    }

    public static byte getUnphasedDiploidValueNoHets(byte g1, byte g2) {
        if (g2 == g1 && !GenotypeTableUtils.isHeterozygous(g1)) {
            return g1;
        }
        if (g1 == -1) {
            return -1;
        }
        if (g2 == -1) {
            return -1;
        }
        if (GenotypeTableUtils.isHeterozygous(g1)) {
            return -1;
        }
        if (GenotypeTableUtils.isHeterozygous(g2)) {
            return -1;
        }
        return GenotypeTableUtils.getUnphasedDiploidValue(g1, g2);
    }

    public static byte[] getDiploidValues(byte genotype) {
        byte[] result = new byte[]{(byte)(genotype >>> 4 & 0xF), (byte)(genotype & 0xF)};
        return result;
    }

    public static BitSet[] calcBitPresenceFromGenotype(byte[] genotype, byte[] mjA, byte[] mnA) {
        int sites = genotype.length;
        if (genotype.length != mjA.length || genotype.length != mnA.length) {
            throw new ArrayIndexOutOfBoundsException("Input genotypes unequal in length");
        }
        OpenBitSet rMj = new OpenBitSet(genotype.length);
        OpenBitSet rMn = new OpenBitSet(genotype.length);
        for (int i = 0; i < sites; ++i) {
            byte g = genotype[i];
            byte mj = mjA[i];
            byte mn = mnA[i];
            if (mj == 15) continue;
            if (g == GenotypeTableUtils.getDiploidValuePhased(mj, mj)) {
                rMj.fastSet(i);
                continue;
            }
            if (mn == 15) continue;
            if (g == GenotypeTableUtils.getDiploidValuePhased(mn, mn)) {
                rMn.fastSet(i);
                continue;
            }
            byte het = GenotypeTableUtils.getUnphasedDiploidValue(mj, mn);
            if (!GenotypeTableUtils.isEqual(g, het)) continue;
            rMj.fastSet(i);
            rMn.fastSet(i);
        }
        return new BitSet[]{rMj, rMn};
    }

    public static BitSet calcBitPresenceOfDiploidValueFromGenotype(byte[] genotype, byte diploidValue) {
        int sites = genotype.length;
        OpenBitSet result = new OpenBitSet(genotype.length);
        for (int i = 0; i < sites; ++i) {
            if (diploidValue == -1 || !GenotypeTableUtils.isEqual(diploidValue, genotype[i])) continue;
            result.fastSet(i);
        }
        return result;
    }

    public static BitSet calcBitPresenceFromGenotype(byte[] genotype, byte[] referenceValues) {
        int sites = genotype.length;
        if (genotype.length != referenceValues.length) {
            throw new ArrayIndexOutOfBoundsException("GenotypeTableUtils: calcBitPresenceFromGenotype: Input genotypes unequal in length");
        }
        OpenBitSet result = new OpenBitSet(genotype.length);
        for (int i = 0; i < sites; ++i) {
            if (referenceValues[i] == 15) continue;
            if (referenceValues[i] == (byte)(genotype[i] & 0xF)) {
                result.fastSet(i);
                continue;
            }
            if (referenceValues[i] != (byte)(genotype[i] >>> 4 & 0xF)) continue;
            result.fastSet(i);
        }
        return result;
    }

    public static BitSet calcBitUnknownPresenceFromGenotype(byte[] genotype) {
        int length = genotype.length;
        OpenBitSet result = new OpenBitSet(genotype.length);
        for (int i = 0; i < length; ++i) {
            if (genotype[i] != -1) continue;
            result.fastSet(i);
        }
        return result;
    }

    public static BitSet[] calcBitPresenceFromGenotype15(byte[] genotype, byte[] mjA, byte[] mnA) {
        int sites = genotype.length;
        if (genotype.length != mjA.length || genotype.length != mnA.length) {
            throw new ArrayIndexOutOfBoundsException("Input genotypes unequal in length");
        }
        ByteBuffer gBB = ByteBuffer.wrap(genotype);
        ByteBuffer mjBB = ByteBuffer.wrap(mjA);
        ByteBuffer mnBB = ByteBuffer.wrap(mnA);
        OpenBitSet rMj = new OpenBitSet(genotype.length);
        OpenBitSet rMn = new OpenBitSet(genotype.length);
        for (int i = 0; i < sites; ++i) {
            byte g = gBB.get();
            byte mj = mjBB.get();
            byte mn = mnBB.get();
            if (mj == 15) continue;
            if (g == GenotypeTableUtils.getDiploidValuePhased(mj, mj)) {
                rMj.fastSet(i);
                continue;
            }
            if (mn == 15) continue;
            if (g == GenotypeTableUtils.getDiploidValuePhased(mn, mn)) {
                rMn.fastSet(i);
                continue;
            }
            byte het = GenotypeTableUtils.getUnphasedDiploidValue(mj, mn);
            if (!GenotypeTableUtils.isEqual(g, het)) continue;
            rMj.fastSet(i);
            rMn.fastSet(i);
        }
        return new BitSet[]{rMj, rMn};
    }

    public static BitSet[] calcBitPresenceFromGenotype(byte[] genotype, byte mj, byte mn) {
        int sites = genotype.length;
        OpenBitSet rMj = new OpenBitSet(genotype.length);
        OpenBitSet rMn = new OpenBitSet(genotype.length);
        for (int i = 0; i < sites; ++i) {
            byte g = genotype[i];
            if (mj == 15) continue;
            if (g == GenotypeTableUtils.getDiploidValuePhased(mj, mj)) {
                rMj.fastSet(i);
                continue;
            }
            if (mn == 15) continue;
            if (g == GenotypeTableUtils.getDiploidValuePhased(mn, mn)) {
                rMn.fastSet(i);
                continue;
            }
            byte het = GenotypeTableUtils.getUnphasedDiploidValue(mj, mn);
            if (!GenotypeTableUtils.isEqual(g, het)) continue;
            rMj.fastSet(i);
            rMn.fastSet(i);
        }
        return new BitSet[]{rMj, rMn};
    }

    public static BitSet calcBitPresenceFromGenotype(byte[] genotype, byte referenceValue) {
        int length = genotype.length;
        OpenBitSet result = new OpenBitSet(genotype.length);
        if (referenceValue == 15) {
            return result;
        }
        for (int i = 0; i < length; ++i) {
            if (referenceValue == (byte)(genotype[i] & 0xF)) {
                result.fastSet(i);
                continue;
            }
            if (referenceValue != (byte)(genotype[i] >>> 4 & 0xF)) continue;
            result.fastSet(i);
        }
        return result;
    }

    public static float[][] convertGenotypeToFloatProbability(GenotypeTable genotype, boolean sitesByTaxa) {
        byte[] alleles;
        byte geno;
        int t;
        byte major;
        int s;
        int nsites = genotype.numberOfSites();
        int ntaxa = genotype.numberOfTaxa();
        float[][] out = null;
        if (sitesByTaxa) {
            out = new float[nsites][ntaxa];
            for (s = 0; s < nsites; ++s) {
                major = genotype.majorAllele(s);
                for (t = 0; t < ntaxa; ++t) {
                    geno = genotype.genotype(t, s);
                    if (geno == -1) {
                        out[s][t] = Float.NaN;
                    }
                    if ((alleles = GenotypeTableUtils.getDiploidValues(geno))[0] == major) {
                        float[] fArray = out[s];
                        int n = t;
                        fArray[n] = (float)((double)fArray[n] + 0.5);
                    }
                    if (alleles[1] != major) continue;
                    float[] fArray = out[s];
                    int n = t;
                    fArray[n] = (float)((double)fArray[n] + 0.5);
                }
            }
        }
        if (!sitesByTaxa) {
            out = new float[ntaxa][nsites];
            for (s = 0; s < nsites; ++s) {
                major = genotype.majorAllele(s);
                for (t = 0; t < ntaxa; ++t) {
                    geno = genotype.genotype(t, s);
                    if (geno == -1) {
                        out[t][s] = Float.NaN;
                    }
                    if ((alleles = GenotypeTableUtils.getDiploidValues(geno))[0] == major) {
                        float[] fArray = out[t];
                        int n = s;
                        fArray[n] = (float)((double)fArray[n] + 0.5);
                    }
                    if (alleles[1] != major) continue;
                    float[] fArray = out[t];
                    int n = s;
                    fArray[n] = (float)((double)fArray[n] + 0.5);
                }
            }
        }
        return out;
    }

    public static double[][] convertGenotypeToDoubleProbability(GenotypeTable genotype, boolean sitesByTaxa) {
        byte[] alleles;
        byte geno;
        int t;
        byte major;
        int s;
        int nsites = genotype.numberOfSites();
        int ntaxa = genotype.numberOfTaxa();
        double[][] out = null;
        if (sitesByTaxa) {
            out = new double[nsites][ntaxa];
            for (s = 0; s < nsites; ++s) {
                major = genotype.majorAllele(s);
                for (t = 0; t < ntaxa; ++t) {
                    geno = genotype.genotype(t, s);
                    if (geno == -1) {
                        out[s][t] = Double.NaN;
                    }
                    if ((alleles = GenotypeTableUtils.getDiploidValues(geno))[0] == major) {
                        double[] dArray = out[s];
                        int n = t;
                        dArray[n] = dArray[n] + 0.5;
                    }
                    if (alleles[1] != major) continue;
                    double[] dArray = out[s];
                    int n = t;
                    dArray[n] = dArray[n] + 0.5;
                }
            }
        }
        if (!sitesByTaxa) {
            out = new double[ntaxa][nsites];
            for (s = 0; s < nsites; ++s) {
                major = genotype.majorAllele(s);
                for (t = 0; t < ntaxa; ++t) {
                    geno = genotype.genotype(t, s);
                    if (geno == -1) {
                        out[t][s] = Double.NaN;
                    }
                    if ((alleles = GenotypeTableUtils.getDiploidValues(geno))[0] == major) {
                        double[] dArray = out[t];
                        int n = s;
                        dArray[n] = dArray[n] + 0.5;
                    }
                    if (alleles[1] != major) continue;
                    double[] dArray = out[t];
                    int n = s;
                    dArray[n] = dArray[n] + 0.5;
                }
            }
        }
        return out;
    }
}

