/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import net.maizegenetics.dna.snp.Translate;
import net.maizegenetics.dna.snp.TranslateIndex;
import net.maizegenetics.dna.snp.TranslateIndexBuilder;
import net.maizegenetics.dna.snp.TranslateIndexRedirectUnordered;
import net.maizegenetics.dna.snp.TranslateNegative;

public class TranslateBuilder {
    private TranslateBuilder() {
    }

    public static Translate getInstance(TranslateIndex translateTaxa, TranslateIndex translateSite) {
        if (translateTaxa == null) {
            throw new IllegalArgumentException("TranslateBuilder: filter: must specify translateTaxa");
        }
        if (translateSite == null) {
            throw new IllegalArgumentException("TranslateBuilder: filter: must specify translateSite");
        }
        if (TranslateBuilder.hasNegativeIndices(translateTaxa) || TranslateBuilder.hasNegativeIndices(translateSite)) {
            return new TranslateNegative(translateTaxa, translateSite);
        }
        return new Translate(translateTaxa, translateSite);
    }

    public static Translate getInstance(Translate base, Translate translate) {
        TranslateIndex translateTaxa = TranslateIndexBuilder.merge(base.translateTaxa(), translate.translateTaxa());
        TranslateIndex translateSite = TranslateIndexBuilder.merge(base.translateSite(), translate.translateSite());
        if (TranslateBuilder.hasNegativeIndices(translateTaxa) || TranslateBuilder.hasNegativeIndices(translateSite)) {
            return new TranslateNegative(translateTaxa, translateSite);
        }
        return new Translate(translateTaxa, translateSite);
    }

    private static boolean hasNegativeIndices(TranslateIndex translateIndex) {
        if (!(translateIndex instanceof TranslateIndexRedirectUnordered)) {
            return false;
        }
        for (int current : translateIndex.getTranslations()) {
            if (current != -1) continue;
            return true;
        }
        return false;
    }
}

