/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ForkJoinPool;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.genotypecall.AbstractGenotypeCallTable;
import net.maizegenetics.util.Tuple;
import org.apache.log4j.Logger;

public class GOBIIGenotypeCallTable
extends AbstractGenotypeCallTable {
    private static final Logger myLogger = Logger.getLogger(GOBIIGenotypeCallTable.class);
    private static final int NUM_LOOK_AHEAD_BLOCKS = 103;
    private final String myFilename;
    private final int myNumLinesPerInterval = 100;
    private final int myMaxCacheSize;
    private final ConcurrentLinkedQueue<IHDF5Reader> myReaders = new ConcurrentLinkedQueue();
    private final CopyOnWriteArraySet<Integer> myCurrentlyProcessingBlocks = new CopyOnWriteArraySet();
    private final WeakHashMap<Thread, Tuple<Integer, byte[]>> myLastSite = new WeakHashMap();
    private final Cache<Integer, byte[][]> myGenoCache;
    private final ConcurrentHashMap<Integer, CompletableFuture<byte[]>> myFutureQueue = new ConcurrentHashMap();
    private final ForkJoinPool myThreadPool;

    private GOBIIGenotypeCallTable(int numTaxa, int numSites, boolean phased, String filename) {
        super(numTaxa, numSites, phased, NucleotideAlignmentConstants.NUCLEOTIDE_ALLELES);
        this.myFilename = filename;
        long oneThirdMemory = Runtime.getRuntime().maxMemory() / (long)(numTaxa * 3);
        this.myMaxCacheSize = (int)Math.min((long)(110 * Runtime.getRuntime().availableProcessors()), oneThirdMemory);
        this.myGenoCache = CacheBuilder.newBuilder().initialCapacity(this.myMaxCacheSize).maximumSize((long)this.myMaxCacheSize).build();
        this.myThreadPool = new ForkJoinPool();
    }

    public static GOBIIGenotypeCallTable getInstance(int numTaxa, int numSites, boolean phased, String filename) {
        return new GOBIIGenotypeCallTable(numTaxa, numSites, phased, filename);
    }

    private byte[] getFromCache(int site) {
        int blockNumber = site / 100;
        byte[][] result = (byte[][])this.myGenoCache.getIfPresent((Object)blockNumber);
        if (result == null) {
            CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
            CompletableFuture temp = this.myFutureQueue.putIfAbsent(site, future);
            if (temp != null) {
                future = temp;
            }
            if (this.myCurrentlyProcessingBlocks.add(blockNumber)) {
                this.myThreadPool.submit(new ProcessLines(site));
            }
            try {
                result = (byte[][])this.myGenoCache.getIfPresent((Object)blockNumber);
                if (result != null) {
                    this.myFutureQueue.remove(site);
                    future.complete(result[site % 100]);
                    return result[site % 100];
                }
                return (byte[])future.get();
            }
            catch (Exception e) {
                myLogger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result[site % 100];
    }

    private IHDF5Reader getReader() {
        IHDF5Reader reader = this.myReaders.poll();
        if (reader == null) {
            try {
                reader = HDF5Factory.openForReading((String)this.myFilename);
            }
            catch (Exception e) {
                myLogger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return reader;
    }

    @Override
    public byte genotype(int taxon, int site) {
        try {
            Tuple<Integer, byte[]> temp = this.myLastSite.get(Thread.currentThread());
            if (temp != null) {
                if ((Integer)temp.x == site) {
                    return ((byte[])temp.y)[taxon];
                }
                byte[] result = this.getFromCache(site);
                this.myLastSite.put(Thread.currentThread(), new Tuple<Integer, byte[]>(site, result));
                return result[taxon];
            }
            byte[] result = this.getFromCache(site);
            this.myLastSite.put(Thread.currentThread(), new Tuple<Integer, byte[]>(site, result));
            return result[taxon];
        }
        catch (Exception ex) {
            myLogger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new IllegalStateException("GOBIIGenotypeCallTable: genotype: Error getting genotype from cache: " + ex.getMessage());
        }
    }

    @Override
    public byte[] genotypeForAllTaxa(int site) {
        byte[] result = new byte[this.myTaxaCount];
        System.arraycopy(this.getFromCache(site), 0, result, 0, this.myTaxaCount);
        return result;
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        return NucleotideAlignmentConstants.getNucleotideIUPAC(this.genotype(taxon, site));
    }

    @Override
    public String diploidAsString(int site, byte value) {
        return NucleotideAlignmentConstants.getNucleotideIUPAC(value);
    }

    @Override
    public void transposeData(boolean siteInnerLoop) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSiteOptimized() {
        return true;
    }

    private static byte[] parseLine(MDArray<String> input, int numTaxa, int site, int relativeSite) {
        if (input.dimensions()[1] != numTaxa) {
            throw new IllegalStateException("GOBIIGenotypeCallTable: Site: " + site + " has wrong number of taxa: " + input.size() + ".  Number of taxa: " + numTaxa);
        }
        byte[] data = new byte[numTaxa];
        for (int t = 0; t < numTaxa; ++t) {
            data[t] = NucleotideAlignmentConstants.getNucleotideDiploidByte((String)input.get(relativeSite, t));
        }
        return data;
    }

    public static void main(String[] args) {
        int[] dimensions;
        String filename = "/SSD/gobii/gobii_terry/DS_1.h5";
        IHDF5Reader reader = HDF5Factory.openForReading((String)filename);
        MDArray input = reader.string().readMDArrayBlockWithOffset("allelematrix", new int[]{5, 282}, new long[]{1L, 0L});
        for (int dim : dimensions = input.dimensions()) {
            System.out.println("dim: " + dim);
        }
        for (int i = 0; i < input.size(); ++i) {
            System.out.println(i + ": " + (String)input.get(i));
        }
    }

    private class ProcessLines
    implements Runnable {
        private int myStartSite;
        private final int myProcessBlock;

        public ProcessLines(int site) {
            this.myProcessBlock = site / 100;
            this.myStartSite = this.myProcessBlock * 100;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.myStartSite >= GOBIIGenotypeCallTable.this.mySiteCount) {
                return;
            }
            IHDF5Reader reader = GOBIIGenotypeCallTable.this.getReader();
            try {
                CompletableFuture future;
                int i;
                int numSites = Math.min(100, GOBIIGenotypeCallTable.this.mySiteCount - this.myStartSite);
                byte[][] result = new byte[numSites][];
                MDArray input = reader.string().readMDArrayBlockWithOffset("allelematrix", new int[]{numSites, GOBIIGenotypeCallTable.this.myTaxaCount}, new long[]{this.myStartSite, 0L});
                for (i = 0; i < numSites; ++i) {
                    result[i] = GOBIIGenotypeCallTable.parseLine((MDArray<String>)input, GOBIIGenotypeCallTable.this.myTaxaCount, this.myStartSite + i, i);
                    future = (CompletableFuture)GOBIIGenotypeCallTable.this.myFutureQueue.remove(this.myStartSite + i);
                    if (future == null) continue;
                    future.complete(result[i]);
                }
                GOBIIGenotypeCallTable.this.myGenoCache.put((Object)this.myProcessBlock, (Object)result);
                GOBIIGenotypeCallTable.this.myGenoCache.getIfPresent((Object)this.myProcessBlock);
                GOBIIGenotypeCallTable.this.myCurrentlyProcessingBlocks.remove(this.myProcessBlock);
                for (i = 0; i < numSites; ++i) {
                    future = (CompletableFuture)GOBIIGenotypeCallTable.this.myFutureQueue.remove(this.myStartSite + i);
                    if (future == null) continue;
                    future.complete(result[i]);
                }
                this.myStartSite += 100;
                if (this.myStartSite >= GOBIIGenotypeCallTable.this.mySiteCount) {
                    return;
                }
                for (int b = 1; b < 103; ++b) {
                    int i2;
                    if (GOBIIGenotypeCallTable.this.myGenoCache.getIfPresent((Object)(this.myProcessBlock + b)) != null) {
                        return;
                    }
                    if (!GOBIIGenotypeCallTable.this.myCurrentlyProcessingBlocks.add(this.myProcessBlock + b)) {
                        return;
                    }
                    numSites = Math.min(100, GOBIIGenotypeCallTable.this.mySiteCount - this.myStartSite);
                    result = new byte[numSites][];
                    input = reader.string().readMDArrayBlockWithOffset("allelematrix", new int[]{numSites, GOBIIGenotypeCallTable.this.myTaxaCount}, new long[]{this.myStartSite, 0L});
                    for (i2 = 0; i2 < numSites; ++i2) {
                        result[i2] = GOBIIGenotypeCallTable.parseLine((MDArray<String>)input, GOBIIGenotypeCallTable.this.myTaxaCount, this.myStartSite + i2, i2);
                    }
                    GOBIIGenotypeCallTable.this.myGenoCache.put((Object)(this.myProcessBlock + b), (Object)result);
                    GOBIIGenotypeCallTable.this.myGenoCache.getIfPresent((Object)(this.myProcessBlock + b));
                    GOBIIGenotypeCallTable.this.myCurrentlyProcessingBlocks.remove(this.myProcessBlock + b);
                    for (i2 = 0; i2 < numSites; ++i2) {
                        CompletableFuture future2 = (CompletableFuture)GOBIIGenotypeCallTable.this.myFutureQueue.remove(this.myStartSite + i2);
                        if (future2 == null) continue;
                        future2.complete(result[i2]);
                    }
                    this.myStartSite += 100;
                    if (this.myStartSite < GOBIIGenotypeCallTable.this.mySiteCount) continue;
                    return;
                }
            }
            catch (Exception e) {
                myLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                GOBIIGenotypeCallTable.this.myReaders.add(reader);
            }
        }
    }
}

