/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ForkJoinPool;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.genotypecall.AbstractGenotypeCallTable;
import net.maizegenetics.dna.snp.io.LineIndex;
import org.apache.log4j.Logger;

public class LineIndexHapmapGenotypeCallTable
extends AbstractGenotypeCallTable {
    private static final Logger myLogger = Logger.getLogger(LineIndexHapmapGenotypeCallTable.class);
    private static final int NUM_HAPMAP_NON_TAXA_HEADERS = 11;
    private static final int NUM_LOOK_AHEAD_BLOCKS = 103;
    private final String myFilename;
    private final LineIndex myIndex;
    private final boolean myIsOneLetter;
    private final int myNumLinesPerInterval;
    private final ConcurrentLinkedQueue<BlockCompressedInputStream> myReaders = new ConcurrentLinkedQueue();
    private final CopyOnWriteArraySet<Integer> myCurrentlyProcessingBlocks = new CopyOnWriteArraySet();
    private final Cache<Integer, byte[][]> myGenoCache;
    private final Cache<Integer, byte[]> mySmallGenoCache;
    private final ConcurrentHashMap<Integer, CompletableFuture<byte[]>> myFutureQueue = new ConcurrentHashMap();
    private final ForkJoinPool myThreadPool;

    private LineIndexHapmapGenotypeCallTable(int numTaxa, int numSites, boolean phased, boolean isOneLetter, LineIndex index, String filename) {
        super(numTaxa, numSites, phased, NucleotideAlignmentConstants.NUCLEOTIDE_ALLELES);
        this.myIsOneLetter = isOneLetter;
        this.myIndex = index;
        this.myNumLinesPerInterval = index.numLinesPerInterval();
        this.myFilename = filename;
        long oneThirdMemory = Runtime.getRuntime().maxMemory() / (long)(numTaxa * this.myNumLinesPerInterval * 3);
        int maxCacheSize = (int)Math.min((long)(110 * Runtime.getRuntime().availableProcessors()), oneThirdMemory);
        this.myGenoCache = CacheBuilder.newBuilder().initialCapacity(maxCacheSize).maximumSize((long)maxCacheSize).build();
        this.mySmallGenoCache = CacheBuilder.newBuilder().initialCapacity(1000).maximumSize(1000L).build();
        this.myThreadPool = ForkJoinPool.commonPool();
    }

    public static LineIndexHapmapGenotypeCallTable getInstance(int numTaxa, int numSites, boolean phased, boolean isOneLetter, LineIndex index, String filename) {
        return new LineIndexHapmapGenotypeCallTable(numTaxa, numSites, phased, isOneLetter, index, filename);
    }

    private byte[] getFromCache(int site) {
        int blockNumber = site / this.myNumLinesPerInterval;
        byte[][] result = (byte[][])this.myGenoCache.getIfPresent((Object)blockNumber);
        if (result == null) {
            CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
            CompletableFuture temp = this.myFutureQueue.putIfAbsent(site, future);
            if (temp != null) {
                future = temp;
            }
            if (this.myCurrentlyProcessingBlocks.add(blockNumber)) {
                this.myThreadPool.submit(new ProcessLines(site));
            }
            try {
                result = (byte[][])this.myGenoCache.getIfPresent((Object)blockNumber);
                if (result != null) {
                    this.myFutureQueue.remove(site);
                    future.complete(result[site % this.myNumLinesPerInterval]);
                    return result[site % this.myNumLinesPerInterval];
                }
                return (byte[])future.get();
            }
            catch (Exception e) {
                myLogger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result[site % this.myNumLinesPerInterval];
    }

    private BlockCompressedInputStream getReader() {
        BlockCompressedInputStream reader = this.myReaders.poll();
        if (reader == null) {
            try {
                reader = new BlockCompressedInputStream(new File(this.myFilename));
            }
            catch (Exception e) {
                myLogger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return reader;
    }

    @Override
    public byte genotype(int taxon, int site) {
        try {
            byte[] result = (byte[])this.mySmallGenoCache.getIfPresent((Object)site);
            if (result != null) {
                return result[taxon];
            }
            result = this.getFromCache(site);
            this.mySmallGenoCache.put((Object)site, (Object)result);
            return result[taxon];
        }
        catch (Exception ex) {
            myLogger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new IllegalStateException("LineIndexHapmapGenotypeCallTable: genotype: Error getting genotype from cache: " + ex.getMessage());
        }
    }

    @Override
    public byte[] genotypeForAllTaxa(int site) {
        byte[] result = new byte[this.myTaxaCount];
        System.arraycopy(this.getFromCache(site), 0, result, 0, this.myTaxaCount);
        return result;
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        return NucleotideAlignmentConstants.getNucleotideIUPAC(this.genotype(taxon, site));
    }

    @Override
    public String diploidAsString(int site, byte value) {
        return NucleotideAlignmentConstants.getNucleotideIUPAC(value);
    }

    @Override
    public void transposeData(boolean siteInnerLoop) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSiteOptimized() {
        return true;
    }

    private static byte[] parseLine(String input, int numTaxa, int site, boolean isOneLetter) {
        int len = input.length();
        int tabIndex = 0;
        int offset = 0;
        for (int i = 0; tabIndex < 11 && i < len; ++i) {
            if (input.charAt(i) != '\t') continue;
            ++tabIndex;
            offset = i + 1;
        }
        byte[] data = new byte[numTaxa];
        int taxon = 0;
        if (isOneLetter) {
            for (int i = offset; i < len; i += 2) {
                if (taxon >= numTaxa) {
                    throw new IllegalStateException("LineIndexHapmapGenotypeCallTable: Site: " + site + " has too many values.");
                }
                byte value = NucleotideAlignmentConstants.getNucleotideDiploidByte(input.charAt(i));
                if (value == 102) {
                    throw new IllegalStateException("LineIndexHapmapGenotypeCallTable: Site: " + site + " has illegal value: " + input.charAt(i));
                }
                data[taxon++] = value;
            }
        } else {
            for (int i = offset; i < len; i += 3) {
                if (taxon >= numTaxa) {
                    throw new IllegalStateException("LineIndexHapmapGenotypeCallTable: Site: " + site + " has too many values.");
                }
                byte value = GenotypeTableUtils.getDiploidValue(NucleotideAlignmentConstants.getNucleotideDiploidByte(input.charAt(i + 1)), NucleotideAlignmentConstants.getNucleotideDiploidByte(input.charAt(i)));
                if (value == 102) {
                    throw new IllegalStateException("LineIndexHapmapGenotypeCallTable: Site: " + site + " has illegal value: " + input.charAt(i) + input.charAt(i + 1));
                }
                data[taxon++] = value;
            }
        }
        return data;
    }

    private class ProcessLines
    implements Runnable {
        private int myStartSite;
        private final int mySeekIndex;
        private final int myProcessBlock;

        public ProcessLines(int site) {
            this.myProcessBlock = site / LineIndexHapmapGenotypeCallTable.this.myNumLinesPerInterval;
            this.myStartSite = this.myProcessBlock * LineIndexHapmapGenotypeCallTable.this.myNumLinesPerInterval;
            this.mySeekIndex = this.myStartSite / LineIndexHapmapGenotypeCallTable.this.myNumLinesPerInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.myStartSite >= LineIndexHapmapGenotypeCallTable.this.mySiteCount) {
                return;
            }
            BlockCompressedInputStream reader = LineIndexHapmapGenotypeCallTable.this.getReader();
            try {
                CompletableFuture future;
                int i;
                reader.seek(LineIndexHapmapGenotypeCallTable.this.myIndex.virtualOffset(this.mySeekIndex));
                int numSites = Math.min(LineIndexHapmapGenotypeCallTable.this.myNumLinesPerInterval, LineIndexHapmapGenotypeCallTable.this.mySiteCount - this.myStartSite);
                byte[][] result = new byte[numSites][];
                for (i = 0; i < numSites; ++i) {
                    result[i] = LineIndexHapmapGenotypeCallTable.parseLine(reader.readLine(), LineIndexHapmapGenotypeCallTable.this.myTaxaCount, this.myStartSite + i, LineIndexHapmapGenotypeCallTable.this.myIsOneLetter);
                    future = (CompletableFuture)LineIndexHapmapGenotypeCallTable.this.myFutureQueue.remove(this.myStartSite + i);
                    if (future == null) continue;
                    future.complete(result[i]);
                }
                LineIndexHapmapGenotypeCallTable.this.myGenoCache.put((Object)this.myProcessBlock, (Object)result);
                LineIndexHapmapGenotypeCallTable.this.myGenoCache.getIfPresent((Object)this.myProcessBlock);
                LineIndexHapmapGenotypeCallTable.this.myCurrentlyProcessingBlocks.remove(this.myProcessBlock);
                for (i = 0; i < numSites; ++i) {
                    future = (CompletableFuture)LineIndexHapmapGenotypeCallTable.this.myFutureQueue.remove(this.myStartSite + i);
                    if (future == null) continue;
                    future.complete(result[i]);
                }
                this.myStartSite += LineIndexHapmapGenotypeCallTable.this.myNumLinesPerInterval;
                if (this.myStartSite >= LineIndexHapmapGenotypeCallTable.this.mySiteCount) {
                    return;
                }
                for (int b = 1; b < 103; ++b) {
                    int i2;
                    if (LineIndexHapmapGenotypeCallTable.this.myGenoCache.getIfPresent((Object)(this.myProcessBlock + b)) != null) {
                        return;
                    }
                    if (!LineIndexHapmapGenotypeCallTable.this.myCurrentlyProcessingBlocks.add(this.myProcessBlock + b)) {
                        return;
                    }
                    numSites = Math.min(LineIndexHapmapGenotypeCallTable.this.myNumLinesPerInterval, LineIndexHapmapGenotypeCallTable.this.mySiteCount - this.myStartSite);
                    result = new byte[numSites][];
                    for (i2 = 0; i2 < numSites; ++i2) {
                        result[i2] = LineIndexHapmapGenotypeCallTable.parseLine(reader.readLine(), LineIndexHapmapGenotypeCallTable.this.myTaxaCount, this.myStartSite + i2, LineIndexHapmapGenotypeCallTable.this.myIsOneLetter);
                    }
                    LineIndexHapmapGenotypeCallTable.this.myGenoCache.put((Object)(this.myProcessBlock + b), (Object)result);
                    LineIndexHapmapGenotypeCallTable.this.myGenoCache.getIfPresent((Object)(this.myProcessBlock + b));
                    LineIndexHapmapGenotypeCallTable.this.myCurrentlyProcessingBlocks.remove(this.myProcessBlock + b);
                    for (i2 = 0; i2 < numSites; ++i2) {
                        CompletableFuture future2 = (CompletableFuture)LineIndexHapmapGenotypeCallTable.this.myFutureQueue.remove(this.myStartSite + i2);
                        if (future2 == null) continue;
                        future2.complete(result[i2]);
                    }
                    this.myStartSite += LineIndexHapmapGenotypeCallTable.this.myNumLinesPerInterval;
                    if (this.myStartSite < LineIndexHapmapGenotypeCallTable.this.mySiteCount) continue;
                    return;
                }
            }
            catch (Exception e) {
                myLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                LineIndexHapmapGenotypeCallTable.this.myReaders.add(reader);
            }
        }
    }
}

