/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.util.ArrayList;
import java.util.TreeSet;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import org.apache.log4j.Logger;

public class BuilderFromGenotypeHDF5 {
    private static final Logger myLogger = Logger.getLogger(BuilderFromGenotypeHDF5.class);
    private final String infile;

    private BuilderFromGenotypeHDF5(String infile) {
        this.infile = infile;
    }

    public static void mergeToMutableHDF5(String[] infiles, String newMerge) {
        if (infiles == null || infiles.length == 0) {
            return;
        }
        System.out.println("Opening Existing Position List");
        PositionListBuilder palBuild = new PositionListBuilder();
        System.out.println("Combining Position List");
        for (String infile : infiles) {
            System.out.println("..." + infile);
            IHDF5Reader reader = HDF5Factory.openForReading((String)infile);
            PositionList pl = PositionListBuilder.getInstance(reader);
            palBuild.addAll(pl);
            reader.close();
            System.gc();
        }
        System.out.println("Sorting Position List");
        PositionList pal = palBuild.build();
        palBuild = null;
        System.out.println("Creating Position List Look Up");
        int[][] oldSiteToNewSite = new int[infiles.length][];
        int misses = 0;
        int hits = 0;
        for (int i = 0; i < infiles.length; ++i) {
            System.out.println("..." + infiles[i]);
            IHDF5Reader reader = HDF5Factory.openForReading((String)infiles[i]);
            PositionList aPL = PositionListBuilder.getInstance(reader);
            oldSiteToNewSite[i] = new int[aPL.numberOfSites()];
            for (int j = 0; j < aPL.size(); ++j) {
                oldSiteToNewSite[i][j] = pal.indexOf(aPL.get(j));
                if (oldSiteToNewSite[i][j] < 0) {
                    System.out.println(oldSiteToNewSite[i][j]);
                    System.out.println(((Position)aPL.get(j)).toString());
                    System.out.println(((Position)pal.get(-oldSiteToNewSite[i][j])).toString());
                    System.out.printf("misses:%d hits:%d %n", ++misses, hits);
                    continue;
                }
                ++hits;
            }
            reader.close();
            System.gc();
        }
        System.out.println(misses);
        int numberOfSites = pal.numberOfSites();
        ArrayList<TaxaList> inTL = new ArrayList<TaxaList>();
        TreeSet<Taxon> taxa = new TreeSet<Taxon>();
        for (String infile : infiles) {
            IHDF5Reader reader = HDF5Factory.openForReading((String)infile);
            TaxaList aTL = new TaxaListBuilder().buildFromHDF5Genotypes(reader);
            reader.close();
            taxa.addAll(aTL);
            inTL.add(aTL);
        }
        TaxaList newTaxaList = new TaxaListBuilder().addAll(taxa).build();
        int[][] oldTaxaToNewTaxa = new int[inTL.size()][];
        for (int i = 0; i < inTL.size(); ++i) {
            TaxaList aTL = (TaxaList)inTL.get(i);
            oldTaxaToNewTaxa[i] = new int[aTL.numberOfTaxa()];
            for (int j = 0; j < aTL.size(); ++j) {
                oldTaxaToNewTaxa[i][j] = newTaxaList.indexOf((Taxon)aTL.get(j));
                if (oldTaxaToNewTaxa[i][j] >= 0) continue;
                System.out.println(oldTaxaToNewTaxa[i][j]);
                System.out.println(((Taxon)aTL.get(j)).toString());
            }
        }
        GenotypeTableBuilder ab = GenotypeTableBuilder.getTaxaIncremental(pal, newMerge);
        System.gc();
        System.out.println("Opening alignments");
        ArrayList<GenotypeTable> sourceA = new ArrayList<GenotypeTable>();
        for (String infile : infiles) {
            sourceA.add(GenotypeTableBuilder.getInstance(infile));
        }
        for (Taxon aT : newTaxaList) {
            System.out.println("Write taxon:" + aT.getName());
            byte[] geno = new byte[numberOfSites];
            for (int i = 0; i < sourceA.size(); ++i) {
                int taxonIndex = ((GenotypeTable)sourceA.get(i)).taxa().indexOf(aT);
                byte[] r = ((GenotypeTable)sourceA.get(i)).genotypeAllSites(taxonIndex);
                for (int j = 0; j < oldSiteToNewSite[i].length; ++j) {
                    geno[oldSiteToNewSite[i][j]] = r[j];
                }
            }
            ab.addTaxon(aT, geno);
        }
        ab.build();
    }
}

