/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import java.io.BufferedWriter;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\u001a \u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\r\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"FLAPJACK_CHARS", "", "", "[Ljava/lang/String;", "FLAPJACK_MISSING", "myLogger", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "writeToFlapjack", "genotypes", "Lnet/maizegenetics/dna/snp/GenotypeTable;", "filename", "delimiter", "", "tassel"})
@JvmName(name="FlapjackUtils")
public final class FlapjackUtils {
    private static final Logger myLogger = Logger.getLogger((String)"net.maizegenetics.dna.snp.io.FlapjackUtils");
    @NotNull
    private static final String FLAPJACK_MISSING = "-";
    @NotNull
    private static final String[] FLAPJACK_CHARS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String writeToFlapjack(@NotNull GenotypeTable genotypes, @NotNull String filename, char delimiter) {
        Intrinsics.checkNotNullParameter((Object)genotypes, (String)"genotypes");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        if (delimiter != ' ' && delimiter != '\t') {
            throw new IllegalArgumentException("FlapjackUtils: writeToFlapjack: Delimiter character must be either a blank space or a tab.");
        }
        String mapFileName = Utils.addSuffixIfNeeded(filename, ".flpjk.map");
        String genoFileName = Utils.addSuffixIfNeeded(filename, ".flpjk.geno");
        try {
            Closeable closeable = Utils.getBufferedWriter(genoFileName);
            Throwable throwable = null;
            try {
                int n;
                BufferedWriter genoWriter = (BufferedWriter)closeable;
                boolean bl = false;
                Closeable closeable2 = Utils.getBufferedWriter(mapFileName);
                Throwable throwable2 = null;
                try {
                    BufferedWriter mapWriter = (BufferedWriter)closeable2;
                    boolean bl2 = false;
                    n = 0;
                    int n2 = genotypes.numberOfSites();
                    while (n < n2) {
                        int site = n++;
                        mapWriter.write(genotypes.siteName(site));
                        mapWriter.write(delimiter);
                        mapWriter.write(genotypes.chromosomeName(site));
                        mapWriter.write(delimiter);
                        mapWriter.write(Integer.toString(genotypes.chromosomalPosition(site)));
                        mapWriter.write("\n");
                        genoWriter.write(delimiter);
                        genoWriter.write(genotypes.siteName(site));
                    }
                    mapWriter = Unit.INSTANCE;
                }
                catch (Throwable mapWriter) {
                    throwable2 = mapWriter;
                    throw mapWriter;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                genoWriter.write("\n");
                int n3 = 0;
                int n4 = genotypes.numberOfTaxa();
                while (n3 < n4) {
                    int taxa = n3++;
                    genoWriter.write(genotypes.taxaName(taxa));
                    int n5 = 0;
                    n = genotypes.numberOfSites();
                    block18: while (n5 < n) {
                        int site = n5++;
                        genoWriter.write(delimiter);
                        byte[] alleles = genotypes.genotypeArray(taxa, site);
                        switch (alleles.length) {
                            case 1: {
                                genoWriter.write(FLAPJACK_CHARS[alleles[0]]);
                                continue block18;
                            }
                            case 2: {
                                genoWriter.write(FLAPJACK_CHARS[alleles[0]]);
                                genoWriter.write("/");
                                genoWriter.write(FLAPJACK_CHARS[alleles[1]]);
                                continue block18;
                            }
                        }
                        genoWriter.write(FLAPJACK_CHARS[alleles[0]]);
                        genoWriter.write("/");
                        genoWriter.write(FLAPJACK_CHARS[alleles[1]]);
                        genoWriter.write("/");
                        genoWriter.write(FLAPJACK_CHARS[alleles[2]]);
                    }
                    genoWriter.write("\n");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return mapFileName + " and " + genoFileName;
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("Problem writing Flapjack files: " + mapFileName + " and " + genoFileName + '\n' + e.getMessage());
        }
    }

    public static /* synthetic */ String writeToFlapjack$default(GenotypeTable genotypeTable, String string, char c, int n, Object object) {
        if ((n & 4) != 0) {
            c = (char)9;
        }
        return FlapjackUtils.writeToFlapjack(genotypeTable, string, c);
    }

    static {
        String[] stringArray = new String[]{"A", "C", "G", "T", FLAPJACK_MISSING, FLAPJACK_MISSING, "X", "X", "X", "X", "X", "X", "X", "X", "X", FLAPJACK_MISSING};
        FLAPJACK_CHARS = stringArray;
    }
}

