/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.io.HeaderPositions;
import net.maizegenetics.dna.snp.score.AlleleDepthUtil;

class ProcessVCFBlock
implements Callable<ProcessVCFBlock> {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final Pattern SLASH_PATTERN = Pattern.compile("/");
    private final HeaderPositions hp;
    private final int taxaN;
    private final int siteN;
    private final int startSite;
    private final GenotypeTableBuilder hdf5Builder;
    private ArrayList<String> txtL;
    private byte[][] gTS;
    private byte[][][] dTS;
    private final ArrayList<Position> blkPosList;
    private final boolean keepDepth;

    private ProcessVCFBlock(int taxaN, HeaderPositions hp, ArrayList<String> txtL, int startSite, GenotypeTableBuilder hdf5Builder, boolean keepDepth) {
        this.taxaN = taxaN;
        this.siteN = txtL.size();
        this.txtL = txtL;
        this.hp = hp;
        this.blkPosList = new ArrayList(this.siteN);
        this.startSite = startSite;
        this.hdf5Builder = hdf5Builder;
        this.keepDepth = keepDepth;
    }

    static ProcessVCFBlock getInstance(int taxaN, HeaderPositions hp, ArrayList<String> txtL, boolean keepDepth) {
        return new ProcessVCFBlock(taxaN, hp, txtL, Integer.MIN_VALUE, null, keepDepth);
    }

    static ProcessVCFBlock getInstance(int taxaN, HeaderPositions hp, ArrayList<String> txtL, int startSite, GenotypeTableBuilder hdf5Builder, boolean keepDepth) {
        return new ProcessVCFBlock(taxaN, hp, txtL, startSite, hdf5Builder, keepDepth);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ProcessVCFBlock call() throws Exception {
        HashMap<String, Chromosome> chromosomeLookup = new HashMap<String, Chromosome>();
        this.gTS = new byte[this.taxaN][this.siteN];
        if (this.keepDepth) {
            this.dTS = new byte[this.taxaN][6][this.siteN];
        }
        for (int s = 0; s < this.siteN; ++s) {
            String input = this.txtL.get(s);
            try {
                int i;
                int[] tabPos = new int[this.hp.NUM_HAPMAP_NON_TAXA_HEADERS + this.taxaN];
                int tabIndex = 0;
                int len = input.length();
                for (int i2 = 0; tabIndex < this.hp.NUM_HAPMAP_NON_TAXA_HEADERS + this.taxaN && i2 < len; ++i2) {
                    if (input.charAt(i2) != '\t') continue;
                    tabPos[tabIndex++] = i2;
                }
                String chrName = input.substring(0, tabPos[this.hp.CHROMOSOME_INDEX]);
                Chromosome currChr = (Chromosome)chromosomeLookup.get(chrName);
                if (currChr == null) {
                    currChr = new Chromosome(new String(chrName));
                    chromosomeLookup.put(chrName, currChr);
                }
                String snpID = null;
                if (this.hp.SNPID_INDEX > 0) {
                    snpID = input.substring(tabPos[this.hp.SNPID_INDEX - 1] + 1, tabPos[this.hp.SNPID_INDEX]);
                }
                String refS = input.substring(tabPos[this.hp.REF_INDEX - 1] + 1, tabPos[this.hp.REF_INDEX]);
                String alt = input.substring(tabPos[this.hp.ALT_INDEX - 1] + 1, tabPos[this.hp.ALT_INDEX]);
                String variants = alt.equals(".") ? refS : (refS + "/" + alt).replace(',', '/').replace("<INS>", "+").replace('I', '+').replace("<DEL>", "-").replace('D', '-').replace("*", "N");
                GeneralPosition.Builder apb = new GeneralPosition.Builder(currChr, Integer.parseInt(input.substring(tabPos[this.hp.POSITION_INDEX - 1] + 1, tabPos[this.hp.POSITION_INDEX]))).knownVariants(variants);
                if (snpID != null && !snpID.equals(".")) {
                    apb.snpName(snpID);
                }
                byte[] alleles = new byte[variants.split("/").length];
                int i3 = 0;
                int varInd = 0;
                while (i3 < alleles.length) {
                    alleles[i3] = NucleotideAlignmentConstants.getNucleotideAlleleByte(variants.charAt(varInd));
                    ++i3;
                    varInd += 2;
                }
                String[] variantList = variants.split("/");
                if (variantList[0].length() > 1) {
                    String[] parsedVariantList = new String[variantList.length];
                    for (i = 0; i < variantList.length; ++i) {
                        if (variantList[i].length() > 1) {
                            parsedVariantList[i] = variantList[i].substring(1);
                            if (parsedVariantList[i].length() != 0) continue;
                            parsedVariantList[i] = "-";
                            continue;
                        }
                        parsedVariantList[i] = "-";
                    }
                    for (i = 0; i < parsedVariantList.length; ++i) {
                        alleles[i] = NucleotideAlignmentConstants.getNucleotideAlleleByte(parsedVariantList[i].charAt(0));
                    }
                } else {
                    boolean isIndel = false;
                    for (i = 1; i < variantList.length; ++i) {
                        if (variantList[i].length() <= variantList[0].length()) continue;
                        isIndel = true;
                        break;
                    }
                    if (isIndel) {
                        int i4;
                        String[] parsedVariantList = new String[variantList.length];
                        for (i4 = 0; i4 < variantList.length; ++i4) {
                            if (variantList[i4].length() > 1) {
                                parsedVariantList[i4] = variantList[i4].substring(1);
                                if (parsedVariantList[i4].length() != 0) continue;
                                parsedVariantList[i4] = "-";
                                continue;
                            }
                            parsedVariantList[i4] = "-";
                        }
                        for (i4 = 0; i4 < parsedVariantList.length; ++i4) {
                            alleles[i4] = NucleotideAlignmentConstants.getNucleotideAlleleByte(parsedVariantList[i4].charAt(0));
                        }
                    } else {
                        for (i = 0; i < variantList.length; ++i) {
                            alleles[i] = NucleotideAlignmentConstants.getNucleotideAlleleByte(variantList[i].charAt(0));
                        }
                    }
                }
                apb.allele(WHICH_ALLELE.Reference, alleles[0]);
                if (alleles.length > 1) {
                    apb.allele(WHICH_ALLELE.Alternate, alleles[1]);
                }
                for (String annoS : Splitter.on((String)";").split((CharSequence)input.substring(tabPos[this.hp.INFO_INDEX - 1] + 1, tabPos[this.hp.INFO_INDEX]))) {
                    apb.addAnno(annoS);
                }
                this.blkPosList.add(apb.build());
                boolean iGT = false;
                int iAD = -1;
                int iDP = -1;
                int iGQ = -1;
                int iPL = -1;
                if (this.hp.FORMAT_INDEX >= 0) {
                    if (tabPos[this.hp.FORMAT_INDEX] == 0) {
                        throw new IllegalStateException("Error Processing VCF: Missing FORMAT tag.");
                    }
                    String unsplitInput = input.substring(tabPos[this.hp.FORMAT_INDEX - 1] + 1, tabPos[this.hp.FORMAT_INDEX]);
                    if (unsplitInput.length() == 0 || !unsplitInput.startsWith("GT")) {
                        if (!unsplitInput.contains("GT")) throw new IllegalStateException("Error Processing VCF Block: Missing FORMAT tag.");
                        throw new IllegalStateException("Error Processing VCF Block: GT field is not in first position of FORMAT.");
                    }
                    String[] formatS = unsplitInput.split(":");
                    iAD = ProcessVCFBlock.firstEqualIndex(formatS, "AD");
                }
                int t = 0;
                for (String taxaAllG : Splitter.on((String)"\t").split((CharSequence)input.substring(tabPos[this.hp.NUM_HAPMAP_NON_TAXA_HEADERS - 1] + 1))) {
                    int f = 0;
                    if (taxaAllG.startsWith(".")) {
                        this.gTS[t][s] = -1;
                        ++t;
                        continue;
                    }
                    for (String fieldS : Splitter.on((String)":").split((CharSequence)taxaAllG)) {
                        if (f == 0) {
                            if (fieldS.equals(".")) throw new IllegalStateException("Error Processing VCF block: Found haploid information for the element: " + taxaAllG + ".\nExpected a diploid entry.");
                            int a1 = 0;
                            int a2 = 0;
                            if (fieldS.length() == 1) {
                                a1 = fieldS.charAt(0) - 48;
                                a2 = fieldS.charAt(0) - 48;
                            } else {
                                a1 = fieldS.charAt(0) - 48;
                                a2 = fieldS.charAt(2) - 48;
                            }
                            if (a1 > alleles.length - 1 || a2 > alleles.length - 1) {
                                Position pos = this.blkPosList.get(this.blkPosList.size() - 1);
                                throw new IllegalStateException("\nError Processing VCF block: Mismatch of alleles.\n  At Chromosome " + pos.getChromosome().getName() + ", Position " + pos.getPosition() + ".\nAllele ID larger than number of alleles");
                            }
                            this.gTS[t][s] = a1 < 0 || a2 < 0 ? -1 : GenotypeTableUtils.getDiploidValue(alleles[a1], alleles[a2]);
                        } else if (f == iAD && this.keepDepth && this.gTS[t][s] != -1) {
                            int i5 = 0;
                            for (String ad : Splitter.on((String)",").split((CharSequence)fieldS)) {
                                if (i5 >= alleles.length) continue;
                                if (alleles[i5] == 15 || ad.equals(".") || alleles[i5] == 6 || alleles[i5] == 102) {
                                    ++i5;
                                    continue;
                                }
                                int adInt = Integer.parseInt(ad);
                                this.dTS[t][alleles[i5++]][s] = AlleleDepthUtil.depthIntToByte(adInt);
                            }
                        }
                        ++f;
                    }
                    ++t;
                }
                continue;
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                System.err.println("Err Site Number:" + s);
                System.err.println("Err Site Number:" + this.blkPosList.get(this.blkPosList.size() - 1).toString());
                System.err.println("Err:" + input);
                throw e;
            }
        }
        this.txtL = null;
        if (this.hdf5Builder == null) return this;
        this.addResultsToHDF5Builder();
        this.gTS = null;
        this.dTS = null;
        this.txtL = null;
        this.blkPosList.clear();
        return this;
    }

    private void addResultsToHDF5Builder() {
        this.hdf5Builder.addSiteBlock(this.startSite, PositionListBuilder.getInstance(this.blkPosList), this.gTS, this.dTS);
    }

    int getSiteNumber() {
        return this.siteN;
    }

    byte[][] getGenoTS() {
        return this.gTS;
    }

    byte[][][] getDepthTS() {
        return this.dTS;
    }

    ArrayList<Position> getBlkPosList() {
        return this.blkPosList;
    }

    private static int firstEqualIndex(String[] sa, String match) {
        for (int i = 0; i < sa.length; ++i) {
            if (!sa[i].equals(match)) continue;
            return i;
        }
        return -1;
    }
}

