/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.maizegenetics.dna.snp.byte2d.Byte2D;
import net.maizegenetics.dna.snp.score.AlleleDepthUtil;
import net.maizegenetics.dna.snp.score.SiteScore;

public class AlleleDepth
implements SiteScore {
    public static final SiteScore.SITE_SCORE_TYPE[] ALLELE_DEPTH_TYPES = new SiteScore.SITE_SCORE_TYPE[]{SiteScore.SITE_SCORE_TYPE.DepthA, SiteScore.SITE_SCORE_TYPE.DepthC, SiteScore.SITE_SCORE_TYPE.DepthG, SiteScore.SITE_SCORE_TYPE.DepthT, SiteScore.SITE_SCORE_TYPE.DepthInsertion, SiteScore.SITE_SCORE_TYPE.DepthGap};
    public static final int NUM_ALLELE_DEPTH_TYPES = ALLELE_DEPTH_TYPES.length;
    private final Map<SiteScore.SITE_SCORE_TYPE, Byte2D> myValues;
    private final int myNumTaxa;
    private final int myNumSites;

    AlleleDepth(Byte2D[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("AlleleDepth: init: no values provided.");
        }
        this.myValues = new HashMap<SiteScore.SITE_SCORE_TYPE, Byte2D>();
        this.myNumTaxa = values[0].numTaxa();
        this.myNumSites = values[0].numSites();
        for (int i = 0; i < values.length; ++i) {
            if (this.myNumTaxa != values[i].numTaxa() || this.myNumSites != values[i].numSites()) {
                throw new IllegalArgumentException("AlleleDepth: init: number of taxa or sites don't match for all values.");
            }
            this.myValues.put(values[i].siteScoreType(), values[i]);
        }
    }

    AlleleDepth(int numTaxa, int numSites) {
        this.myNumTaxa = numTaxa;
        this.myNumSites = numSites;
        this.myValues = null;
    }

    public int value(int taxon, int site, SiteScore.SITE_SCORE_TYPE scoreType) {
        return AlleleDepthUtil.depthByteToInt(this.myValues.get((Object)scoreType).valueForAllele(taxon, site));
    }

    public int depthForAllele(int taxon, int site, int allele) {
        return this.value(taxon, site, ALLELE_DEPTH_TYPES[allele]);
    }

    public int[] values(int taxon, int site) {
        int[] result = new int[NUM_ALLELE_DEPTH_TYPES];
        int count = 0;
        for (SiteScore.SITE_SCORE_TYPE current : ALLELE_DEPTH_TYPES) {
            result[count++] = this.value(taxon, site, current);
        }
        return result;
    }

    public int[][] values(int taxon) {
        int[][] result = new int[NUM_ALLELE_DEPTH_TYPES][this.numSites()];
        int count = 0;
        for (SiteScore.SITE_SCORE_TYPE current : ALLELE_DEPTH_TYPES) {
            for (int site = 0; site < this.numSites(); ++site) {
                result[count][site] = this.value(taxon, site, current);
            }
            ++count;
        }
        return result;
    }

    public byte valueByte(int taxon, int site, SiteScore.SITE_SCORE_TYPE scoreType) {
        return this.myValues.get((Object)scoreType).valueForAllele(taxon, site);
    }

    public byte[] valuesByte(int taxon, int site) {
        byte[] result = new byte[NUM_ALLELE_DEPTH_TYPES];
        int count = 0;
        for (SiteScore.SITE_SCORE_TYPE current : ALLELE_DEPTH_TYPES) {
            result[count++] = this.valueByte(taxon, site, current);
        }
        return result;
    }

    public byte[][] valuesForTaxonByte(int taxon) {
        byte[][] result = new byte[NUM_ALLELE_DEPTH_TYPES][this.numSites()];
        int count = 0;
        for (SiteScore.SITE_SCORE_TYPE current : ALLELE_DEPTH_TYPES) {
            for (int site = 0; site < this.numSites(); ++site) {
                result[count][site] = this.valueByte(taxon, site, current);
            }
            ++count;
        }
        return result;
    }

    public byte[][] valuesForSiteByte(int site) {
        byte[][] result = new byte[NUM_ALLELE_DEPTH_TYPES][this.numTaxa()];
        int count = 0;
        for (SiteScore.SITE_SCORE_TYPE current : ALLELE_DEPTH_TYPES) {
            for (int taxon = 0; taxon < this.numTaxa(); ++taxon) {
                result[count][taxon] = this.valueByte(taxon, site, current);
            }
            ++count;
        }
        return result;
    }

    public int depth(int taxon, int site) {
        int result = 0;
        for (SiteScore.SITE_SCORE_TYPE current : ALLELE_DEPTH_TYPES) {
            result += this.value(taxon, site, current);
        }
        return result;
    }

    public int depthForTaxon(int taxon) {
        int result = 0;
        for (int site = 0; site < this.numSites(); ++site) {
            result += this.depth(taxon, site);
        }
        return result;
    }

    public int depthForSite(int site) {
        int result = 0;
        for (int taxon = 0; taxon < this.numTaxa(); ++taxon) {
            result += this.depth(taxon, site);
        }
        return result;
    }

    Collection<Byte2D> byteStorage() {
        return this.myValues.values();
    }

    @Override
    public Set<SiteScore.SITE_SCORE_TYPE> siteScoreTypes() {
        return new HashSet<SiteScore.SITE_SCORE_TYPE>(Arrays.asList(ALLELE_DEPTH_TYPES));
    }

    @Override
    public int numTaxa() {
        return this.myNumTaxa;
    }

    @Override
    public int numSites() {
        return this.myNumSites;
    }
}

