/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.maizegenetics.dna.snp.byte2d.Byte2D;
import net.maizegenetics.dna.snp.score.SiteScore;

public class Dosage
implements SiteScore {
    private final Byte2D myStorage;
    private final int myNumTaxa;
    private final int myNumSites;

    Dosage(Byte2D value) {
        this.myStorage = value;
        this.myNumTaxa = this.myStorage.numTaxa();
        this.myNumSites = this.myStorage.numSites();
    }

    Dosage(int numTaxa, int numSites) {
        this.myStorage = null;
        this.myNumTaxa = numTaxa;
        this.myNumSites = numSites;
    }

    public byte value(int taxon, int site) {
        return this.myStorage.valueForAllele(taxon, site);
    }

    Byte2D byteStorage() {
        return this.myStorage;
    }

    @Override
    public Set<SiteScore.SITE_SCORE_TYPE> siteScoreTypes() {
        return new HashSet<SiteScore.SITE_SCORE_TYPE>(Arrays.asList(SiteScore.SITE_SCORE_TYPE.Dosage));
    }

    @Override
    public int numTaxa() {
        return this.myNumTaxa;
    }

    @Override
    public int numSites() {
        return this.myNumSites;
    }
}

