/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import net.maizegenetics.dna.snp.Translate;
import net.maizegenetics.dna.snp.score.AlleleDepth;
import net.maizegenetics.dna.snp.score.HDF5AlleleDepth;
import net.maizegenetics.dna.snp.score.SiteScore;

public class FilterHDF5AlleleDepth
extends AlleleDepth {
    private final HDF5AlleleDepth myBase;
    private final Translate myTranslate;

    FilterHDF5AlleleDepth(HDF5AlleleDepth alleleDepth, Translate translate) {
        super(translate.numTaxa(), translate.numSites());
        this.myBase = alleleDepth;
        this.myTranslate = translate;
    }

    @Override
    public byte[] valuesByte(int taxon, int site) {
        return this.myBase.valuesByte(this.myTranslate.taxon(taxon), this.myTranslate.site(site));
    }

    @Override
    public byte[][] valuesForTaxonByte(int taxon) {
        if (!this.myTranslate.hasSiteTranslations()) {
            return this.myBase.valuesForTaxonByte(this.myTranslate.taxon(taxon));
        }
        return super.valuesForTaxonByte(taxon);
    }

    @Override
    public byte valueByte(int taxon, int site, SiteScore.SITE_SCORE_TYPE scoreType) {
        return this.myBase.valueByte(this.myTranslate.taxon(taxon), this.myTranslate.site(site), scoreType);
    }
}

