/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import java.util.Collection;
import net.maizegenetics.dna.snp.MaskMatrix;
import net.maizegenetics.dna.snp.byte2d.Byte2D;
import net.maizegenetics.dna.snp.score.AlleleDepth;
import net.maizegenetics.dna.snp.score.SiteScore;

public class MaskAlleleDepth
extends AlleleDepth {
    private final AlleleDepth myDepth;
    private final MaskMatrix myMask;

    public MaskAlleleDepth(AlleleDepth depth, MaskMatrix mask) {
        super(depth.numTaxa(), depth.numSites());
        if (depth.numTaxa() != mask.numTaxa() || depth.numSites() != mask.numSites()) {
            throw new IllegalArgumentException("MaskAlleleDepth: init: depth and mask dimensions don't match");
        }
        this.myDepth = depth;
        this.myMask = mask;
    }

    @Override
    public int value(int taxon, int site, SiteScore.SITE_SCORE_TYPE scoreType) {
        if (this.myMask.get(taxon, site)) {
            return 0;
        }
        return this.myDepth.value(taxon, site, scoreType);
    }

    @Override
    public byte valueByte(int taxon, int site, SiteScore.SITE_SCORE_TYPE scoreType) {
        if (this.myMask.get(taxon, site)) {
            return 0;
        }
        return this.myDepth.valueByte(taxon, site, scoreType);
    }

    @Override
    Collection<Byte2D> byteStorage() {
        return null;
    }

    public AlleleDepth base() {
        return this.myDepth;
    }

    public MaskMatrix mask() {
        return this.myMask;
    }
}

