/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import java.io.BufferedWriter;
import java.io.FileWriter;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.PETags;
import org.apache.log4j.Logger;
import org.biojava.nbio.alignment.Alignments;
import org.biojava.nbio.alignment.SimpleGapPenalty;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.core.alignment.matrices.SubstitutionMatrixHelper;
import org.biojava.nbio.core.alignment.template.SequencePair;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.template.Sequence;

public abstract class AbstractPETags
implements PETags {
    private static final Logger myLogger = Logger.getLogger(AbstractPETags.class);
    protected int tagLengthInLong;
    protected long[][] tagsF;
    protected long[][] tagsB;
    protected short[] tagFLength;
    protected short[] tagBLength;
    protected byte[] contigLengthInLong;
    protected long[][] contig;
    protected short[] contigLength;

    @Override
    public long[] getTagF(int index) {
        return this.tagsF[index];
    }

    @Override
    public long[] getTagB(int index) {
        return this.tagsB[index];
    }

    @Override
    public int getTagCount() {
        return this.tagsF.length;
    }

    @Override
    public int getTagIndex(long[] tagF, long[] tagB) {
        int first = 0;
        int len = this.getTagCount() - first;
        int comp = 0;
        while (len > 0) {
            int half = len / 2;
            int middle = first + half;
            comp = this.compareTags(middle, tagF, tagB);
            if (comp < 0) {
                first = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        if (first < this.getTagCount() && this.compareTags(first, tagF, tagB) == 0) {
            return first;
        }
        return -(first + 1);
    }

    @Override
    public long[] getContig(int index) {
        if (this.getContigLengthInLong(index) == 0) {
            return null;
        }
        return this.contig[index];
    }

    @Override
    public int getContigCount() {
        int sum = 0;
        for (int i = 0; i < this.getTagCount(); ++i) {
            if (this.getContigLengthInLong(i) == 0) continue;
            ++sum;
        }
        return sum;
    }

    @Override
    public short getContigLength(int index) {
        return this.contigLength[index];
    }

    @Override
    public byte getContigLengthInLong(int index) {
        return this.contigLengthInLong[index];
    }

    public void mkFastaFile(String fFastaFileS, String bFastaFileS) {
        try {
            BufferedWriter bwf = new BufferedWriter(new FileWriter(fFastaFileS), 65536);
            BufferedWriter bwb = new BufferedWriter(new FileWriter(bFastaFileS), 65536);
            for (int i = 0; i < this.getTagCount(); ++i) {
                String backwardTag;
                String forwardTag;
                String forwardName = String.valueOf(i) + "_f_";
                String backwardName = String.valueOf(i) + "_b_";
                if (this.getContigLength(i) == 0) {
                    forwardName = forwardName + "n";
                    backwardName = backwardName + "n";
                    forwardTag = BaseEncoder.getSequenceFromLong(this.getTagF(i)).substring(0, this.getTagFLength(i));
                    backwardTag = BaseEncoder.getSequenceFromLong(this.getTagB(i)).substring(0, this.getTagBLength(i));
                } else {
                    forwardName = forwardName + "c";
                    backwardName = backwardName + "c";
                    forwardTag = BaseEncoder.getSequenceFromLong(this.getContig(i)).substring(0, this.getContigLength(i));
                    backwardTag = BaseEncoder.getReverseComplement(forwardTag);
                }
                bwf.write(">" + forwardName);
                bwf.newLine();
                bwf.write(forwardTag);
                bwf.newLine();
                bwb.write(">" + backwardName);
                bwb.newLine();
                bwb.write(backwardTag);
                bwb.newLine();
            }
            bwf.flush();
            bwf.close();
            bwb.flush();
            bwb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mkFastaFile(String tagsFFastaFileS, String tagsBFastaFileS, String contigFastaFileS) {
        try {
            BufferedWriter bwf = new BufferedWriter(new FileWriter(tagsFFastaFileS), 65536);
            BufferedWriter bwb = new BufferedWriter(new FileWriter(tagsBFastaFileS), 65536);
            BufferedWriter bwc = new BufferedWriter(new FileWriter(contigFastaFileS), 65536);
            for (int i = 0; i < this.getTagCount(); ++i) {
                bwf.write(">" + String.valueOf(i));
                bwf.newLine();
                bwf.write(BaseEncoder.getSequenceFromLong(this.getTagF(i)).substring(0, this.getTagFLength(i)));
                bwf.newLine();
                bwb.write(">" + String.valueOf(i));
                bwb.newLine();
                bwb.write(BaseEncoder.getSequenceFromLong(this.getTagB(i)).substring(0, this.getTagBLength(i)));
                bwb.newLine();
                if (this.getContigLength(i) == 0) continue;
                bwc.write(">" + String.valueOf(i));
                bwc.newLine();
                bwc.write(BaseEncoder.getSequenceFromLong(this.getContig(i)).substring(0, this.getContigLength(i)));
                bwc.newLine();
            }
            bwf.flush();
            bwf.close();
            bwb.flush();
            bwb.close();
            bwc.flush();
            bwc.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void orderTagsFTagsB() {
        for (int i = 0; i < this.getTagCount(); ++i) {
            this.orderTagFTagB(i);
        }
    }

    private boolean orderTagFTagB(int index) {
        if (this.compareTagFTagB(index) == 1) {
            this.switchTagFTagB(index);
            return true;
        }
        return false;
    }

    private void switchTagFTagB(int index) {
        long[] temp = this.tagsF[index];
        this.tagsF[index] = this.tagsB[index];
        this.tagsB[index] = temp;
        short tl = this.tagFLength[index];
        this.tagFLength[index] = this.tagBLength[index];
        this.tagBLength[index] = tl;
    }

    public void contigPETags() {
        SimpleGapPenalty gapPen = new SimpleGapPenalty(10, 10);
        SubstitutionMatrix subMatrix = SubstitutionMatrixHelper.getNuc4_4();
        int minOverlap = 30;
        double minIden = 0.97;
        int halfLength = 128;
        for (int i = 0; i < this.getTagCount(); ++i) {
            int startPos;
            String queryS = BaseEncoder.getSequenceFromLong(this.getTagF(i)).substring(0, this.getTagFLength(i));
            DNASequence query = null;
            try {
                query = new DNASequence(queryS);
            }
            catch (CompoundNotFoundException ex) {
                myLogger.error((Object)("AbstractPETags:contigPETags, compoundNotFound exception from DNASequence call for: " + queryS));
                myLogger.debug((Object)ex.getMessage(), (Throwable)ex);
                return;
            }
            String hitS = BaseEncoder.getReverseComplement(BaseEncoder.getSequenceFromLong(this.getTagB(i)).substring(0, this.getTagBLength(i)));
            DNASequence hit = null;
            try {
                hit = new DNASequence(hitS);
            }
            catch (CompoundNotFoundException ex) {
                myLogger.error((Object)("AbstractPETags:contigPETags 2, compoundNotFound exception from DNASequence call for: " + hitS));
                myLogger.debug((Object)ex.getMessage(), (Throwable)ex);
                return;
            }
            SequencePair psa = Alignments.getPairwiseAlignment((Sequence)query, (Sequence)hit, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.LOCAL, (GapPenalty)gapPen, (SubstitutionMatrix)subMatrix);
            int queryStart = psa.getIndexInQueryAt(1);
            int queryEnd = psa.getIndexInQueryAt(psa.getLength());
            int hitStart = psa.getIndexInTargetAt(1);
            int overlap = psa.getLength();
            int idenNum = psa.getNumIdenticals();
            if (i % 10000 == 0) {
                System.out.println("Contigged " + i + " PETags. Total: " + this.getTagCount());
            }
            if (hitStart != 1 || queryEnd != this.getTagFLength(i) || overlap < minOverlap || (double)(idenNum / overlap) < minIden) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(queryS.substring(0, queryStart - 1));
            if (queryEnd < halfLength) {
                sb.append(queryS.substring(queryStart - 1, queryEnd));
                startPos = queryEnd - queryStart + hitStart;
                sb.append(hitS.substring(startPos, hitS.length()));
            } else if (queryStart < halfLength) {
                sb.append(queryS.substring(queryStart - 1, halfLength));
                startPos = halfLength - queryStart + hitStart;
                sb.append(hitS.substring(startPos, hitS.length()));
            } else {
                sb.append(hitS.substring(hitStart - 1, hitS.length()));
            }
            this.contigLength[i] = (short)sb.length();
            int leftover = this.contigLength[i] % 32;
            if (leftover == 0) {
                this.contigLengthInLong[i] = (byte)(this.contigLength[i] / 32);
            } else {
                this.contigLengthInLong[i] = (byte)(this.contigLength[i] / 32 + 1);
                for (int j = 0; j < 32 - leftover; ++j) {
                    sb.append("A");
                }
            }
            String contigS = sb.toString();
            long[] temp = BaseEncoder.getLongArrayFromSeq(contigS);
            this.contig[i] = temp;
        }
    }

    private int compareTagFTagB(int index) {
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            if (this.tagsF[index][i] < this.tagsB[index][i]) {
                return -1;
            }
            if (this.tagsF[index][i] <= this.tagsB[index][i]) continue;
            return 1;
        }
        return 0;
    }

    private int compareTags(int index, long[] tagF, long[] tagB) {
        int i;
        for (i = 0; i < this.tagLengthInLong; ++i) {
            if (this.tagsF[index][i] < tagF[i]) {
                return -1;
            }
            if (this.tagsF[index][i] <= tagF[i]) continue;
            return 1;
        }
        for (i = 0; i < this.tagLengthInLong; ++i) {
            if (this.tagsB[index][i] < tagB[i]) {
                return -1;
            }
            if (this.tagsB[index][i] <= tagB[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public short getTagFLength(int index) {
        return this.tagFLength[index];
    }

    @Override
    public short getTagBLength(int index) {
        return this.tagBLength[index];
    }

    @Override
    public int getTagSizeInLong() {
        return this.tagLengthInLong;
    }

    protected void iniMatrix(int tagLengthInLong, int tagNum) {
        this.tagLengthInLong = tagLengthInLong;
        this.tagsF = new long[tagNum][tagLengthInLong];
        this.tagsB = new long[tagNum][tagLengthInLong];
        this.tagFLength = new short[tagNum];
        this.tagBLength = new short[tagNum];
        this.contigLengthInLong = new byte[tagNum];
        this.contig = new long[tagNum][];
        this.contigLength = new short[tagNum];
    }

    public void swap(int index1, int index2) {
        long[] temp = this.tagsF[index1];
        this.tagsF[index1] = this.tagsF[index2];
        this.tagsF[index2] = temp;
        temp = this.tagsB[index1];
        this.tagsB[index1] = this.tagsB[index2];
        this.tagsB[index2] = temp;
        short tl = this.tagFLength[index1];
        this.tagFLength[index1] = this.tagFLength[index2];
        this.tagFLength[index2] = tl;
        tl = this.tagBLength[index1];
        this.tagBLength[index1] = this.tagBLength[index2];
        this.tagBLength[index2] = tl;
        byte temByte = this.contigLengthInLong[index1];
        this.contigLengthInLong[index1] = this.contigLengthInLong[index2];
        this.contigLengthInLong[index2] = temByte;
        temp = this.contig[index1];
        this.contig[index1] = this.contig[index2];
        this.contig[index2] = temp;
        tl = this.contigLength[index1];
        this.contigLength[index1] = this.contigLength[index2];
        this.contigLength[index2] = tl;
    }

    public int compare(int index1, int index2) {
        int i;
        for (i = 0; i < this.tagLengthInLong; ++i) {
            if (this.tagsF[index1][i] < this.tagsF[index2][i]) {
                return -1;
            }
            if (this.tagsF[index1][i] <= this.tagsF[index2][i]) continue;
            return 1;
        }
        for (i = 0; i < this.tagLengthInLong; ++i) {
            if (this.tagsB[index1][i] < this.tagsB[index2][i]) {
                return -1;
            }
            if (this.tagsB[index1][i] <= this.tagsB[index2][i]) continue;
            return 1;
        }
        return 0;
    }

    public void sort() {
        System.out.println("Position index sort begin.");
        GenericSorting.quickSort((int)0, (int)this.getTagCount(), (IntComparator)this, (Swapper)this);
        System.out.println("Position index sort end.");
    }
}

