/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import ch.systemsx.cisd.hdf5.HDF5FloatStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.io.BufferedWriter;
import java.io.FileWriter;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.AbstractTags;
import net.maizegenetics.util.Tassel5HDF5Constants;

public abstract class AbstractTagsHDF5
extends AbstractTags {
    protected IHDF5Writer h5 = null;
    protected int currentBlockIndex = -1;
    protected int currentIndex = -1;

    public int getBlockSize() {
        return 65536;
    }

    public int getBlockNum() {
        int num = super.getTagCount() / this.getBlockSize();
        if (super.getTagCount() % this.getBlockSize() == 0) {
            return num;
        }
        return num + 1;
    }

    public int getBlockIndex(int tagIndex) {
        return tagIndex / this.getBlockSize();
    }

    public int getCurrentBlockIndex() {
        return this.currentBlockIndex;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public int getCurrentIndexWithinBlock() {
        return this.getCurrentIndex() % this.getBlockSize();
    }

    protected void initializeMatrix(int tagCount, int tagLengthInLong) {
        this.tagLengthInLong = tagLengthInLong;
        this.tags = new long[tagLengthInLong][tagCount];
        this.tagLength = new byte[tagCount];
    }

    public boolean isInCurrentBlock(int queryIndex) {
        int queryBlockIndex = queryIndex / this.getBlockSize();
        return queryBlockIndex == this.currentBlockIndex;
    }

    public HDF5IntStorageFeatures getIntStorageFeatures() {
        return Tassel5HDF5Constants.intDeflation;
    }

    public HDF5GenericStorageFeatures getGenericStorageFeatures() {
        return Tassel5HDF5Constants.genDeflation;
    }

    public HDF5FloatStorageFeatures getFloatStorageFeatures() {
        return Tassel5HDF5Constants.floatDeflation;
    }

    @Override
    public void sort() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void swap(int index1, int index2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void writeToFasta(String outfileS) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            for (int i = 0; i < this.getTagCount(); ++i) {
                bw.write(">" + String.valueOf(i));
                bw.newLine();
                long[] t = this.getTag(i);
                bw.write(BaseEncoder.getSequenceFromLong(t).substring(0, this.getTagLength(i)));
                bw.newLine();
                if (i % 100000 != 0) continue;
                System.out.println("output " + String.valueOf(i + 1) + " tags to Fasta");
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void initializeHDF5(String inputFileS) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void readHDF5(String hdf5FileS) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void populateBlock(int blockIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void readBlock(int blockIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void writeBlock(int blockIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

