/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.io.CharStreams;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.maizegenetics.analysis.gbs.repgen.AlignmentInfo;
import net.maizegenetics.analysis.gbs.repgen.RefTagData;
import net.maizegenetics.analysis.gbs.repgen.TagCorrelationInfo;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.Allele;
import net.maizegenetics.dna.snp.SimpleAllele;
import net.maizegenetics.dna.tag.RepGenDataWriter;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagBuilder;
import net.maizegenetics.dna.tag.TaxaDistBuilder;
import net.maizegenetics.dna.tag.TaxaDistribution;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.Tuple;
import net.maizegenetics.util.db.SQL;
import org.sqlite.SQLiteConfig;

public class RepGenSQLite
implements RepGenDataWriter,
AutoCloseable {
    private Connection connection = null;
    private BiMap<Tag, Integer> tagTagIDMap;
    private BiMap<RefTagData, Integer> reftagReftagIDMap;
    private Map<String, Integer> mappingApproachToIDMap;
    private BiMap<String, Integer> referenceGenomeToIDMap;
    private SortedMap<Position, Integer> physicalMapPositionToIDMap;
    public BiMap<Position, Integer> snpPosToIDMap;
    private BiMap<Allele, Integer> alleleToIDMap;
    private TaxaList myTaxaList;
    PreparedStatement tagTaxaDistPS;
    PreparedStatement allelePairWithTagid1PS;
    PreparedStatement posTagMappingInsertPS;
    PreparedStatement taxaDistWhereTagMappingIDPS;
    PreparedStatement snpPositionsForChromosomePS;
    PreparedStatement snpQualityInsertPS;
    PreparedStatement allelePairInsertPS;
    PreparedStatement tagtagAlignmentInsertPS;
    PreparedStatement tagReftagAlignmentInsertPS;
    PreparedStatement refRefAlignmentInsertPS;
    PreparedStatement tagAlignForNonRefTagPS;
    PreparedStatement refAlignForRefTagPS;
    PreparedStatement nonReftagAlignmentsForRefTagPS;
    PreparedStatement refTagAlignsForNonRefTagPS;
    PreparedStatement tagTagCorrelationInsertPS;
    PreparedStatement tagCorrelationsForTag1PS;
    PreparedStatement tagCorrelationsForTag2PS;

    public RepGenSQLite(String filename) {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        try {
            boolean doesDBExist = Files.exists(Paths.get(filename, new String[0]), new LinkOption[0]);
            SQLiteConfig config = new SQLiteConfig();
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + filename, config.toProperties());
            this.connection.setAutoCommit(true);
            Statement statement = this.connection.createStatement();
            statement.setQueryTimeout(30);
            if (!doesDBExist) {
                String schema = CharStreams.toString((Readable)new InputStreamReader(RepGenSQLite.class.getResourceAsStream("RepGenSchema.sql")));
                statement.executeUpdate(schema);
            }
            this.initPreparedStatements();
            this.loadReferenceGenomeHash();
            this.loadTagHash();
            this.loadRefTagHash();
            this.loadMappingApproachHash();
            this.loadTaxaList();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void close() throws Exception {
        System.out.println("Closing SQLDB");
        this.connection.close();
    }

    private void initPreparedStatements() {
        try {
            this.posTagMappingInsertPS = this.connection.prepareStatement("INSERT OR IGNORE into TagMapping (reftagid, position_id, method_id, bp_error, cm_error) values(?,?,?,?,?)");
            this.tagTaxaDistPS = this.connection.prepareStatement("select depthsRLE from tagtaxadistribution where tagid=?");
            this.allelePairInsertPS = this.connection.prepareStatement("INSERT into allelepair (tagid_1,tagid_2,qualityscore) values(?,?,?)");
            this.allelePairWithTagid1PS = this.connection.prepareStatement("select * from allelepair where tagid_1=?");
            this.snpPositionsForChromosomePS = this.connection.prepareStatement("select position, qualityScore, refAllele from snpposition where chromosome=?");
            this.snpQualityInsertPS = this.connection.prepareStatement("INSERT into snpQuality (snpid, taxasubset ,avgDepth, minorDepthProp, minor2DepthProp, gapDepthProp, propCovered, propCovered2, taxaCntWithMinorAlleleGE2, minorAlleleFreqGE2, inbredF_DGE2) values(?,?,?,?,?,?,?,?,?,?,?)");
            this.tagtagAlignmentInsertPS = this.connection.prepareStatement("INSERT into tag_tag_Alignments (tag1id, tag2id, score ) values(?,?,?)");
            this.tagReftagAlignmentInsertPS = this.connection.prepareStatement("INSERT into tag_reftag_Alignments(tag1id, refTagID, score,ref_align_start_pos,ref_align_strand ) values(?,?,?,?,?)");
            this.refRefAlignmentInsertPS = this.connection.prepareStatement("INSERT into reftag_reftag_Alignments(tag1id, tag2id, score ) values(?,?,?)");
            this.tagTagCorrelationInsertPS = this.connection.prepareStatement("INSERT into tagCorrelations (tag1id, tag2id, t1t2_pearson, t1t2_spearman, pres_abs_pearson, r2 ) values(?,?,?,?,?,?)");
            this.tagAlignForNonRefTagPS = this.connection.prepareStatement("select tag2id,  score from tag_tag_Alignments where tag1id=? and score >= ?");
            this.refAlignForRefTagPS = this.connection.prepareStatement("select tag2id, score from reftag_reftag_Alignments where tag1id=? and score >= ?");
            this.nonReftagAlignmentsForRefTagPS = this.connection.prepareStatement("select tag1id, score, ref_align_start_pos, ref_align_strand from tag_refTag_Alignments where refTagID=? and score >= ?");
            this.refTagAlignsForNonRefTagPS = this.connection.prepareStatement("select refTagID, score, ref_align_start_pos, ref_align_strand from tag_reftag_Alignments where tag1id=? and score >= ?");
            this.tagCorrelationsForTag1PS = this.connection.prepareStatement("select tag2id, t1t2_pearson, t1t2_spearman, pres_abs_pearson, r2 from tagCorrelations where tag1id=?");
            this.tagCorrelationsForTag2PS = this.connection.prepareStatement("select tag1id, t1t2_pearson, t1t2_spearman, pres_abs_pearson, r2 from tagCorrelations where tag2id=?");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadTagHash() {
        try {
            boolean hasName;
            ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from tag");
            int size = rs.getInt(1);
            System.out.println("size of all tags in tag table=" + size);
            if (this.tagTagIDMap == null || size / (this.tagTagIDMap.size() + 1) > 3) {
                this.tagTagIDMap = HashBiMap.create((int)size);
            }
            rs = this.connection.createStatement().executeQuery("select * from tag");
            try {
                rs.findColumn("tagName");
                hasName = true;
            }
            catch (SQLException e) {
                hasName = false;
            }
            while (rs.next()) {
                TagBuilder tagBuilder = TagBuilder.instance(rs.getBytes("sequence"), rs.getShort("seqlen"));
                if (hasName) {
                    tagBuilder.name(rs.getString("tagName"));
                }
                this.tagTagIDMap.putIfAbsent((Object)tagBuilder.build(), (Object)rs.getInt("tagid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadRefTagHash() {
        try {
            boolean hasName;
            ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from reftag");
            int size = rs.getInt(1);
            System.out.println("size of all tags in reftag table=" + size);
            if (this.reftagReftagIDMap == null || size / (this.reftagReftagIDMap.size() + 1) > 3) {
                this.reftagReftagIDMap = HashBiMap.create((int)size);
            }
            rs = this.connection.createStatement().executeQuery("select * from refTag");
            try {
                rs.findColumn("tagName");
                hasName = true;
            }
            catch (SQLException e) {
                hasName = false;
            }
            while (rs.next()) {
                TagBuilder tagBuilder = TagBuilder.instance(rs.getBytes("sequence"), rs.getShort("seqlen"));
                if (hasName) {
                    tagBuilder.name(rs.getString("tagName"));
                }
                Tag refTag = tagBuilder.build();
                String chrom = rs.getString("chromosome");
                int pos = rs.getInt("position");
                int refGenID = rs.getInt("refGenomeID");
                String refGenName = (String)this.referenceGenomeToIDMap.inverse().get((Object)refGenID);
                RefTagData rtd = new RefTagData(refTag, chrom, pos, refGenName);
                this.reftagReftagIDMap.putIfAbsent((Object)rtd, (Object)rs.getInt("reftagid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadPhysicalMapPositionHash() {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from physicalmapposition");
            int size = rs.getInt(1);
            System.out.println("Before loading new positions, size of all positions in physicalMapPosiiton table=" + size);
            if (this.physicalMapPositionToIDMap == null) {
                this.physicalMapPositionToIDMap = new TreeMap<Position, Integer>();
            } else if (size == this.physicalMapPositionToIDMap.size()) {
                return;
            }
            rs = this.connection.createStatement().executeQuery("select * from physicalMapPosition");
            while (rs.next()) {
                GeneralPosition p = new GeneralPosition.Builder(new Chromosome(rs.getString("chromosome")), rs.getInt("physical_position")).strand(rs.getByte("strand")).build();
                this.physicalMapPositionToIDMap.putIfAbsent(p, rs.getInt("posid"));
            }
            rs = this.connection.createStatement().executeQuery("select count(*) from physicalmapposition");
            size = rs.getInt(1);
            System.out.println("After loading new positions, size of all positions in physicalMapPosiiton table=" + size + ", size of physicalMapPositionToIDMAP: " + this.physicalMapPositionToIDMap.size());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadSNPPositionHash(boolean force) {
        if (force && this.snpPosToIDMap != null) {
            this.snpPosToIDMap.clear();
        }
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from snpposition");
            int size = rs.getInt(1);
            System.out.println("size of all positions in snpPosition table=" + size);
            if (this.snpPosToIDMap == null) {
                this.snpPosToIDMap = HashBiMap.create((int)size);
            } else if (size == this.snpPosToIDMap.size()) {
                return;
            }
            rs = this.connection.createStatement().executeQuery("select * from snpposition");
            while (rs.next()) {
                byte refAllele = (byte)rs.getInt("refAllele");
                GeneralPosition p = new GeneralPosition.Builder(new Chromosome(rs.getString("chromosome")), rs.getInt("position")).strand(rs.getByte("strand")).addAnno("QualityScore", Float.valueOf(rs.getFloat("qualityScore"))).allele(WHICH_ALLELE.Reference, refAllele).build();
                this.snpPosToIDMap.putIfAbsent((Object)p, (Object)rs.getInt("snpid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadAlleleHash() {
        try {
            this.loadSNPPositionHash(false);
            ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from allele");
            int size = rs.getInt(1);
            System.out.println("size of all alleles in allele table=" + size);
            if (this.alleleToIDMap == null) {
                this.alleleToIDMap = HashBiMap.create((int)size);
            }
            if (size == this.alleleToIDMap.size()) {
                return;
            }
            rs = this.connection.createStatement().executeQuery("select * from allele");
            while (rs.next()) {
                int snpid = rs.getInt("snpid");
                Position p = (Position)this.snpPosToIDMap.inverse().get((Object)snpid);
                SimpleAllele a = new SimpleAllele(rs.getByte("allelecall"), p);
                this.alleleToIDMap.putIfAbsent((Object)a, (Object)rs.getInt("alleleid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadReferenceGenomeHash() {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from referenceGenome");
            int size = rs.getInt(1);
            System.out.println("size of all references in referenceGenome table=" + size);
            if (size == 0) {
                this.connection.createStatement().executeUpdate("insert into referenceGenome (refname) values('unknown')");
                size = 1;
            }
            this.referenceGenomeToIDMap = HashBiMap.create((int)size);
            rs = this.connection.createStatement().executeQuery("select * from referenceGenome");
            while (rs.next()) {
                this.referenceGenomeToIDMap.put((Object)rs.getString("refname"), (Object)rs.getInt("refid"));
                System.out.println("refence name from referenceGenome: " + rs.getString("refname"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadMappingApproachHash() {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from mappingApproach");
            int size = rs.getInt(1);
            System.out.println("size of all approaches in mappingApproach table=" + size);
            if (size == 0) {
                this.connection.createStatement().executeUpdate("insert into mappingApproach (approach, software, protocols) values('unknown','unknown','unknown')");
                size = 1;
            }
            this.mappingApproachToIDMap = new HashMap<String, Integer>(size);
            rs = this.connection.createStatement().executeQuery("select * from mappingApproach");
            while (rs.next()) {
                this.mappingApproachToIDMap.put(rs.getString("approach"), rs.getInt("mapappid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadTaxaList() {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from taxa");
            int size = rs.getInt(1);
            System.out.println("size of all taxa in taxa table=" + size);
            TaxaListBuilder tlb = new TaxaListBuilder();
            rs = this.connection.createStatement().executeQuery("select * from taxa");
            while (rs.next()) {
                tlb.add(new Taxon(rs.getString("name")));
            }
            this.myTaxaList = tlb.build();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public TaxaList getTaxaList() {
        if (this.myTaxaList == null) {
            this.loadTaxaList();
        }
        return this.myTaxaList;
    }

    @Override
    public Map<Tag, String> getTagsNameMap() {
        try {
            HashMap<Tag, String> tagNameMap = new HashMap<Tag, String>(this.tagTagIDMap.size() + 1);
            ResultSet rs = this.connection.createStatement().executeQuery("select * from tag");
            while (rs.next()) {
                tagNameMap.put(TagBuilder.instance(rs.getBytes("sequence"), rs.getShort("seqlen")).build(), rs.getString("tagName"));
            }
            return tagNameMap;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean putAllTag(Set<Tag> tags, Map<Tag, Tuple<Integer, String>> tagInstanceAverageQS) {
        int batchCount = 0;
        int totalCount = 0;
        if (tagInstanceAverageQS != null) {
            try {
                this.connection.setAutoCommit(false);
                PreparedStatement tagInsertPS = this.connection.prepareStatement("insert into tag (sequence, seqlen,isReference,qualityScore,numTagInstances) values(?,?,?,?,?)");
                for (Map.Entry<Tag, Tuple<Integer, String>> entry : tagInstanceAverageQS.entrySet()) {
                    Tag tag = entry.getKey();
                    if (this.tagTagIDMap.containsKey((Object)tag)) continue;
                    int numInstances = (Integer)entry.getValue().x;
                    String qscore = (String)entry.getValue().y;
                    tagInsertPS.setBytes(1, tag.seq2BitAsBytes());
                    tagInsertPS.setShort(2, tag.seqLength());
                    tagInsertPS.setBoolean(3, tag.isReference());
                    tagInsertPS.setString(4, qscore);
                    tagInsertPS.setInt(5, numInstances);
                    tagInsertPS.addBatch();
                    ++totalCount;
                    if (++batchCount <= 10000) continue;
                    tagInsertPS.executeBatch();
                    batchCount = 0;
                }
                tagInsertPS.executeBatch();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement tagInsertPS = this.connection.prepareStatement("insert into tag (sequence, seqlen,isReference) values(?,?,?)");
            for (Tag tag : tags) {
                if (this.tagTagIDMap.containsKey((Object)tag)) continue;
                tagInsertPS.setBytes(1, tag.seq2BitAsBytes());
                tagInsertPS.setShort(2, tag.seqLength());
                tagInsertPS.setBoolean(3, tag.isReference());
                tagInsertPS.addBatch();
                ++totalCount;
                if (++batchCount <= 100000) continue;
                tagInsertPS.executeBatch();
                batchCount = 0;
            }
            tagInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        if (totalCount > 0) {
            System.out.println("RepGenSQLite:putAllTag, totalCount=" + totalCount + ",loadingHash");
            this.loadTagHash();
        }
        return true;
    }

    @Override
    public boolean putAllRefTag(Multimap<Tag, Position> refTagPositionMap, String refGenome) {
        int batchCount = 0;
        int totalCount = 0;
        try {
            this.connection.setAutoCommit(false);
            int refGenomeID = (Integer)this.referenceGenomeToIDMap.get((Object)refGenome);
            PreparedStatement refTagInsertPS = this.connection.prepareStatement("insert into reftag (sequence, seqlen, chromosome,position,refGenomeID) values(?,?,?,?,?)");
            for (Map.Entry entry : refTagPositionMap.entries()) {
                int posInt;
                Position pos;
                String chromosome;
                Tag tag = (Tag)entry.getKey();
                RefTagData rtd = new RefTagData(tag, chromosome = (pos = (Position)entry.getValue()).getChromosome().getName(), posInt = pos.getPosition(), refGenome);
                if (this.reftagReftagIDMap.containsKey((Object)rtd)) continue;
                refTagInsertPS.setBytes(1, tag.seq2BitAsBytes());
                refTagInsertPS.setShort(2, tag.seqLength());
                refTagInsertPS.setString(3, pos.getChromosome().getName());
                refTagInsertPS.setInt(4, pos.getPosition());
                refTagInsertPS.setInt(5, refGenomeID);
                refTagInsertPS.addBatch();
                ++totalCount;
                if (++batchCount <= 100000) continue;
                refTagInsertPS.executeBatch();
                batchCount = 0;
            }
            refTagInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        if (totalCount > 0) {
            System.out.println("RepGenSQLite:putAllRefTag, totalCount=" + totalCount + ",loadingHash\n");
            this.loadRefTagHash();
        }
        return true;
    }

    @Override
    public boolean putAllNamesTag(Map<Tag, String> tagNameMap) {
        int batchCount = 0;
        int totalCount = 0;
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement tagInsertPS = this.connection.prepareStatement("insert into tag (sequence, seqlen, tagName) values(?,?,?)");
            for (Map.Entry<Tag, String> entry : tagNameMap.entrySet()) {
                Tag tag = entry.getKey();
                if (this.tagTagIDMap.containsKey((Object)tag)) continue;
                tagInsertPS.setBytes(1, tag.seq2BitAsBytes());
                tagInsertPS.setShort(2, tag.seqLength());
                tagInsertPS.setString(3, entry.getValue());
                tagInsertPS.addBatch();
                ++totalCount;
                if (++batchCount <= 100000) continue;
                System.out.println("tagInsertPS.executeBatch() " + batchCount);
                tagInsertPS.executeBatch();
                batchCount = 0;
            }
            tagInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        if (totalCount > 0) {
            this.loadTagHash();
        }
        return true;
    }

    @Override
    public void putTaxaList(TaxaList taxaList) {
        try {
            this.connection.createStatement().execute("delete from taxa");
            this.connection.setAutoCommit(false);
            PreparedStatement taxaInsertPS = this.connection.prepareStatement("insert into taxa (taxonid, name) values(?,?)");
            for (int i = 0; i < taxaList.size(); ++i) {
                taxaInsertPS.setInt(1, i);
                taxaInsertPS.setString(2, ((Taxon)taxaList.get(i)).getName());
                taxaInsertPS.addBatch();
            }
            taxaInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
            this.loadTaxaList();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void putTaxaDistribution(Map<Tag, TaxaDistribution> tagTaxaDistributionMap) {
        int batchCount = 0;
        try {
            int numTaxa = this.myTaxaList.numberOfTaxa();
            this.connection.setAutoCommit(false);
            PreparedStatement tagInsertPS = this.connection.prepareStatement("insert into tagtaxadistribution (tagid, depthsRLE, totalDepth) values(?,?,?)");
            for (Map.Entry<Tag, TaxaDistribution> entry : tagTaxaDistributionMap.entrySet()) {
                int tagID = (Integer)this.tagTagIDMap.get((Object)entry.getKey());
                tagInsertPS.setInt(1, tagID);
                if (entry.getValue().maxTaxa() != numTaxa) {
                    throw new IllegalStateException("Number of taxa does not agree with taxa distribution");
                }
                tagInsertPS.setBytes(2, entry.getValue().encodeTaxaDepth());
                tagInsertPS.setInt(3, entry.getValue().totalDepth());
                tagInsertPS.addBatch();
                if (++batchCount <= 100000) continue;
                System.out.println("putTaxaDistribution next" + batchCount);
                tagInsertPS.executeBatch();
                batchCount = 0;
            }
            tagInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void putTagTagAlignments(Multimap<Tag, AlignmentInfo> tagAlignInfoMap) {
        int batchCount = 0;
        try {
            this.connection.setAutoCommit(false);
            for (Map.Entry entry : tagAlignInfoMap.entries()) {
                AlignmentInfo ai = (AlignmentInfo)entry.getValue();
                int ind = 1;
                this.tagtagAlignmentInsertPS.setInt(ind++, (Integer)this.tagTagIDMap.get(entry.getKey()));
                this.tagtagAlignmentInsertPS.setInt(ind++, (Integer)this.tagTagIDMap.get((Object)ai.tag2()));
                this.tagtagAlignmentInsertPS.setInt(ind++, ai.score());
                this.tagtagAlignmentInsertPS.addBatch();
                if (++batchCount <= 100000) continue;
                this.tagtagAlignmentInsertPS.executeBatch();
                batchCount = 0;
            }
            this.tagtagAlignmentInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
            ResultSet rs = this.connection.createStatement().executeQuery("select count (*) as numAlignments from tag_tag_Alignments");
            if (rs.next()) {
                System.out.println("Total alignments in tag_tag_Alignments table: " + rs.getInt("numAlignments"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void putTagRefTagAlignments(Multimap<Tag, AlignmentInfo> tagAlignInfoMap, String refGenome) {
        int batchCount = 0;
        try {
            this.connection.setAutoCommit(false);
            for (Map.Entry entry : tagAlignInfoMap.entries()) {
                AlignmentInfo ai = (AlignmentInfo)entry.getValue();
                int ind = 1;
                this.tagReftagAlignmentInsertPS.setInt(ind++, (Integer)this.tagTagIDMap.get(entry.getKey()));
                RefTagData rtd = new RefTagData(ai.tag2(), ai.tag2chrom(), ai.tag2pos(), refGenome);
                this.tagReftagAlignmentInsertPS.setInt(ind++, (Integer)this.reftagReftagIDMap.get((Object)rtd));
                this.tagReftagAlignmentInsertPS.setInt(ind++, ai.score());
                this.tagReftagAlignmentInsertPS.setInt(ind++, ai.alignmentPos());
                this.tagReftagAlignmentInsertPS.setInt(ind++, ai.ref_strand());
                this.tagReftagAlignmentInsertPS.addBatch();
                if (++batchCount <= 100000) continue;
                this.tagReftagAlignmentInsertPS.executeBatch();
                batchCount = 0;
            }
            this.tagReftagAlignmentInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
            ResultSet rs = this.connection.createStatement().executeQuery("select count (*) as numAlignments from tag_reftag_Alignments");
            if (rs.next()) {
                System.out.println("Total alignments in tag_RefTag_Alignments table: " + rs.getInt("numAlignments"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void putRefRefAlignments(Multimap<RefTagData, AlignmentInfo> tagAlignInfoMap, String refGenome) {
        int batchCount = 0;
        try {
            this.connection.setAutoCommit(false);
            for (Map.Entry entry : tagAlignInfoMap.entries()) {
                AlignmentInfo ai = (AlignmentInfo)entry.getValue();
                int ind = 1;
                this.refRefAlignmentInsertPS.setInt(ind++, (Integer)this.reftagReftagIDMap.get(entry.getKey()));
                RefTagData rtd = new RefTagData(ai.tag2(), ai.tag2chrom(), ai.tag2pos(), refGenome);
                this.refRefAlignmentInsertPS.setInt(ind++, (Integer)this.reftagReftagIDMap.get((Object)rtd));
                this.refRefAlignmentInsertPS.setInt(ind++, ai.score());
                this.refRefAlignmentInsertPS.addBatch();
                if (++batchCount <= 10000) continue;
                this.refRefAlignmentInsertPS.executeBatch();
                batchCount = 0;
            }
            this.refRefAlignmentInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
            ResultSet rs = this.connection.createStatement().executeQuery("select count (*) as numAlignments from reftag_reftag_Alignments");
            if (rs.next()) {
                System.out.println("Total number of alignments in reftag_reftag_alignments table: " + rs.getInt("numAlignments"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void putRefTagMapping(Multimap<Tag, Position> refTagPositionMap, String refGenome) {
        int batchCount = 0;
        this.loadReferenceGenomeHash();
        try {
            this.putAllRefTag(refTagPositionMap, refGenome);
            System.out.println("putREfTagMaping: size of map: " + refTagPositionMap.size() + ", keyset size: " + refTagPositionMap.keySet().size() + ", values size: " + refTagPositionMap.values().size());
            this.putPhysicalMapPositionsIfAbsent(refTagPositionMap.values(), refGenome);
            this.connection.setAutoCommit(false);
            for (Map.Entry entry : refTagPositionMap.entries()) {
                Position entrypos = (Position)entry.getValue();
                int ind = 1;
                RefTagData rtd = new RefTagData((Tag)entry.getKey(), entrypos.getChromosome().getName(), entrypos.getPosition(), refGenome);
                this.posTagMappingInsertPS.setInt(ind++, (Integer)this.reftagReftagIDMap.get((Object)rtd));
                this.posTagMappingInsertPS.setInt(ind++, (Integer)this.physicalMapPositionToIDMap.get(entrypos));
                this.posTagMappingInsertPS.setInt(ind++, this.getMappingApproachID(entrypos));
                this.posTagMappingInsertPS.setInt(ind++, 0);
                this.posTagMappingInsertPS.setFloat(ind++, 0.0f);
                this.posTagMappingInsertPS.addBatch();
                if (++batchCount <= 10000) continue;
                this.posTagMappingInsertPS.executeBatch();
                batchCount = 0;
            }
            this.posTagMappingInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
            ResultSet rs = this.connection.createStatement().executeQuery("select count (DISTINCT physical_position) as numPhysicalSites from physicalMapPosition");
            if (rs.next()) {
                System.out.println("Total number of distinct physical position sites: " + rs.getInt("numPhysicalSites"));
            }
            if ((rs = this.connection.createStatement().executeQuery("select count (*) as numPhysicalSites from physicalMapPosition")).next()) {
                System.out.println("Total number of physical position sites: " + rs.getInt("numPhysicalSites"));
            }
            PreparedStatement physMapNumFromTCPMP = this.connection.prepareStatement("select count(*) as numSites from (select count(*) as tgcnt,physical_position from physicalMapPosition GROUP BY physical_position) where tgcnt=?");
            physMapNumFromTCPMP.setInt(1, 1);
            rs = physMapNumFromTCPMP.executeQuery();
            if (rs.next()) {
                System.out.println("Number of physical position sites with 1 tag: " + rs.getInt("numSites"));
            }
            physMapNumFromTCPMP.setInt(1, 2);
            rs = physMapNumFromTCPMP.executeQuery();
            if (rs.next()) {
                System.out.println("Number of physical position sites with 2 tags: " + rs.getInt("numSites"));
            }
            physMapNumFromTCPMP.setInt(1, 3);
            rs = physMapNumFromTCPMP.executeQuery();
            if (rs.next()) {
                System.out.println("Number of physical position sites with 3 tags: " + rs.getInt("numSites"));
            }
            PreparedStatement cutSiteGreaterThanPS = this.connection.prepareStatement("select count(*) as numSites from (select count(*) as tgcnt,physical_position from physicalMapPosition GROUP BY physical_position) where tgcnt>?");
            cutSiteGreaterThanPS.setInt(1, 3);
            rs = cutSiteGreaterThanPS.executeQuery();
            if (rs.next()) {
                System.out.println("Number of cut sites with more than 3 tags: " + rs.getInt("numSites"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void putSNPQualityProfile(Map<Position, Map<String, Double>> tagAnnotatedPositionMap, String taxaSubset) {
        int batchCount = 0;
        try {
            this.putSNPPositionsIfAbsent(tagAnnotatedPositionMap.keySet());
            this.connection.setAutoCommit(false);
            for (Map.Entry<Position, Map<String, Double>> entry : tagAnnotatedPositionMap.entrySet()) {
                Position p = entry.getKey();
                Map<String, Double> vals = entry.getValue();
                int ind = 1;
                this.snpQualityInsertPS.setInt(ind++, (Integer)this.snpPosToIDMap.get((Object)p));
                this.snpQualityInsertPS.setString(ind++, taxaSubset);
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("avgDepth", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("minorDepthProp", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("minor2DepthProp", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("gapDepthProp", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("propCovered", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("propCovered2", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("taxaCntWithMinorAlleleGE2", 0.0));
                if (vals.containsKey("minorAlleleFreqGE2")) {
                    this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("minorAlleleFreqGE2", 0.0));
                    this.snpQualityInsertPS.setDouble(ind++, (Double)vals.getOrDefault("inbredF_DGE2", null));
                } else {
                    this.snpQualityInsertPS.setDouble(ind++, 0.0);
                    this.snpQualityInsertPS.setDouble(ind++, Double.NaN);
                }
                this.snpQualityInsertPS.addBatch();
                if (++batchCount <= 10000) continue;
                System.out.println("putSNPQualityProfile next" + batchCount);
                this.snpQualityInsertPS.executeBatch();
                batchCount = 0;
            }
            this.snpQualityInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void putSNPQualityProfile(Map<Position, Map<String, Double>> tagAnnotatedPositionMap, String taxaSubset, int counter) throws SQLException {
        try {
            this.putSNPPositionsIfAbsent(tagAnnotatedPositionMap.keySet());
            this.connection.setAutoCommit(false);
            for (Map.Entry<Position, Map<String, Double>> entry : tagAnnotatedPositionMap.entrySet()) {
                Position p = entry.getKey();
                Map<String, Double> vals = entry.getValue();
                int ind = 1;
                this.snpQualityInsertPS.setInt(ind++, (Integer)this.snpPosToIDMap.get((Object)p));
                this.snpQualityInsertPS.setString(ind++, taxaSubset);
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("avgDepth", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("minorDepthProp", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("minor2DepthProp", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("gapDepthProp", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("propCovered", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("propCovered2", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("taxaCntWithMinorAlleleGE2", 0.0));
                if (vals.containsKey("minorAlleleFreqGE2")) {
                    this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("minorAlleleFreqGE2", 0.0));
                    this.snpQualityInsertPS.setDouble(ind++, (Double)vals.getOrDefault("inbredF_DGE2", null));
                } else {
                    this.snpQualityInsertPS.setDouble(ind++, 0.0);
                    this.snpQualityInsertPS.setDouble(ind++, Double.NaN);
                }
                if (counter == -1) {
                    this.snpQualityInsertPS.executeBatch();
                    this.connection.setAutoCommit(true);
                    continue;
                }
                this.snpQualityInsertPS.addBatch();
                if (counter % 10000 != 0) continue;
                this.snpQualityInsertPS.executeBatch();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private int getMappingApproachID(Position p) throws SQLException {
        String mapApp = p.getAnnotation().getTextAnnotation("mappingapproach")[0];
        if (mapApp == null) {
            return this.mappingApproachToIDMap.get("unknown");
        }
        Integer val = this.mappingApproachToIDMap.get(mapApp);
        if (val == null) {
            this.connection.createStatement().executeUpdate("insert into mappingApproach (approach, software, protocols) values('" + mapApp + "','unknown','unknown')");
            this.loadMappingApproachHash();
            return this.mappingApproachToIDMap.get(mapApp);
        }
        return val;
    }

    private int getReferenceGenomeID(String refGenome) throws SQLException {
        Integer val = (Integer)this.referenceGenomeToIDMap.get((Object)refGenome);
        if (val == null) {
            this.connection.createStatement().executeUpdate("insert into referenceGenome (refname) values('" + refGenome + "')");
            this.loadReferenceGenomeHash();
            return (Integer)this.referenceGenomeToIDMap.get((Object)refGenome);
        }
        return val;
    }

    @Override
    public void addReferenceGenome(String name) {
        Integer val = this.mappingApproachToIDMap.get(name);
        if (val == null) {
            try {
                this.connection.createStatement().executeUpdate("insert or ignore into referenceGenome (refname) values('" + name + "')");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.loadReferenceGenomeHash();
        }
    }

    @Override
    public void addMappingApproach(String name) {
        Integer val = this.mappingApproachToIDMap.get(name);
        if (val == null) {
            try {
                this.connection.createStatement().executeUpdate("insert into mappingApproach (approach, software, protocols) values('" + name + "','unknown','unknown')");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.loadMappingApproachHash();
        }
    }

    @Override
    public void setTagAlignmentBest(Tag tag, Position position, boolean isBest) {
    }

    @Override
    public boolean putTagAlleles(Multimap<Tag, Allele> tagAlleleMap) {
        int batchCount = 0;
        try {
            PreparedStatement alleleTagInsertPS = this.connection.prepareStatement("INSERT OR IGNORE into tagallele (alleleid, tagid) values(?,?)");
            this.putAllTag(tagAlleleMap.keySet(), null);
            this.loadSNPPositionHash(false);
            this.putSNPPositionsIfAbsent(tagAlleleMap.values().stream().map(a -> a.position()).distinct().collect(Collectors.toSet()));
            this.putAlleleIfAbsent(tagAlleleMap.values().stream().distinct().collect(Collectors.toSet()));
            this.connection.setAutoCommit(false);
            for (Map.Entry tagAlleleEntry : tagAlleleMap.entries()) {
                int ind = 1;
                alleleTagInsertPS.setInt(ind++, (Integer)this.alleleToIDMap.get(tagAlleleEntry.getValue()));
                alleleTagInsertPS.setInt(ind++, (Integer)this.tagTagIDMap.get(tagAlleleEntry.getKey()));
                alleleTagInsertPS.addBatch();
                if (++batchCount <= 10000) continue;
                System.out.println("alleleTagInsertPS next" + batchCount);
                alleleTagInsertPS.executeBatch();
                batchCount = 0;
            }
            alleleTagInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean putTagAlignmentApproach(String tagAlignmentName, String protocol) {
        return false;
    }

    @Override
    public TaxaDistribution getTaxaDistribution(Tag tag) {
        int tagid = (Integer)this.tagTagIDMap.get((Object)tag);
        try {
            this.tagTaxaDistPS.setInt(1, tagid);
            ResultSet rs = this.tagTaxaDistPS.executeQuery();
            return TaxaDistBuilder.create(rs.getBytes(1));
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Set<Allele> getAlleles(Tag tag) {
        if (this.alleleToIDMap == null) {
            this.loadAlleleHash();
        }
        ImmutableSet.Builder alleleBuilder = new ImmutableSet.Builder();
        try {
            this.allelePairWithTagid1PS.setInt(1, (Integer)this.tagTagIDMap.get((Object)tag));
            ResultSet rs = this.allelePairWithTagid1PS.executeQuery();
            while (rs.next()) {
                alleleBuilder.add(this.alleleToIDMap.inverse().get((Object)rs.getInt("alleleid")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return alleleBuilder.build();
    }

    @Override
    public Multimap<Tag, Allele> getAlleleMap() {
        if (this.alleleToIDMap == null) {
            this.loadAlleleHash();
        }
        ImmutableMultimap.Builder tagAlleleBuilder = new ImmutableMultimap.Builder();
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select * from tagallele");
            while (rs.next()) {
                tagAlleleBuilder.put(this.tagTagIDMap.inverse().get((Object)rs.getInt("tagid")), this.alleleToIDMap.inverse().get((Object)rs.getInt("alleleid")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tagAlleleBuilder.build();
    }

    @Override
    public Set<Tag> getTagsForAllele(Position position, byte allele) {
        return this.getTagsForAllele(new SimpleAllele(allele, position));
    }

    @Override
    public Set<Tag> getTagsForAllele(Allele allele) {
        return null;
    }

    public Stream<ImmutableMultimap<Allele, TaxaDistribution>> getAllAllelesTaxaDistForSNP() {
        if (this.snpPosToIDMap == null) {
            this.loadSNPPositionHash(false);
        }
        Stream<ImmutableMultimap<Allele, TaxaDistribution>> stream = SQL.stream(this.connection, "select a.*, td.* from allele a, tagallele ta, tagtaxadistribution td\nwhere a.alleleid=ta.alleleid and ta.tagid=td.tagid order by a.snpid", new Object[0]).map(entry -> {
            ImmutableMultimap.Builder atdBuilder = ImmutableMultimap.builder();
            Position pos = (Position)this.snpPosToIDMap.inverse().get((Object)entry.asInt("snpid"));
            SimpleAllele allele = new SimpleAllele((byte)entry.asInt("allelecall"), pos);
            byte[] byteArray = (byte[])entry.val("depthsRLE").get();
            atdBuilder.put((Object)allele, (Object)TaxaDistBuilder.create(byteArray));
            return atdBuilder.build();
        });
        return stream;
    }

    public Stream<Map.Entry<Allele, TaxaDistribution>> getAllAllelesTaxaDistForSNPEntries() {
        if (this.snpPosToIDMap == null) {
            this.loadSNPPositionHash(false);
        }
        Stream<Map.Entry<Allele, TaxaDistribution>> stream = SQL.stream(this.connection, "select a.snpid, a.allelecall, td.depthsRLE from allele a, tagallele ta, tagtaxadistribution td\nwhere td.tagid = ta.tagid AND a.alleleid = ta.alleleid order by a.snpid", new Object[0]).map(entry -> {
            Position pos = (Position)this.snpPosToIDMap.inverse().get((Object)entry.asInt("snpid"));
            SimpleAllele allele = new SimpleAllele((byte)entry.asInt("allelecall"), pos);
            byte[] byteArray = (byte[])entry.val("depthsRLE").get();
            return new AbstractMap.SimpleEntry<SimpleAllele, TaxaDistribution>(allele, TaxaDistBuilder.create(byteArray));
        });
        return stream;
    }

    @Override
    public Set<Tag> getTags() {
        return this.tagTagIDMap.keySet();
    }

    @Override
    public Set<RefTagData> getRefTags() {
        return this.reftagReftagIDMap.keySet();
    }

    @Override
    public PositionList getPhysicalMapPositions() {
        if (this.physicalMapPositionToIDMap == null) {
            this.loadPhysicalMapPositionHash();
        }
        PositionListBuilder plb = new PositionListBuilder();
        this.physicalMapPositionToIDMap.keySet().stream().forEach(p -> plb.add((Position)p));
        plb.sortPositions();
        return plb.build();
    }

    @Override
    public PositionList getPhysicalMapPositions(Chromosome chromosome, int firstPosition, int lastPosition) {
        PositionListBuilder plb = new PositionListBuilder();
        plb.addAll(this.getPositionSubMap(chromosome, firstPosition, lastPosition).keySet());
        return plb.build();
    }

    @Override
    public PositionList getSNPPositions() {
        if (this.snpPosToIDMap == null) {
            this.loadSNPPositionHash(false);
        }
        return new PositionListBuilder().addAll(this.snpPosToIDMap.keySet()).build();
    }

    @Override
    public PositionList getSNPPositions(int minSupportValue) {
        return null;
    }

    @Override
    public PositionList getSNPPositions(double minQualityScore) {
        if (minQualityScore == 0.0) {
            return this.getSNPPositions();
        }
        if (this.snpPosToIDMap == null) {
            this.loadSNPPositionHash(false);
        }
        PositionListBuilder plb = new PositionListBuilder();
        this.snpPosToIDMap.keySet().stream().forEach(pos -> {
            double[] qs = pos.getAnnotation().getQuantAnnotation("QualityScore");
            if (qs != null && qs.length > 0 && qs[0] >= minQualityScore) {
                plb.add((Position)pos);
            }
        });
        return plb.build();
    }

    @Override
    public Set<Tag> getTagsForTaxon(Taxon taxon) {
        ImmutableSet.Builder tagBuilder = new ImmutableSet.Builder();
        int taxonIndex = this.myTaxaList.indexOf(taxon);
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select * from tagtaxadistribution");
            while (rs.next()) {
                if (TaxaDistBuilder.create(rs.getBytes("depthsRLE")).depths()[taxonIndex] <= 0) continue;
                tagBuilder.add(this.tagTagIDMap.inverse().get((Object)rs.getInt("tagid")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tagBuilder.build();
    }

    @Override
    public Map<Tag, Integer> getTagDepth(Taxon taxon, Position position) {
        return null;
    }

    @Override
    public Map<Tag, Integer> getTagsWithDepth(int minimumDepth) {
        ImmutableMap.Builder tagBuilder = new ImmutableMap.Builder();
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select tagid, totalDepth from tagtaxadistribution where totalDepth >= " + minimumDepth);
            while (rs.next()) {
                tagBuilder.put(this.tagTagIDMap.inverse().get((Object)rs.getInt(1)), (Object)rs.getInt(2));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tagBuilder.build();
    }

    @Override
    public PositionList getTagCutPositions(Chromosome chromosome, int firstPosition, int lastPosition, boolean onlyBest) {
        PositionListBuilder plb = new PositionListBuilder();
        plb.addAll(this.getPositionSubMap(chromosome, firstPosition, lastPosition).keySet());
        return plb.build();
    }

    @Override
    public Map<Tag, Position> getTagCutPosition(Set<Tag> tagSet) {
        ImmutableMap.Builder tagPosBuilder = new ImmutableMap.Builder();
        for (Tag tag : tagSet) {
            int tagID = (Integer)this.tagTagIDMap.get((Object)tag);
            try {
                ResultSet rs = this.connection.createStatement().executeQuery("select cp.*, tcp.* from cutposition cp, tag t, tagCutPosition tcp where tcp.tagid=t.tagid and tcp.positionid=cp.positionid and t.tagid= " + tagID);
                while (rs.next()) {
                    GeneralPosition cutPos = new GeneralPosition.Builder(new Chromosome(rs.getString("chromosome")), rs.getInt("position")).strand(rs.getByte("strand")).addAnno("forward", rs.getBoolean("forward") ? "true" : "false").build();
                    tagPosBuilder.put((Object)tag, (Object)cutPos);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
        }
        return tagPosBuilder.build();
    }

    private Map<Position, Integer> getPositionSubMap(Chromosome chromosome, int firstPosition, int lastPosition) {
        if (this.physicalMapPositionToIDMap == null) {
            this.loadPhysicalMapPositionHash();
        }
        GeneralPosition startPos = new GeneralPosition.Builder(chromosome, firstPosition).build();
        if (lastPosition < 0) {
            lastPosition = Integer.MAX_VALUE;
        }
        GeneralPosition lastPos = new GeneralPosition.Builder(chromosome, lastPosition).build();
        return this.physicalMapPositionToIDMap.subMap(startPos, lastPos);
    }

    @Override
    public Map<String, String> getTagAlignmentApproaches() {
        ImmutableMap.Builder appBuilder = new ImmutableMap.Builder();
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select * from mappingApproach");
            while (rs.next()) {
                appBuilder.put((Object)rs.getString("approach"), (Object)(rs.getString("software") + ":" + rs.getString("approach")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return appBuilder.build();
    }

    @Override
    public Map<Position, Map<Tag, Tuple<Boolean, TaxaDistribution>>> getCutPositionTagTaxaMap(Chromosome chromosome, int firstPosition, int lastPosition) {
        String sqlQuery = "select p.positionid, forward, chromosome, position, strand, t.tagid, depthsRLE  from tag t, cutposition p, tagCutPosition tc, tagtaxadistribution ttd where p.positionid=tc.positionid and tc.tagid=t.tagid and t.tagid=ttd.tagid and chromosome='" + chromosome.toString() + "' order by position";
        HashMap<Position, Map<Tag, Tuple<Boolean, TaxaDistribution>>> positionTagTaxaMap = new HashMap<Position, Map<Tag, Tuple<Boolean, TaxaDistribution>>>();
        HashMap tempPositionMap = new HashMap();
        this.getPositionSubMap(chromosome, firstPosition, lastPosition).entrySet().stream().forEach(entry -> {
            Position cfr_ignored_0 = (Position)tempPositionMap.put(entry.getValue(), entry.getKey());
        });
        int totalTagsAdded = 0;
        try {
            ResultSet rs = this.connection.createStatement().executeQuery(sqlQuery);
            while (rs.next()) {
                Position position = (Position)tempPositionMap.get(rs.getInt("positionid"));
                Tag tag = (Tag)this.tagTagIDMap.inverse().get((Object)rs.getInt("tagid"));
                TaxaDistribution taxaDistribution = TaxaDistBuilder.create(rs.getBytes("depthsRLE"));
                Boolean forwardAlignDirection = rs.getBoolean("forward");
                Map tagTaxaMap = positionTagTaxaMap.computeIfAbsent(position, k -> new HashMap());
                tagTaxaMap.put(tag, new Tuple<Boolean, TaxaDistribution>(forwardAlignDirection, taxaDistribution));
                ++totalTagsAdded;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        System.out.println("positionTagTaxaMap = " + positionTagTaxaMap.size() + " totalTagsAdded: " + totalTagsAdded);
        return positionTagTaxaMap;
    }

    @Override
    public Map<Position, Map<Tag, TaxaDistribution>> getCutPosForStrandTagTaxaMap(Chromosome chromosome, int firstPosition, int lastPosition, boolean direction) {
        String sqlQuery = "select p.positionid, forward, chromosome, position, strand, t.tagid, depthsRLE  from tag t, cutposition p, tagCutPosition tc, tagtaxadistribution ttd where p.positionid=tc.positionid and tc.tagid=t.tagid and t.tagid=ttd.tagid and chromosome='" + chromosome.toString() + "' order by position";
        HashMap<Position, Map<Tag, TaxaDistribution>> positionTagTaxaMap = new HashMap<Position, Map<Tag, TaxaDistribution>>();
        HashMap tempPositionMap = new HashMap();
        this.getPositionSubMap(chromosome, firstPosition, lastPosition).entrySet().stream().forEach(entry -> {
            Position cfr_ignored_0 = (Position)tempPositionMap.put(entry.getValue(), entry.getKey());
        });
        int totalTagsAdded = 0;
        try {
            ResultSet rs = this.connection.createStatement().executeQuery(sqlQuery);
            while (rs.next()) {
                Boolean forwardAlignDirection = rs.getBoolean("forward");
                if (forwardAlignDirection != direction) continue;
                Position position = (Position)tempPositionMap.get(rs.getInt("positionid"));
                Tag tag = (Tag)this.tagTagIDMap.inverse().get((Object)rs.getInt("tagid"));
                TaxaDistribution taxaDistribution = TaxaDistBuilder.create(rs.getBytes("depthsRLE"));
                Map tagTaxaMap = positionTagTaxaMap.computeIfAbsent(position, k -> new HashMap());
                tagTaxaMap.put(tag, taxaDistribution);
                ++totalTagsAdded;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        System.out.println("positionTagTaxaMap size, forwardStrand, " + direction + " size:" + positionTagTaxaMap.size() + " totalTagsAdded:" + totalTagsAdded);
        return positionTagTaxaMap;
    }

    private void putPhysicalMapPositionsIfAbsent(Collection<Position> positions, String refGenome) {
        try {
            int batchCount = 0;
            int positionExists = 0;
            int newPosition = 0;
            if (this.physicalMapPositionToIDMap == null) {
                this.loadPhysicalMapPositionHash();
            }
            this.connection.setAutoCommit(false);
            System.out.println("putPhysicalMapPositionsIfAbsent: size of positions: " + positions.size());
            PreparedStatement posInsertPS = this.connection.prepareStatement("INSERT OR IGNORE into physicalMapPosition (reference_genome_id, chromosome, physical_position, strand) values(?,?,?,?)");
            for (Position p : positions) {
                if (this.physicalMapPositionToIDMap.containsKey(p)) {
                    ++positionExists;
                    continue;
                }
                ++newPosition;
                posInsertPS.setInt(1, this.getReferenceGenomeID(refGenome));
                posInsertPS.setString(2, p.getChromosome().getName());
                posInsertPS.setInt(3, p.getPosition());
                posInsertPS.setByte(4, p.getStrand());
                posInsertPS.addBatch();
                if (++batchCount <= 10000) continue;
                System.out.println("putPhysicalMapPositionsIfAbsent next" + batchCount);
                posInsertPS.executeBatch();
                batchCount = 0;
            }
            posInsertPS.executeBatch();
            if (batchCount > 0) {
                this.loadPhysicalMapPositionHash();
            }
            this.connection.setAutoCommit(true);
            System.out.println("putPhysicalMapPositionsIfAbsent: end, positionExists: " + positionExists + ", newPositions: " + newPosition);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void putSNPPositionsIfAbsent(Collection<Position> positions) {
        try {
            int batchCount = 0;
            if (this.snpPosToIDMap == null) {
                this.loadSNPPositionHash(false);
            }
            this.connection.setAutoCommit(false);
            PreparedStatement snpPosInsertPS = this.connection.prepareStatement("INSERT OR IGNORE into snpposition (chromosome, position, strand,qualityScore,refAllele) values(?,?,?,?,?)");
            for (Position p : positions) {
                if (this.snpPosToIDMap.containsKey((Object)p)) continue;
                snpPosInsertPS.setString(1, p.getChromosome().toString());
                snpPosInsertPS.setInt(2, p.getPosition());
                snpPosInsertPS.setByte(3, p.getStrand());
                double[] qsList = p.getAnnotation().getQuantAnnotation("QualityScore");
                if (qsList != null & qsList.length > 0) {
                    snpPosInsertPS.setFloat(4, (float)qsList[0]);
                } else {
                    snpPosInsertPS.setFloat(4, 0.0f);
                }
                snpPosInsertPS.setByte(5, p.getAllele(WHICH_ALLELE.Reference));
                snpPosInsertPS.addBatch();
                if (++batchCount <= 10000) continue;
                System.out.println("putSNPPositionsIfAbsent next" + batchCount);
                snpPosInsertPS.executeBatch();
                batchCount = 0;
            }
            snpPosInsertPS.executeBatch();
            if (batchCount > 0) {
                this.loadSNPPositionHash(false);
            }
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void putAlleleIfAbsent(Collection<Allele> alleles) throws IllegalStateException {
        try {
            int batchCount = 0;
            PreparedStatement alleleInsertPS = this.connection.prepareStatement("INSERT OR IGNORE into allele (snpid, allelecall, qualityscore) values(?,?,?)");
            this.connection.setAutoCommit(false);
            for (Allele allele : alleles) {
                Integer snpID = (Integer)this.snpPosToIDMap.get((Object)allele.position());
                if (snpID == null) {
                    throw new IllegalStateException("SNP position missing for allele");
                }
                int index = 1;
                alleleInsertPS.setInt(index++, snpID);
                alleleInsertPS.setByte(index++, allele.allele());
                alleleInsertPS.setByte(index++, (byte)0);
                alleleInsertPS.addBatch();
                if (++batchCount <= 10000) continue;
                System.out.println("putAlleleIfAbsent next" + batchCount);
                alleleInsertPS.executeBatch();
                batchCount = 0;
            }
            alleleInsertPS.executeBatch();
            if (batchCount > 0) {
                this.loadAlleleHash();
            }
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public PositionList getSNPPositionsForChromosomes(Integer startChr, Integer endChr) {
        PositionListBuilder plb = new PositionListBuilder();
        if (startChr < 1 || endChr < 1 || startChr > endChr) {
            System.err.printf("getSNPPOsitionsForChromosomes:  bad Chromosome values: startChr %d, endChr %d\n", startChr, endChr);
            return null;
        }
        try {
            for (int chrom = startChr.intValue(); chrom <= endChr; ++chrom) {
                this.snpPositionsForChromosomePS.setString(1, Integer.toString(chrom));
                ResultSet rs = this.snpPositionsForChromosomePS.executeQuery();
                while (rs.next()) {
                    Chromosome chr = new Chromosome(Integer.toString(chrom));
                    byte refAllele = (byte)rs.getInt("refAllele");
                    GeneralPosition position = new GeneralPosition.Builder(chr, rs.getInt("position")).addAnno("QualityScore", Float.valueOf(rs.getFloat("qualityScore"))).allele(WHICH_ALLELE.Reference, refAllele).build();
                    plb.add(position);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return plb.build();
    }

    @Override
    public void putSNPPositionQS(PositionList qsPL) {
        int batchCount = 0;
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement qsUpdatePS = this.connection.prepareStatement("update snpposition set qualityScore = ? where chromosome = ? and position = ?");
            for (Position qsPos : qsPL) {
                double qscore = 0.0;
                double[] qs = qsPos.getAnnotation().getQuantAnnotation("QualityScore");
                if (qs != null && qs.length > 0) {
                    qscore = qs[0];
                }
                qsUpdatePS.setFloat(1, (float)qscore);
                qsUpdatePS.setString(2, qsPos.getChromosome().getName());
                qsUpdatePS.setInt(3, qsPos.getPosition());
                qsUpdatePS.addBatch();
                if (++batchCount <= 100000) continue;
                System.out.println("updateSNPPosition next " + batchCount);
                qsUpdatePS.executeBatch();
                batchCount = 0;
            }
            qsUpdatePS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            System.out.println("Error executing UPDATE statement for TagDataSQLite:putSNPQualityPositions");
            e.printStackTrace();
        }
        this.loadSNPPositionHash(true);
    }

    @Override
    public ListMultimap<String, Tuple<Integer, Float>> getSNPPositionQS(HashMultimap<String, Integer> myMap) {
        ImmutableListMultimap.Builder qsMap = new ImmutableListMultimap.Builder().orderKeysBy((Comparator)Ordering.natural()).orderKeysBy((Comparator)Ordering.natural());
        boolean batchCount = false;
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement dbTestPS = this.connection.prepareStatement("select qualityScore from snpposition where chromosome = ? and position = ?");
            for (Map.Entry entry : myMap.entries()) {
                String chrom = (String)entry.getKey();
                Integer posQS = (Integer)entry.getValue();
                dbTestPS.setString(1, chrom);
                dbTestPS.setInt(2, posQS);
                ResultSet rs = dbTestPS.executeQuery();
                while (rs.next()) {
                    Float myQual = Float.valueOf(rs.getFloat("qualityScore"));
                    Tuple<Integer, Float> myTuple = new Tuple<Integer, Float>(posQS, myQual);
                    qsMap.put((Object)chrom, myTuple);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
        return qsMap.build();
    }

    @Override
    public List<Chromosome> getChromosomesFromCutPositions() {
        ArrayList<Chromosome> chromList = new ArrayList<Chromosome>();
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select DISTINCT chromosome from cutPosition");
            while (rs.next()) {
                Chromosome chrom = new Chromosome(rs.getString("chromosome"));
                chromList.add(chrom);
            }
        }
        catch (SQLException exc) {
            exc.printStackTrace();
            return null;
        }
        return chromList;
    }

    @Override
    public void clearTagTaxaDistributionData() {
        try {
            boolean rs = this.connection.createStatement().execute("delete FROM tagtaxadistribution");
            rs = this.connection.createStatement().execute("delete FROM tag");
            this.tagTagIDMap = null;
            this.loadTagHash();
        }
        catch (SQLException exc) {
            System.out.println("ERROR - problem deleting tagtaxadistribution data");
            exc.printStackTrace();
        }
    }

    @Override
    public void clearAlignmentData() {
        try {
            boolean rs = this.connection.createStatement().execute("delete FROM tagCutPosition");
            rs = this.connection.createStatement().execute("delete FROM cutPosition");
            rs = this.connection.createStatement().execute("delete FROM mappingApproach");
            this.physicalMapPositionToIDMap = null;
            this.mappingApproachToIDMap = null;
            this.loadMappingApproachHash();
            this.loadReferenceGenomeHash();
        }
        catch (SQLException exc) {
            System.out.println("ERROR - problem deleting alignment data");
            exc.printStackTrace();
        }
    }

    @Override
    public void clearDiscoveryData() {
        try {
            boolean rs = this.connection.createStatement().execute("delete FROM tagallele");
            rs = this.connection.createStatement().execute("delete FROM snpposition");
            rs = this.connection.createStatement().execute("delete FROM allele");
            this.alleleToIDMap = null;
            this.snpPosToIDMap = null;
        }
        catch (SQLException exc) {
            System.out.println("ERROR - problem deleting discovery data");
            exc.printStackTrace();
        }
    }

    @Override
    public void clearSNPQualityData() {
        try {
            boolean bl = this.connection.createStatement().execute("delete FROM snpQuality");
        }
        catch (SQLException exc) {
            System.out.println("ERROR - problem deleting snpQuality data");
            exc.printStackTrace();
        }
    }

    @Override
    public Map<Tag, TaxaDistribution> getAllTagsTaxaMap() {
        ImmutableMap.Builder tagTDBuilder = ImmutableMap.builder();
        this.loadTagHash();
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select tagid, depthsRLE from tagtaxadistribution");
            while (rs.next()) {
                Tag myTag = (Tag)this.tagTagIDMap.inverse().get((Object)rs.getInt("tagid"));
                TaxaDistribution myTD = TaxaDistBuilder.create(rs.getBytes("depthsRLE"));
                TaxaDistribution myTDIncr = TaxaDistBuilder.create(myTD);
                tagTDBuilder.put((Object)myTag, (Object)myTDIncr);
            }
            return tagTDBuilder.build();
        }
        catch (SQLException exc) {
            System.out.println("getAllTaxaMap: caught SQLException attempting to grab taxa Distribution ");
            exc.printStackTrace();
            return tagTDBuilder.build();
        }
    }

    @Override
    public PositionList getTagCutPositions(boolean onlyBest) {
        return null;
    }

    @Override
    public void putAllelePairs(Multimap<Tag, Tuple<Tag, Integer>> tagTagAlignMap) {
        int batchCount = 0;
        try {
            this.putAllTag(tagTagAlignMap.keySet(), null);
            this.connection.setAutoCommit(false);
            for (Map.Entry entry : tagTagAlignMap.entries()) {
                Tag tag1 = (Tag)entry.getKey();
                Tag tag2 = (Tag)((Tuple)entry.getValue()).x;
                int score = (Integer)((Tuple)entry.getValue()).y;
                int ind = 1;
                this.allelePairInsertPS.setInt(ind++, (Integer)this.tagTagIDMap.get((Object)tag1));
                this.allelePairInsertPS.setInt(ind++, (Integer)this.tagTagIDMap.get((Object)tag2));
                this.allelePairInsertPS.setInt(ind++, score);
                this.allelePairInsertPS.addBatch();
                if (++batchCount <= 10000) continue;
                this.allelePairInsertPS.executeBatch();
                batchCount = 0;
            }
            this.allelePairInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    @Override
    public Multimap<Allele, Map<Tag, TaxaDistribution>> getAllelesTagTaxaDistForSNP(Position position) {
        return null;
    }

    @Override
    public Multimap<Tag, AlignmentInfo> getTagAlignmentsForTags(List<Tag> tags, int minscore) {
        ImmutableMultimap.Builder tagAIBuilder = ImmutableMultimap.builder();
        this.loadTagHash();
        this.loadRefTagHash();
        try {
            for (Tag tag : tags) {
                Integer tagID = (Integer)this.tagTagIDMap.get((Object)tag);
                if (tagID == null) {
                    System.out.println("getAlignmentsForTag: no tagID in alignments table for tag: " + tag.sequence());
                    continue;
                }
                this.tagAlignForNonRefTagPS.setInt(1, tagID);
                this.tagAlignForNonRefTagPS.setInt(2, minscore);
                ResultSet rs = this.tagAlignForNonRefTagPS.executeQuery();
                while (rs.next()) {
                    int score = rs.getInt("score");
                    Tag tag2 = (Tag)this.tagTagIDMap.inverse().get((Object)rs.getInt("tag2id"));
                    AlignmentInfo ai = new AlignmentInfo(tag2, null, -1, -1, -1, null, score);
                    tagAIBuilder.put((Object)tag, (Object)ai);
                }
            }
        }
        catch (SQLException exc) {
            System.out.println("getTagAlignmentsForTag: caught SQLException attempting to grab alignment data ");
            exc.printStackTrace();
        }
        return tagAIBuilder.build();
    }

    @Override
    public Multimap<Tag, AlignmentInfo> getAllNonRefTagAlignments(int minscore) {
        ImmutableMultimap.Builder tagAIBuilder = ImmutableMultimap.builder();
        this.loadTagHash();
        Set<Tag> tagsToAlign = this.getTags();
        ArrayList<Tag> tagList = new ArrayList<Tag>(tagsToAlign);
        return this.getTagAlignmentsForTags(tagList, minscore);
    }

    @Override
    public Multimap<RefTagData, AlignmentInfo> getRefAlignmentsForRefTags(List<RefTagData> refTags, int minscore) {
        ImmutableMultimap.Builder tagAIBuilder = ImmutableMultimap.builder();
        this.loadRefTagHash();
        try {
            for (RefTagData tag : refTags) {
                Integer tagID = (Integer)this.reftagReftagIDMap.get((Object)tag);
                if (tagID == null) {
                    System.out.println("getAlignmentsForTag: no tagID in alignments table for reftag: " + tag.tag().sequence());
                    continue;
                }
                this.refAlignForRefTagPS.setInt(1, tagID);
                this.refAlignForRefTagPS.setInt(2, minscore);
                ResultSet rs = this.refAlignForRefTagPS.executeQuery();
                while (rs.next()) {
                    int score = rs.getInt("score");
                    RefTagData tag2data = (RefTagData)this.reftagReftagIDMap.inverse().get((Object)rs.getInt("tag2id"));
                    AlignmentInfo ai = new AlignmentInfo(tag2data.tag(), tag2data.chromosome(), tag2data.position(), -1, 1, tag2data.refGenome(), score);
                    tagAIBuilder.put((Object)tag, (Object)ai);
                }
            }
        }
        catch (SQLException exc) {
            System.out.println("getAlignmentsForRefTags: caught SQLException attempting to grab taxa Distribution ");
            exc.printStackTrace();
        }
        return tagAIBuilder.build();
    }

    @Override
    public Multimap<RefTagData, AlignmentInfo> getAllRefTagAlignments(int minscore) {
        this.loadRefTagHash();
        Set<RefTagData> refTags = this.getRefTags();
        ArrayList<RefTagData> refTagList = new ArrayList<RefTagData>(refTags);
        return this.getRefAlignmentsForRefTags(refTagList, minscore);
    }

    @Override
    public Multimap<Tag, AlignmentInfo> getRefAlignmentsForTags(List<Tag> tags, int minscore) {
        ImmutableMultimap.Builder tagAIBuilder = ImmutableMultimap.builder();
        try {
            for (Tag tag : tags) {
                Integer tagID = (Integer)this.tagTagIDMap.get((Object)tag);
                if (tagID == null) {
                    System.out.println("getAlignmentsForTag: no tagID in alignments table for tag: " + tag.sequence());
                    continue;
                }
                this.refTagAlignsForNonRefTagPS.setInt(1, tagID);
                this.refTagAlignsForNonRefTagPS.setInt(2, minscore);
                ResultSet rs = this.refTagAlignsForNonRefTagPS.executeQuery();
                while (rs.next()) {
                    int alignPos = rs.getInt("ref_align_start_pos");
                    int ref_strand = rs.getInt("ref_align_strand");
                    int score = rs.getInt("score");
                    RefTagData rtd = (RefTagData)this.reftagReftagIDMap.inverse().get((Object)rs.getInt("refTagID"));
                    AlignmentInfo ai = new AlignmentInfo(rtd.tag(), rtd.chromosome(), rtd.position(), alignPos, ref_strand, rtd.refGenome(), score);
                    tagAIBuilder.put((Object)tag, (Object)ai);
                }
            }
        }
        catch (SQLException exc) {
            System.out.println("getRefAlignmentsForTags: caught SQLException attempting to get reftag alignments ");
            exc.printStackTrace();
        }
        return tagAIBuilder.build();
    }

    @Override
    public Multimap<Tag, AlignmentInfo> getTagAlignmentsForRefTag(RefTagData refTag, int minscore) {
        ImmutableMultimap.Builder tagAIBuilder = ImmutableMultimap.builder();
        int refTagID = (Integer)this.reftagReftagIDMap.get((Object)refTag);
        try {
            this.connection.setAutoCommit(false);
            this.nonReftagAlignmentsForRefTagPS.setInt(1, refTagID);
            this.nonReftagAlignmentsForRefTagPS.setInt(2, minscore);
            ResultSet rs = this.nonReftagAlignmentsForRefTagPS.executeQuery();
            while (rs.next()) {
                int alignPos = rs.getInt("ref_align_start_pos");
                int ref_strand = rs.getInt("ref_align_strand");
                int score = rs.getInt("score");
                Tag tag1 = (Tag)this.tagTagIDMap.inverse().get((Object)rs.getInt("tag1id"));
                AlignmentInfo ai = new AlignmentInfo(refTag.tag(), refTag.chromosome(), refTag.position(), alignPos, ref_strand, refTag.refGenome(), score);
                tagAIBuilder.put((Object)tag1, (Object)ai);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return tagAIBuilder.build();
    }

    @Override
    public void putTagTagCorrelationMatrix(Multimap<Tag, TagCorrelationInfo> tagCorrelationMap) {
        int batchCount = 0;
        this.loadTagHash();
        try {
            this.connection.setAutoCommit(false);
            for (Map.Entry entry : tagCorrelationMap.entries()) {
                TagCorrelationInfo tci = (TagCorrelationInfo)entry.getValue();
                int ind = 1;
                this.tagTagCorrelationInsertPS.setInt(ind++, (Integer)this.tagTagIDMap.get(entry.getKey()));
                this.tagTagCorrelationInsertPS.setInt(ind++, (Integer)this.tagTagIDMap.get((Object)tci.tag2()));
                this.tagTagCorrelationInsertPS.setDouble(ind++, tci.t1t2_pearson());
                this.tagTagCorrelationInsertPS.setDouble(ind++, tci.t1t2_spearman());
                this.tagTagCorrelationInsertPS.setDouble(ind++, tci.pres_abs_pearson());
                this.tagTagCorrelationInsertPS.setDouble(ind++, tci.r2());
                this.tagTagCorrelationInsertPS.addBatch();
                if (++batchCount <= 10000) continue;
                this.tagTagCorrelationInsertPS.executeBatch();
                batchCount = 0;
            }
            this.tagTagCorrelationInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
            ResultSet rs = this.connection.createStatement().executeQuery("select count (*) as numCorrelations from tagCorrelations");
            if (rs.next()) {
                System.out.println("Total tag-tag correlations in tagCorrelations table: " + rs.getInt("numCorrelations"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Multimap<Tag, TagCorrelationInfo> getCorrelationsForTags(List<Tag> tags) {
        ImmutableMultimap.Builder tagCorBuilder = ImmutableMultimap.builder();
        try {
            for (Tag tag : tags) {
                Integer tagID = (Integer)this.tagTagIDMap.get((Object)tag);
                if (tagID == null) {
                    System.out.println("getCorrelationsForTag: no tagID in tagCorrelations table for tag: " + tag.sequence());
                    continue;
                }
                this.tagCorrelationsForTag1PS.setInt(1, tagID);
                ResultSet rs = this.tagCorrelationsForTag1PS.executeQuery();
                int numCorrelations = 0;
                while (rs.next()) {
                    ++numCorrelations;
                    int tag2id = rs.getInt("tag2id");
                    double t1t2_p = rs.getFloat("t1t2_pearson");
                    double t1t2_s = rs.getFloat("t1t2_spearman");
                    double pa_pearson = rs.getFloat("pres_abs_pearson");
                    double r2 = rs.getFloat("r2");
                    Tag tag2 = (Tag)this.tagTagIDMap.inverse().get((Object)tag2id);
                    TagCorrelationInfo tci = new TagCorrelationInfo(tag2, t1t2_p, t1t2_s, pa_pearson, r2);
                    tagCorBuilder.put((Object)tag, (Object)tci);
                }
                this.tagCorrelationsForTag2PS.setInt(1, tagID);
                rs = this.tagCorrelationsForTag2PS.executeQuery();
                int numCorrelations2 = 0;
                while (rs.next()) {
                    ++numCorrelations2;
                    int tag1id = rs.getInt("tag1id");
                    double t1t2_p = rs.getFloat("t1t2_pearson");
                    double t1t2_s = rs.getFloat("t1t2_spearman");
                    double pa_pearson = rs.getFloat("pres_abs_pearson");
                    double r2 = rs.getFloat("r2");
                    Tag tag2 = (Tag)this.tagTagIDMap.inverse().get((Object)tag1id);
                    TagCorrelationInfo tci = new TagCorrelationInfo(tag2, t1t2_p, t1t2_s, pa_pearson, r2);
                    tagCorBuilder.put((Object)tag, (Object)tci);
                }
            }
        }
        catch (SQLException exc) {
            System.out.println("getAllTaxaMap: caught SQLException attempting to grab taxa Distribution ");
            exc.printStackTrace();
        }
        return tagCorBuilder.build();
    }
}

