/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import cern.colt.list.FloatArrayList;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.io.CharStreams;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.Allele;
import net.maizegenetics.dna.snp.SimpleAllele;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagBuilder;
import net.maizegenetics.dna.tag.TagDataWriter;
import net.maizegenetics.dna.tag.TaxaDistBuilder;
import net.maizegenetics.dna.tag.TaxaDistribution;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.TableReportBuilder;
import net.maizegenetics.util.Tuple;
import net.maizegenetics.util.db.SQL;
import org.sqlite.SQLiteConfig;

public class TagDataSQLite
implements TagDataWriter,
AutoCloseable {
    private Connection connection = null;
    private BiMap<Tag, Integer> tagTagIDMap;
    private BiMap<String, Integer> tissueTissueIDMap;
    private Map<String, Integer> mappingApproachToIDMap;
    private SortedMap<Position, Integer> cutPosToIDMap;
    public BiMap<Position, Integer> snpPosToIDMap;
    private BiMap<Allele, Integer> alleleToIDMap;
    private TaxaList myTaxaList;
    PreparedStatement tagTaxaDistPS;
    PreparedStatement tagAlleleWhereTagPS;
    PreparedStatement tagidWhereSNPidPS;
    PreparedStatement tagidWhereAlleleidPS;
    PreparedStatement posTagInsertPS;
    PreparedStatement taxaDistWhereCutPositionIDPS;
    PreparedStatement snpPositionsForChromosomePS;
    PreparedStatement alleleTaxaDistForSnpidPS;
    PreparedStatement allAlleleTaxaDistForSnpidPS;
    PreparedStatement snpQualityInsertPS;

    public TagDataSQLite(String filename) {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        try {
            boolean doesDBExist = Files.exists(Paths.get(filename, new String[0]), new LinkOption[0]);
            SQLiteConfig config = new SQLiteConfig();
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + filename, config.toProperties());
            this.connection.setAutoCommit(true);
            Statement statement = this.connection.createStatement();
            statement.setQueryTimeout(30);
            if (!doesDBExist) {
                String schema = CharStreams.toString((Readable)new InputStreamReader(TagDataSQLite.class.getResourceAsStream("TagSchema.sql")));
                statement.executeUpdate(schema);
            }
            this.initPreparedStatements();
            this.loadTagHash();
            this.loadTissueHash();
            this.loadMappingApproachHash();
            this.loadTaxaList();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void close() throws Exception {
        System.out.println("Closing SQLDB");
        this.connection.close();
    }

    private void initPreparedStatements() {
        try {
            this.posTagInsertPS = this.connection.prepareStatement("INSERT OR IGNORE into tagCutPosition (tagid, positionid, mapappid, bestmapping, forward, cigar, supportval) values(?,?,?,?,?,?,?)");
            this.tagTaxaDistPS = this.connection.prepareStatement("select depthsRLE from tagtaxadistribution where tagid=?");
            this.tagAlleleWhereTagPS = this.connection.prepareStatement("select * from tagallele where tagid=?");
            this.tagidWhereSNPidPS = this.connection.prepareStatement("select tagid from allele, tagallele where allele.snpid=? and allele.alleleid=tagallele.alleleid");
            this.tagidWhereAlleleidPS = this.connection.prepareStatement("select tagid from tagallele where alleleid=?");
            this.taxaDistWhereCutPositionIDPS = this.connection.prepareStatement("select tagtaxadistribution.* from tagCutPosition, tagtaxadistribution where tagCutPosition.positionid=? and tagCutPosition.tagid=tagtaxadistribution.tagid and tagCutPosition.bestmapping=1");
            this.snpPositionsForChromosomePS = this.connection.prepareStatement("select position, qualityScore, refAllele from snpposition where chromosome=?");
            this.alleleTaxaDistForSnpidPS = this.connection.prepareStatement("select a.*, td.* from allele a, tagallele ta, tagtaxadistribution td\nwhere a.alleleid=ta.alleleid and ta.tagid=td.tagid and a.snpid=?");
            this.allAlleleTaxaDistForSnpidPS = this.connection.prepareStatement("select a.*, td.* from allele a, tagallele ta, tagtaxadistribution td\nwhere a.alleleid=ta.alleleid and ta.tagid=td.tagid order by a.snpid");
            this.snpQualityInsertPS = this.connection.prepareStatement("INSERT into snpQuality (snpid, taxasubset ,avgDepth, minorDepthProp, minor2DepthProp, gapDepthProp, propCovered, propCovered2, taxaCntWithMinorAlleleGE2, minorAlleleFreqGE2, inbredF_DGE2) values(?,?,?,?,?,?,?,?,?,?,?)");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadTagHash() {
        try {
            boolean hasName;
            ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from tag");
            int size = rs.getInt(1);
            System.out.println("size of all tags in tag table=" + size);
            if (this.tagTagIDMap == null || size / (this.tagTagIDMap.size() + 1) > 3) {
                this.tagTagIDMap = HashBiMap.create((int)size);
            }
            rs = this.connection.createStatement().executeQuery("select * from tag");
            try {
                rs.findColumn("tagName");
                hasName = true;
            }
            catch (SQLException e) {
                hasName = false;
            }
            while (rs.next()) {
                TagBuilder tagBuilder = TagBuilder.instance(rs.getBytes("sequence"), rs.getShort("seqlen"));
                if (hasName) {
                    tagBuilder.name(rs.getString("tagName"));
                }
                this.tagTagIDMap.putIfAbsent((Object)tagBuilder.build(), (Object)rs.getInt("tagid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadTissueHash() {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from tissue");
            int size = rs.getInt(1);
            System.out.println("size of all tissues in tissue table=" + size);
            if (this.tissueTissueIDMap == null || size / (this.tissueTissueIDMap.size() + 1) > 3) {
                this.tissueTissueIDMap = HashBiMap.create((int)size);
            }
            rs = this.connection.createStatement().executeQuery("select * from tissue");
            while (rs.next()) {
                this.tissueTissueIDMap.putIfAbsent((Object)rs.getString("tissue"), (Object)rs.getInt("tissueid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadCutPositionHash() {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from cutPosition");
            int size = rs.getInt(1);
            System.out.println("size of all positions in cutPosition table=" + size);
            if (this.cutPosToIDMap == null) {
                this.cutPosToIDMap = new TreeMap<Position, Integer>();
            } else if (size == this.cutPosToIDMap.size()) {
                return;
            }
            rs = this.connection.createStatement().executeQuery("select * from cutPosition");
            while (rs.next()) {
                GeneralPosition p = new GeneralPosition.Builder(new Chromosome(rs.getString("chromosome")), rs.getInt("position")).strand(rs.getByte("strand")).build();
                this.cutPosToIDMap.putIfAbsent(p, rs.getInt("positionid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadSNPPositionHash(boolean force) {
        if (force && this.snpPosToIDMap != null) {
            this.snpPosToIDMap.clear();
        }
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from snpposition");
            int size = rs.getInt(1);
            System.out.println("size of all positions in snpPosition table=" + size);
            if (this.snpPosToIDMap == null) {
                this.snpPosToIDMap = HashBiMap.create((int)size);
            } else if (size == this.snpPosToIDMap.size()) {
                return;
            }
            rs = this.connection.createStatement().executeQuery("select * from snpposition");
            while (rs.next()) {
                byte refAllele = (byte)rs.getInt("refAllele");
                GeneralPosition p = new GeneralPosition.Builder(new Chromosome(rs.getString("chromosome")), rs.getInt("position")).strand(rs.getByte("strand")).addAnno("QualityScore", Float.valueOf(rs.getFloat("qualityScore"))).allele(WHICH_ALLELE.Reference, refAllele).build();
                this.snpPosToIDMap.putIfAbsent((Object)p, (Object)rs.getInt("snpid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadAlleleHash() {
        try {
            this.loadSNPPositionHash(false);
            ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from allele");
            int size = rs.getInt(1);
            System.out.println("size of all alleles in allele table=" + size);
            if (this.alleleToIDMap == null) {
                this.alleleToIDMap = HashBiMap.create((int)size);
            }
            if (size == this.alleleToIDMap.size()) {
                return;
            }
            rs = this.connection.createStatement().executeQuery("select * from allele");
            while (rs.next()) {
                int snpid = rs.getInt("snpid");
                Position p = (Position)this.snpPosToIDMap.inverse().get((Object)snpid);
                SimpleAllele a = new SimpleAllele(rs.getByte("allelecall"), p);
                this.alleleToIDMap.putIfAbsent((Object)a, (Object)rs.getInt("alleleid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadMappingApproachHash() {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from mappingApproach");
            int size = rs.getInt(1);
            System.out.println("size of all tags in mappingApproach table=" + size);
            if (size == 0) {
                this.connection.createStatement().executeUpdate("insert into mappingApproach (approach, software, protocols) values('unknown','unknown','unknown')");
                size = 1;
            }
            this.mappingApproachToIDMap = new HashMap<String, Integer>(size);
            rs = this.connection.createStatement().executeQuery("select * from mappingApproach");
            while (rs.next()) {
                this.mappingApproachToIDMap.put(rs.getString("approach"), rs.getInt("mapappid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadTaxaList() {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from taxa");
            int size = rs.getInt(1);
            System.out.println("size of all taxa in taxa table=" + size);
            TaxaListBuilder tlb = new TaxaListBuilder();
            rs = this.connection.createStatement().executeQuery("select * from taxa");
            while (rs.next()) {
                tlb.add(new Taxon(rs.getString("name")));
            }
            this.myTaxaList = tlb.build();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public TaxaList getTaxaList() {
        if (this.myTaxaList == null) {
            this.loadTaxaList();
        }
        return this.myTaxaList;
    }

    @Override
    public Map<Tag, String> getTagsNameMap() {
        try {
            HashMap<Tag, String> tagNameMap = new HashMap<Tag, String>(this.tagTagIDMap.size() + 1);
            ResultSet rs = this.connection.createStatement().executeQuery("select * from tag");
            while (rs.next()) {
                tagNameMap.put(TagBuilder.instance(rs.getBytes("sequence"), rs.getShort("seqlen")).build(), rs.getString("tagName"));
            }
            return tagNameMap;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean putAllTag(Set<Tag> tags) {
        int batchCount = 0;
        int totalCount = 0;
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement tagInsertPS = this.connection.prepareStatement("insert into tag (sequence, seqlen) values(?,?)");
            for (Tag tag : tags) {
                if (this.tagTagIDMap.containsKey((Object)tag)) continue;
                tagInsertPS.setBytes(1, tag.seq2BitAsBytes());
                tagInsertPS.setShort(2, tag.seqLength());
                tagInsertPS.addBatch();
                ++totalCount;
                if (++batchCount <= 100000) continue;
                System.out.println("tagInsertPS.executeBatch() " + batchCount);
                tagInsertPS.executeBatch();
                batchCount = 0;
            }
            tagInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        if (totalCount > 0) {
            this.loadTagHash();
        }
        return true;
    }

    @Override
    public boolean putAllNamesTag(Map<Tag, String> tagNameMap) {
        int batchCount = 0;
        int totalCount = 0;
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement tagInsertPS = this.connection.prepareStatement("insert into tag (sequence, seqlen, tagName) values(?,?,?)");
            for (Map.Entry<Tag, String> entry : tagNameMap.entrySet()) {
                Tag tag = entry.getKey();
                if (this.tagTagIDMap.containsKey((Object)tag)) continue;
                tagInsertPS.setBytes(1, tag.seq2BitAsBytes());
                tagInsertPS.setShort(2, tag.seqLength());
                tagInsertPS.setString(3, entry.getValue());
                tagInsertPS.addBatch();
                ++totalCount;
                if (++batchCount <= 100000) continue;
                System.out.println("tagInsertPS.executeBatch() " + batchCount);
                tagInsertPS.executeBatch();
                batchCount = 0;
            }
            tagInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        if (totalCount > 0) {
            this.loadTagHash();
        }
        return true;
    }

    @Override
    public void putTaxaList(TaxaList taxaList) {
        try {
            this.connection.createStatement().execute("delete from taxa");
            this.connection.setAutoCommit(false);
            PreparedStatement taxaInsertPS = this.connection.prepareStatement("insert into taxa (taxonid, name) values(?,?)");
            for (int i = 0; i < taxaList.size(); ++i) {
                taxaInsertPS.setInt(1, i);
                taxaInsertPS.setString(2, ((Taxon)taxaList.get(i)).getName());
                taxaInsertPS.addBatch();
            }
            taxaInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
            this.loadTaxaList();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean putTaxaTissueDistribution(String taxon, String tissue, List<Tag> tags, int[] counts) {
        int batchCount = 0;
        try {
            this.connection.setAutoCommit(false);
            int tissueID = (Integer)this.tissueTissueIDMap.get((Object)tissue);
            int taxaID = this.myTaxaList.indexOf(taxon);
            PreparedStatement tagTaxaTissuePS = this.connection.prepareStatement("replace into tagTaxaTissueDist (tagid, tissueid, taxonid, readCount) values(?,?,?,?) ");
            for (int i = 0; i < counts.length; ++i) {
                int tagID = (Integer)this.tagTagIDMap.get((Object)tags.get(i));
                tagTaxaTissuePS.setInt(1, tagID);
                tagTaxaTissuePS.setInt(2, tissueID);
                tagTaxaTissuePS.setInt(3, taxaID);
                tagTaxaTissuePS.setInt(4, counts[i]);
                tagTaxaTissuePS.addBatch();
                if (++batchCount <= 100000) continue;
                System.out.println("putTaxaDistribution next" + batchCount);
                tagTaxaTissuePS.executeBatch();
                batchCount = 0;
            }
            tagTaxaTissuePS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void putTaxaDistribution(Map<Tag, TaxaDistribution> tagTaxaDistributionMap) {
        int batchCount = 0;
        try {
            int numTaxa = this.myTaxaList.numberOfTaxa();
            this.connection.setAutoCommit(false);
            PreparedStatement tagInsertPS = this.connection.prepareStatement("insert into tagtaxadistribution (tagid, depthsRLE, totalDepth) values(?,?,?)");
            for (Map.Entry<Tag, TaxaDistribution> entry : tagTaxaDistributionMap.entrySet()) {
                int tagID = (Integer)this.tagTagIDMap.get((Object)entry.getKey());
                tagInsertPS.setInt(1, tagID);
                if (entry.getValue().maxTaxa() != numTaxa) {
                    throw new IllegalStateException("Number of taxa does not agree with taxa distribution");
                }
                tagInsertPS.setBytes(2, entry.getValue().encodeTaxaDepth());
                tagInsertPS.setInt(3, entry.getValue().totalDepth());
                tagInsertPS.addBatch();
                if (++batchCount <= 100000) continue;
                System.out.println("putTaxaDistribution next" + batchCount);
                tagInsertPS.executeBatch();
                batchCount = 0;
            }
            tagInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void putTagAlignments(Multimap<Tag, Position> tagAnnotatedPositionMap) {
        int batchCount = 0;
        try {
            this.putAllTag(tagAnnotatedPositionMap.keySet());
            this.putCutPositionsIfAbsent(tagAnnotatedPositionMap.values());
            this.connection.setAutoCommit(false);
            for (Map.Entry entry : tagAnnotatedPositionMap.entries()) {
                Position p = (Position)entry.getValue();
                GeneralAnnotation annotation = p.getAnnotation();
                int ind = 1;
                this.posTagInsertPS.setInt(ind++, (Integer)this.tagTagIDMap.get(entry.getKey()));
                this.posTagInsertPS.setInt(ind++, (Integer)this.cutPosToIDMap.get(p));
                this.posTagInsertPS.setInt(ind++, this.getMappingApproachID(p));
                this.posTagInsertPS.setBoolean(ind++, true);
                boolean forward = true;
                try {
                    if (annotation.getTextAnnotation("forward")[0].toLowerCase().equals("false")) {
                        forward = false;
                    }
                }
                catch (Exception e) {
                    System.err.println(p.toString());
                    System.err.println("Error with forward annotation");
                }
                this.posTagInsertPS.setBoolean(ind++, forward);
                String cigarValue = "";
                try {
                    cigarValue = annotation.getTextAnnotation("cigar")[0];
                }
                catch (Exception e) {
                    System.err.println(p.toString());
                    System.err.println("Error with cigar");
                }
                this.posTagInsertPS.setString(ind++, cigarValue);
                short supportVal = 0;
                try {
                    String[] svS = annotation.getTextAnnotation("supportvalue");
                    if (svS.length > 0) {
                        supportVal = Short.parseShort(svS[0]);
                    }
                }
                catch (Exception e) {
                    System.err.println("Error with supportVal");
                }
                this.posTagInsertPS.setByte(ind++, (byte)supportVal);
                this.posTagInsertPS.addBatch();
                if (++batchCount <= 10000) continue;
                System.out.println("putTagAlignments next" + batchCount);
                this.posTagInsertPS.executeBatch();
                batchCount = 0;
            }
            this.posTagInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
            ResultSet rs = this.connection.createStatement().executeQuery("select count (DISTINCT positionid) as numCutSites from tagCutPosition");
            if (rs.next()) {
                System.out.println("Total number of cut sites: " + rs.getInt("numCutSites"));
            }
            PreparedStatement cutSiteNumFromTCPPS = this.connection.prepareStatement("select count(*) as numSites from (select count(*) as tgcnt,positionid from tagCutPosition GROUP BY positionid) where tgcnt=?");
            cutSiteNumFromTCPPS.setInt(1, 1);
            rs = cutSiteNumFromTCPPS.executeQuery();
            if (rs.next()) {
                System.out.println("Number of cut sites with 1 tag: " + rs.getInt("numSites"));
            }
            cutSiteNumFromTCPPS.setInt(1, 2);
            rs = cutSiteNumFromTCPPS.executeQuery();
            if (rs.next()) {
                System.out.println("Number of cut sites with 2 tags: " + rs.getInt("numSites"));
            }
            cutSiteNumFromTCPPS.setInt(1, 3);
            rs = cutSiteNumFromTCPPS.executeQuery();
            if (rs.next()) {
                System.out.println("Number of cut sites with 3 tags: " + rs.getInt("numSites"));
            }
            PreparedStatement cutSiteGreaterThanPS = this.connection.prepareStatement("select count(*) as numSites from (select count(*) as tgcnt,positionid from tagCutPosition GROUP BY positionid) where tgcnt>?");
            cutSiteGreaterThanPS.setInt(1, 3);
            rs = cutSiteGreaterThanPS.executeQuery();
            if (rs.next()) {
                System.out.println("Number of cut sites with more than 3 tags: " + rs.getInt("numSites"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void putSNPQualityProfile(Map<Position, Map<String, Double>> tagAnnotatedPositionMap, String taxaSubset) {
        int batchCount = 0;
        try {
            this.putSNPPositionsIfAbsent(tagAnnotatedPositionMap.keySet());
            this.connection.setAutoCommit(false);
            for (Map.Entry<Position, Map<String, Double>> entry : tagAnnotatedPositionMap.entrySet()) {
                Position p = entry.getKey();
                Map<String, Double> vals = entry.getValue();
                int ind = 1;
                this.snpQualityInsertPS.setInt(ind++, (Integer)this.snpPosToIDMap.get((Object)p));
                this.snpQualityInsertPS.setString(ind++, taxaSubset);
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("avgDepth", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("minorDepthProp", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("minor2DepthProp", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("gapDepthProp", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("propCovered", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("propCovered2", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("taxaCntWithMinorAlleleGE2", 0.0));
                if (vals.containsKey("minorAlleleFreqGE2")) {
                    this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("minorAlleleFreqGE2", 0.0));
                    this.snpQualityInsertPS.setDouble(ind++, (Double)vals.getOrDefault("inbredF_DGE2", null));
                } else {
                    this.snpQualityInsertPS.setDouble(ind++, 0.0);
                    this.snpQualityInsertPS.setDouble(ind++, Double.NaN);
                }
                this.snpQualityInsertPS.addBatch();
                if (++batchCount <= 10000) continue;
                System.out.println("putSNPQualityProfile next" + batchCount);
                this.snpQualityInsertPS.executeBatch();
                batchCount = 0;
            }
            this.snpQualityInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void putSNPQualityProfile(Map<Position, Map<String, Double>> tagAnnotatedPositionMap, String taxaSubset, int counter) throws SQLException {
        try {
            this.putSNPPositionsIfAbsent(tagAnnotatedPositionMap.keySet());
            this.connection.setAutoCommit(false);
            for (Map.Entry<Position, Map<String, Double>> entry : tagAnnotatedPositionMap.entrySet()) {
                Position p = entry.getKey();
                Map<String, Double> vals = entry.getValue();
                int ind = 1;
                this.snpQualityInsertPS.setInt(ind++, (Integer)this.snpPosToIDMap.get((Object)p));
                this.snpQualityInsertPS.setString(ind++, taxaSubset);
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("avgDepth", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("minorDepthProp", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("minor2DepthProp", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("gapDepthProp", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("propCovered", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("propCovered2", 0.0));
                this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("taxaCntWithMinorAlleleGE2", 0.0));
                if (vals.containsKey("minorAlleleFreqGE2")) {
                    this.snpQualityInsertPS.setDouble(ind++, vals.getOrDefault("minorAlleleFreqGE2", 0.0));
                    this.snpQualityInsertPS.setDouble(ind++, (Double)vals.getOrDefault("inbredF_DGE2", null));
                } else {
                    this.snpQualityInsertPS.setDouble(ind++, 0.0);
                    this.snpQualityInsertPS.setDouble(ind++, Double.NaN);
                }
                if (counter == -1) {
                    this.snpQualityInsertPS.executeBatch();
                    this.connection.setAutoCommit(true);
                    continue;
                }
                this.snpQualityInsertPS.addBatch();
                if (counter % 10000 != 0) continue;
                this.snpQualityInsertPS.executeBatch();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private int getMappingApproachID(Position p) throws SQLException {
        String mapApp = p.getAnnotation().getTextAnnotation("mappingapproach")[0];
        if (mapApp == null) {
            return this.mappingApproachToIDMap.get("unknown");
        }
        Integer val = this.mappingApproachToIDMap.get(mapApp);
        if (val == null) {
            this.connection.createStatement().executeUpdate("insert into mappingApproach (approach, software, protocols) values('" + mapApp + "','unknown','unknown')");
            this.loadMappingApproachHash();
            return this.mappingApproachToIDMap.get(mapApp);
        }
        return val;
    }

    @Override
    public void setTagAlignmentBest(Tag tag, Position position, boolean isBest) {
    }

    @Override
    public boolean putTagAlleles(Multimap<Tag, Allele> tagAlleleMap) {
        int batchCount = 0;
        try {
            PreparedStatement alleleTagInsertPS = this.connection.prepareStatement("INSERT OR IGNORE into tagallele (alleleid, tagid) values(?,?)");
            this.putAllTag(tagAlleleMap.keySet());
            this.loadSNPPositionHash(false);
            this.putSNPPositionsIfAbsent(tagAlleleMap.values().stream().map(a -> a.position()).distinct().collect(Collectors.toSet()));
            this.putAlleleIfAbsent(tagAlleleMap.values().stream().distinct().collect(Collectors.toSet()));
            this.connection.setAutoCommit(false);
            for (Map.Entry tagAlleleEntry : tagAlleleMap.entries()) {
                int ind = 1;
                alleleTagInsertPS.setInt(ind++, (Integer)this.alleleToIDMap.get(tagAlleleEntry.getValue()));
                alleleTagInsertPS.setInt(ind++, (Integer)this.tagTagIDMap.get(tagAlleleEntry.getKey()));
                alleleTagInsertPS.addBatch();
                if (++batchCount <= 10000) continue;
                System.out.println("alleleTagInsertPS next" + batchCount);
                alleleTagInsertPS.executeBatch();
                batchCount = 0;
            }
            alleleTagInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean putTagAlignmentApproach(String tagAlignmentName, String protocol) {
        return false;
    }

    @Override
    public TaxaDistribution getTaxaDistribution(Tag tag) {
        int tagid = (Integer)this.tagTagIDMap.get((Object)tag);
        try {
            this.tagTaxaDistPS.setInt(1, tagid);
            ResultSet rs = this.tagTaxaDistPS.executeQuery();
            return TaxaDistBuilder.create(rs.getBytes(1));
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Set<Allele> getAlleles(Tag tag) {
        if (this.alleleToIDMap == null) {
            this.loadAlleleHash();
        }
        ImmutableSet.Builder alleleBuilder = new ImmutableSet.Builder();
        try {
            this.tagAlleleWhereTagPS.setInt(1, (Integer)this.tagTagIDMap.get((Object)tag));
            ResultSet rs = this.tagAlleleWhereTagPS.executeQuery();
            while (rs.next()) {
                alleleBuilder.add(this.alleleToIDMap.inverse().get((Object)rs.getInt("alleleid")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return alleleBuilder.build();
    }

    @Override
    public Multimap<Tag, Allele> getAlleleMap() {
        if (this.alleleToIDMap == null) {
            this.loadAlleleHash();
        }
        ImmutableMultimap.Builder tagAlleleBuilder = new ImmutableMultimap.Builder();
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select * from tagallele");
            while (rs.next()) {
                tagAlleleBuilder.put(this.tagTagIDMap.inverse().get((Object)rs.getInt("tagid")), this.alleleToIDMap.inverse().get((Object)rs.getInt("alleleid")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tagAlleleBuilder.build();
    }

    @Override
    public Set<Tag> getTagsForSNPPosition(Position position) {
        ImmutableSet.Builder tagBuilder = new ImmutableSet.Builder();
        try {
            this.tagidWhereSNPidPS.setInt(1, (Integer)this.snpPosToIDMap.get((Object)position));
            ResultSet rs = this.tagAlleleWhereTagPS.executeQuery();
            while (rs.next()) {
                tagBuilder.add(this.tagTagIDMap.inverse().get((Object)rs.getInt("tagid")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tagBuilder.build();
    }

    @Override
    public Set<Tag> getTagsForAllele(Position position, byte allele) {
        return this.getTagsForAllele(new SimpleAllele(allele, position));
    }

    @Override
    public Set<Tag> getTagsForAllele(Allele allele) {
        return null;
    }

    public Multimap<Allele, TaxaDistribution> getAllelesTaxaDistForSNP(Position position) {
        ImmutableMultimap.Builder atdBuilder = ImmutableMultimap.builder();
        try {
            this.alleleTaxaDistForSnpidPS.setInt(1, (Integer)this.snpPosToIDMap.get((Object)position));
            ResultSet rs = this.alleleTaxaDistForSnpidPS.executeQuery();
            while (rs.next()) {
                SimpleAllele allele = new SimpleAllele((byte)rs.getInt("allelecall"), position);
                atdBuilder.put((Object)allele, (Object)TaxaDistBuilder.create(rs.getBytes("depthsRLE")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return atdBuilder.build();
    }

    @Override
    public Multimap<Allele, Map<Tag, TaxaDistribution>> getAllelesTagTaxaDistForSNP(Position position) {
        ImmutableMultimap.Builder aTTdBuilder = ImmutableMultimap.builder();
        try {
            if (this.snpPosToIDMap == null) {
                this.loadSNPPositionHash(false);
            }
            this.alleleTaxaDistForSnpidPS.setInt(1, (Integer)this.snpPosToIDMap.get((Object)position));
            ResultSet rs = this.alleleTaxaDistForSnpidPS.executeQuery();
            while (rs.next()) {
                SimpleAllele allele = new SimpleAllele((byte)rs.getInt("allelecall"), position);
                Tag snpTag = (Tag)this.tagTagIDMap.inverse().get((Object)rs.getInt("tagid"));
                TaxaDistribution snpTD = TaxaDistBuilder.create(rs.getBytes("depthsRLE"));
                ImmutableMap.Builder tagTDBuilder = ImmutableMap.builder();
                tagTDBuilder.put((Object)snpTag, (Object)snpTD);
                aTTdBuilder.put((Object)allele, (Object)tagTDBuilder.build());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return aTTdBuilder.build();
    }

    public Stream<ImmutableMultimap<Allele, TaxaDistribution>> getAllAllelesTaxaDistForSNP() {
        if (this.snpPosToIDMap == null) {
            this.loadSNPPositionHash(false);
        }
        Stream<ImmutableMultimap<Allele, TaxaDistribution>> stream = SQL.stream(this.connection, "select a.*, td.* from allele a, tagallele ta, tagtaxadistribution td\nwhere a.alleleid=ta.alleleid and ta.tagid=td.tagid order by a.snpid", new Object[0]).map(entry -> {
            ImmutableMultimap.Builder atdBuilder = ImmutableMultimap.builder();
            Position pos = (Position)this.snpPosToIDMap.inverse().get((Object)entry.asInt("snpid"));
            SimpleAllele allele = new SimpleAllele((byte)entry.asInt("allelecall"), pos);
            byte[] byteArray = (byte[])entry.val("depthsRLE").get();
            atdBuilder.put((Object)allele, (Object)TaxaDistBuilder.create(byteArray));
            return atdBuilder.build();
        });
        return stream;
    }

    public Stream<Map.Entry<Allele, TaxaDistribution>> getAllAllelesTaxaDistForSNPEntries() {
        if (this.snpPosToIDMap == null) {
            this.loadSNPPositionHash(false);
        }
        Stream<Map.Entry<Allele, TaxaDistribution>> stream = SQL.stream(this.connection, "select a.snpid, a.allelecall, td.depthsRLE from allele a, tagallele ta, tagtaxadistribution td\nwhere td.tagid = ta.tagid AND a.alleleid = ta.alleleid order by a.snpid", new Object[0]).map(entry -> {
            Position pos = (Position)this.snpPosToIDMap.inverse().get((Object)entry.asInt("snpid"));
            SimpleAllele allele = new SimpleAllele((byte)entry.asInt("allelecall"), pos);
            byte[] byteArray = (byte[])entry.val("depthsRLE").get();
            return new AbstractMap.SimpleEntry<SimpleAllele, TaxaDistribution>(allele, TaxaDistBuilder.create(byteArray));
        });
        return stream;
    }

    @Override
    public Phenotype getAllCountsForTagTissue(Tag tag, String tissue) {
        Integer tagID = (Integer)this.tagTagIDMap.get((Object)tag);
        Integer tissueID = (Integer)this.tissueTissueIDMap.get((Object)tissue);
        if (tagID == null || tissueID == null) {
            System.out.println("getAllCountsForTagTissue: ERROR, either tissueID or tagID not found in DB");
            return null;
        }
        ArrayList<Taxon> taxaList = new ArrayList<Taxon>();
        FloatArrayList countList = new FloatArrayList();
        SQL.stream(this.connection, "select t.taxonid, t.readCount from tagTaxaTissueDist t where t.tagid=" + tagID + " AND t.tissueid=" + tissueID + ";", new Object[0]).forEach(entry -> {
            taxaList.add((Taxon)this.myTaxaList.get(entry.asInt("taxonid")));
            countList.add((float)entry.asInt("readCount"));
        });
        NumericAttribute trait = new NumericAttribute(tissue + ":" + tag.sequence() + ":count", countList.elements(), new OpenBitSet(countList.size()));
        return new PhenotypeBuilder().fromAttributeList(Arrays.asList(new TaxaAttribute(taxaList), trait), Arrays.asList(Phenotype.ATTRIBUTE_TYPE.taxa, Phenotype.ATTRIBUTE_TYPE.data)).build().get(0);
    }

    @Override
    public TableReport getAllCountsForTaxonTissue(Taxon taxon, String tissue) {
        Integer taxonID = this.myTaxaList.indexOf(taxon.getName());
        Integer tissueID = (Integer)this.tissueTissueIDMap.get((Object)tissue);
        if (tissueID == null || taxonID == null) {
            System.out.println("getAllCountsForTaxonTissue: ERROR, either tissueID or taxonID not found in DB");
            return null;
        }
        Object[] headers = new String[]{"Sequence", "TagName", "ReadCount"};
        TableReportBuilder reportBuilder = TableReportBuilder.getInstance("CountsFor:" + taxon.getName() + ":" + tissue, headers);
        SQL.stream(this.connection, "select t.tagid, t.readCount, tag.tagName from tagTaxaTissueDist t, tag where t.taxonid=" + taxonID + " AND t.tissueid=" + tissueID + " AND tag.tagid=t.tagid;", new Object[0]).forEach(entry -> reportBuilder.addElements(((Tag)this.tagTagIDMap.inverse().get((Object)entry.asInt("tagid"))).sequence(), entry.val("tagName").orElse("").toString(), entry.asInt("readCount")));
        return reportBuilder.build();
    }

    @Override
    public Phenotype getAllCountsForTissue(String tissue) {
        Integer tissueID = (Integer)this.tissueTissueIDMap.get((Object)tissue);
        if (tissueID == null) {
            System.out.println("getAllCountsForTissue: ERROR, tissue " + tissue + " not found in DB");
            return null;
        }
        AtomicInteger counter = new AtomicInteger();
        Map taxaIDtoNumAttIndex = SQL.stream(this.connection, "select DISTINCT taxonid from tagTaxaTissueDist where tissueid=" + tissueID + " ORDER BY taxonid;", new Object[0]).map(entry -> new Tuple<Integer, Integer>(entry.asInt("taxonid"), counter.getAndIncrement())).collect(Collectors.toMap(Tuple::getX, Tuple::getY, (a, b) -> a, TreeMap::new));
        TaxaList taxaList = taxaIDtoNumAttIndex.keySet().stream().map(this.myTaxaList::get).collect(TaxaList.collect());
        counter.set(0);
        Map tagIDtoNumAttIndex = SQL.stream(this.connection, "select DISTINCT tagid from tagTaxaTissueDist where tissueid=" + tissueID + " ORDER BY tagid;", new Object[0]).map(entry -> new Tuple<Integer, Integer>(entry.asInt("tagid"), counter.getAndIncrement())).collect(Collectors.toMap(Tuple::getX, Tuple::getY, (a, b) -> a, TreeMap::new));
        float[][] data = new float[tagIDtoNumAttIndex.size()][taxaIDtoNumAttIndex.size()];
        SQL.stream(this.connection, "select t.tagid, t.taxonid, t.readCount from tagTaxaTissueDist t where t.tissueid=" + tissueID + ";", new Object[0]).forEach(entry -> {
            data[((Integer)tagIDtoNumAttIndex.get((Object)Integer.valueOf((int)entry.asInt((String)"tagid")))).intValue()][((Integer)taxaIDtoNumAttIndex.get((Object)Integer.valueOf((int)entry.asInt((String)"taxonid")))).intValue()] = entry.asInt("readCount");
        });
        ArrayList<PhenotypeAttribute> phenotypeAttributes = new ArrayList<PhenotypeAttribute>(tagIDtoNumAttIndex.size() + 1);
        ArrayList<Phenotype.ATTRIBUTE_TYPE> attributeTypeList = new ArrayList<Phenotype.ATTRIBUTE_TYPE>(tagIDtoNumAttIndex.size() + 1);
        phenotypeAttributes.add(new TaxaAttribute(taxaList));
        attributeTypeList.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        tagIDtoNumAttIndex.entrySet().stream().forEachOrdered(entry -> {
            Tag tag = (Tag)this.tagTagIDMap.inverse().get(entry.getKey());
            NumericAttribute trait = new NumericAttribute(tissue + ":" + tag.name() + ":count", data[(Integer)entry.getValue()], new OpenBitSet(data[(Integer)entry.getValue()].length));
            phenotypeAttributes.add(trait);
            attributeTypeList.add(Phenotype.ATTRIBUTE_TYPE.data);
        });
        return new PhenotypeBuilder().fromAttributeList(phenotypeAttributes, attributeTypeList).build().get(0);
    }

    @Override
    public Set<Tag> getTags() {
        return this.tagTagIDMap.keySet();
    }

    @Override
    public PositionList getSNPPositions() {
        if (this.snpPosToIDMap == null) {
            this.loadSNPPositionHash(false);
        }
        return new PositionListBuilder().addAll(this.snpPosToIDMap.keySet()).build();
    }

    @Override
    public PositionList getSNPPositions(int minSupportValue) {
        return null;
    }

    @Override
    public PositionList getSNPPositions(double minQualityScore) {
        if (minQualityScore == 0.0) {
            return this.getSNPPositions();
        }
        if (this.snpPosToIDMap == null) {
            this.loadSNPPositionHash(false);
        }
        PositionListBuilder plb = new PositionListBuilder();
        this.snpPosToIDMap.keySet().stream().forEach(pos -> {
            double[] qs = pos.getAnnotation().getQuantAnnotation("QualityScore");
            if (qs != null && qs.length > 0 && qs[0] >= minQualityScore) {
                plb.add((Position)pos);
            }
        });
        return plb.build();
    }

    @Override
    public Set<Tag> getTagsForTaxon(Taxon taxon) {
        ImmutableSet.Builder tagBuilder = new ImmutableSet.Builder();
        int taxonIndex = this.myTaxaList.indexOf(taxon);
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select * from tagtaxadistribution");
            while (rs.next()) {
                if (TaxaDistBuilder.create(rs.getBytes("depthsRLE")).depths()[taxonIndex] <= 0) continue;
                tagBuilder.add(this.tagTagIDMap.inverse().get((Object)rs.getInt("tagid")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tagBuilder.build();
    }

    @Override
    public Map<Tag, Integer> getTagDepth(Taxon taxon, Position position) {
        return null;
    }

    @Override
    public Map<Tag, Integer> getTagsWithDepth(int minimumDepth) {
        ImmutableMap.Builder tagBuilder = new ImmutableMap.Builder();
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select tagid, totalDepth from tagtaxadistribution where totalDepth >= " + minimumDepth);
            while (rs.next()) {
                tagBuilder.put(this.tagTagIDMap.inverse().get((Object)rs.getInt(1)), (Object)rs.getInt(2));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tagBuilder.build();
    }

    @Override
    public PositionList getTagCutPositions(boolean onlyBest) {
        if (this.cutPosToIDMap == null) {
            this.loadCutPositionHash();
        }
        PositionListBuilder plb = new PositionListBuilder();
        this.cutPosToIDMap.keySet().stream().forEach(p -> plb.add((Position)p));
        plb.sortPositions();
        return plb.build();
    }

    @Override
    public PositionList getTagCutPositions(Chromosome chromosome, int firstPosition, int lastPosition, boolean onlyBest) {
        PositionListBuilder plb = new PositionListBuilder();
        plb.addAll(this.getPositionSubMap(chromosome, firstPosition, lastPosition).keySet());
        return plb.build();
    }

    @Override
    public Map<Tag, Position> getTagCutPosition(Set<Tag> tagSet) {
        ImmutableMap.Builder tagPosBuilder = new ImmutableMap.Builder();
        for (Tag tag : tagSet) {
            int tagID = (Integer)this.tagTagIDMap.get((Object)tag);
            try {
                ResultSet rs = this.connection.createStatement().executeQuery("select cp.*, tcp.* from cutposition cp, tag t, tagCutPosition tcp where tcp.tagid=t.tagid and tcp.positionid=cp.positionid and t.tagid= " + tagID);
                while (rs.next()) {
                    GeneralPosition cutPos = new GeneralPosition.Builder(new Chromosome(rs.getString("chromosome")), rs.getInt("position")).strand(rs.getByte("strand")).addAnno("forward", rs.getBoolean("forward") ? "true" : "false").build();
                    tagPosBuilder.put((Object)tag, (Object)cutPos);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
        }
        return tagPosBuilder.build();
    }

    private Map<Position, Integer> getPositionSubMap(Chromosome chromosome, int firstPosition, int lastPosition) {
        if (this.cutPosToIDMap == null) {
            this.loadCutPositionHash();
        }
        GeneralPosition startPos = new GeneralPosition.Builder(chromosome, firstPosition).build();
        if (lastPosition < 0) {
            lastPosition = Integer.MAX_VALUE;
        }
        GeneralPosition lastPos = new GeneralPosition.Builder(chromosome, lastPosition).build();
        return this.cutPosToIDMap.subMap(startPos, lastPos);
    }

    @Override
    public Map<String, String> getTagAlignmentApproaches() {
        ImmutableMap.Builder appBuilder = new ImmutableMap.Builder();
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select * from mappingApproach");
            while (rs.next()) {
                appBuilder.put((Object)rs.getString("approach"), (Object)(rs.getString("software") + ":" + rs.getString("approach")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return appBuilder.build();
    }

    @Override
    public Map<Position, Map<Tag, Tuple<Boolean, TaxaDistribution>>> getCutPositionTagTaxaMap(Chromosome chromosome, int firstPosition, int lastPosition) {
        String sqlQuery = "select p.positionid, forward, chromosome, position, strand, t.tagid, depthsRLE  from tag t, cutposition p, tagCutPosition tc, tagtaxadistribution ttd where p.positionid=tc.positionid and tc.tagid=t.tagid and t.tagid=ttd.tagid and chromosome='" + chromosome.toString() + "' order by position";
        HashMap<Position, Map<Tag, Tuple<Boolean, TaxaDistribution>>> positionTagTaxaMap = new HashMap<Position, Map<Tag, Tuple<Boolean, TaxaDistribution>>>();
        HashMap tempPositionMap = new HashMap();
        this.getPositionSubMap(chromosome, firstPosition, lastPosition).entrySet().stream().forEach(entry -> {
            Position cfr_ignored_0 = (Position)tempPositionMap.put(entry.getValue(), entry.getKey());
        });
        int totalTagsAdded = 0;
        try {
            ResultSet rs = this.connection.createStatement().executeQuery(sqlQuery);
            while (rs.next()) {
                Position position = (Position)tempPositionMap.get(rs.getInt("positionid"));
                Tag tag = (Tag)this.tagTagIDMap.inverse().get((Object)rs.getInt("tagid"));
                TaxaDistribution taxaDistribution = TaxaDistBuilder.create(rs.getBytes("depthsRLE"));
                Boolean forwardAlignDirection = rs.getBoolean("forward");
                Map tagTaxaMap = positionTagTaxaMap.computeIfAbsent(position, k -> new HashMap());
                tagTaxaMap.put(tag, new Tuple<Boolean, TaxaDistribution>(forwardAlignDirection, taxaDistribution));
                ++totalTagsAdded;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        System.out.println("positionTagTaxaMap = " + positionTagTaxaMap.size() + " totalTagsAdded: " + totalTagsAdded);
        return positionTagTaxaMap;
    }

    @Override
    public Map<Position, Map<Tag, TaxaDistribution>> getCutPosForStrandTagTaxaMap(Chromosome chromosome, int firstPosition, int lastPosition, boolean direction) {
        String sqlQuery = "select p.positionid, forward, chromosome, position, strand, t.tagid, depthsRLE  from tag t, cutposition p, tagCutPosition tc, tagtaxadistribution ttd where p.positionid=tc.positionid and tc.tagid=t.tagid and t.tagid=ttd.tagid and chromosome='" + chromosome.toString() + "' order by position";
        HashMap<Position, Map<Tag, TaxaDistribution>> positionTagTaxaMap = new HashMap<Position, Map<Tag, TaxaDistribution>>();
        HashMap tempPositionMap = new HashMap();
        this.getPositionSubMap(chromosome, firstPosition, lastPosition).entrySet().stream().forEach(entry -> {
            Position cfr_ignored_0 = (Position)tempPositionMap.put(entry.getValue(), entry.getKey());
        });
        int totalTagsAdded = 0;
        try {
            ResultSet rs = this.connection.createStatement().executeQuery(sqlQuery);
            while (rs.next()) {
                Boolean forwardAlignDirection = rs.getBoolean("forward");
                if (forwardAlignDirection != direction) continue;
                Position position = (Position)tempPositionMap.get(rs.getInt("positionid"));
                Tag tag = (Tag)this.tagTagIDMap.inverse().get((Object)rs.getInt("tagid"));
                TaxaDistribution taxaDistribution = TaxaDistBuilder.create(rs.getBytes("depthsRLE"));
                Map tagTaxaMap = positionTagTaxaMap.computeIfAbsent(position, k -> new HashMap());
                tagTaxaMap.put(tag, taxaDistribution);
                ++totalTagsAdded;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        System.out.println("positionTagTaxaMap size, forwardStrand, " + direction + " size:" + positionTagTaxaMap.size() + " totalTagsAdded:" + totalTagsAdded);
        return positionTagTaxaMap;
    }

    @Override
    public Map<Tag, TaxaDistribution> getTagsTaxaMap(Position cutPosition) {
        ImmutableMap.Builder tagTaxaDistributionBuilder = new ImmutableMap.Builder();
        if (this.cutPosToIDMap == null) {
            this.loadCutPositionHash();
        }
        try {
            this.taxaDistWhereCutPositionIDPS.setInt(1, (Integer)this.cutPosToIDMap.get(cutPosition));
            ResultSet rs = this.taxaDistWhereCutPositionIDPS.executeQuery();
            while (rs.next()) {
                tagTaxaDistributionBuilder.put(this.tagTagIDMap.inverse().get((Object)rs.getInt("tagid")), (Object)TaxaDistBuilder.create(rs.getBytes("depthsRLE")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tagTaxaDistributionBuilder.build();
    }

    private void putCutPositionsIfAbsent(Collection<Position> positions) {
        try {
            int batchCount = 0;
            if (this.cutPosToIDMap == null) {
                this.loadCutPositionHash();
            }
            this.connection.setAutoCommit(false);
            PreparedStatement posInsertPS = this.connection.prepareStatement("INSERT OR IGNORE into cutposition (chromosome, position, strand) values(?,?,?)");
            for (Position p : positions) {
                if (this.cutPosToIDMap.containsKey(p)) continue;
                posInsertPS.setString(1, p.getChromosome().toString());
                posInsertPS.setInt(2, p.getPosition());
                posInsertPS.setByte(3, p.getStrand());
                posInsertPS.addBatch();
                if (++batchCount <= 10000) continue;
                System.out.println("putCutPositionsIfAbsent next" + batchCount);
                posInsertPS.executeBatch();
                batchCount = 0;
            }
            posInsertPS.executeBatch();
            if (batchCount > 0) {
                this.loadCutPositionHash();
            }
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void putSNPPositionsIfAbsent(Collection<Position> positions) {
        try {
            int batchCount = 0;
            if (this.snpPosToIDMap == null) {
                this.loadSNPPositionHash(false);
            }
            this.connection.setAutoCommit(false);
            PreparedStatement snpPosInsertPS = this.connection.prepareStatement("INSERT OR IGNORE into snpposition (chromosome, position, strand,qualityScore,refAllele) values(?,?,?,?,?)");
            for (Position p : positions) {
                if (this.snpPosToIDMap.containsKey((Object)p)) continue;
                snpPosInsertPS.setString(1, p.getChromosome().toString());
                snpPosInsertPS.setInt(2, p.getPosition());
                snpPosInsertPS.setByte(3, p.getStrand());
                double[] qsList = p.getAnnotation().getQuantAnnotation("QualityScore");
                if (qsList != null & qsList.length > 0) {
                    snpPosInsertPS.setFloat(4, (float)qsList[0]);
                } else {
                    snpPosInsertPS.setFloat(4, 0.0f);
                }
                snpPosInsertPS.setByte(5, p.getAllele(WHICH_ALLELE.Reference));
                snpPosInsertPS.addBatch();
                if (++batchCount <= 10000) continue;
                System.out.println("putSNPPositionsIfAbsent next" + batchCount);
                snpPosInsertPS.executeBatch();
                batchCount = 0;
            }
            snpPosInsertPS.executeBatch();
            if (batchCount > 0) {
                this.loadSNPPositionHash(false);
            }
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void putAlleleIfAbsent(Collection<Allele> alleles) throws IllegalStateException {
        try {
            int batchCount = 0;
            PreparedStatement alleleInsertPS = this.connection.prepareStatement("INSERT OR IGNORE into allele (snpid, allelecall, qualityscore) values(?,?,?)");
            this.connection.setAutoCommit(false);
            for (Allele allele : alleles) {
                Integer snpID = (Integer)this.snpPosToIDMap.get((Object)allele.position());
                if (snpID == null) {
                    throw new IllegalStateException("SNP position missing for allele");
                }
                int index = 1;
                alleleInsertPS.setInt(index++, snpID);
                alleleInsertPS.setByte(index++, allele.allele());
                alleleInsertPS.setByte(index++, (byte)0);
                alleleInsertPS.addBatch();
                if (++batchCount <= 10000) continue;
                System.out.println("putAlleleIfAbsent next" + batchCount);
                alleleInsertPS.executeBatch();
                batchCount = 0;
            }
            alleleInsertPS.executeBatch();
            if (batchCount > 0) {
                this.loadAlleleHash();
            }
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public PositionList getSNPPositionsForChromosomes(Integer startChr, Integer endChr) {
        PositionListBuilder plb = new PositionListBuilder();
        if (startChr < 1 || endChr < 1 || startChr > endChr) {
            System.err.printf("getSNPPOsitionsForChromosomes:  bad Chromosome values: startChr %d, endChr %d\n", startChr, endChr);
            return null;
        }
        try {
            for (int chrom = startChr.intValue(); chrom <= endChr; ++chrom) {
                this.snpPositionsForChromosomePS.setString(1, Integer.toString(chrom));
                ResultSet rs = this.snpPositionsForChromosomePS.executeQuery();
                while (rs.next()) {
                    Chromosome chr = new Chromosome(Integer.toString(chrom));
                    byte refAllele = (byte)rs.getInt("refAllele");
                    GeneralPosition position = new GeneralPosition.Builder(chr, rs.getInt("position")).addAnno("QualityScore", Float.valueOf(rs.getFloat("qualityScore"))).allele(WHICH_ALLELE.Reference, refAllele).build();
                    plb.add(position);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return plb.build();
    }

    @Override
    public void putSNPPositionQS(PositionList qsPL) {
        int batchCount = 0;
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement qsUpdatePS = this.connection.prepareStatement("update snpposition set qualityScore = ? where chromosome = ? and position = ?");
            for (Position qsPos : qsPL) {
                double qscore = 0.0;
                double[] qs = qsPos.getAnnotation().getQuantAnnotation("QualityScore");
                if (qs != null && qs.length > 0) {
                    qscore = qs[0];
                }
                qsUpdatePS.setFloat(1, (float)qscore);
                qsUpdatePS.setString(2, qsPos.getChromosome().getName());
                qsUpdatePS.setInt(3, qsPos.getPosition());
                qsUpdatePS.addBatch();
                if (++batchCount <= 100000) continue;
                System.out.println("updateSNPPosition next " + batchCount);
                qsUpdatePS.executeBatch();
                batchCount = 0;
            }
            qsUpdatePS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            System.out.println("Error executing UPDATE statement for TagDataSQLite:putSNPQualityPositions");
            e.printStackTrace();
        }
        this.loadSNPPositionHash(true);
    }

    @Override
    public ListMultimap<String, Tuple<Integer, Float>> getSNPPositionQS(HashMultimap<String, Integer> myMap) {
        ImmutableListMultimap.Builder qsMap = new ImmutableListMultimap.Builder().orderKeysBy((Comparator)Ordering.natural()).orderKeysBy((Comparator)Ordering.natural());
        boolean batchCount = false;
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement dbTestPS = this.connection.prepareStatement("select qualityScore from snpposition where chromosome = ? and position = ?");
            for (Map.Entry entry : myMap.entries()) {
                String chrom = (String)entry.getKey();
                Integer posQS = (Integer)entry.getValue();
                dbTestPS.setString(1, chrom);
                dbTestPS.setInt(2, posQS);
                ResultSet rs = dbTestPS.executeQuery();
                while (rs.next()) {
                    Float myQual = Float.valueOf(rs.getFloat("qualityScore"));
                    Tuple<Integer, Float> myTuple = new Tuple<Integer, Float>(posQS, myQual);
                    qsMap.put((Object)chrom, myTuple);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
        return qsMap.build();
    }

    @Override
    public List<Chromosome> getChromosomesFromCutPositions() {
        ArrayList<Chromosome> chromList = new ArrayList<Chromosome>();
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select DISTINCT chromosome from cutPosition");
            while (rs.next()) {
                Chromosome chrom = new Chromosome(rs.getString("chromosome"));
                chromList.add(chrom);
            }
        }
        catch (SQLException exc) {
            exc.printStackTrace();
            return null;
        }
        return chromList;
    }

    @Override
    public void clearTagTaxaDistributionData() {
        try {
            boolean rs = this.connection.createStatement().execute("delete FROM tagtaxadistribution");
            rs = this.connection.createStatement().execute("delete FROM tag");
            this.tagTagIDMap = null;
            this.loadTagHash();
        }
        catch (SQLException exc) {
            System.out.println("ERROR - problem deleting tagtaxadistribution data");
            exc.printStackTrace();
        }
    }

    @Override
    public void clearAlignmentData() {
        try {
            boolean rs = this.connection.createStatement().execute("delete FROM tagCutPosition");
            rs = this.connection.createStatement().execute("delete FROM cutPosition");
            rs = this.connection.createStatement().execute("delete FROM mappingApproach");
            this.cutPosToIDMap = null;
            this.mappingApproachToIDMap = null;
            this.loadMappingApproachHash();
        }
        catch (SQLException exc) {
            System.out.println("ERROR - problem deleting alignment data");
            exc.printStackTrace();
        }
    }

    @Override
    public void clearDiscoveryData() {
        try {
            boolean rs = this.connection.createStatement().execute("delete FROM tagallele");
            rs = this.connection.createStatement().execute("delete FROM snpposition");
            rs = this.connection.createStatement().execute("delete FROM allele");
            this.alleleToIDMap = null;
            this.snpPosToIDMap = null;
        }
        catch (SQLException exc) {
            System.out.println("ERROR - problem deleting discovery data");
            exc.printStackTrace();
        }
    }

    @Override
    public void clearSNPQualityData() {
        try {
            boolean bl = this.connection.createStatement().execute("delete FROM snpQuality");
        }
        catch (SQLException exc) {
            System.out.println("ERROR - problem deleting snpQuality data");
            exc.printStackTrace();
        }
    }

    @Override
    public Map<Tag, TaxaDistribution> getAllTagsTaxaMap() {
        ImmutableMap.Builder tagTDBuilder = ImmutableMap.builder();
        this.loadTagHash();
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("select tagid, depthsRLE from tagtaxadistribution");
            while (rs.next()) {
                Tag myTag = (Tag)this.tagTagIDMap.inverse().get((Object)rs.getInt("tagid"));
                TaxaDistribution myTD = TaxaDistBuilder.create(rs.getBytes("depthsRLE"));
                TaxaDistribution myTDIncr = TaxaDistBuilder.create(myTD);
                tagTDBuilder.put((Object)myTag, (Object)myTDIncr);
            }
            return tagTDBuilder.build();
        }
        catch (SQLException exc) {
            System.out.println("getAllTaxaMap: caught SQLException attempting to grab taxa Distribution ");
            exc.printStackTrace();
            return tagTDBuilder.build();
        }
    }

    @Override
    public boolean putAllTissue(ArrayList<String> tissues) {
        int batchCount = 0;
        int totalCount = 0;
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement tissueInsertPS = this.connection.prepareStatement("insert into tissue (tissue) values(?)");
            for (String tissue : tissues) {
                if (this.tissueTissueIDMap.containsKey((Object)tissue)) continue;
                tissueInsertPS.setString(1, tissue);
                tissueInsertPS.addBatch();
                ++totalCount;
                if (++batchCount <= 100000) continue;
                System.out.println("tissueInsertPS.executeBatch() " + batchCount);
                tissueInsertPS.executeBatch();
                batchCount = 0;
            }
            tissueInsertPS.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        if (totalCount > 0) {
            this.loadTissueHash();
        }
        return true;
    }

    @Override
    public Set<String> getAllTissue() {
        return this.tissueTissueIDMap.keySet();
    }
}

