/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import cern.colt.list.IntArrayList;
import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.map.hash.TIntIntHashMap;
import net.maizegenetics.dna.tag.AbstractTaxaDistribution;
import net.maizegenetics.dna.tag.TaxaDistribution;

class TaxaDistIntExpandable
extends AbstractTaxaDistribution {
    private IntArrayList taxaWithTag;
    private TIntIntHashMap taxaTagMap = null;
    private int totalDepth;
    private final int maxTaxa;

    public TaxaDistIntExpandable(int maxTaxa) {
        this.maxTaxa = maxTaxa;
        this.taxaWithTag = new IntArrayList(1);
    }

    @Override
    public synchronized TaxaDistribution increment(int taxaNum) {
        this.taxaWithTag.add(taxaNum);
        ++this.totalDepth;
        return this;
    }

    private void convertListToMap() {
        this.taxaTagMap = new TIntIntHashMap(this.maxTaxa);
        for (int taxaIndex : this.taxaWithTag.elements()) {
            this.taxaTagMap.adjustOrPutValue(taxaIndex, 1, 1);
        }
        this.taxaWithTag = null;
    }

    @Override
    public int[] depths() {
        int[] depths = new int[this.maxTaxa];
        if (this.taxaWithTag != null) {
            for (int i = 0; i < this.taxaWithTag.size(); ++i) {
                int n = this.taxaWithTag.getQuick(i);
                depths[n] = depths[n] + 1;
            }
        } else {
            TIntIntIterator sst = this.taxaTagMap.iterator();
            while (sst.hasNext()) {
                sst.advance();
                depths[sst.key()] = sst.value();
            }
        }
        return depths;
    }

    @Override
    public int totalDepth() {
        return this.totalDepth;
    }

    @Override
    public int maxTaxa() {
        return this.maxTaxa;
    }

    @Override
    public int numberOfTaxaWithTag() {
        return this.taxaWithDepths()[0].length;
    }

    @Override
    public int memorySize() {
        int size = 40;
        if (this.taxaWithTag != null) {
            size += this.taxaWithTag.size() * 8;
        }
        if (this.taxaTagMap != null) {
            size += this.taxaTagMap.size() * 12;
        }
        return size;
    }
}

