/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.awt.Component;
import javax.swing.JOptionPane;
import net.maizegenetics.util.ExceptionUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class DialogUtils {
    private static final Logger myLogger = Logger.getLogger(DialogUtils.class);
    private static final int DEFAULT_MESSAGE_LINE_LENGTH = 50;

    private DialogUtils() {
    }

    public static void showWarning(String str, Component parent) {
        if (parent == null) {
            myLogger.warn((Object)str);
        } else {
            JOptionPane.showMessageDialog(parent, DialogUtils.getErrorMessage(str), "Warning", 2);
        }
    }

    public static void showError(String str, Component parent) {
        if (parent == null) {
            myLogger.error((Object)str);
        } else {
            JOptionPane.showMessageDialog(parent, DialogUtils.getErrorMessage(str), "Error", 0);
        }
    }

    public static void showError(Throwable e, Component parent) {
        String str = Utils.shortenStrLineLen(ExceptionUtils.getExceptionCauses(e), 50, 7);
        if (parent == null) {
            myLogger.error((Object)str);
        } else {
            JOptionPane.showMessageDialog(parent, DialogUtils.getErrorMessage(str), "Error", 0);
        }
    }

    public static void showErrorCause(Throwable e, Component parent) {
        Throwable temp = e.getCause();
        if (temp != null) {
            DialogUtils.showError(temp, parent);
        } else {
            DialogUtils.showError(e, parent);
        }
    }

    private static String getErrorMessage(String message) {
        if (message.length() <= 50) {
            return message;
        }
        int count = 0;
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        int n = message.length();
        for (int i = 0; i < n; ++i) {
            ++count;
            if (message.charAt(i) == '\n') {
                builder.append("<br>");
                count = 0;
                continue;
            }
            if (count > 50 && message.charAt(i) == ' ') {
                builder.append("<br>");
                count = 0;
                continue;
            }
            builder.append(message.charAt(i));
        }
        builder.append("</html>");
        return builder.toString();
    }
}

