/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.matrixalgebra.decomposition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.EJMLDoubleMatrix;
import net.maizegenetics.matrixalgebra.decomposition.SingularValueDecomposition;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R5\u0010\t\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00030\u0003 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lnet/maizegenetics/matrixalgebra/decomposition/EJMLSingularValueDecomposition;", "Lnet/maizegenetics/matrixalgebra/decomposition/SingularValueDecomposition;", "matrix", "Lorg/ejml/data/DMatrixRMaj;", "(Lorg/ejml/data/DMatrixRMaj;)V", "getMatrix", "()Lorg/ejml/data/DMatrixRMaj;", "myMatrix", "getMyMatrix", "mySvd", "Lorg/ejml/interfaces/decomposition/SingularValueDecomposition_F64;", "kotlin.jvm.PlatformType", "getMySvd", "()Lorg/ejml/interfaces/decomposition/SingularValueDecomposition_F64;", "tol", "", "getTol", "()D", "getRank", "", "getS", "Lnet/maizegenetics/matrixalgebra/Matrix/DoubleMatrix;", "getSingularValues", "", "getU", "transpose", "", "getV", "tassel"})
public final class EJMLSingularValueDecomposition
implements SingularValueDecomposition {
    @NotNull
    private final DMatrixRMaj matrix;
    private final SingularValueDecomposition_F64<DMatrixRMaj> mySvd;
    @NotNull
    private final DMatrixRMaj myMatrix;
    private final double tol;

    public EJMLSingularValueDecomposition(@NotNull DMatrixRMaj matrix) {
        DMatrixRMaj dMatrixRMaj;
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        this.matrix = matrix;
        this.mySvd = DecompositionFactory_DDRM.svd((int)this.matrix.numRows, (int)this.matrix.numCols, (boolean)true, (boolean)true, (boolean)true);
        this.tol = 1.0E-10;
        if (this.mySvd.inputModified()) {
            DMatrixRMaj dMatrixRMaj2 = this.matrix.copy();
            Intrinsics.checkNotNullExpressionValue((Object)dMatrixRMaj2, (String)"matrix.copy()");
            dMatrixRMaj = dMatrixRMaj2;
        } else {
            dMatrixRMaj = this.myMatrix = this.matrix;
        }
        if (!this.mySvd.decompose((Matrix)this.matrix)) {
            boolean bl = false;
            String string = "unable to create singular value decomposition";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final DMatrixRMaj getMatrix() {
        return this.matrix;
    }

    public final SingularValueDecomposition_F64<DMatrixRMaj> getMySvd() {
        return this.mySvd;
    }

    @NotNull
    public final DMatrixRMaj getMyMatrix() {
        return this.myMatrix;
    }

    public final double getTol() {
        return this.tol;
    }

    @Override
    @NotNull
    public DoubleMatrix getU(boolean transpose) {
        Matrix matrix = this.mySvd.getU(null, transpose);
        Intrinsics.checkNotNullExpressionValue((Object)matrix, (String)"mySvd.getU(null, transpose)");
        return new EJMLDoubleMatrix((DMatrixRMaj)matrix);
    }

    @Override
    @NotNull
    public DoubleMatrix getV(boolean transpose) {
        Matrix matrix = this.mySvd.getV(null, transpose);
        Intrinsics.checkNotNullExpressionValue((Object)matrix, (String)"mySvd.getV(null, transpose)");
        return new EJMLDoubleMatrix((DMatrixRMaj)matrix);
    }

    @Override
    @NotNull
    public DoubleMatrix getS() {
        Matrix matrix = this.mySvd.getW(null);
        Intrinsics.checkNotNullExpressionValue((Object)matrix, (String)"mySvd.getW(null)");
        return new EJMLDoubleMatrix((DMatrixRMaj)matrix);
    }

    @Override
    @NotNull
    public double[] getSingularValues() {
        double[] dArray = this.mySvd.getSingularValues();
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"mySvd.singularValues");
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getRank() {
        void $this$filterTo$iv$iv;
        double[] $this$filter$iv = this.getSingularValues();
        boolean $i$f$filter = false;
        double[] dArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!(it >= this.getTol())) continue;
            destination$iv$iv.add((double)element$iv$iv);
        }
        return ((Collection)((List)destination$iv$iv)).size();
    }
}

