/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.util.TableReport;

public class GenotypePhenotype
implements TableReport {
    private final GenotypeTable myGenotype;
    private final Phenotype myPhenotype;
    private final String name;
    private final int[] observationToGenotypeIndex;

    GenotypePhenotype(GenotypeTable theGenotype, Phenotype thePhenotype, String name) {
        this.myGenotype = theGenotype;
        this.myPhenotype = thePhenotype;
        this.name = name;
        TaxaAttribute myTaxaAttr = this.myPhenotype.taxaAttribute();
        TaxaList myTaxaList = this.myGenotype.taxa();
        int numberOfObs = this.myPhenotype.numberOfObservations();
        this.observationToGenotypeIndex = new int[numberOfObs];
        for (int obs = 0; obs < numberOfObs; ++obs) {
            this.observationToGenotypeIndex[obs] = myTaxaList.indexOf(myTaxaAttr.taxon(obs));
        }
    }

    public GenotypeTable genotypeTable() {
        return this.myGenotype;
    }

    public Phenotype phenotype() {
        return this.myPhenotype;
    }

    public boolean areGenotypeValuesDiscrete() {
        return this.myGenotype.hasGenotype();
    }

    public boolean areTaxaReplicated() {
        this.myPhenotype.areTaxaReplicated();
        return true;
    }

    public String[] getStringGenotype(int site) {
        String missing = "N";
        int numberOfObs = this.myPhenotype.numberOfObservations();
        String[] geno = new String[numberOfObs];
        for (int obs = 0; obs < numberOfObs; ++obs) {
            int ndx = this.observationToGenotypeIndex[obs];
            geno[obs] = ndx < 0 ? missing : this.myGenotype.genotypeAsString(ndx, site);
        }
        return geno;
    }

    public byte genotype(int obs, int site) {
        int ndx = this.observationToGenotypeIndex[obs];
        if (ndx < 0) {
            return -1;
        }
        return this.myGenotype.genotype(ndx, site);
    }

    public boolean isHeterozygous(int obs, int site) {
        int ndx = this.observationToGenotypeIndex[obs];
        return this.myGenotype.isHeterozygous(ndx, site);
    }

    public byte[] genotypeAllTaxa(int site) {
        int numberOfObs = this.myPhenotype.numberOfObservations();
        byte[] geno = new byte[numberOfObs];
        for (int obs = 0; obs < numberOfObs; ++obs) {
            int ndx = this.observationToGenotypeIndex[obs];
            geno[obs] = ndx < 0 ? -1 : this.myGenotype.genotype(ndx, site);
        }
        return geno;
    }

    public float[] alleleProbsOfType(SiteScore.SITE_SCORE_TYPE type, int site) {
        int numberOfObs = this.myPhenotype.numberOfObservations();
        float[] values = new float[numberOfObs];
        for (int obs = 0; obs < numberOfObs; ++obs) {
            int ndx = this.observationToGenotypeIndex[obs];
            values[obs] = this.myGenotype.alleleProbability(ndx, site, type);
        }
        return values;
    }

    public float[] referenceProb(int site) {
        int numberOfObs = this.myPhenotype.numberOfObservations();
        float[] values = new float[numberOfObs];
        for (int obs = 0; obs < numberOfObs; ++obs) {
            int ndx = this.observationToGenotypeIndex[obs];
            values[obs] = ndx < 0 ? Float.NaN : this.myGenotype.referenceProbability(ndx, site);
        }
        return values;
    }

    @Override
    public Object[] getTableColumnNames() {
        int numberOfPhenotypeColumns = this.myPhenotype.getColumnCount();
        Object[] colNames = new Object[numberOfPhenotypeColumns + 1];
        System.arraycopy(this.myPhenotype.getTableColumnNames(), 0, colNames, 0, numberOfPhenotypeColumns);
        colNames[numberOfPhenotypeColumns] = "Genotype";
        return colNames;
    }

    @Override
    public String getTableTitle() {
        return this.name;
    }

    @Override
    public int getColumnCount() {
        return 1 + this.myPhenotype.getColumnCount();
    }

    @Override
    public long getRowCount() {
        return this.myPhenotype.getRowCount();
    }

    @Override
    public long getElementCount() {
        return (long)this.getColumnCount() * this.getRowCount();
    }

    @Override
    public Object[] getRow(long row) {
        int numberOfPhenotypeColumns = this.myPhenotype.getColumnCount();
        Object[] rowData = new Object[this.getColumnCount()];
        System.arraycopy(this.myPhenotype.getRow(row), 0, rowData, 0, numberOfPhenotypeColumns);
        rowData[numberOfPhenotypeColumns] = this.genotypeToDisplay((int)row);
        return rowData;
    }

    @Override
    public Object getValueAt(long row, int col) {
        int haplotypeColumn = this.myPhenotype.getColumnCount();
        if (col == haplotypeColumn) {
            return this.genotypeToDisplay((int)row);
        }
        return this.myPhenotype.getValueAt(row, col);
    }

    public int numberOfObservations() {
        return this.myPhenotype.numberOfObservations();
    }

    private String genotypeToDisplay(int row) {
        int genotypeRow = this.indexOfGenotype(row);
        if (genotypeRow < 0) {
            return "none";
        }
        int siteCount = Math.min(this.myGenotype.numberOfSites(), 10);
        StringBuilder builder = new StringBuilder();
        if (this.myGenotype.hasGenotype()) {
            builder.append(this.myGenotype.genotypeAsStringRange(genotypeRow, 0, siteCount));
        } else if (this.myGenotype.hasReferenceProbablity()) {
            siteCount = Math.min(this.myGenotype.numberOfSites(), 5);
            for (int i = 0; i < siteCount; ++i) {
                if (i > 0) {
                    builder.append(";");
                }
                builder.append(this.myGenotype.referenceProbability(genotypeRow, i));
            }
        } else if (this.myGenotype.hasAlleleProbabilities()) {
            for (int i = 0; i < siteCount; ++i) {
                builder.append(this.mostProbableAllele(genotypeRow, i));
            }
        } else {
            builder.append("???");
        }
        if (this.myGenotype.numberOfSites() > 10) {
            builder.append("...");
        }
        return builder.toString();
    }

    private String mostProbableAllele(int taxon, int site) {
        String allele = "A";
        float maxP = this.myGenotype.alleleProbability(taxon, site, SiteScore.SITE_SCORE_TYPE.ProbA);
        float prC = this.myGenotype.alleleProbability(taxon, site, SiteScore.SITE_SCORE_TYPE.ProbC);
        float prG = this.myGenotype.alleleProbability(taxon, site, SiteScore.SITE_SCORE_TYPE.ProbG);
        float prT = this.myGenotype.alleleProbability(taxon, site, SiteScore.SITE_SCORE_TYPE.ProbT);
        if (prC > maxP) {
            allele = "C";
            maxP = prC;
        }
        if (prG > maxP) {
            allele = "G";
            maxP = prG;
        }
        if (prT > maxP) {
            allele = "T";
        }
        return allele;
    }

    private int indexOfGenotype(int phenotypeRow) {
        return this.myGenotype.taxa().indexOf(this.myPhenotype.taxaAttribute().taxon(phenotypeRow).getName());
    }
}

