/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.maizegenetics.phenotype.CategoricalAttribute;
import net.maizegenetics.phenotype.CorePhenotype;
import net.maizegenetics.phenotype.FilterPhenotype;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.TaxaListUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import org.apache.log4j.Logger;

public class PhenotypeBuilder {
    private Logger myLogger = Logger.getLogger(PhenotypeBuilder.class);
    private SOURCE_TYPE source;
    private List<ACTION> actionList = new ArrayList<ACTION>();
    private List<String> filenameList = null;
    private List<Phenotype> phenotypeList = new ArrayList<Phenotype>();
    private String phenotypeName = "Phenotype";
    private List<PhenotypeAttribute> attributeList = null;
    private List<Phenotype.ATTRIBUTE_TYPE> attributeTypeList = null;
    private List<PhenotypeAttribute> separateByList = null;
    private List<Taxon> taxaToKeep = null;
    private List<Taxon> taxaToRemove = null;
    private int[] indexOfAttributesToKeep = null;
    private Map<PhenotypeAttribute, Phenotype.ATTRIBUTE_TYPE> attributeChangeMap = null;
    private boolean addSourceDataFactor = false;

    public PhenotypeBuilder fromFile(String filename) {
        if (this.filenameList == null) {
            this.filenameList = new ArrayList<String>();
        }
        this.filenameList.add(filename);
        this.source = SOURCE_TYPE.file;
        this.actionList.add(ACTION.importFile);
        return this;
    }

    public PhenotypeBuilder fromPhenotype(Phenotype base) {
        this.phenotypeList.add(base);
        this.source = SOURCE_TYPE.phenotype;
        return this;
    }

    public PhenotypeBuilder fromPhenotypeList(List<Phenotype> phenotypes) {
        this.phenotypeList.addAll(phenotypes);
        this.source = SOURCE_TYPE.list;
        StringBuilder sb = new StringBuilder();
        for (Phenotype pheno : phenotypes) {
            if (sb.length() > 0) {
                sb.append(" + ");
            }
            sb.append(pheno.name());
        }
        this.phenotypeName = sb.toString();
        return this;
    }

    public PhenotypeBuilder fromAttributeList(List<PhenotypeAttribute> attributes, List<Phenotype.ATTRIBUTE_TYPE> types) {
        this.attributeList = attributes;
        this.attributeTypeList = types;
        this.source = SOURCE_TYPE.attributes;
        this.actionList.add(ACTION.buildFromAttributes);
        return this;
    }

    public PhenotypeBuilder unionJoin() {
        this.actionList.add(ACTION.union);
        return this;
    }

    public PhenotypeBuilder intersectJoin() {
        this.actionList.add(ACTION.intersect);
        return this;
    }

    public PhenotypeBuilder concatenate() {
        this.actionList.add(ACTION.concatenate);
        return this;
    }

    public PhenotypeBuilder assignName(String name) {
        this.phenotypeName = name;
        return this;
    }

    public PhenotypeBuilder keepTaxa(List<Taxon> taxaToKeep) {
        this.actionList.add(ACTION.keepTaxa);
        this.taxaToKeep = taxaToKeep;
        return this;
    }

    public PhenotypeBuilder removeTaxa(List<Taxon> taxaToRemove) {
        this.actionList.add(ACTION.removeTaxa);
        this.taxaToRemove = taxaToRemove;
        return this;
    }

    public PhenotypeBuilder keepAttributes(List<PhenotypeAttribute> attributesToKeep) {
        this.actionList.add(ACTION.keepAttributes);
        this.attributeList = attributesToKeep;
        return this;
    }

    public PhenotypeBuilder keepAttributes(int[] indexOfAttributes) {
        this.actionList.add(ACTION.keepAttributes);
        this.indexOfAttributesToKeep = indexOfAttributes;
        return this;
    }

    public PhenotypeBuilder changeAttributeType(Map<PhenotypeAttribute, Phenotype.ATTRIBUTE_TYPE> changeMap) {
        if (this.attributeChangeMap == null) {
            this.attributeChangeMap = new HashMap<PhenotypeAttribute, Phenotype.ATTRIBUTE_TYPE>();
        }
        this.attributeChangeMap.putAll(changeMap);
        this.actionList.add(ACTION.changeType);
        return this;
    }

    public PhenotypeBuilder typesOfRetainedAttributes(List<Phenotype.ATTRIBUTE_TYPE> attributeTypes) {
        this.attributeTypeList = attributeTypes;
        return this;
    }

    public PhenotypeBuilder pivotOn(List<PhenotypeAttribute> factors) {
        for (PhenotypeAttribute attr : factors) {
            if (attr.isTypeCompatible(Phenotype.ATTRIBUTE_TYPE.factor)) continue;
            String msg = "One of the attributes in factors is not a CategoricalAttribute. Only CategoricalAttributes (factors) can be used for pivots.";
            throw new IllegalArgumentException(msg);
        }
        this.separateByList = factors;
        this.actionList.add(ACTION.separate);
        this.actionList.add(ACTION.union);
        return this;
    }

    public PhenotypeBuilder separateOn(List<PhenotypeAttribute> factors) {
        for (PhenotypeAttribute attr : factors) {
            if (attr.isTypeCompatible(Phenotype.ATTRIBUTE_TYPE.factor)) continue;
            String msg = "One of the attributes in factors is not a CategoricalAttribute. Only CategoricalAttributes (factors) can be used to separate Phenotype observations.";
            throw new IllegalArgumentException(msg);
        }
        this.separateByList = factors;
        this.actionList.add(ACTION.separate);
        return this;
    }

    public PhenotypeBuilder removeMissingObservations() {
        this.actionList.add(ACTION.removeMissing);
        return this;
    }

    public List<Phenotype> build() {
        for (ACTION action : this.actionList) {
            this.performAction(action);
        }
        return this.phenotypeList;
    }

    private void performAction(ACTION action) {
        switch (action) {
            case importFile: {
                this.importFile();
                break;
            }
            case intersect: {
                this.joinPhenotypes(action);
                break;
            }
            case union: {
                this.joinPhenotypes(action);
                break;
            }
            case concatenate: {
                this.concatenatePhenotypes();
                break;
            }
            case keepTaxa: {
                this.keepTaxaFilter();
                break;
            }
            case keepAttributes: {
                this.keepAttributesFilter();
                break;
            }
            case removeTaxa: {
                this.removeTaxaFilter();
                break;
            }
            case changeType: {
                this.applyAttributeChangeMap();
                break;
            }
            case separate: {
                this.separateByFactors();
                break;
            }
            case buildFromAttributes: {
                this.createPhenotypeFromLists();
                break;
            }
            case removeMissing: {
                this.removeAllObservationsWithMissingValues();
            }
        }
    }

    private void importFile() {
        while (this.filenameList.size() > 0) {
            File phenotypeFile = new File(this.filenameList.remove(0));
            try {
                BufferedReader br = new BufferedReader(new FileReader(phenotypeFile));
                Throwable throwable = null;
                try {
                    String topline = br.readLine();
                    if (this.phenotypeName.equals("Phenotype")) {
                        this.phenotypeName = phenotypeFile.getName();
                        if (this.phenotypeName.endsWith(".txt")) {
                            this.phenotypeName = this.phenotypeName.substring(0, this.phenotypeName.length() - 4);
                        }
                    }
                    Phenotype myPhenotype = topline.toLowerCase().startsWith("<phenotype") ? this.importPhenotypeFile(phenotypeFile) : this.importTraits(phenotypeFile);
                    br.close();
                    this.phenotypeList.add(myPhenotype);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (br == null) continue;
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    br.close();
                }
            }
            catch (IOException e) {
                String errorMsg = "Error reading " + phenotypeFile.getPath() + " in PhenotypeBuilder.importFile().";
                this.myLogger.error((Object)errorMsg);
                e.printStackTrace();
                throw new IllegalArgumentException(errorMsg);
            }
        }
    }

    private Phenotype importPhenotypeFile(File phenotypeFile) throws IOException {
        String inputStr;
        Pattern whiteSpace = Pattern.compile("\\s+");
        ArrayList<PhenotypeAttribute> attributes = new ArrayList<PhenotypeAttribute>();
        ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        BufferedReader phenotypeReader = new BufferedReader(new FileReader(phenotypeFile));
        phenotypeReader.readLine();
        String[] typeString = whiteSpace.split(phenotypeReader.readLine());
        String[] phenoNames = whiteSpace.split(phenotypeReader.readLine());
        if (typeString.length != phenoNames.length) {
            phenotypeReader.close();
            StringBuilder msg = new StringBuilder("Error importing ");
            msg.append(phenotypeFile.toString()).append(".\nThe number of data types must equal the number of phenotype names.");
            throw new IllegalArgumentException(msg.toString());
        }
        int taxaCol = 0;
        while (!typeString[taxaCol].toLowerCase().equals("taxa")) {
            if (++taxaCol != typeString.length) continue;
            phenotypeReader.close();
            StringBuilder msg = new StringBuilder("Error importing ");
            msg.append(phenotypeFile.toString()).append(".\ndata types must contain one taxa column");
            throw new IllegalArgumentException(msg.toString());
        }
        int nPheno = typeString.length;
        ArrayList<String[]> stringData = new ArrayList<String[]>();
        int lineNumber = 3;
        while ((inputStr = phenotypeReader.readLine()) != null) {
            ++lineNumber;
            String[] stringDataValues = whiteSpace.split(inputStr);
            if (stringDataValues.length != nPheno) {
                phenotypeReader.close();
                StringBuilder msg = new StringBuilder("Error importing ");
                msg.append(phenotypeFile.toString()).append(".\nImport stopped because line number ");
                msg.append(lineNumber).append(" had ").append(stringDataValues.length);
                msg.append(" values but there are ").append(nPheno).append(" data types in the header.");
                throw new IllegalArgumentException(msg.toString());
            }
            stringData.add(stringDataValues);
        }
        int nObs = stringData.size();
        for (int pheno = 0; pheno < nPheno; ++pheno) {
            if (typeString[pheno].toLowerCase().startsWith("cov") || typeString[pheno].toLowerCase().startsWith("dat")) {
                float[] dataArray = new float[nObs];
                OpenBitSet missing = new OpenBitSet(nObs);
                int obsCount = 0;
                for (String[] inputLine : stringData) {
                    if (inputLine[pheno].equalsIgnoreCase("NaN") || inputLine[pheno].equalsIgnoreCase("NA") || inputLine[pheno].equals(".")) {
                        dataArray[obsCount] = Float.NaN;
                        missing.fastSet(obsCount);
                    } else {
                        try {
                            dataArray[obsCount] = Float.parseFloat(inputLine[pheno]);
                        }
                        catch (NumberFormatException nfe) {
                            throw new IllegalArgumentException("PhenotypeBuilder: importPhenotypeFile: at observation " + obsCount + " Taxon: " + inputLine[taxaCol] + " Value: " + inputLine[pheno] + " is not a number.");
                        }
                    }
                    ++obsCount;
                }
                attributes.add(new NumericAttribute(phenoNames[pheno], dataArray, missing));
                if (typeString[pheno].toLowerCase().startsWith("cov")) {
                    types.add(Phenotype.ATTRIBUTE_TYPE.covariate);
                    continue;
                }
                types.add(Phenotype.ATTRIBUTE_TYPE.data);
                continue;
            }
            if (typeString[pheno].toLowerCase().startsWith("tax")) {
                ArrayList<Taxon> taxa = new ArrayList<Taxon>();
                for (String[] inputLine : stringData) {
                    taxa.add(new Taxon(inputLine[pheno]));
                }
                attributes.add(new TaxaAttribute(taxa, phenoNames[pheno]));
                types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
                continue;
            }
            if (typeString[pheno].toLowerCase().startsWith("fac")) {
                String[] labelArray = new String[nObs];
                int obsCount = 0;
                for (String[] inputLine : stringData) {
                    labelArray[obsCount++] = inputLine[pheno];
                }
                attributes.add(new CategoricalAttribute(phenoNames[pheno], labelArray));
                types.add(Phenotype.ATTRIBUTE_TYPE.factor);
                continue;
            }
            StringBuilder msg = new StringBuilder("Error Importing ");
            msg.append(phenotypeFile.toString()).append(".\nImproper data type : ").append(typeString[pheno]);
            throw new IllegalArgumentException(msg.toString());
        }
        phenotypeReader.close();
        return new CorePhenotype(attributes, types, this.phenotypeName);
    }

    private Phenotype importTraits(File phenotypeFile) throws IOException {
        BufferedReader phenotypeReader = new BufferedReader(new FileReader(phenotypeFile));
        int numberOfDataLines = 0;
        String inputline = phenotypeReader.readLine();
        ArrayList<String> headerLines = new ArrayList<String>();
        boolean isFactor = false;
        boolean isCovariate = false;
        boolean hasHeaders = false;
        boolean isTrait = false;
        String[] traitnames = new String[]{};
        while (inputline != null) {
            if ((inputline = inputline.trim()).length() > 1 && !inputline.startsWith("<") && !inputline.startsWith("#")) {
                ++numberOfDataLines;
            } else if (inputline.toLowerCase().startsWith("<trai")) {
                isTrait = true;
                String[] splitLine = inputline.split("[<>\\s]+");
                traitnames = Arrays.copyOfRange(splitLine, 2, splitLine.length);
            } else if (inputline.toLowerCase().startsWith("<cov")) {
                isCovariate = true;
            } else if (inputline.toLowerCase().startsWith("<fac")) {
                isFactor = true;
            } else if (inputline.toLowerCase().startsWith("<head")) {
                hasHeaders = true;
                headerLines.add(inputline);
            }
            inputline = phenotypeReader.readLine();
        }
        phenotypeReader.close();
        if (hasHeaders) {
            return this.processTraitsAndFactors(phenotypeFile, traitnames, numberOfDataLines, isCovariate, headerLines);
        }
        if (isFactor) {
            return this.processFactors(phenotypeFile, traitnames, numberOfDataLines);
        }
        if (isTrait) {
            return this.processTraits(phenotypeFile, traitnames, numberOfDataLines, isCovariate);
        }
        throw new IllegalArgumentException("Unrecognized format for a phenotype.");
    }

    private Phenotype processTraits(File phenotypeFile, String[] traitnames, int numberOfDataLines, boolean isCovariate) throws IOException {
        String inputline;
        int ntraits = traitnames.length;
        int nattributes = ntraits + 1;
        ArrayList<PhenotypeAttribute> attributes = new ArrayList<PhenotypeAttribute>(nattributes);
        ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>(nattributes);
        ArrayList<float[]> traitValues = new ArrayList<float[]>(ntraits);
        ArrayList<OpenBitSet> missingList = new ArrayList<OpenBitSet>(ntraits);
        ArrayList<Taxon> taxaList = new ArrayList<Taxon>();
        types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        Phenotype.ATTRIBUTE_TYPE myAttributeType = isCovariate ? Phenotype.ATTRIBUTE_TYPE.covariate : Phenotype.ATTRIBUTE_TYPE.data;
        for (int i = 0; i < ntraits; ++i) {
            traitValues.add(new float[numberOfDataLines]);
            missingList.add(new OpenBitSet(numberOfDataLines));
            types.add(myAttributeType);
        }
        BufferedReader phenotypeReader = new BufferedReader(new FileReader(phenotypeFile));
        int dataCount = 0;
        int lineCount = 1;
        while ((inputline = phenotypeReader.readLine()) != null) {
            if ((inputline = inputline.trim()).length() > 1 && !inputline.startsWith("<") && !inputline.startsWith("#")) {
                String[] values = inputline.split("\\s+");
                if (values.length != ntraits + 1) {
                    String msg = String.format("Incorrect number of values in line %d of %s", lineCount, phenotypeFile.getName());
                    phenotypeReader.close();
                    throw new IllegalArgumentException(msg);
                }
                taxaList.add(new Taxon(values[0]));
                for (int i = 0; i < ntraits; ++i) {
                    float val;
                    String inval = values[i + 1].trim();
                    if (inval.equals("-99") || inval.equals("-999")) {
                        val = Float.NaN;
                    } else {
                        try {
                            val = Float.parseFloat(inval);
                        }
                        catch (NumberFormatException e) {
                            val = Float.NaN;
                        }
                    }
                    if (Double.isNaN(val)) {
                        ((BitSet)missingList.get(i)).fastSet(dataCount);
                    }
                    ((float[])traitValues.get((int)i))[dataCount] = val;
                }
                ++dataCount;
            }
            ++lineCount;
        }
        phenotypeReader.close();
        attributes.add(new TaxaAttribute(taxaList));
        for (int i = 0; i < ntraits; ++i) {
            attributes.add(new NumericAttribute(traitnames[i], (float[])traitValues.get(i), (BitSet)missingList.get(i)));
        }
        return new CorePhenotype(attributes, types, this.phenotypeName);
    }

    private Phenotype processFactors(File phenotypeFile, String[] traitnames, int numberOfDataLines) throws IOException {
        String inputline;
        int ntraits = traitnames.length;
        int nattributes = ntraits + 1;
        ArrayList<PhenotypeAttribute> attributes = new ArrayList<PhenotypeAttribute>(nattributes);
        ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>(nattributes);
        ArrayList<String[]> traitValues = new ArrayList<String[]>(ntraits);
        ArrayList<Taxon> taxaList = new ArrayList<Taxon>();
        types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        Phenotype.ATTRIBUTE_TYPE myAttributeType = Phenotype.ATTRIBUTE_TYPE.factor;
        for (int i = 0; i < ntraits; ++i) {
            traitValues.add(new String[numberOfDataLines]);
            types.add(myAttributeType);
        }
        BufferedReader phenotypeReader = new BufferedReader(new FileReader(phenotypeFile));
        int dataCount = 0;
        int lineCount = 1;
        while ((inputline = phenotypeReader.readLine()) != null) {
            if ((inputline = inputline.trim()).length() > 1 && !inputline.startsWith("<") && !inputline.startsWith("#")) {
                String[] values = inputline.split("\\s+");
                if (values.length != ntraits + 1) {
                    String msg = String.format("Incorrect number of values in line %d of %s", lineCount, phenotypeFile.getName());
                    phenotypeReader.close();
                    throw new IllegalArgumentException(msg);
                }
                taxaList.add(new Taxon(values[0]));
                for (int i = 0; i < ntraits; ++i) {
                    ((String[])traitValues.get((int)i))[dataCount] = values[i + 1];
                }
                ++dataCount;
            }
            ++lineCount;
        }
        phenotypeReader.close();
        attributes.add(new TaxaAttribute(taxaList));
        for (int i = 0; i < ntraits; ++i) {
            attributes.add(new CategoricalAttribute(traitnames[i], (String[])traitValues.get(i)));
        }
        return new CorePhenotype(attributes, types, this.phenotypeName);
    }

    private Phenotype processTraitsAndFactors(File phenotypeFile, String[] traitnames, int numberOfDataLines, boolean isCovariate, ArrayList<String> headerList) throws IOException {
        int i;
        String inputline;
        int i2;
        TreeSet<String> traitSet = new TreeSet<String>();
        for (String trait : traitnames) {
            traitSet.add(trait);
        }
        HashMap<String, Integer> traitMap = new HashMap<String, Integer>();
        int traitCount = 0;
        for (String trait : traitSet) {
            traitMap.put(trait, traitCount++);
        }
        int ntraitnames = traitnames.length;
        int ntraits = traitSet.size();
        int nfactors = headerList.size();
        String[] factorNames = new String[nfactors];
        String[] splitHeader = headerList.get(0).split("[<>=\\s]+");
        factorNames[0] = splitHeader[3];
        String[] factorValues = Arrays.copyOfRange(splitHeader, 4, splitHeader.length);
        for (int i3 = 1; i3 < nfactors; ++i3) {
            splitHeader = headerList.get(i3).split("[<>=\\s]+");
            factorNames[i3] = splitHeader[3].replace("|", ":");
            for (int j = 0; j < factorValues.length; ++j) {
                int n = j;
                factorValues[n] = factorValues[n] + "|" + splitHeader[j + 4].replace("|", ":");
            }
        }
        TreeSet<String> factorSet = new TreeSet<String>();
        for (String val : factorValues) {
            factorSet.add(val);
        }
        int nCompositeFactors = factorSet.size();
        HashMap<String, Integer> factorMap = new HashMap<String, Integer>();
        int factorCount = 0;
        for (String factor : factorSet) {
            factorMap.put(factor, factorCount++);
        }
        int ndata = numberOfDataLines * nCompositeFactors;
        ArrayList<String[]> factorAttributeArrays = new ArrayList<String[]>(nfactors);
        for (int i4 = 0; i4 < nfactors; ++i4) {
            factorAttributeArrays.add(new String[ndata]);
        }
        int fromIndex = 0;
        int toIndex = numberOfDataLines;
        for (String factor : factorSet) {
            String[] subFactor = factor.split("\\|");
            for (i2 = 0; i2 < nfactors; ++i2) {
                Arrays.fill((Object[])factorAttributeArrays.get(i2), fromIndex, toIndex, subFactor[i2]);
            }
            fromIndex += numberOfDataLines;
            toIndex += numberOfDataLines;
        }
        ArrayList<float[]> traitAttributeArrays = new ArrayList<float[]>();
        ArrayList<OpenBitSet> missingList = new ArrayList<OpenBitSet>();
        ArrayList<Taxon> tempTaxa = new ArrayList<Taxon>();
        for (i2 = 0; i2 < ntraits; ++i2) {
            float[] traitArray = new float[ndata];
            Arrays.fill(traitArray, Float.NaN);
            traitAttributeArrays.add(traitArray);
            missingList.add(new OpenBitSet(ndata));
        }
        BufferedReader br = new BufferedReader(new FileReader(phenotypeFile));
        int dataCount = 0;
        int lineCount = 1;
        while ((inputline = br.readLine()) != null) {
            if ((inputline = inputline.trim()).length() > 1 && !inputline.startsWith("<") && !inputline.startsWith("#")) {
                String[] values = inputline.split("\\s+");
                if (values.length != ntraitnames + 1) {
                    String msg = String.format("Incorrect number of values in line %d of %s", lineCount, phenotypeFile.getName());
                    br.close();
                    throw new IllegalArgumentException(msg);
                }
                tempTaxa.add(new Taxon(values[0]));
                for (i = 0; i < ntraitnames; ++i) {
                    float val;
                    int traitnum = (Integer)traitMap.get(traitnames[i]);
                    int factornum = (Integer)factorMap.get(factorValues[i]);
                    int dataIndex = factornum * numberOfDataLines + dataCount;
                    try {
                        val = Float.parseFloat(values[i + 1]);
                    }
                    catch (NumberFormatException e) {
                        val = Float.NaN;
                        ((BitSet)missingList.get(traitnum)).fastSet(dataIndex);
                    }
                    ((float[])traitAttributeArrays.get((int)traitnum))[dataIndex] = val;
                }
                ++dataCount;
            }
            ++lineCount;
        }
        br.close();
        ArrayList<Taxon> taxaList = new ArrayList<Taxon>(ndata);
        for (i = 0; i < nCompositeFactors; ++i) {
            taxaList.addAll(tempTaxa);
        }
        Phenotype.ATTRIBUTE_TYPE myAttributeType = isCovariate ? Phenotype.ATTRIBUTE_TYPE.covariate : Phenotype.ATTRIBUTE_TYPE.data;
        ArrayList<PhenotypeAttribute> attributes = new ArrayList<PhenotypeAttribute>(nfactors + ntraits);
        ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>(nfactors + ntraits);
        attributes.add(new TaxaAttribute(taxaList));
        types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        for (int i5 = 0; i5 < nfactors; ++i5) {
            attributes.add(new CategoricalAttribute(factorNames[i5], (String[])factorAttributeArrays.get(i5)));
            types.add(Phenotype.ATTRIBUTE_TYPE.factor);
        }
        traitCount = 0;
        for (String trait : traitSet) {
            attributes.add(new NumericAttribute(trait, (float[])traitAttributeArrays.get(traitCount), (BitSet)missingList.get(traitCount)));
            types.add(myAttributeType);
            ++traitCount;
        }
        return new CorePhenotype(attributes, types, this.phenotypeName);
    }

    private void keepTaxaFilter() {
        ArrayList<Phenotype> newList = new ArrayList<Phenotype>();
        for (Phenotype pheno : this.phenotypeList) {
            newList.add(FilterPhenotype.getInstance(pheno, this.taxaToKeep, this.filterPhenotypeName(pheno.name())));
        }
        this.phenotypeList = newList;
    }

    private void keepAttributesFilter() {
        ArrayList<Phenotype> newList = new ArrayList<Phenotype>();
        for (Phenotype pheno : this.phenotypeList) {
            if (this.attributeList != null) {
                if (this.attributeTypeList == null) {
                    this.attributeTypeList = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
                    for (PhenotypeAttribute attr : this.attributeList) {
                        this.attributeTypeList.add(pheno.attributeType(pheno.indexOfAttribute(attr)));
                    }
                }
                this.applyAttributeChangeMap();
                newList.add(new CorePhenotype(this.attributeList, this.attributeTypeList, this.filterPhenotypeName(pheno.name())));
                continue;
            }
            if (this.indexOfAttributesToKeep == null) continue;
            if (this.indexOfAttributesToKeep.length == 1 && this.indexOfAttributesToKeep[0] == -1) {
                int nattr = pheno.numberOfAttributes();
                this.indexOfAttributesToKeep = new int[nattr - 1];
                for (int i = 0; i < this.indexOfAttributesToKeep.length; ++i) {
                    this.indexOfAttributesToKeep[i] = i;
                }
            }
            this.attributeList = new ArrayList<PhenotypeAttribute>();
            this.attributeTypeList = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
            for (Object attrnum : (Object)this.indexOfAttributesToKeep) {
                this.attributeList.add(pheno.attribute((int)attrnum));
            }
            if (this.attributeTypeList == null || this.attributeTypeList.size() != this.attributeList.size()) {
                for (Object attrnum : (Object)this.indexOfAttributesToKeep) {
                    this.attributeTypeList.add(pheno.attributeType((int)attrnum));
                }
            }
            this.applyAttributeChangeMap();
            newList.add(new CorePhenotype(this.attributeList, this.attributeTypeList, this.filterPhenotypeName(pheno.name())));
        }
        this.phenotypeList = newList;
    }

    private void removeTaxaFilter() {
        ArrayList<Phenotype> newList = new ArrayList<Phenotype>();
        for (Phenotype pheno : this.phenotypeList) {
            TaxaList myTaxaList = pheno.taxa();
            Iterator taxaIter = myTaxaList.iterator();
            TaxaListBuilder newTaxaList = new TaxaListBuilder();
            while (taxaIter.hasNext()) {
                Taxon current = (Taxon)taxaIter.next();
                if (this.taxaToRemove.contains(current)) continue;
                newTaxaList.add(current);
            }
            newList.add(FilterPhenotype.getInstance(pheno, newTaxaList.build(), "filtered_" + pheno.name()));
        }
        this.phenotypeList = newList;
    }

    private String filterPhenotypeName(String oldName) {
        if (oldName.toLowerCase().startsWith("filter")) {
            return oldName;
        }
        return "filtered_" + oldName;
    }

    private void separateByFactors() {
        ArrayList<Phenotype> newList = new ArrayList<Phenotype>();
        for (Phenotype pheno : this.phenotypeList) {
            newList.addAll(this.separatePhenotypeByFactors(pheno));
        }
        this.phenotypeList = newList;
    }

    private List<Phenotype> separatePhenotypeByFactors(Phenotype base) {
        ArrayList<Phenotype> phenotypeList = new ArrayList<Phenotype>();
        phenotypeList.add(base);
        for (PhenotypeAttribute factor : this.separateByList) {
            ArrayList<Phenotype> subsettedPhenotypeList = new ArrayList<Phenotype>();
            for (Phenotype pheno : phenotypeList) {
                subsettedPhenotypeList.addAll(this.subsetPhenotypeByOneFactor(pheno, (CategoricalAttribute)factor));
            }
            phenotypeList = subsettedPhenotypeList;
        }
        return phenotypeList;
    }

    private List<Phenotype> subsetPhenotypeByOneFactor(Phenotype base, CategoricalAttribute byFactor) {
        ArrayList<Phenotype> phenoList = new ArrayList<Phenotype>();
        int nlevels = byFactor.numberOfLevels();
        for (int i = 0; i < nlevels; ++i) {
            int[] subset = byFactor.whichObservations(i);
            ArrayList<PhenotypeAttribute> newAttr = new ArrayList<PhenotypeAttribute>();
            ArrayList<Phenotype.ATTRIBUTE_TYPE> newTypes = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
            String factorLevelName = byFactor.name() + "." + byFactor.labelList().get(i);
            String newPhenoName = base.name() + "_" + factorLevelName;
            for (int j = 0; j < base.numberOfAttributes(); ++j) {
                if (base.attribute(j).equals(byFactor)) continue;
                String newName = null;
                if (base.attributeType(j) == Phenotype.ATTRIBUTE_TYPE.data) {
                    newName = base.attribute(j).name() + "_" + factorLevelName;
                }
                newAttr.add(base.attribute(j).subset(subset, newName));
                newTypes.add(base.attributeType(j));
            }
            phenoList.add(new CorePhenotype(newAttr, newTypes, newPhenoName));
        }
        return phenoList;
    }

    private void applyAttributeChangeMap() {
        if (this.attributeChangeMap != null) {
            ArrayList<Phenotype> newList = new ArrayList<Phenotype>();
            for (Phenotype pheno : this.phenotypeList) {
                List<PhenotypeAttribute> attrList = pheno.attributeListCopy();
                List<Phenotype.ATTRIBUTE_TYPE> typeList = pheno.typeListCopy();
                int nattr = attrList.size();
                for (int i = 0; i < nattr; ++i) {
                    Phenotype.ATTRIBUTE_TYPE newType = this.attributeChangeMap.get(attrList.get(i));
                    if (newType == null) continue;
                    typeList.set(i, newType);
                }
                newList.add(new CorePhenotype(attrList, typeList, "retyped_" + pheno.name()));
            }
            this.phenotypeList = newList;
        }
    }

    private void createPhenotypeFromLists() {
        if (this.attributeList.size() != this.attributeTypeList.size()) {
            throw new IllegalArgumentException("Error building Phenotype: attribute list size not equal to type list size.");
        }
        Iterator<Phenotype.ATTRIBUTE_TYPE> typeIter = this.attributeTypeList.iterator();
        for (PhenotypeAttribute attr : this.attributeList) {
            Phenotype.ATTRIBUTE_TYPE type;
            if (attr.isTypeCompatible(type = typeIter.next())) continue;
            throw new IllegalArgumentException("Error building Phenotype: types not compatible with attributes.");
        }
        CorePhenotype newPhenotype = new CorePhenotype(this.attributeList, this.attributeTypeList, this.phenotypeName);
        this.phenotypeList.add(newPhenotype);
    }

    private void joinPhenotypes(ACTION joinAction) {
        if (this.phenotypeList.size() < 2) {
            throw new IllegalArgumentException("No join will be made because joining phenotypes requires at least two phenotypes.");
        }
        if (this.addSourceDataFactor) {
            this.mergePhenotypesWithDataSourceFactor();
        } else {
            Iterator<Phenotype> phenoIter = this.phenotypeList.iterator();
            Phenotype firstPhenotype = phenoIter.next();
            Phenotype secondPhenotype = phenoIter.next();
            Phenotype mergedPhenotype = this.mergeTwoPhenotypes(firstPhenotype, secondPhenotype, joinAction);
            while (phenoIter.hasNext()) {
                mergedPhenotype = this.mergeTwoPhenotypes(mergedPhenotype, phenoIter.next(), joinAction);
            }
            this.phenotypeList.clear();
            this.phenotypeList.add(mergedPhenotype);
        }
    }

    private void concatenatePhenotypes() {
        int nPheno = this.phenotypeList.size();
        if (nPheno < 2) {
            throw new IllegalArgumentException("No phenotypes to join: must specify at least two phenotypes.");
        }
        this.attributeList = new ArrayList<PhenotypeAttribute>();
        this.attributeTypeList = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        ArrayList<Taxon> jointTaxaList = new ArrayList<Taxon>();
        String attrName = this.phenotypeList.get(0).name();
        for (Phenotype pheno : this.phenotypeList) {
            TaxaAttribute someTaxa = pheno.taxaAttribute();
            if (someTaxa == null) {
                throw new IllegalArgumentException(String.format("Phenotypes cannot be concatenated because %s has no taxa.", pheno.name()));
            }
            jointTaxaList.addAll(someTaxa.allTaxaAsList());
        }
        TaxaAttribute myTaxaAttribute = new TaxaAttribute(jointTaxaList, attrName);
        this.attributeList.add(myTaxaAttribute);
        this.attributeTypeList.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        HashSet<String> attributeNameSet = new HashSet<String>();
        int totalNumberOfObs = 0;
        for (Phenotype pheno : this.phenotypeList) {
            int nattr = pheno.numberOfAttributes();
            totalNumberOfObs += pheno.numberOfObservations();
            for (int i = 0; i < nattr; ++i) {
                if (pheno.attributeType(i) == Phenotype.ATTRIBUTE_TYPE.taxa) continue;
                attributeNameSet.add(pheno.attributeName(i));
            }
        }
        for (String attributeName : attributeNameSet) {
            String[] values;
            Phenotype.ATTRIBUTE_TYPE myType = null;
            for (Phenotype pheno : this.phenotypeList) {
                int attrIndex = pheno.attributeIndexForName(attributeName);
                if (attrIndex <= -1) continue;
                myType = pheno.attributeType(attrIndex);
                break;
            }
            if (myType == Phenotype.ATTRIBUTE_TYPE.factor) {
                values = new String[totalNumberOfObs];
                int nPreviousObs = 0;
                for (Phenotype pheno : this.phenotypeList) {
                    int nObs = pheno.numberOfObservations();
                    int attrIndex = pheno.attributeIndexForName(attributeName);
                    if (attrIndex > -1) {
                        System.arraycopy((String[])pheno.attribute(attrIndex).allValues(), 0, values, nPreviousObs, nObs);
                    } else {
                        Arrays.fill(values, nPreviousObs, nPreviousObs + nObs, "?");
                    }
                    nPreviousObs += nObs;
                }
                this.attributeList.add(new CategoricalAttribute(attributeName, values));
                this.attributeTypeList.add(myType);
                continue;
            }
            values = (String[])new float[totalNumberOfObs];
            OpenBitSet missing = new OpenBitSet(totalNumberOfObs);
            int nPreviousObs = 0;
            for (Phenotype pheno : this.phenotypeList) {
                int nObs = pheno.numberOfObservations();
                int attrIndex = pheno.attributeIndexForName(attributeName);
                if (attrIndex > -1) {
                    PhenotypeAttribute thisAttribute = pheno.attribute(attrIndex);
                    System.arraycopy((float[])thisAttribute.allValues(), 0, values, nPreviousObs, nObs);
                    for (int i = 0; i < nObs; ++i) {
                        if (!thisAttribute.isMissing(i)) continue;
                        missing.fastSet(nPreviousObs + i);
                    }
                } else {
                    Arrays.fill((float[])values, nPreviousObs, nPreviousObs + nObs, Float.NaN);
                    missing.set(nPreviousObs, nPreviousObs + nObs);
                }
                nPreviousObs += nObs;
            }
            this.attributeList.add(new NumericAttribute(attributeName, (float[])values, missing));
            this.attributeTypeList.add(myType);
        }
        this.sortAttributes();
        this.phenotypeList.clear();
        this.phenotypeList.add(new CorePhenotype(this.attributeList, this.attributeTypeList, this.phenotypeName));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Phenotype mergeTwoPhenotypes(Phenotype pheno1, Phenotype pheno2, ACTION thisAction) {
        LinkedHashSet<String> attributeNameSet = new LinkedHashSet<String>();
        int nAttributes1 = pheno1.numberOfAttributes();
        for (int a = 0; a < nAttributes1; ++a) {
            if (pheno1.attributeType(a) == Phenotype.ATTRIBUTE_TYPE.taxa) continue;
            attributeNameSet.add(pheno1.attributeName(a));
        }
        int nAttributes2 = pheno2.numberOfAttributes();
        for (int a = 0; a < nAttributes2; ++a) {
            if (pheno2.attributeType(a) == Phenotype.ATTRIBUTE_TYPE.taxa) continue;
            attributeNameSet.add(pheno2.attributeName(a));
        }
        ArrayList attributeNameList = new ArrayList(attributeNameSet);
        ArrayList<Phenotype.ATTRIBUTE_TYPE> typeList = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        for (String name : attributeNameList) {
            int ndx = pheno1.attributeIndexForName(name);
            if (ndx > -1) {
                typeList.add(pheno1.attributeType(ndx));
                continue;
            }
            typeList.add(pheno2.attributeType(pheno2.attributeIndexForName(name)));
        }
        TaxaList outTaxa = thisAction.equals((Object)ACTION.union) ? TaxaListUtils.getAllTaxa(pheno1.taxa(), pheno2.taxa()) : TaxaListUtils.getCommonTaxa(pheno1.taxa(), pheno2.taxa());
        ArrayListMultimap pheno1ObservationMap = ArrayListMultimap.create();
        List<Taxon> pheno1Taxa = pheno1.taxaAttribute().allTaxaAsList();
        int taxonCount = 0;
        for (Taxon taxon : pheno1Taxa) {
            pheno1ObservationMap.put((Object)taxon, (Object)taxonCount++);
        }
        ArrayListMultimap pheno2ObservationMap = ArrayListMultimap.create();
        List<Taxon> pheno2Taxa = pheno2.taxaAttribute().allTaxaAsList();
        taxonCount = 0;
        for (Taxon taxon : pheno2Taxa) {
            pheno2ObservationMap.put((Object)taxon, (Object)taxonCount++);
        }
        ArrayList<String> mergeFactors = new ArrayList<String>();
        ArrayList<int[]> mergeFactorIndex = new ArrayList<int[]>();
        mergeFactors.addAll(this.listCommonNames(pheno1.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor), pheno2.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor)));
        mergeFactors.addAll(this.listCommonNames(pheno1.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate), pheno2.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate)));
        int numberOfMergeFactors = mergeFactors.size();
        if (numberOfMergeFactors > 0) {
            Collections.sort(mergeFactors);
            for (String factorName : mergeFactors) {
                mergeFactorIndex.add(new int[]{pheno1.attributeIndexForName(factorName), pheno2.attributeIndexForName(factorName)});
            }
        }
        ArrayList<int[]> mergeObservation = new ArrayList<int[]>();
        ArrayList<Taxon> listOfTaxaForObservations = new ArrayList<Taxon>();
        for (Taxon taxon : outTaxa) {
            Object obs12;
            Collection pheno1obs = pheno1ObservationMap.get((Object)taxon);
            Collection pheno2obs = pheno2ObservationMap.get((Object)taxon);
            boolean[] wasPheno2ObsUsed = new boolean[pheno2obs.size()];
            Arrays.fill(wasPheno2ObsUsed, false);
            for (Object obs12 : pheno1obs) {
                boolean wasPheno1ObsUsed = false;
                int obs2Count = 0;
                for (Integer obs2 : pheno2obs) {
                    boolean mergeTheseObs = true;
                    Iterator iterator = mergeFactorIndex.iterator();
                    if (iterator.hasNext()) {
                        int[] ndx = (int[])iterator.next();
                        if (!pheno1.value((Integer)obs12, ndx[0]).equals(pheno2.value(obs2, ndx[1]))) {
                            mergeTheseObs = false;
                        }
                    }
                    if (mergeTheseObs) {
                        wasPheno1ObsUsed = true;
                        wasPheno2ObsUsed[obs2Count] = true;
                        mergeObservation.add(new int[]{(Integer)obs12, obs2});
                        listOfTaxaForObservations.add(taxon);
                    }
                    ++obs2Count;
                }
                if (wasPheno1ObsUsed) continue;
                mergeObservation.add(new int[]{(Integer)obs12, -1});
                listOfTaxaForObservations.add(taxon);
            }
            int obs2Count = 0;
            obs12 = pheno2obs.iterator();
            while (obs12.hasNext()) {
                Integer obs2 = (Integer)obs12.next();
                if (wasPheno2ObsUsed[obs2Count++]) continue;
                mergeObservation.add(new int[]{-1, obs2});
                listOfTaxaForObservations.add(taxon);
            }
        }
        TaxaAttribute newTaxaAttribute = new TaxaAttribute(listOfTaxaForObservations, pheno1.taxaAttribute().name());
        ArrayList<PhenotypeAttribute> newAttributes = new ArrayList<PhenotypeAttribute>();
        ArrayList<Phenotype.ATTRIBUTE_TYPE> newTypes = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        newAttributes.add(newTaxaAttribute);
        newTypes.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        int nAdd = attributeNameList.size();
        int nObs = mergeObservation.size();
        block14: for (int i = 0; i < nAdd; ++i) {
            Phenotype.ATTRIBUTE_TYPE myType = (Phenotype.ATTRIBUTE_TYPE)((Object)typeList.get(i));
            String attrName = (String)attributeNameList.get(i);
            int[] attrnum = new int[]{pheno1.attributeIndexForName(attrName), pheno2.attributeIndexForName(attrName)};
            switch (myType) {
                case data: 
                case covariate: {
                    float[] myFloatData = new float[nObs];
                    OpenBitSet myMissing = new OpenBitSet(nObs);
                    int obsCount = 0;
                    for (int[] ndx : mergeObservation) {
                        boolean pheno2HasNonmissingValue;
                        boolean pheno1HasNonmissingValue = attrnum[0] > -1 && ndx[0] > -1 && !pheno1.isMissing(ndx[0], attrnum[0]);
                        boolean bl = pheno2HasNonmissingValue = attrnum[1] > -1 && ndx[1] > -1 && !pheno2.isMissing(ndx[1], attrnum[1]);
                        if (pheno1HasNonmissingValue && pheno2HasNonmissingValue) {
                            throw new IllegalArgumentException("Data sets will not be joined because both phenotypes have values for " + attrName);
                        }
                        if (pheno1HasNonmissingValue) {
                            myFloatData[obsCount] = ((Float)pheno1.value(ndx[0], attrnum[0])).floatValue();
                        } else if (pheno2HasNonmissingValue) {
                            myFloatData[obsCount] = ((Float)pheno2.value(ndx[1], attrnum[1])).floatValue();
                        } else {
                            myFloatData[obsCount] = Float.NaN;
                            myMissing.fastSet(obsCount);
                        }
                        ++obsCount;
                    }
                    newAttributes.add(new NumericAttribute(attrName, myFloatData, myMissing));
                    newTypes.add(myType);
                    continue block14;
                }
                case factor: {
                    boolean isMergeAttribute = mergeFactors.contains(attrName);
                    String[] myStringData = new String[nObs];
                    int obsCount = 0;
                    for (int[] ndx : mergeObservation) {
                        boolean pheno2HasNonmissingValue;
                        boolean pheno1HasNonmissingValue = attrnum[0] > -1 && ndx[0] > -1 && !pheno1.isMissing(ndx[0], attrnum[0]);
                        boolean bl = pheno2HasNonmissingValue = attrnum[1] > -1 && ndx[1] > -1 && !pheno2.isMissing(ndx[1], attrnum[1]);
                        if (pheno1HasNonmissingValue && pheno2HasNonmissingValue) {
                            if (!isMergeAttribute) throw new IllegalArgumentException("Data sets will not be joined because both phenotypes have values for " + attrName);
                            myStringData[obsCount] = (String)pheno1.value(ndx[0], attrnum[0]);
                        } else {
                            myStringData[obsCount] = pheno1HasNonmissingValue ? (String)pheno1.value(ndx[0], attrnum[0]) : (pheno2HasNonmissingValue ? (String)pheno2.value(ndx[1], attrnum[1]) : "?");
                        }
                        ++obsCount;
                    }
                    newAttributes.add(new CategoricalAttribute(attrName, myStringData));
                    newTypes.add(myType);
                }
            }
        }
        return new CorePhenotype(newAttributes, newTypes, this.phenotypeName);
    }

    private List<Phenotype> makeAttributeNamesDifferent(List<Phenotype> phenoList) {
        int npheno = phenoList.size();
        HashMultiset attrNameSet = HashMultiset.create();
        for (Phenotype pheno : phenoList) {
            for (int i = 0; i < pheno.numberOfAttributes(); ++i) {
                if (pheno.attributeType(i) == Phenotype.ATTRIBUTE_TYPE.taxa) continue;
                attrNameSet.add((Object)pheno.attributeName(i));
            }
        }
        ArrayList attrNameMapList = new ArrayList();
        for (int i = 0; i < npheno; ++i) {
            attrNameMapList.add(new HashMap());
        }
        for (String attrName : attrNameSet) {
            if (attrNameSet.count((Object)attrName) <= 1) continue;
            for (int i = 0; i < npheno; ++i) {
                int ndx = phenoList.get(i).attributeIndexForName(attrName);
                if (ndx <= -1) continue;
                ((HashMap)attrNameMapList.get(i)).put(attrName, attrName + "." + i);
            }
        }
        ArrayList<Phenotype> newPhenotypeList = new ArrayList<Phenotype>();
        for (int i = 0; i < npheno; ++i) {
            if (((HashMap)attrNameMapList.get(i)).size() > 0) {
                List<PhenotypeAttribute> attrList = phenoList.get(i).attributeListCopy();
                List<Phenotype.ATTRIBUTE_TYPE> typeList = phenoList.get(i).typeListCopy();
                for (String oldname : ((HashMap)attrNameMapList.get(i)).keySet()) {
                    int ndx = phenoList.get(i).attributeIndexForName(oldname);
                    if (ndx <= -1) continue;
                    PhenotypeAttribute newAttr = phenoList.get(i).attribute(ndx).changeName((String)((HashMap)attrNameMapList.get(i)).get(oldname));
                    attrList.set(ndx, newAttr);
                }
                newPhenotypeList.add(new CorePhenotype(attrList, typeList, phenoList.get(i).name()));
                continue;
            }
            newPhenotypeList.add(phenoList.get(i));
        }
        return newPhenotypeList;
    }

    private void mergePhenotypesWithDataSourceFactor() {
        HashMap<String, Phenotype.ATTRIBUTE_TYPE> typeMap = new HashMap<String, Phenotype.ATTRIBUTE_TYPE>();
        for (Phenotype pheno : this.phenotypeList) {
            for (int i = 0; i < pheno.numberOfAttributes(); ++i) {
                if (pheno.attributeType(i) == Phenotype.ATTRIBUTE_TYPE.taxa) continue;
                typeMap.put(pheno.attributeName(i), pheno.attributeType(i));
            }
        }
        ArrayList attrNames = new ArrayList(typeMap.keySet());
        Collections.sort(attrNames);
        ArrayList<Phenotype.ATTRIBUTE_TYPE> newTypeList = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        for (Object aname : attrNames) {
            newTypeList.add((Phenotype.ATTRIBUTE_TYPE)((Object)typeMap.get(aname)));
        }
        int totalObservations = 0;
        for (Phenotype ph : this.phenotypeList) {
            totalObservations += ph.numberOfObservations();
        }
        ArrayList<Object[]> attrData = new ArrayList<Object[]>();
        ArrayList<OpenBitSet> missingData = new ArrayList<OpenBitSet>();
        for (String aname : attrNames) {
            missingData.add(new OpenBitSet(totalObservations));
            Phenotype.ATTRIBUTE_TYPE atype = (Phenotype.ATTRIBUTE_TYPE)((Object)typeMap.get(aname));
            if (atype == Phenotype.ATTRIBUTE_TYPE.covariate || atype == Phenotype.ATTRIBUTE_TYPE.data) {
                attrData.add(new float[0]);
                continue;
            }
            attrData.add(new String[0]);
        }
        ArrayList<Taxon> taxaList = new ArrayList<Taxon>();
        ArrayList<String> dataSourceNames = new ArrayList<String>();
        int startObs = 0;
        for (int p = 0; p < this.phenotypeList.size(); ++p) {
            Phenotype pheno = this.phenotypeList.get(p);
            int nobs = pheno.numberOfObservations();
            taxaList.addAll(pheno.taxa());
            String sourceName = pheno.name();
            for (int i = 0; i < pheno.numberOfObservations(); ++i) {
                dataSourceNames.add(sourceName);
            }
            for (int a = 0; a < attrNames.size(); ++a) {
                float[] floatData;
                int i;
                String[] stringData;
                String aname = (String)attrNames.get(a);
                int ndx = pheno.attributeIndexForName(aname);
                OpenBitSet md = (OpenBitSet)missingData.get(a);
                Object data = attrData.get(a);
                if (ndx > -1) {
                    int origObs;
                    if (data instanceof String[]) {
                        stringData = (String[])data;
                        for (i = startObs; i < nobs; ++i) {
                            origObs = i - startObs;
                            if (pheno.isMissing(origObs, ndx)) {
                                md.fastSet(i);
                            }
                            stringData[i] = (String)pheno.value(origObs, ndx);
                        }
                        continue;
                    }
                    floatData = (float[])data;
                    for (i = startObs; i < nobs; ++i) {
                        origObs = i - startObs;
                        if (pheno.isMissing(origObs, ndx)) {
                            md.fastSet(i);
                        }
                        floatData[i] = ((Float)pheno.value(origObs, ndx)).floatValue();
                    }
                    continue;
                }
                if (data instanceof String[]) {
                    stringData = (String[])data;
                    for (i = startObs; i < nobs; ++i) {
                        md.fastSet(i);
                        stringData[i] = "?";
                    }
                    continue;
                }
                floatData = (float[])data;
                for (i = startObs; i < nobs; ++i) {
                    md.fastSet(i);
                    floatData[i] = Float.NaN;
                }
            }
        }
        ArrayList<PhenotypeAttribute> newAttrList = new ArrayList<PhenotypeAttribute>();
        for (int a = 0; a < attrNames.size(); ++a) {
            Object data = attrData.get(a);
            if (data instanceof String[]) {
                newAttrList.add(new CategoricalAttribute((String)attrNames.get(a), (String[])data));
                continue;
            }
            newAttrList.add(new NumericAttribute((String)attrNames.get(a), (float[])data, (BitSet)missingData.get(a)));
        }
        this.phenotypeList.clear();
        StringBuilder newPhenotypeName = new StringBuilder();
        for (Phenotype pheno : this.phenotypeList) {
            if (newPhenotypeName.length() > 0) {
                newPhenotypeName.append("+");
            }
            newPhenotypeName.append(pheno.name());
        }
        this.phenotypeList.add(new CorePhenotype(newAttrList, newTypeList, newPhenotypeName.toString()));
    }

    private List<String> listCommonNames(List<PhenotypeAttribute> list1, List<PhenotypeAttribute> list2) {
        ArrayList<String> outlist = new ArrayList<String>();
        for (PhenotypeAttribute attr1 : list1) {
            String name1 = attr1.name();
            for (PhenotypeAttribute attr2 : list2) {
                if (!name1.equalsIgnoreCase(attr2.name())) continue;
                outlist.add(name1);
            }
        }
        return outlist;
    }

    private void sortAttributes() {
        int nAttr = this.attributeList.size();
        ArrayList<Integer> index = new ArrayList<Integer>();
        for (int i = 0; i < nAttr; ++i) {
            index.add(i);
        }
        Collections.sort(index, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                Phenotype.ATTRIBUTE_TYPE type2;
                Phenotype.ATTRIBUTE_TYPE type1 = (Phenotype.ATTRIBUTE_TYPE)((Object)PhenotypeBuilder.this.attributeTypeList.get(o1));
                if (type1 == (type2 = (Phenotype.ATTRIBUTE_TYPE)((Object)PhenotypeBuilder.this.attributeTypeList.get(o2)))) {
                    return ((PhenotypeAttribute)PhenotypeBuilder.this.attributeList.get(o1)).name().compareTo(((PhenotypeAttribute)PhenotypeBuilder.this.attributeList.get(o2)).name());
                }
                if (type1 == Phenotype.ATTRIBUTE_TYPE.taxa) {
                    return -1;
                }
                if (type2 == Phenotype.ATTRIBUTE_TYPE.taxa) {
                    return 1;
                }
                if (type1 == Phenotype.ATTRIBUTE_TYPE.factor) {
                    return -1;
                }
                if (type2 == Phenotype.ATTRIBUTE_TYPE.factor) {
                    return 1;
                }
                if (type1 == Phenotype.ATTRIBUTE_TYPE.covariate) {
                    return -1;
                }
                if (type2 == Phenotype.ATTRIBUTE_TYPE.covariate) {
                    return 1;
                }
                return 0;
            }
        });
        List<PhenotypeAttribute> unsortedAttributeList = this.attributeList;
        List<Phenotype.ATTRIBUTE_TYPE> unsortedAttributeTypeList = this.attributeTypeList;
        this.attributeList = new ArrayList<PhenotypeAttribute>();
        this.attributeTypeList = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        for (Integer ndx : index) {
            this.attributeList.add(unsortedAttributeList.get(ndx));
            this.attributeTypeList.add(unsortedAttributeTypeList.get(ndx));
        }
    }

    private void removeAllObservationsWithMissingValues() {
        ArrayList<Phenotype> newList = new ArrayList<Phenotype>();
        for (Phenotype pheno : this.phenotypeList) {
            int nobs = pheno.numberOfObservations();
            OpenBitSet anyMissing = new OpenBitSet(nobs);
            pheno.attributeStream().map(PhenotypeAttribute::missing).reduce(anyMissing, (a, b) -> {
                a.or((BitSet)b);
                return a;
            });
            int[] nonMissingIndex = IntStream.range(0, nobs).filter(i -> !anyMissing.fastGet(i)).toArray();
            List<PhenotypeAttribute> subsetList = pheno.attributeStream().map(a -> a.subset(nonMissingIndex, a.name())).collect(Collectors.toList());
            CorePhenotype myNewPhenotype = new CorePhenotype(subsetList, pheno.typeListCopy(), "NonMissing_" + pheno.name());
            newList.add(myNewPhenotype);
        }
        this.phenotypeList = newList;
    }

    private static enum ACTION {
        importFile,
        union,
        intersect,
        separate,
        concatenate,
        keepTaxa,
        removeTaxa,
        keepAttributes,
        changeType,
        buildFromAttributes,
        removeMissing;

    }

    private static enum SOURCE_TYPE {
        file,
        phenotype,
        list,
        attributes;

    }
}

