/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import java.util.ArrayList;
import java.util.List;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;

public class TaxaAttribute
implements PhenotypeAttribute {
    private final ArrayList<Taxon> taxaList;
    private final int numberOfTaxa;
    private final String name;
    public static final String DEFAULT_NAME = "Taxa";
    private static final List<Phenotype.ATTRIBUTE_TYPE> myAllowedTypes = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();

    public TaxaAttribute(List<Taxon> taxa, String name) {
        this.name = DEFAULT_NAME;
        this.taxaList = taxa instanceof ArrayList ? (ArrayList<Object>)taxa : new ArrayList<Taxon>(taxa);
        this.numberOfTaxa = taxa.size();
    }

    public TaxaAttribute(List<Taxon> taxa) {
        this(taxa, DEFAULT_NAME);
    }

    public Taxon[] allTaxa() {
        return this.taxaList.toArray(new Taxon[this.numberOfTaxa]);
    }

    public List<Taxon> allTaxaAsList() {
        return new ArrayList<Taxon>(this.taxaList);
    }

    public Taxon taxon(int obs) {
        return this.taxaList.get(obs);
    }

    @Override
    public Object value(int obs) {
        return this.taxaList.get(obs);
    }

    @Override
    public Object allValues() {
        Taxon[] taxaArray = new Taxon[this.numberOfTaxa];
        return this.taxaList.toArray(taxaArray);
    }

    @Override
    public PhenotypeAttribute subset(int[] obs, String newName) {
        int n = obs.length;
        ArrayList<Taxon> subset = new ArrayList<Taxon>();
        for (int i = 0; i < n; ++i) {
            subset.add(this.taxaList.get(obs[i]));
        }
        if (newName == null) {
            newName = this.name;
        }
        return new TaxaAttribute(subset, newName);
    }

    @Override
    public PhenotypeAttribute changeName(String newName) {
        return new TaxaAttribute(this.taxaList, newName);
    }

    @Override
    public boolean isMissing(int obs) {
        return false;
    }

    @Override
    public BitSet missing() {
        return new OpenBitSet(this.numberOfTaxa);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int size() {
        return this.numberOfTaxa;
    }

    @Override
    public List<Phenotype.ATTRIBUTE_TYPE> getCompatibleTypes() {
        return myAllowedTypes;
    }

    @Override
    public boolean isTypeCompatible(Phenotype.ATTRIBUTE_TYPE type) {
        return myAllowedTypes.contains((Object)type);
    }

    public String toString() {
        return this.name();
    }

    static {
        myAllowedTypes.add(Phenotype.ATTRIBUTE_TYPE.taxa);
    }
}

