/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.plugindef;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.snp.io.JSONUtils;
import net.maizegenetics.dna.snp.io.ReadBedfile;
import net.maizegenetics.gui.DialogUtils;
import net.maizegenetics.gui.SelectFromAvailableDialog;
import net.maizegenetics.gui.SiteNamesAvailableListModel;
import net.maizegenetics.gui.TaxaAvailableListModel;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.ParameterCache;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginListener;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.plugindef.ThreadedPluginListener;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.distance.ReadDistanceMatrix;
import net.maizegenetics.util.ExceptionUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public abstract class AbstractPlugin
implements Plugin {
    private static final Logger myLogger = Logger.getLogger(AbstractPlugin.class);
    public static final String DEFAULT_CITATION = "Bradbury PJ, Zhang Z, Kroon DE, Casstevens TM, Ramdoss Y, Buckler ES. (2007) TASSEL: Software for association mapping of complex traits in diverse samples. Bioinformatics 23:2633-2635.";
    public static final String POSITION_LIST_NONE = "None";
    public static final String TAXA_LIST_NONE = "None";
    private final List<PluginListener> myListeners = new ArrayList<PluginListener>();
    private final List<Plugin> myInputs = new ArrayList<Plugin>();
    private DataSet myCurrentInputData = null;
    private final Frame myParentFrame;
    private final boolean myIsInteractive;
    private boolean myTrace = false;
    private boolean myThreaded = false;
    protected boolean myWasCancelled = false;
    private static final int TEXT_FIELD_WIDTH = 25;
    private boolean parametersAreSet = true;
    private static final int DEFAULT_TOOL_TIP_LINE_LENGTH = 50;
    private static final List<String> myPrintedCitations = new ArrayList<String>();

    public AbstractPlugin() {
        this(null, true);
    }

    public AbstractPlugin(Frame parentFrame, boolean isInteractive) {
        this.myParentFrame = parentFrame;
        this.myIsInteractive = isInteractive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        LocalDateTime time = LocalDateTime.now();
        String timeStr = time.format(DateTimeFormatter.ofPattern("MMM d, uuuu H:mm:s"));
        myLogger.info((Object)("Starting " + this.getClass().getName() + ": time: " + timeStr));
        this.myCurrentInputData = input;
        try {
            this.preProcessParameters(input);
            if (this.isInteractive() && !this.setParametersViaGUI()) {
                DataSet dataSet = null;
                return dataSet;
            }
            this.checkRequiredParameters();
            this.postProcessParameters();
            this.printParameterValues();
            this.checkParameters();
            DataSet output = this.processData(input);
            time = LocalDateTime.now();
            timeStr = time.format(DateTimeFormatter.ofPattern("MMM d, uuuu H:mm:s"));
            myLogger.info((Object)("Finished " + this.getClass().getName() + ": time: " + timeStr));
            this.fireDataSetReturned(new PluginEvent(output, this.getClass()));
            DataSet dataSet = output;
            return dataSet;
        }
        catch (Exception e) {
            if (this.isInteractive()) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                DialogUtils.showError(e.getMessage() + "\n", (Component)this.getParentFrame());
            } else {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                this.printUsage();
                myLogger.error((Object)e.getMessage());
                if (!this.getListeners().isEmpty()) {
                    System.exit(1);
                }
            }
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    protected void preProcessParameters(DataSet input) {
    }

    protected void postProcessParameters() {
    }

    @Override
    public DataSet processData(DataSet input) {
        throw new UnsupportedOperationException();
    }

    protected List<Field> getParameterFields() {
        Field[] fields;
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field current : fields = this.getClass().getDeclaredFields()) {
            if (!current.getType().isAssignableFrom(PluginParameter.class)) continue;
            current.setAccessible(true);
            result.add(current);
        }
        return result;
    }

    private List<PluginParameter<?>> getParameterInstances() {
        Field[] fields;
        ArrayList result = new ArrayList();
        for (Field current : fields = this.getClass().getDeclaredFields()) {
            if (!current.getType().isAssignableFrom(PluginParameter.class)) continue;
            current.setAccessible(true);
            try {
                PluginParameter parameter = (PluginParameter)current.get(this);
                result.add(parameter);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("AbstractPlugin: getParameterInstances: problem getting parameter instances");
            }
        }
        return result;
    }

    private Field getParameterField(String key) {
        Field[] fields;
        for (Field current : fields = this.getClass().getDeclaredFields()) {
            if (!current.getType().isAssignableFrom(PluginParameter.class)) continue;
            try {
                current.setAccessible(true);
                PluginParameter parameter = (PluginParameter)current.get(this);
                if (!parameter.cmdLineName().equals(key)) continue;
                return current;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("AbstractPlugin: getParameterField: problem with key: " + key);
            }
        }
        throw new IllegalArgumentException("AbstractPlugin: getParameterField: unknown key: " + key);
    }

    private PluginParameter<?> getParameterInstance(String key) {
        try {
            Field field = this.getParameterField(key);
            return (PluginParameter)field.get(this);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isPluginParameter(String key) {
        return this.getParameterInstance(key) != null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T convert(String input, Class<T> outputClass) {
        block35: {
            if (input == null || input.length() == 0) {
                return null;
            }
            if (outputClass.isEnum()) {
                return Enum.valueOf(outputClass, input);
            }
            if (outputClass.isAssignableFrom(String.class)) {
                return (T)input;
            }
            if (outputClass.isAssignableFrom(Integer.class)) {
                groupingSeparator = DecimalFormatSymbols.getInstance(Locale.getDefault()).getGroupingSeparator();
                input = input.replace(String.valueOf(groupingSeparator), "");
                decimalSeparator = DecimalFormatSymbols.getInstance(Locale.getDefault()).getDecimalSeparator();
                input = input.replace(String.valueOf(decimalSeparator), ".");
                return (T)new Integer(new BigDecimal(input).intValueExact());
            }
            if (outputClass.isAssignableFrom(Double.class)) {
                groupingSeparator = DecimalFormatSymbols.getInstance(Locale.getDefault()).getGroupingSeparator();
                input = input.replace(String.valueOf(groupingSeparator), "");
                decimalSeparator = DecimalFormatSymbols.getInstance(Locale.getDefault()).getDecimalSeparator();
                input = input.replace(String.valueOf(decimalSeparator), ".");
                return (T)new Double(new BigDecimal(input).doubleValue());
            }
            if (outputClass.isAssignableFrom(Float.class)) {
                groupingSeparator = DecimalFormatSymbols.getInstance(Locale.getDefault()).getGroupingSeparator();
                input = input.replace(String.valueOf(groupingSeparator), "");
                decimalSeparator = DecimalFormatSymbols.getInstance(Locale.getDefault()).getDecimalSeparator();
                input = input.replace(String.valueOf(decimalSeparator), ".");
                return (T)new Double(new BigDecimal(input).floatValue());
            }
            if (outputClass.isAssignableFrom(List.class)) {
                return (T)AbstractPlugin.getListFromString(input);
            }
            if (outputClass.isAssignableFrom(SortedSet.class)) {
                return (T)AbstractPlugin.getSortedSet(input);
            }
            if (!outputClass.isAssignableFrom(PositionList.class)) ** GOTO lbl44
            test = input.trim().substring(Math.max(0, input.length() - 8)).toLowerCase();
            if (test.endsWith(".bed") || test.endsWith(".bed.gz")) {
                return (T)ReadBedfile.getPositionList(input);
            }
            if (!test.endsWith(".json") && !test.endsWith(".json.gz")) break block35;
            return (T)JSONUtils.importPositionListFromJSON(input);
        }
        try {
            temp = ImportUtils.read(input);
            return (T)temp.positions();
        }
        catch (Exception e) {
            try {
                AbstractPlugin.myLogger.debug((Object)e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException("AbstractPlugin: convert: don't know who to covert: " + input + " to postion list");
lbl44:
                // 1 sources

                if (outputClass.isAssignableFrom(TaxaList.class)) {
                    test = input.trim().substring(Math.max(0, input.length() - 8)).toLowerCase();
                    if (test.endsWith(".json") || test.endsWith(".json.gz")) {
                        return (T)JSONUtils.importTaxaListFromJSON(input);
                    }
                    if (!test.endsWith(".txt")) {
                        taxa = input.trim().split(",");
                        return (T)new TaxaListBuilder().addAll(taxa).build();
                    }
                    builder = new TaxaListBuilder();
                    br = Utils.getBufferedReader(input);
                    var5_17 = null;
                    try {
                        line = br.readLine();
                        sep = Pattern.compile("[\\s,]+");
                        while (line != null) {
                            line = line.trim();
                            parsedline = sep.split(line);
                            for (i = 0; i < parsedline.length; ++i) {
                                if (parsedline[i] == null && parsedline[i].length() == 0) continue;
                                builder.add(parsedline[i]);
                            }
                            line = br.readLine();
                        }
                        return (T)builder.build();
                    }
                    catch (Throwable var6_20) {
                        var5_17 = var6_20;
                        throw var6_20;
                    }
                    finally {
                        if (br != null) {
                            if (var5_17 != null) {
                                try {
                                    br.close();
                                }
                                catch (Throwable var6_19) {
                                    var5_17.addSuppressed(var6_19);
                                }
                            } else {
                                br.close();
                            }
                        }
                    }
                }
                if (outputClass.isAssignableFrom(DistanceMatrix.class)) {
                    return (T)ReadDistanceMatrix.readDistanceMatrix(input);
                }
                if (!outputClass.isAssignableFrom(Character.class)) {
                    return outputClass.getConstructor(new Class[]{String.class}).newInstance(new Object[]{input});
                }
                if (input.length() == 1) return (T)new Character(input.charAt(0));
                throw new IllegalArgumentException("Should be one character");
            }
            catch (Exception nfe) {
                AbstractPlugin.myLogger.debug((Object)nfe.getMessage(), (Throwable)nfe);
                message = nfe.getMessage();
                if (message != null) throw new IllegalArgumentException(message + " Problem converting: " + input + " to " + Utils.getBasename(outputClass.getName()));
                throw new IllegalArgumentException("Problem converting: " + input + " to " + Utils.getBasename(outputClass.getName()));
            }
        }
    }

    private static List<String> getListFromString(String str) {
        if (str == null || str.length() == 0 || str.equalsIgnoreCase("null")) {
            return null;
        }
        String[] tokens = str.split(",");
        ArrayList<String> result = new ArrayList<String>();
        for (String current : tokens) {
            if ((current = current.trim()).length() == 0) continue;
            result.add(current);
        }
        return result;
    }

    private static SortedSet<Integer> getSortedSet(String str) {
        if (str == null || str.length() == 0 || str.equalsIgnoreCase("null")) {
            return null;
        }
        String[] tokens = str.split(",");
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (String current : tokens) {
            if ((current = current.trim()).length() == 0) continue;
            result.add(Integer.valueOf(current));
        }
        return result;
    }

    @Override
    public void setParameters(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (args[i].startsWith("-")) {
                    PluginParameter<?> parameter = this.getParameterInstance(arg = arg.substring(1));
                    if (parameter == null) {
                        myLogger.error((Object)("Unrecognized argument: " + args[i]));
                        this.printUsage();
                        System.exit(1);
                    }
                    if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                        if (parameter.valueType().isAssignableFrom(Boolean.class)) {
                            this.setParameter(arg, (Object)Boolean.TRUE);
                            continue;
                        }
                        if (Number.class.isAssignableFrom(parameter.valueType())) {
                            this.setParameter(arg, args[i + 1]);
                            ++i;
                            continue;
                        }
                        myLogger.error((Object)("Parameter requires a value: " + args[i]));
                        this.printUsage();
                        System.exit(1);
                        continue;
                    }
                    this.setParameter(arg, args[i + 1]);
                    ++i;
                    continue;
                }
                myLogger.error((Object)("Argument expected to start with dash(-): " + args[i]));
                this.printUsage();
                System.exit(1);
            }
        }
    }

    private void setFieldsToConfigParameters(Map<String, JComponent> parameterFields) {
        List<PluginParameter<?>> parameterInstances = this.getParameterInstances();
        if (parameterInstances.isEmpty()) {
            return;
        }
        for (PluginParameter<?> current : parameterInstances) {
            JComponent component = parameterFields.get(current.cmdLineName());
            this.setFieldToConfigParameters(component, current);
        }
    }

    private void setFieldToConfigParameters(JComponent component, PluginParameter<?> parameter) {
        Optional<String> configValue = ParameterCache.value(this, parameter.cmdLineName());
        if (!configValue.isPresent()) {
            return;
        }
        try {
            if (component instanceof JTextField) {
                ((JTextField)component).setText(configValue.get());
            } else if (component instanceof JCheckBox) {
                Boolean value = AbstractPlugin.convert(configValue.get(), Boolean.class);
                ((JCheckBox)component).setSelected(value);
            } else if (component instanceof JComboBox) {
                Object value = AbstractPlugin.convert(configValue.get(), parameter.valueType());
                ((JComboBox)component).setSelectedItem(value);
            }
        }
        catch (Exception e) {
            myLogger.warn((Object)("setFieldToConfigParameters: problem with configuration key: " + this.getClass().getName() + "." + parameter.cmdLineName() + "  value: " + configValue.get() + "\n" + e.getMessage()));
        }
    }

    public void setConfigParameters() {
        if (ParameterCache.hasValues()) {
            for (PluginParameter<?> parameter : this.getParameterInstances()) {
                Optional<String> value = ParameterCache.value(this, parameter.cmdLineName());
                if (!value.isPresent()) continue;
                try {
                    this.setParameter(parameter, (Object)value.get());
                }
                catch (Exception e) {
                    myLogger.warn((Object)("setConfigParameters: problem with configuration key: " + this.getClass().getName() + "." + parameter.cmdLineName() + "  value: " + value.get() + "\n" + e.getMessage()));
                }
            }
        }
    }

    private void checkRequiredParameters() {
        ArrayList<String> cmdLineNames = new ArrayList<String>();
        for (PluginParameter<?> current : this.getParameterInstances()) {
            if (cmdLineNames.contains(current.cmdLineName())) {
                if (this.isInteractive()) {
                    throw new IllegalStateException(current.cmdLineName() + " exist multiple times for this plugin.");
                }
                myLogger.error((Object)("-" + current.cmdLineName() + " exist multiple times for this plugin.\n"));
                this.printUsage();
                System.exit(1);
            } else {
                cmdLineNames.add(current.cmdLineName());
            }
            if (!current.required() || !current.isEmpty()) continue;
            if (this.isInteractive()) {
                throw new IllegalStateException(current.guiName() + " must be defined.");
            }
            myLogger.error((Object)("-" + current.cmdLineName() + " is required.\n"));
            this.printUsage();
            System.exit(1);
        }
    }

    private void checkParameters() {
        for (PluginParameter<?> current : this.getParameterInstances()) {
            String dirname;
            File directory;
            String outFolder;
            File outDir;
            String filename;
            if (current.parameterType() == PluginParameter.PARAMETER_TYPE.IN_FILE && !current.isEmpty()) {
                filename = current.value().toString();
                File theFile = new File(filename);
                if (!theFile.exists()) {
                    if (this.isInteractive()) {
                        throw new IllegalStateException(current.guiName() + ": " + filename + " doesn't exist.");
                    }
                    myLogger.error((Object)("-" + current.cmdLineName() + ": " + filename + " doesn't exist\n"));
                    this.printUsage();
                    System.exit(1);
                }
                if (!theFile.isFile()) {
                    if (this.isInteractive()) {
                        throw new IllegalStateException(current.guiName() + ": " + filename + " isn't a file.");
                    }
                    myLogger.error((Object)("-" + current.cmdLineName() + ": " + filename + " isn't a file\n"));
                    this.printUsage();
                    System.exit(1);
                }
            }
            if (current.parameterType() == PluginParameter.PARAMETER_TYPE.OUT_FILE && !current.isEmpty() && !(outDir = new File(outFolder = Utils.getDirectory(filename = current.value().toString()))).isDirectory()) {
                if (this.isInteractive()) {
                    throw new IllegalStateException(current.guiName() + ": Output Directory: " + outFolder + " doesn't exist.");
                }
                myLogger.error((Object)("-" + current.cmdLineName() + ": Output Directory: " + outFolder + " doesn't exist\n"));
                this.printUsage();
                System.exit(1);
            }
            if (current.parameterType() != PluginParameter.PARAMETER_TYPE.IN_DIR && current.parameterType() != PluginParameter.PARAMETER_TYPE.OUT_DIR || current.isEmpty() || (directory = new File(dirname = current.value().toString())).isDirectory()) continue;
            if (this.isInteractive()) {
                throw new IllegalStateException(current.guiName() + ": Directory: " + dirname + " doesn't exist.");
            }
            myLogger.error((Object)("-" + current.cmdLineName() + ": Directory: " + dirname + " doesn't exist\n"));
            this.printUsage();
            System.exit(1);
        }
    }

    protected void printParameterValues() {
        List<PluginParameter<?>> parameters = this.getParameterInstances();
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        builder.append(Utils.getBasename(this.getClass().getName()));
        builder.append(" Parameters\n");
        for (PluginParameter<?> current : parameters) {
            if (current.parameterType() == PluginParameter.PARAMETER_TYPE.LABEL) continue;
            builder.append(current.cmdLineName());
            builder.append(": ");
            Object value = current.value();
            if (value instanceof PositionList) {
                builder.append(((PositionList)value).numberOfSites());
                builder.append(" positions");
            } else if (value instanceof List) {
                builder.append(Arrays.toString(((List)value).toArray()));
            } else if (value instanceof DistanceMatrix) {
                DistanceMatrix temp = (DistanceMatrix)value;
                builder.append(temp.getColumnCount());
                builder.append(" columns x ");
                builder.append(temp.getRowCount());
                builder.append(" rows");
            } else if (current.parameterType() == PluginParameter.PARAMETER_TYPE.PASSWORD) {
                builder.append("?????");
            } else {
                builder.append(value);
            }
            builder.append("\n");
        }
        myLogger.info((Object)builder.toString());
    }

    private void printUsage() {
        StringBuilder builder = new StringBuilder();
        String description = this.pluginDescription();
        if (description != null) {
            builder.append("\n");
            builder.append(Utils.getBasename(this.getClass().getName())).append(" Description...\n");
            builder.append(description);
            builder.append("\n");
        }
        builder.append("\nUsage:\n");
        builder.append(Utils.getBasename(this.getClass().getName())).append(" <options>\n");
        for (PluginParameter<?> current : this.getParameterInstances()) {
            if (current.parameterType() == PluginParameter.PARAMETER_TYPE.LABEL) continue;
            builder.append("-");
            builder.append(current.cmdLineName());
            builder.append(" ");
            if (current.valueType().isAssignableFrom(Boolean.class)) {
                builder.append("<true | false>");
            } else {
                builder.append("<");
                builder.append(current.guiName());
                builder.append(">");
            }
            builder.append(" : ");
            builder.append(current.description());
            if (current.hasRange()) {
                builder.append(" ");
                builder.append(current.rangeToString());
            }
            if (current.defaultValue() != null) {
                builder.append(" (Default: ");
                builder.append(current.defaultValue());
                builder.append(")");
            }
            if (current.required()) {
                builder.append(" (required)");
            }
            builder.append("\n");
        }
        myLogger.info((Object)builder.toString());
    }

    @Override
    public String getUsage() {
        StringBuilder builder = new StringBuilder();
        builder.append(Utils.getBasename(this.getClass().getName()));
        builder.append("\n");
        String description = this.pluginDescription();
        if (description != null) {
            builder.append("\nDescription: ");
            builder.append(description);
            builder.append("\n\n");
        }
        for (PluginParameter<?> current : this.getParameterInstances()) {
            if (current.parameterType() == PluginParameter.PARAMETER_TYPE.LABEL) continue;
            builder.append("\n");
            builder.append(current.guiName());
            builder.append(" : ");
            builder.append(current.description());
            if (current.hasRange()) {
                builder.append(" ");
                builder.append(current.rangeToString());
            }
            if (current.defaultValue() != null) {
                builder.append(" (Default: ");
                builder.append(current.defaultValue());
                builder.append(")");
            }
            if (current.required()) {
                builder.append(" (required)");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public Map<String, Map<Plugin.PARAMETER_PROPERTIES, String>> usageParameters() {
        HashMap<String, Map<Plugin.PARAMETER_PROPERTIES, String>> result = new HashMap<String, Map<Plugin.PARAMETER_PROPERTIES, String>>();
        for (PluginParameter<?> current : this.getParameterInstances()) {
            if (current.parameterType() == PluginParameter.PARAMETER_TYPE.LABEL) continue;
            HashMap<Plugin.PARAMETER_PROPERTIES, String> temp = new HashMap<Plugin.PARAMETER_PROPERTIES, String>();
            temp.put(Plugin.PARAMETER_PROPERTIES.Required, Boolean.toString(current.required()));
            String defaultValue = current.defaultValue() == null ? null : current.defaultValue().toString();
            temp.put(Plugin.PARAMETER_PROPERTIES.Default, defaultValue);
            temp.put(Plugin.PARAMETER_PROPERTIES.Description, current.description());
            result.put(current.cmdLineName(), temp);
        }
        return result;
    }

    @Override
    public Map<String, String> pluginParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (PluginParameter<?> current : this.getParameterInstances()) {
            if (current.parameterType() == PluginParameter.PARAMETER_TYPE.LABEL) continue;
            result.put(current.cmdLineName(), current.value() == null ? null : current.value().toString());
        }
        return result;
    }

    @Override
    public Object getParameter(Enum key) {
        return this.getParameterInstance(key.toString()).value();
    }

    @Override
    public Object getParameter(String key) {
        return this.getParameterInstance(key).value();
    }

    @Override
    public Plugin setParameter(PluginParameter<?> param, Object value) {
        if (value == null) {
            this.setParameter(param.cmdLineName(), value);
        } else if (value instanceof String) {
            this.setParameter(param.cmdLineName(), (String)value);
        } else {
            this.setParameter(param.cmdLineName(), value);
        }
        return this;
    }

    @Override
    public Plugin setParameter(String key, Object value) {
        block7: {
            try {
                Field field = this.getParameterField(key);
                PluginParameter parameter = (PluginParameter)field.get(this);
                if (parameter == null) {
                    throw new IllegalArgumentException("setParameter: Unknown Parameter: " + key);
                }
                if (parameter.hasRange() && !parameter.acceptsValue(value)) {
                    throw new IllegalArgumentException("setParameter: " + parameter.cmdLineName() + " value: " + value.toString() + " outside range: " + parameter.rangeToString());
                }
                PluginParameter<Object> newParameter = new PluginParameter<Object>(parameter, value);
                field.set(this, newParameter);
            }
            catch (Exception e) {
                if (this.isInteractive()) {
                    try {
                        throw e;
                    }
                    catch (IllegalAccessException ex) {
                        myLogger.error((Object)ex.getMessage(), (Throwable)ex);
                        break block7;
                    }
                }
                myLogger.error((Object)(key + ": " + e.getMessage()));
                this.printUsage();
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                System.exit(1);
            }
        }
        return this;
    }

    @Override
    public Plugin setParameter(String key, String value) {
        try {
            PluginParameter<?> parameter = this.getParameterInstance(key);
            return this.setParameter(key, AbstractPlugin.convert(value, parameter.valueType()));
        }
        catch (Exception e) {
            if (this.isInteractive()) {
                throw new IllegalArgumentException(this.getParameterInstance(key).guiName() + ": " + e.getMessage());
            }
            myLogger.error((Object)(key + ": " + e.getMessage()));
            this.printUsage();
            System.exit(1);
            return this;
        }
    }

    private boolean setParametersViaGUI() {
        final List<PluginParameter<?>> parameterInstances = this.getParameterInstances();
        if (parameterInstances.isEmpty()) {
            return true;
        }
        final JDialog dialog = new JDialog(this.getParentFrame(), null, true);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractPlugin.this.parametersAreSet = false;
                dialog.setVisible(false);
            }
        });
        final HashMap<String, JComponent> parameterFields = new HashMap<String, JComponent>();
        this.parametersAreSet = true;
        JButton okButton = new JButton();
        okButton.setActionCommand("Ok");
        okButton.setText("Ok");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    for (PluginParameter current : parameterInstances) {
                        Object temp;
                        Object input;
                        JComponent component = (JComponent)parameterFields.get(current.cmdLineName());
                        if (current.parameterType() == PluginParameter.PARAMETER_TYPE.LABEL) continue;
                        if (current.parameterType() == PluginParameter.PARAMETER_TYPE.GENOTYPE_TABLE) {
                            input = (GenotypeWrapper)((JComboBox)component).getSelectedItem();
                            if (input == null) continue;
                            AbstractPlugin.this.setParameter(current.cmdLineName(), ((GenotypeWrapper)input).myObj);
                            continue;
                        }
                        if (PositionList.class.isAssignableFrom(current.valueType())) {
                            if (component instanceof JComboBox) {
                                temp = ((JComboBox)component).getSelectedItem();
                                if (temp == "None") {
                                    AbstractPlugin.this.setParameter(current.cmdLineName(), null);
                                    continue;
                                }
                                AbstractPlugin.this.setParameter(current.cmdLineName(), ((Datum)temp).getData());
                                continue;
                            }
                            input = ((JTextField)component).getText().trim();
                            AbstractPlugin.this.setParameter(current.cmdLineName(), (String)input);
                            continue;
                        }
                        if (TaxaList.class.isAssignableFrom(current.valueType())) {
                            if (component instanceof JComboBox) {
                                temp = ((JComboBox)component).getSelectedItem();
                                if (temp == "None") {
                                    AbstractPlugin.this.setParameter(current.cmdLineName(), null);
                                    continue;
                                }
                                AbstractPlugin.this.setParameter(current.cmdLineName(), ((Datum)temp).getData());
                                continue;
                            }
                            input = ((JTextField)component).getText().trim();
                            AbstractPlugin.this.setParameter(current.cmdLineName(), (String)input);
                            continue;
                        }
                        if (current.parameterType() == PluginParameter.PARAMETER_TYPE.DISTANCE_MATRIX) {
                            if (component instanceof JComboBox) {
                                temp = ((JComboBox)component).getSelectedItem();
                                if (temp == null) {
                                    throw new IllegalArgumentException("setParametersViaGUI: must specify a distance matrix.");
                                }
                                AbstractPlugin.this.setParameter(current.cmdLineName(), ((Datum)temp).getData());
                                continue;
                            }
                            input = ((JTextField)component).getText().trim();
                            AbstractPlugin.this.setParameter(current.cmdLineName(), (String)input);
                            continue;
                        }
                        if (current.parameterType() == PluginParameter.PARAMETER_TYPE.OBJECT_LIST_SINGLE_SELECT) {
                            Object selectedObjects = ((JComboBox)component).getSelectedItem();
                            AbstractPlugin.this.setParameter(current.cmdLineName(), selectedObjects);
                            continue;
                        }
                        if (component instanceof JTextField) {
                            input = ((JTextField)component).getText().trim();
                            AbstractPlugin.this.setParameter(current.cmdLineName(), (String)input);
                            continue;
                        }
                        if (component instanceof JCheckBox) {
                            if (((JCheckBox)component).isSelected()) {
                                AbstractPlugin.this.setParameter(current.cmdLineName(), (Object)Boolean.TRUE);
                                continue;
                            }
                            AbstractPlugin.this.setParameter(current.cmdLineName(), (Object)Boolean.FALSE);
                            continue;
                        }
                        if (!(component instanceof JComboBox)) continue;
                        temp = (Enum)((JComboBox)component).getSelectedItem();
                        AbstractPlugin.this.setParameter(current.cmdLineName(), temp);
                    }
                }
                catch (Exception ex) {
                    myLogger.debug((Object)ex.getMessage(), (Throwable)ex);
                    StringBuilder builder = new StringBuilder();
                    builder.append("Problem Setting Parameters: ");
                    builder.append("\n");
                    builder.append(Utils.shortenStrLineLen(ExceptionUtils.getExceptionCauses(ex), 50));
                    String str = builder.toString();
                    DialogUtils.showError(str, (Component)AbstractPlugin.this.getParentFrame());
                    return;
                }
                dialog.setVisible(false);
            }
        });
        JButton cancelButton = new JButton();
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractPlugin.this.parametersAreSet = false;
                dialog.setVisible(false);
            }
        });
        JButton defaultsButton = new JButton();
        defaultsButton.setText("Defaults");
        defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractPlugin.this.setFieldsToDefault(parameterFields);
                AbstractPlugin.this.setFieldsToConfigParameters(parameterFields);
            }
        });
        JButton userManualButton = new JButton();
        userManualButton.setText("User Manual");
        userManualButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop desktop = Desktop.getDesktop();
                    URI uri = new URI(AbstractPlugin.this.pluginUserManualURL());
                    desktop.browse(uri);
                }
                catch (Exception ex) {
                    myLogger.debug((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        boolean show_citation = !DEFAULT_CITATION.equals(this.getCitation());
        JTextPane citationText = null;
        if (show_citation) {
            citationText = new JTextPane();
            citationText.setContentType("text/html");
            citationText.setMargin(new Insets(5, 5, 5, 5));
            citationText.setEditable(false);
            JScrollPane scroll = new JScrollPane(citationText);
            scroll.setHorizontalScrollBarPolicy(31);
            scroll.setVerticalScrollBarPolicy(20);
            scroll.setPreferredSize(new Dimension(scroll.getWidth(), 45));
            panel.add(scroll);
        }
        for (final PluginParameter<?> current : this.getParameterInstances()) {
            Object label;
            ?[] browse;
            JTextField field;
            Object temp;
            JComboBox<Object> menu;
            Datum datum;
            if (current.parameterType() == PluginParameter.PARAMETER_TYPE.GENOTYPE_TABLE) {
                datum = this.getGenotypeTable();
                menu = new JComboBox<Object>();
                if (datum != null) {
                    GenotypeTable table;
                    String name = datum.getName();
                    if (datum.getData() instanceof GenotypeTable) {
                        table = (GenotypeTable)datum.getData();
                    } else if (datum.getData() instanceof GenotypePhenotype) {
                        table = ((GenotypePhenotype)datum.getData()).genotypeTable();
                    } else {
                        throw new IllegalStateException("AbstractPlugin: setParametersViaGUI: unknown GenotypeTable type: " + datum.getData().getClass().getName());
                    }
                    if (current.acceptsValue((Object)GenotypeTable.GENOTYPE_TABLE_COMPONENT.Genotype) && table.hasGenotype()) {
                        menu.addItem(new GenotypeWrapper((Object)GenotypeTable.GENOTYPE_TABLE_COMPONENT.Genotype, "Genotype (" + name + ")"));
                    }
                    if (current.acceptsValue((Object)GenotypeTable.GENOTYPE_TABLE_COMPONENT.ReferenceProbability) && table.hasReferenceProbablity()) {
                        menu.addItem(new GenotypeWrapper((Object)GenotypeTable.GENOTYPE_TABLE_COMPONENT.ReferenceProbability, "Reference Probability (" + name + ")"));
                    }
                    if (current.acceptsValue((Object)GenotypeTable.GENOTYPE_TABLE_COMPONENT.AlleleProbability) && table.hasAlleleProbabilities()) {
                        menu.addItem(new GenotypeWrapper((Object)GenotypeTable.GENOTYPE_TABLE_COMPONENT.AlleleProbability, "Allele Probability (" + name + ")"));
                    }
                    if (current.acceptsValue((Object)GenotypeTable.GENOTYPE_TABLE_COMPONENT.Depth) && table.hasDepth()) {
                        menu.addItem(new GenotypeWrapper((Object)GenotypeTable.GENOTYPE_TABLE_COMPONENT.Depth, "Depth (" + name + ")"));
                    }
                    if (current.acceptsValue((Object)GenotypeTable.GENOTYPE_TABLE_COMPONENT.Dosage) && table.hasDosage()) {
                        menu.addItem(new GenotypeWrapper((Object)GenotypeTable.GENOTYPE_TABLE_COMPONENT.Dosage, "Dosage (" + name + ")"));
                    }
                    menu.setSelectedIndex(0);
                }
                this.createEnableDisableAction(current, parameterFields, menu);
                temp = new JPanel(new FlowLayout(1));
                ((Container)temp).add(new JLabel(current.guiName()));
                ((Container)temp).add(menu);
                ((JComponent)temp).setToolTipText(this.getToolTip(current));
                panel.add((Component)temp);
                parameterFields.put(current.cmdLineName(), menu);
                continue;
            }
            if (PositionList.class.isAssignableFrom(current.valueType())) {
                datum = this.getPositionList();
                if (datum != null) {
                    menu = new JComboBox();
                    menu.addItem("None");
                    menu.addItem(datum);
                    menu.setSelectedIndex(0);
                    this.createEnableDisableAction(current, parameterFields, menu);
                    temp = new JPanel(new FlowLayout(1));
                    ((Container)temp).add(new JLabel(current.guiName()));
                    ((Container)temp).add(menu);
                    ((JComponent)temp).setToolTipText(this.getToolTip(current));
                    panel.add((Component)temp);
                    parameterFields.put(current.cmdLineName(), menu);
                    continue;
                }
                field = new JTextField(17);
                browse = this.getOpenFile(dialog, field);
                JPanel line = this.getLine(current.guiName(), field, (JButton)browse, this.getToolTip(current));
                this.createEnableDisableAction(current, parameterFields, new JComponent[]{field, browse}, field);
                panel.add(line);
                parameterFields.put(current.cmdLineName(), field);
                continue;
            }
            if (current.parameterType() == PluginParameter.PARAMETER_TYPE.DISTANCE_MATRIX) {
                List<Datum> matrices = this.getDistanceMatrices();
                if (!matrices.isEmpty()) {
                    menu = new JComboBox();
                    for (Datum matrix : matrices) {
                        menu.addItem(matrix);
                    }
                    menu.setSelectedIndex(0);
                    this.createEnableDisableAction(current, parameterFields, menu);
                    temp = new JPanel(new FlowLayout(1));
                    ((Container)temp).add(new JLabel(current.guiName()));
                    ((Container)temp).add(menu);
                    ((JComponent)temp).setToolTipText(this.getToolTip(current));
                    panel.add((Component)temp);
                    parameterFields.put(current.cmdLineName(), menu);
                    continue;
                }
                field = new JTextField(17);
                browse = this.getOpenFile(dialog, field);
                JPanel line = this.getLine(current.guiName(), field, (JButton)browse, this.getToolTip(current));
                this.createEnableDisableAction(current, parameterFields, new JComponent[]{field, browse}, field);
                panel.add(line);
                parameterFields.put(current.cmdLineName(), field);
                continue;
            }
            if (current.parameterType() == PluginParameter.PARAMETER_TYPE.OBJECT_LIST_SINGLE_SELECT) {
                JPanel listPanel = new JPanel(new FlowLayout(1));
                listPanel.add(new JLabel(current.guiName()));
                JComboBox<Object> list = new JComboBox<Object>(current.possibleValues().toArray());
                list.setSelectedIndex(0);
                this.createEnableDisableAction(current, parameterFields, list);
                listPanel.add(list);
                listPanel.setToolTipText(this.getToolTip(current));
                panel.add(listPanel);
                parameterFields.put(current.cmdLineName(), list);
                continue;
            }
            if (current.valueType().isEnum()) {
                ?[] values;
                JComboBox menu2 = new JComboBox();
                for (Object item : values = current.valueType().getEnumConstants()) {
                    menu2.addItem(item);
                }
                menu2.setSelectedItem(current.value());
                this.createEnableDisableAction(current, parameterFields, menu2);
                temp = new JPanel(new FlowLayout(1));
                ((Container)temp).add(new JLabel(current.guiName()));
                ((Container)temp).add(menu2);
                ((JComponent)temp).setToolTipText(this.getToolTip(current));
                panel.add((Component)temp);
                parameterFields.put(current.cmdLineName(), menu2);
                continue;
            }
            if (Boolean.class.isAssignableFrom(current.valueType())) {
                JCheckBox check = new JCheckBox(current.guiName());
                check.setToolTipText(this.getToolTip(current));
                if (current.value() == Boolean.TRUE) {
                    check.setSelected(true);
                } else {
                    check.setSelected(false);
                }
                this.createEnableDisableAction(current, parameterFields, check);
                JPanel temp2 = new JPanel(new FlowLayout(1));
                temp2.add(check);
                panel.add(temp2);
                parameterFields.put(current.cmdLineName(), check);
                continue;
            }
            if (TaxaList.class.isAssignableFrom(current.valueType())) {
                List<Datum> datums = this.getTaxaListDatum();
                if (datums != null) {
                    menu = new JComboBox();
                    menu.addItem("None");
                    for (Datum datum2 : datums) {
                        menu.addItem(datum2);
                    }
                    menu.setSelectedIndex(0);
                    this.createEnableDisableAction(current, parameterFields, menu);
                    temp = new JPanel(new FlowLayout(1));
                    ((Container)temp).add(new JLabel(current.guiName()));
                    ((Container)temp).add(menu);
                    ((JComponent)temp).setToolTipText(this.getToolTip(current));
                    panel.add((Component)temp);
                    parameterFields.put(current.cmdLineName(), menu);
                    continue;
                }
                TaxaList taxa = this.getTaxaList();
                JTextField field2 = taxa == null ? new JTextField(25) : new JTextField(18);
                if (current.value() != null) {
                    field2.setText(current.value().toString());
                }
                JPanel taxaPanel = this.getTaxaListPanel(current.guiName(), field2, current.description(), dialog, taxa);
                panel.add(taxaPanel);
                parameterFields.put(current.cmdLineName(), field2);
                continue;
            }
            if (current.parameterType() == PluginParameter.PARAMETER_TYPE.SITE_NAME_LIST) {
                PositionList positions = this.getSiteNameList();
                field = positions == null ? new JTextField(25) : new JTextField(18);
                if (current.value() != null) {
                    field.setText(current.value().toString());
                }
                JPanel positionsPanel = this.getPositionListPanel(current.guiName(), field, current.description(), dialog, positions);
                ArrayList<JComponent> componentList = new ArrayList<JComponent>();
                for (Component component : positionsPanel.getComponents()) {
                    if (!(component instanceof JComponent)) continue;
                    componentList.add((JComponent)component);
                }
                this.createEnableDisableAction(current, parameterFields, componentList.toArray(new JComponent[0]), field);
                panel.add(positionsPanel);
                parameterFields.put(current.cmdLineName(), field);
                continue;
            }
            if (current.parameterType() == PluginParameter.PARAMETER_TYPE.LABEL) {
                JPanel temp3 = new JPanel(new FlowLayout(1));
                label = new JLabel(current.guiName());
                ((JComponent)label).setFont(new Font("Dialog", 1, 14));
                temp3.add((Component)label);
                panel.add(temp3);
                continue;
            }
            final JTextField field3 = current.parameterType() == PluginParameter.PARAMETER_TYPE.PASSWORD ? new JPasswordField(25) : (current.parameterType() != PluginParameter.PARAMETER_TYPE.NA ? new JTextField(17) : new JTextField(25));
            if (current.value() != null) {
                this.setFieldToValue(field3, current, current.value());
            }
            field3.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String input = field3.getText().trim();
                    try {
                        PluginParameter parameter = AbstractPlugin.this.getParameterInstance(current.cmdLineName());
                        if (!current.acceptsValue(input)) {
                            JOptionPane.showMessageDialog(dialog, current.guiName() + " range: " + current.rangeToString());
                            AbstractPlugin.this.setFieldToValue(field3, parameter, parameter.value());
                        } else {
                            AbstractPlugin.this.setFieldToValue(field3, parameter, AbstractPlugin.convert(input, parameter.valueType()));
                        }
                    }
                    catch (Exception ex) {
                        myLogger.debug((Object)ex.getMessage(), (Throwable)ex);
                        JOptionPane.showMessageDialog(dialog, current.guiName() + ": " + ex.getMessage());
                        field3.setText(AbstractPlugin.this.getParameterInstance(current.cmdLineName()).value().toString());
                    }
                }
            });
            label = null;
            label = current.required() ? current.guiName() + "*" : current.guiName();
            JPanel line = null;
            if (current.parameterType() == PluginParameter.PARAMETER_TYPE.IN_FILE) {
                JButton browse2 = this.getOpenFile(dialog, field3);
                line = this.getLine((String)label, field3, browse2, this.getToolTip(current));
                this.createEnableDisableAction(current, parameterFields, new JComponent[]{field3, browse2}, field3);
            } else if (current.parameterType() == PluginParameter.PARAMETER_TYPE.OUT_FILE) {
                JButton browse3 = this.getSaveFile(dialog, field3);
                line = this.getLine((String)label, field3, browse3, this.getToolTip(current));
                this.createEnableDisableAction(current, parameterFields, new JComponent[]{field3, browse3}, field3);
            } else if (current.parameterType() == PluginParameter.PARAMETER_TYPE.IN_DIR) {
                JButton browse4 = this.getOpenDir(dialog, field3);
                line = this.getLine((String)label, field3, browse4, this.getToolTip(current));
                this.createEnableDisableAction(current, parameterFields, new JComponent[]{field3, browse4}, field3);
            } else if (current.parameterType() == PluginParameter.PARAMETER_TYPE.OUT_DIR) {
                JButton browse5 = this.getSaveDir(dialog, field3);
                line = this.getLine((String)label, field3, browse5, this.getToolTip(current));
                this.createEnableDisableAction(current, parameterFields, new JComponent[]{field3, browse5}, field3);
            } else {
                line = this.getLine((String)label, field3, null, this.getToolTip(current));
                this.createEnableDisableAction(current, parameterFields, field3);
            }
            panel.add(line);
            parameterFields.put(current.cmdLineName(), field3);
        }
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)new JScrollPane(panel, 20, 31), this.getButtonName());
        JPanel pnlButtons = new JPanel();
        pnlButtons.setLayout(new FlowLayout());
        pnlButtons.add(okButton);
        pnlButtons.add(cancelButton);
        pnlButtons.add(defaultsButton);
        pnlButtons.add(userManualButton);
        dialog.getContentPane().add((Component)tabbedPane, "Center");
        dialog.getContentPane().add((Component)pnlButtons, "South");
        JTextPane helpText = new JTextPane();
        helpText.setMargin(new Insets(10, 10, 10, 10));
        helpText.setEditable(false);
        helpText.setContentType("text/html");
        tabbedPane.add((Component)new JScrollPane(helpText), "Help");
        dialog.pack();
        if (show_citation) {
            citationText.setText(this.getCitationHTML(dialog.getWidth() / 9));
            dialog.setMinimumSize(null);
            dialog.pack();
        }
        helpText.setText(this.getUsageHTML());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (screenSize.getHeight() - 125.0 < (double)dialog.getHeight()) {
            dialog.setSize(Math.max(dialog.getWidth(), 550), (int)screenSize.getHeight() - 125);
        } else {
            dialog.setSize(Math.max(dialog.getWidth(), 550), Math.max(dialog.getHeight(), 250));
        }
        dialog.setResizable(false);
        dialog.setLocationRelativeTo(this.getParentFrame());
        dialog.setVisible(true);
        return this.parametersAreSet;
    }

    private void setFieldToValue(JTextField field, PluginParameter<?> parameter, Object value) {
        if (value == null) {
            field.setText(null);
        } else if (Integer.class.isAssignableFrom(parameter.valueType())) {
            field.setText(NumberFormat.getInstance().format(value));
        } else if (Double.class.isAssignableFrom(parameter.valueType()) || Float.class.isAssignableFrom(parameter.valueType())) {
            DecimalFormat temp = new DecimalFormat();
            temp.setMaximumFractionDigits(5);
            temp.setMinimumFractionDigits(1);
            field.setText(temp.format(value));
        } else {
            field.setText(value.toString());
        }
    }

    private void setFieldsToDefault(Map<String, JComponent> parameterFields) {
        List<PluginParameter<?>> parameterInstances = this.getParameterInstances();
        if (parameterInstances.isEmpty()) {
            return;
        }
        for (PluginParameter<?> current : parameterInstances) {
            JComponent component = parameterFields.get(current.cmdLineName());
            this.setFieldToDefault(component, current);
        }
    }

    private void setFieldToDefault(JComponent component, PluginParameter<?> current) {
        if (component instanceof JTextField) {
            Object defaultValue = current.defaultValue();
            this.setFieldToValue((JTextField)component, current, defaultValue);
            this.setParameter(current.cmdLineName(), defaultValue);
        } else if (component instanceof JCheckBox) {
            Boolean value = (Boolean)current.defaultValue();
            ((JCheckBox)component).setSelected(value);
            this.setParameter(current.cmdLineName(), (Object)value);
        } else if (component instanceof JComboBox) {
            ((JComboBox)component).setSelectedItem(current.defaultValue());
            this.setParameter(current.cmdLineName(), current.defaultValue());
        }
    }

    @Override
    public void setParametersToDefault() {
        List<PluginParameter<?>> parameterInstances = this.getParameterInstances();
        if (parameterInstances.isEmpty()) {
            return;
        }
        for (PluginParameter<?> current : parameterInstances) {
            this.setParameter(current.cmdLineName(), current.defaultValue());
        }
    }

    private String getCitationHTML(int lineWidth) {
        String citation = this.getCitation();
        int count = 10;
        StringBuilder builder = new StringBuilder();
        builder.append("<html><center>Citation: ");
        int n = citation.length();
        for (int i = 0; i < n; ++i) {
            ++count;
            if (citation.charAt(i) == '\n') {
                builder.append("<br>");
                count = 0;
                continue;
            }
            if (count > lineWidth && citation.charAt(i) == ' ') {
                builder.append("<br>");
                count = 0;
                continue;
            }
            builder.append(citation.charAt(i));
        }
        builder.append("</center></html>");
        return builder.toString();
    }

    public String getUsageHTML() {
        StringBuilder builder = new StringBuilder();
        builder.append("<html><center><strong>");
        builder.append(Utils.getBasename(this.getClass().getName()));
        builder.append("</strong>");
        String description = this.pluginDescription();
        if (description != null) {
            builder.append("<br><br><strong>Description:</strong> ");
            builder.append(description);
        }
        builder.append("<br><br>");
        builder.append("<table border='1'>");
        builder.append("<tr><th>Parameter</th><th>Description</th><th>Values</th><th>Default</th></tr>");
        for (PluginParameter<?> current : this.getParameterInstances()) {
            StringBuilder buildRange;
            String range;
            if (current.parameterType() == PluginParameter.PARAMETER_TYPE.LABEL) continue;
            builder.append("<tr>");
            builder.append("<th>");
            if (current.required()) {
                builder.append("<font color='red'>");
            }
            builder.append(current.guiName());
            if (current.required()) {
                builder.append("</font>");
            }
            builder.append("</th>");
            builder.append("<td>");
            builder.append(current.description());
            builder.append("</td>");
            builder.append("<td>");
            if (current.hasPossibleValues()) {
                range = current.possibleValuesString(true);
                if (range.charAt(0) == '[' && range.charAt(range.length() - 1) == ']') {
                    range = range.substring(1, range.length() - 1);
                }
                buildRange = new StringBuilder();
                for (char rangeChr : range.toCharArray()) {
                    if (rangeChr == '_') {
                        buildRange.append("\n");
                    }
                    buildRange.append(rangeChr);
                }
                builder.append(buildRange.toString());
            } else if (current.hasRange()) {
                range = current.rangeToString(true);
                if (range.charAt(0) == '[' && range.charAt(range.length() - 1) == ']') {
                    range = range.substring(1, range.length() - 1);
                }
                buildRange = new StringBuilder();
                for (char rangeChr : range.toCharArray()) {
                    if (rangeChr == '_') {
                        buildRange.append("\n");
                    }
                    buildRange.append(rangeChr);
                }
                builder.append(buildRange.toString());
            } else if (current.valueType().isAssignableFrom(Boolean.class)) {
                builder.append("true, false");
            }
            builder.append("</td>");
            builder.append("<td>");
            if (current.defaultValue() != null) {
                String defaultValue = current.defaultValue().toString();
                StringBuilder buildDefault = new StringBuilder();
                for (char defaultChr : defaultValue.toCharArray()) {
                    if (defaultChr == '_') {
                        buildDefault.append("\n");
                    }
                    buildDefault.append(defaultChr);
                }
                builder.append(buildDefault.toString());
            }
            builder.append("</td>");
            builder.append("</tr>");
        }
        builder.append("</table>");
        builder.append("</center>");
        builder.append("<br><font color='red'>* parameters in red are required</font>");
        builder.append("</html>");
        return builder.toString();
    }

    private void createEnableDisableAction(PluginParameter<?> current, Map<String, JComponent> parameterFields, JComponent component) {
        this.createEnableDisableAction(current, parameterFields, new JComponent[]{component}, component);
    }

    private void createEnableDisableAction(final PluginParameter<?> current, Map<String, JComponent> parameterFields, final JComponent[] components, JComponent input) {
        if (current.dependentOnParameter() != null) {
            JComponent depends = parameterFields.get(current.dependentOnParameter().cmdLineName());
            if (depends instanceof JCheckBox) {
                final JCheckBox checkBox = (JCheckBox)depends;
                for (JComponent component : components) {
                    if (checkBox.isSelected() == ((Boolean)current.dependentOnParameterValue()[0]).booleanValue()) {
                        component.setEnabled(true);
                        continue;
                    }
                    component.setEnabled(false);
                }
                checkBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        for (JComponent component : components) {
                            if (checkBox.isSelected() == ((Boolean)current.dependentOnParameterValue()[0]).booleanValue()) {
                                component.setEnabled(true);
                                continue;
                            }
                            component.setEnabled(false);
                        }
                    }
                });
            } else if (depends instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)depends;
                block1: for (JComponent component : components) {
                    Object[] values = current.dependentOnParameterValue();
                    component.setEnabled(false);
                    for (Object value : values) {
                        if (comboBox.getSelectedItem() != value) continue;
                        component.setEnabled(true);
                        continue block1;
                    }
                }
                comboBox.addItemListener(e -> {
                    block0: for (JComponent component : components) {
                        Object[] values = current.dependentOnParameterValue();
                        component.setEnabled(false);
                        for (Object value : values) {
                            if (comboBox.getSelectedItem() != value) continue;
                            component.setEnabled(true);
                            continue block0;
                        }
                    }
                });
            }
        }
    }

    private String getToolTip(PluginParameter<?> parameter) {
        String description = parameter.description();
        int count = 0;
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        int n = description.length();
        for (int i = 0; i < n; ++i) {
            ++count;
            if (description.charAt(i) == '\n') {
                builder.append("<br>");
                count = 0;
                continue;
            }
            if (count > 50 && description.charAt(i) == ' ') {
                builder.append("<br>");
                count = 0;
                continue;
            }
            builder.append(description.charAt(i));
        }
        builder.append("</html>");
        return builder.toString();
    }

    private JPanel getLine(String label, JTextField ref, JButton button, String description) {
        JPanel result = new JPanel(new FlowLayout(2));
        result.setToolTipText(description);
        result.add(new JLabel(label));
        ref.setEditable(true);
        ref.setHorizontalAlignment(2);
        ref.setAlignmentX(0.5f);
        ref.setAlignmentY(0.5f);
        ref.setMaximumSize(ref.getPreferredSize());
        result.add(ref);
        if (button != null) {
            result.add(button);
        }
        return result;
    }

    private JPanel getTaxaListPanel(String label, final JTextField ref, String description, final JDialog parent, final TaxaList taxa) {
        JPanel result = new JPanel(new FlowLayout(2));
        result.setToolTipText(description);
        result.add(new JLabel(label));
        ref.setEditable(true);
        ref.setHorizontalAlignment(2);
        ref.setAlignmentX(0.5f);
        ref.setAlignmentY(0.5f);
        ref.setMaximumSize(ref.getPreferredSize());
        result.add(ref);
        if (taxa != null) {
            final SelectFromAvailableDialog dialog = new SelectFromAvailableDialog(this.getParentFrame(), "Taxa Filter", new TaxaAvailableListModel(taxa));
            JButton taxaButton = new JButton(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setLocationRelativeTo(parent);
                    dialog.setVisible(true);
                    if (!dialog.isCanceled()) {
                        int[] indicesToKeep = dialog.getDesiredIndices();
                        StringBuilder builder = new StringBuilder();
                        for (int i = 0; i < indicesToKeep.length; ++i) {
                            if (i != 0) {
                                builder.append(",");
                            }
                            builder.append(taxa.taxaName(indicesToKeep[i]));
                        }
                        ref.setText(builder.toString());
                    }
                    dialog.setVisible(false);
                }
            });
            taxaButton.setText("Select");
            result.add(taxaButton);
        }
        JButton browse = this.getOpenFile(parent, ref);
        result.add(browse);
        return result;
    }

    private JPanel getPositionListPanel(String label, final JTextField ref, String description, final JDialog parent, final PositionList positions) {
        JPanel result = new JPanel(new FlowLayout(2));
        result.setToolTipText(description);
        result.add(new JLabel(label));
        ref.setEditable(true);
        ref.setHorizontalAlignment(2);
        ref.setAlignmentX(0.5f);
        ref.setAlignmentY(0.5f);
        ref.setMaximumSize(ref.getPreferredSize());
        result.add(ref);
        if (positions != null) {
            final SelectFromAvailableDialog dialog = new SelectFromAvailableDialog(this.getParentFrame(), "Site Name Filter", new SiteNamesAvailableListModel(positions));
            JButton siteNamesButton = new JButton(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setLocationRelativeTo(parent);
                    dialog.setVisible(true);
                    if (!dialog.isCanceled()) {
                        int[] indicesToKeep = dialog.getDesiredIndices();
                        StringBuilder builder = new StringBuilder();
                        for (int i = 0; i < indicesToKeep.length; ++i) {
                            if (i != 0) {
                                builder.append(",");
                            }
                            builder.append(positions.siteName(indicesToKeep[i]));
                        }
                        ref.setText(builder.toString());
                    }
                    dialog.setVisible(false);
                }
            });
            siteNamesButton.setText("Select");
            result.add(siteNamesButton);
        }
        return result;
    }

    private JButton getOpenFile(final JDialog parent, final JTextField textField) {
        final JFileChooser fileChooser = new JFileChooser(TasselPrefs.getOpenDir());
        JButton result = new JButton("Browse");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fileChooser.showOpenDialog(parent) == 0) {
                    File file = fileChooser.getSelectedFile();
                    textField.setText(file.getPath());
                    TasselPrefs.putOpenDir(fileChooser.getCurrentDirectory().getPath());
                }
            }
        });
        return result;
    }

    private JButton getSaveFile(final JDialog parent, final JTextField textField) {
        final JFileChooser fileChooser = new JFileChooser(TasselPrefs.getSaveDir());
        JButton result = new JButton("Browse");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fileChooser.showSaveDialog(parent) == 0) {
                    File file = fileChooser.getSelectedFile();
                    textField.setText(file.getPath());
                    TasselPrefs.putSaveDir(fileChooser.getCurrentDirectory().getPath());
                }
            }
        });
        return result;
    }

    private JButton getOpenDir(final JDialog parent, final JTextField textField) {
        final JFileChooser fileChooser = new JFileChooser(Utils.getDirectory(TasselPrefs.getOpenDir()));
        fileChooser.setFileSelectionMode(1);
        JButton result = new JButton("Browse");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fileChooser.showOpenDialog(parent) == 0) {
                    File file = fileChooser.getSelectedFile();
                    textField.setText(file.getPath());
                    TasselPrefs.putOpenDir(file.getPath());
                }
            }
        });
        return result;
    }

    private JButton getSaveDir(final JDialog parent, final JTextField textField) {
        final JFileChooser fileChooser = new JFileChooser(Utils.getDirectory(TasselPrefs.getSaveDir()));
        fileChooser.setFileSelectionMode(1);
        JButton result = new JButton("Browse");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fileChooser.showOpenDialog(parent) == 0) {
                    File file = fileChooser.getSelectedFile();
                    textField.setText(file.getPath());
                    TasselPrefs.putSaveDir(file.getPath());
                }
            }
        });
        return result;
    }

    private Datum getGenotypeTable() {
        if (this.myCurrentInputData == null) {
            return null;
        }
        List<Datum> genotypeTables = this.myCurrentInputData.getDataOfType(GenotypeTable.class);
        if (!genotypeTables.isEmpty()) {
            return genotypeTables.get(0);
        }
        genotypeTables = this.myCurrentInputData.getDataOfType(GenotypePhenotype.class);
        if (!genotypeTables.isEmpty()) {
            return genotypeTables.get(0);
        }
        return null;
    }

    private TaxaList getTaxaList() {
        if (this.myCurrentInputData == null) {
            return null;
        }
        List<Datum> taxaList = this.myCurrentInputData.getDataOfType(GenotypeTable.class);
        if (!taxaList.isEmpty()) {
            return ((GenotypeTable)taxaList.get(0).getData()).taxa();
        }
        taxaList = this.myCurrentInputData.getDataOfType(TaxaList.class);
        if (!taxaList.isEmpty()) {
            return (TaxaList)taxaList.get(0).getData();
        }
        return null;
    }

    private List<Datum> getTaxaListDatum() {
        if (this.myCurrentInputData == null) {
            return null;
        }
        List<Datum> taxaList = this.myCurrentInputData.getDataOfType(TaxaList.class);
        if (!taxaList.isEmpty()) {
            return taxaList;
        }
        return null;
    }

    private PositionList getSiteNameList() {
        if (this.myCurrentInputData == null) {
            return null;
        }
        List<Datum> positionList = this.myCurrentInputData.getDataOfType(GenotypeTable.class);
        if (!positionList.isEmpty()) {
            return ((GenotypeTable)positionList.get(0).getData()).positions();
        }
        positionList = this.myCurrentInputData.getDataOfType(PositionList.class);
        if (!positionList.isEmpty()) {
            return (PositionList)positionList.get(0).getData();
        }
        return null;
    }

    private Datum getPositionList() {
        if (this.myCurrentInputData == null) {
            return null;
        }
        List<Datum> positionList = this.myCurrentInputData.getDataOfType(PositionList.class);
        if (!positionList.isEmpty()) {
            return positionList.get(0);
        }
        return null;
    }

    private List<Datum> getDistanceMatrices() {
        if (this.myCurrentInputData != null) {
            return this.myCurrentInputData.getDataOfType(DistanceMatrix.class);
        }
        return null;
    }

    @Override
    public JMenu getMenu() {
        return null;
    }

    @Override
    public void receiveInput(Plugin input) {
        if (input == null) {
            throw new IllegalArgumentException("AbstractPlugin: receiveInput: input can not be null.");
        }
        if (!this.myInputs.contains(input)) {
            this.myInputs.add(input);
        }
        input.addListener(this);
    }

    @Override
    public JPanel getPanel() {
        return null;
    }

    @Override
    public boolean isInteractive() {
        return this.myIsInteractive;
    }

    @Override
    public Frame getParentFrame() {
        return this.myParentFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(PluginListener listener) {
        List<PluginListener> list = this.myListeners;
        synchronized (list) {
            if (listener != null && !this.myListeners.contains(listener)) {
                this.myListeners.add(listener);
            }
        }
    }

    public List<PluginListener> getListeners() {
        return Collections.unmodifiableList(this.myListeners);
    }

    public boolean hasListeners() {
        return !this.myListeners.isEmpty();
    }

    public List<Plugin> getInputs() {
        return this.myInputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataSetReturned(PluginEvent event) {
        List<PluginListener> list = this.myListeners;
        synchronized (list) {
            Iterator<PluginListener> itr = this.myListeners.iterator();
            while (itr.hasNext()) {
                try {
                    PluginListener current;
                    if (this.myThreaded) {
                        current = itr.next();
                        ThreadedPluginListener thread = new ThreadedPluginListener(current, event);
                        thread.start();
                        continue;
                    }
                    current = itr.next();
                    current.dataSetReturned(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void fireDataSetReturned(DataSet data) {
        this.fireDataSetReturned(new PluginEvent(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProgress(PluginEvent event) {
        Datum datum;
        Integer percent;
        List<Datum> percentage;
        List<PluginListener> list = this.myListeners;
        synchronized (list) {
            for (PluginListener current : this.myListeners) {
                current.progress(event);
            }
        }
        DataSet ds = (DataSet)event.getSource();
        if (ds != null && (percentage = ds.getDataOfType(Integer.class)).size() > 0 && (percent = (Integer)(datum = percentage.get(0)).getData()) == 100 && !myPrintedCitations.contains(this.getCitation())) {
            myLogger.info((Object)(this.getClass().getName() + "  Citation: " + this.getCitation()));
            myPrintedCitations.add(this.getCitation());
        }
    }

    protected void fireProgress(Integer percent) {
        if (percent < 0 || percent > 100) {
            throw new IllegalArgumentException("AbstractPlugin: fireProgress: percent must be between 0 and 100 inclusive.  arg: " + percent);
        }
        Datum percentage = new Datum("Percent", percent, null);
        this.fireProgress(new PluginEvent(new DataSet(percentage, (Plugin)this)));
    }

    @Override
    public String getCitation() {
        return DEFAULT_CITATION;
    }

    @Override
    public String pluginDescription() {
        return null;
    }

    @Override
    public String pluginUserManualURL() {
        return "https://bitbucket.org/tasseladmin/tassel-5-source/wiki/UserManual";
    }

    @Override
    public void dataSetReturned(PluginEvent event) {
        DataSet input = (DataSet)event.getSource();
        this.performFunction(input);
    }

    @Override
    public void progress(PluginEvent event) {
    }

    public void reverseTrace(int indent) {
        if (this.myTrace) {
            return;
        }
        this.indent(indent);
        System.out.println(this.getClass().getName());
        Iterator<Plugin> itr = this.myInputs.iterator();
        while (itr.hasNext()) {
            try {
                AbstractPlugin current = (AbstractPlugin)itr.next();
                current.reverseTrace(indent + 3);
            }
            catch (Exception exception) {}
        }
        this.myTrace = true;
    }

    public void trace(int indent) {
        if (this.myTrace) {
            return;
        }
        this.indent(indent);
        System.out.println(this.getClass().getName());
        Iterator<PluginListener> itr = this.myListeners.iterator();
        while (itr.hasNext()) {
            try {
                AbstractPlugin current = (AbstractPlugin)itr.next();
                current.trace(indent + 3);
            }
            catch (Exception exception) {}
        }
        this.myTrace = true;
    }

    private void indent(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(" ");
        }
    }

    @Override
    public void setThreaded(boolean threaded) {
        this.myThreaded = threaded;
    }

    @Override
    public boolean cancel() {
        return false;
    }

    @Override
    public void run() {
        this.performFunction(null);
    }

    @Override
    public void progress(int percent, Object meta) {
        this.fireProgress(percent);
    }

    @Override
    public boolean wasCancelled() {
        return this.myWasCancelled;
    }

    private class GenotypeWrapper {
        private final Object myObj;
        private final String myName;

        public GenotypeWrapper(Object obj, String name) {
            this.myObj = obj;
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }

        public Object getObject() {
            return this.myObj;
        }
    }
}

