/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.progress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.progress.PluginProgressUnit;

public class ProgressPanel
extends JPanel {
    private static ProgressPanel SINGLETON = null;
    private final JPanel myMainPane;
    private final Map myPlugins = new HashMap();
    private final Map myCancelPlugins = new HashMap();

    private ProgressPanel() {
        this.setLayout(new BorderLayout());
        this.myMainPane = new JPanel();
        BoxLayout layout = new BoxLayout(this.myMainPane, 1);
        this.myMainPane.setLayout(layout);
        this.myMainPane.setAlignmentX(0.0f);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.myMainPane);
        this.add((Component)scrollPane, "Center");
    }

    public static ProgressPanel getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new ProgressPanel();
        }
        return SINGLETON;
    }

    public void addPipelineSegment(List<Plugin> plugins) {
        if (plugins == null || plugins.size() == 0) {
            return;
        }
        for (int i = 0; i < plugins.size(); ++i) {
            this.addPlugin(plugins.get(i), true, plugins.get(0));
        }
    }

    public void addPlugin(Plugin plugin) {
        this.addPlugin(plugin, true, null);
    }

    public void addPlugin(Plugin plugin, boolean cancelButton, Plugin cancelPlugin) {
        Integer level = 0;
        this.myPlugins.put(plugin, level);
        PluginProgressUnit current = new PluginProgressUnit(plugin, level, cancelButton, cancelPlugin);
        if (cancelPlugin != null) {
            this.myCancelPlugins.put(current, cancelPlugin);
        }
        this.myMainPane.add(current);
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressUnit(PluginProgressUnit unit) {
        Map map = this.myCancelPlugins;
        synchronized (map) {
            Plugin cancelPlugin = (Plugin)this.myCancelPlugins.get(unit);
            if (cancelPlugin != null) {
                this.myCancelPlugins.remove(unit);
            }
            this.myMainPane.remove(unit);
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanProgressUnit(Plugin plugin) {
        Map map = this.myCancelPlugins;
        synchronized (map) {
            Iterator itr = this.myCancelPlugins.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry current = itr.next();
                Plugin tempPlugin = (Plugin)current.getValue();
                if (tempPlugin != plugin) continue;
                itr.remove();
                this.myMainPane.remove((PluginProgressUnit)current.getKey());
            }
        }
        this.revalidate();
        this.repaint();
    }
}

